/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.log;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import sun.rmi.log.LogHandler;
import sun.rmi.log.LogInputStream;
import sun.rmi.log.LogOutputStream;
import sun.security.action.GetBooleanAction;

public class ReliableLog {
    public static final int PreferredMajorVersion = 0;
    public static final int PreferredMinorVersion = 1;
    private boolean Debug = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.log.debug"));
    private static String snapshotPrefix = "Snapshot.";
    private static String logfilePrefix = "Logfile.";
    private static String versionFile = "Version_Number";
    private static String newVersionFile = "New_Version_Number";
    private static int intBytes = 4;
    private static long diskPageSize = 512L;
    private File dir;
    private int version = 0;
    private String logName = null;
    private RandomAccessFile log = null;
    private FileDescriptor logFD;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private int logEntries = 0;
    private long lastSnapshot = 0L;
    private long lastLog = 0L;
    private LogHandler handler;
    private int majorFormatVersion = 0;
    private int minorFormatVersion = 0;

    public ReliableLog(String string, LogHandler logHandler) throws IOException {
        this(string, logHandler, false);
    }

    public ReliableLog(String string, LogHandler logHandler, boolean bl) throws IOException {
        this.dir = new File(string);
        if (!(this.dir.exists() && this.dir.isDirectory() || this.dir.mkdir())) {
            throw new IOException("could not create directory for log: " + string);
        }
        this.handler = logHandler;
        this.lastSnapshot = 0L;
        this.lastLog = 0L;
        this.getVersion();
        if (this.version == 0) {
            try {
                this.snapshot(logHandler.initialSnapshot());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("initial snapshot failed with exception: " + exception);
            }
        }
    }

    public synchronized void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
        }
        finally {
            Object var2_1 = null;
            this.log = null;
        }
    }

    private void commitToNewVersion() throws IOException {
        this.writeVersionFile(false);
        this.deleteNewVersionFile();
    }

    private void createFirstVersion() throws IOException {
        this.version = 0;
        this.writeVersionFile(false);
    }

    private void deleteFile(String string) throws IOException {
        File file = new File(string);
        if (!file.delete()) {
            throw new IOException("couldn't remove file: " + string);
        }
    }

    private void deleteLogFile(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(logfilePrefix, n));
    }

    private void deleteNewVersionFile() throws IOException {
        this.deleteFile(this.fName(newVersionFile));
    }

    private void deleteSnapshot(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(snapshotPrefix, n));
    }

    private String fName(String string) {
        return String.valueOf(this.dir.getPath()) + File.separator + string;
    }

    private void getVersion() throws IOException {
        try {
            this.version = this.readVersion(this.fName(newVersionFile));
            this.commitToNewVersion();
        }
        catch (IOException iOException) {
            try {
                this.deleteNewVersionFile();
            }
            catch (IOException iOException2) {}
            try {
                this.version = this.readVersion(this.fName(versionFile));
            }
            catch (IOException iOException3) {
                this.createFirstVersion();
            }
        }
    }

    private void incrVersion() {
        do {
            ++this.version;
        } while (this.version == 0);
    }

    private void initializeLogFile() throws IOException {
        this.log.setLength(0L);
        this.majorFormatVersion = 0;
        this.log.writeInt(0);
        this.minorFormatVersion = 1;
        this.log.writeInt(1);
        this.logBytes = intBytes * 2;
        this.logEntries = 0;
    }

    public long logSize() {
        return this.logBytes;
    }

    private void openLogFile(boolean bl) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.logName = this.versionName(logfilePrefix);
        this.log = new RandomAccessFile(this.logName, "rw");
        this.logFD = this.log.getFD();
        if (bl) {
            this.initializeLogFile();
        }
    }

    private int readVersion(String string) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        try {
            n = dataInputStream.readInt();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dataInputStream.close();
            throw throwable;
        }
        dataInputStream.close();
        return n;
    }

    public synchronized Object recover() throws IOException {
        Object object;
        if (this.Debug) {
            System.err.println("log.debug: recover()");
        }
        if (this.version == 0) {
            return null;
        }
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        if (this.Debug) {
            System.err.println("log.debug: recovering from " + string);
        }
        try {
            try {
                object = this.handler.recover(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                if (this.Debug) {
                    System.err.println("log.debug: recovery failed: " + exception);
                }
                throw new IOException("log recover failed with exception: " + exception);
            }
            this.snapshotBytes = file.length();
        }
        finally {
            Object var6_7 = null;
            ((InputStream)bufferedInputStream).close();
        }
        return this.recoverUpdates(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object recoverUpdates(Object object) throws IOException {
        this.logBytes = 0L;
        this.logEntries = 0;
        if (this.version == 0) {
            return object;
        }
        String string = this.versionName(logfilePrefix);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        if (this.Debug) {
            System.err.println("log.debug: reading updates from " + string);
        }
        try {
            this.majorFormatVersion = dataInputStream.readInt();
            this.logBytes += (long)intBytes;
            this.minorFormatVersion = dataInputStream.readInt();
            this.logBytes += (long)intBytes;
        }
        catch (EOFException eOFException) {
            this.openLogFile(true);
            bufferedInputStream = null;
        }
        if (this.majorFormatVersion != 0) {
            if (this.Debug) {
                System.err.println("log.debug: major version mismatch: " + this.majorFormatVersion + "." + this.minorFormatVersion);
            }
            throw new IOException("Log file " + this.logName + " has a " + "version " + this.majorFormatVersion + "." + this.minorFormatVersion + " format, and this implementation " + " understands only version " + 0 + "." + 1);
        }
        try {
            while (bufferedInputStream != null) {
                int n = 0;
                try {
                    n = dataInputStream.readInt();
                }
                catch (EOFException eOFException) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was sync'd cleanly");
                    }
                    break;
                }
                if (n == 0) {
                    if (this.Debug) {
                        System.err.println("log.debug: last update incomplete");
                    }
                    break;
                }
                if (n < 0) {
                    if (this.Debug) {
                        System.err.println("log.debug: length = " + n);
                    }
                    throw new IOException("corrupted log: bad update length");
                }
                if (((InputStream)bufferedInputStream).available() < n) {
                    if (this.Debug) {
                        System.err.println("log.debug: log was truncated");
                    }
                    break;
                }
                if (this.Debug) {
                    System.err.println("log.debug: rdUpdate size " + n);
                }
                try {
                    object = this.handler.readUpdate(new LogInputStream(bufferedInputStream, n), object);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException("read update failed with exception: " + exception);
                }
                this.logBytes += (long)(intBytes + n);
                ++this.logEntries;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
            throw throwable;
        }
        Object var6_8 = null;
        if (bufferedInputStream != null) {
            ((InputStream)bufferedInputStream).close();
        }
        if (this.Debug) {
            System.err.println("log.debug: recovered updates: " + this.logEntries);
        }
        this.openLogFile(false);
        if (this.log == null) {
            throw new IOException("rmid's log is inaccessible, it may have been corrupted or closed");
        }
        this.log.seek(this.logBytes);
        this.log.setLength(this.logBytes);
        return object;
    }

    public synchronized void snapshot(Object object) throws IOException {
        int n = this.version;
        this.incrVersion();
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                this.handler.snapshot(fileOutputStream, object);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException("snapshot failed with exception of type: " + exception.getClass().getName() + ", message was: " + exception.getMessage());
            }
            this.snapshotBytes = file.length();
            this.lastSnapshot = System.currentTimeMillis();
        }
        finally {
            Object var7_8 = null;
            fileOutputStream.close();
        }
        this.openLogFile(true);
        this.writeVersionFile(true);
        this.commitToNewVersion();
        this.deleteSnapshot(n);
        this.deleteLogFile(n);
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public synchronized void update(Object object) throws IOException {
        this.update(object, false);
    }

    public synchronized void update(Object object, boolean bl) throws IOException {
        if (this.log == null) {
            throw new IOException("rmid's log is inaccessible, it may have been corrupted or closed");
        }
        long l = this.log.getFilePointer();
        this.log.writeInt(0);
        try {
            this.handler.writeUpdate(new LogOutputStream(this.log), object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("write update failed with exception: " + exception.getClass().getName() + ", message: " + exception.getMessage());
        }
        long l2 = this.log.getFilePointer();
        long l3 = l2 - l - (long)intBytes;
        this.logFD.sync();
        this.log.seek(l);
        this.log.writeInt((int)l3);
        this.log.seek(l2);
        this.logBytes = l2;
        if (bl) {
            this.logFD.sync();
        }
        this.lastLog = System.currentTimeMillis();
        ++this.logEntries;
    }

    private String versionName(String string) {
        return this.versionName(string, 0);
    }

    private String versionName(String string, int n) {
        n = n == 0 ? this.version : n;
        return String.valueOf(this.fName(string)) + String.valueOf(n);
    }

    private void writeVersionFile(boolean bl) throws IOException {
        String string = bl ? newVersionFile : versionFile;
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fName(string)));
        dataOutputStream.writeInt(this.version);
        dataOutputStream.close();
    }
}

