/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.server.LogStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.security.action.GetPropertyAction;

public final class LoaderHandler {
    static final int logLevel = LogStream.parseLevel((String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.loader.logLevel")));
    private static String codebase = null;
    private static URL[] codebaseURLs;
    private static Map codebaseLoaders;
    private static HashMap loaderTable;
    private static ReferenceQueue refQueue;
    private static Map pathToURLsCache;
    static /* synthetic */ Class class$sun$rmi$server$LoaderHandler;

    static {
        Object object = (String)AccessController.doPrivileged(new GetPropertyAction("java.rmi.server.codebase"));
        if (object != null && ((String)object).trim().length() > 0) {
            codebase = object;
        }
        codebaseURLs = null;
        codebaseLoaders = Collections.synchronizedMap(new WeakHashMap(5));
        object = ClassLoader.getSystemClassLoader();
        while (object != null) {
            codebaseLoaders.put(object, null);
            object = ((ClassLoader)object).getParent();
        }
        loaderTable = new HashMap(5);
        refQueue = new ReferenceQueue();
        pathToURLsCache = new WeakHashMap(5);
    }

    private LoaderHandler() {
    }

    private static void addPermissionsForURLs(URL[] uRLArray, PermissionCollection permissionCollection, boolean bl) {
        int n = 0;
        while (n < uRLArray.length) {
            URL uRL = uRLArray[n];
            try {
                Permission permission = uRL.openConnection().getPermission();
                if (permission != null) {
                    String string;
                    if (permission instanceof FilePermission) {
                        string = permission.getName();
                        int n2 = string.lastIndexOf(File.separatorChar);
                        if (n2 != -1) {
                            if ((string = string.substring(0, n2 + 1)).endsWith(File.separator)) {
                                string = String.valueOf(string) + "-";
                            }
                            permissionCollection.add(new FilePermission(string, "read"));
                        } else {
                            permissionCollection.add(permission);
                        }
                    } else {
                        permissionCollection.add(permission);
                        if (bl && (string = uRL.getHost()) != null) {
                            permissionCollection.add(new SocketPermission(string, "connect, accept"));
                        }
                    }
                }
            }
            catch (IOException iOException) {}
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String getClassAnnotation(Class clazz) {
        ClassLoader classLoader;
        String string = clazz.getName();
        int n = string.length();
        if (n > 0 && string.charAt(0) == '[') {
            int n2 = 1;
            while (n > n2 && string.charAt(n2) == '[') {
                ++n2;
            }
            if (n > n2 && string.charAt(n2) != 'L') {
                return null;
            }
        }
        if ((classLoader = clazz.getClassLoader()) == null || codebaseLoaders.containsKey(classLoader)) {
            return codebase;
        }
        String string2 = null;
        if (classLoader instanceof Loader) {
            string2 = ((Loader)classLoader).getClassAnnotation();
        } else if (classLoader instanceof URLClassLoader) {
            try {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                if (uRLArray != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        int n3 = 0;
                        while (n3 < uRLArray.length) {
                            Permission permission = uRLArray[n3].openConnection().getPermission();
                            if (permission != null) {
                                securityManager.checkPermission(permission);
                            }
                            ++n3;
                        }
                    }
                    string2 = LoaderHandler.urlsToPath(uRLArray);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {}
        }
        if (string2 != null) {
            return string2;
        }
        return codebase;
    }

    public static ClassLoader getClassLoader(String string) throws MalformedURLException, SecurityException {
        ClassLoader classLoader = LoaderHandler.getRMIContextClassLoader();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return classLoader;
        }
        URL[] uRLArray = string != null ? LoaderHandler.pathToURLs(string) : LoaderHandler.getDefaultCodebaseURLs();
        Loader loader = LoaderHandler.lookupLoader(uRLArray, classLoader);
        if (loader != null) {
            loader.checkPermissions();
        }
        return loader;
    }

    private static synchronized URL[] getDefaultCodebaseURLs() throws MalformedURLException {
        if (codebaseURLs == null) {
            codebaseURLs = codebase != null ? LoaderHandler.pathToURLs(codebase) : new URL[0];
        }
        return codebaseURLs;
    }

    private static AccessControlContext getLoaderAccessControlContext(URL[] uRLArray) {
        PermissionCollection permissionCollection = (PermissionCollection)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource codeSource = new CodeSource(null, null);
                Policy policy = Policy.getPolicy();
                if (policy != null) {
                    return policy.getPermissions(codeSource);
                }
                return new Permissions();
            }
        });
        permissionCollection.add(new RuntimePermission("createClassLoader"));
        permissionCollection.add(new PropertyPermission("java.*", "read"));
        LoaderHandler.addPermissionsForURLs(uRLArray, permissionCollection, true);
        ProtectionDomain protectionDomain = new ProtectionDomain(new CodeSource(uRLArray.length > 0 ? uRLArray[0] : null, null), permissionCollection);
        return new AccessControlContext(new ProtectionDomain[]{protectionDomain});
    }

    private static ClassLoader getRMIContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Object getSecurityContext(ClassLoader classLoader) {
        URL[] uRLArray;
        if (classLoader instanceof Loader && (uRLArray = ((Loader)classLoader).getURLs()).length > 0) {
            return uRLArray[0];
        }
        return null;
    }

    public static Class loadClass(String string) throws MalformedURLException, ClassNotFoundException {
        return LoaderHandler.loadClass(LoaderHandler.getDefaultCodebaseURLs(), string);
    }

    public static Class loadClass(String string, String string2) throws MalformedURLException, ClassNotFoundException {
        if (string != null) {
            return LoaderHandler.loadClass(LoaderHandler.pathToURLs(string), string2);
        }
        return LoaderHandler.loadClass(string2);
    }

    public static Class loadClass(URL uRL, String string) throws MalformedURLException, ClassNotFoundException {
        if (uRL != null) {
            return LoaderHandler.loadClass(new URL[]{uRL}, string);
        }
        return LoaderHandler.loadClass(string);
    }

    private static Class loadClass(URL[] uRLArray, String string) throws ClassNotFoundException {
        ClassLoader classLoader = LoaderHandler.getRMIContextClassLoader();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            try {
                return Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException(String.valueOf(classNotFoundException.getMessage()) + " (no security manager: RMI class loader disabled)", classNotFoundException.getException());
            }
        }
        Loader loader = LoaderHandler.lookupLoader(uRLArray, classLoader);
        if (logLevel >= 20) {
            LogStream.log("loader").println("LoaderHandler.loadClass: loading class \"" + string + "\"" + " from " + Arrays.asList(uRLArray));
        }
        try {
            if (loader != null) {
                loader.checkPermissions();
            }
        }
        catch (SecurityException securityException) {
            try {
                return Class.forName(string, false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException("access denied to class loader", securityException);
            }
        }
        return Class.forName(string, false, loader);
    }

    private static Loader lookupLoader(final URL[] uRLArray, final ClassLoader classLoader) {
        Loader loader;
        Class clazz = class$sun$rmi$server$LoaderHandler != null ? class$sun$rmi$server$LoaderHandler : (class$sun$rmi$server$LoaderHandler = LoaderHandler.class$("sun.rmi.server.LoaderHandler"));
        synchronized (clazz) {
            LoaderEntry loaderEntry;
            while ((loaderEntry = (LoaderEntry)refQueue.poll()) != null) {
                if (loaderEntry.removed) continue;
                loaderTable.remove(loaderEntry.key);
            }
            LoaderKey loaderKey = new LoaderKey(uRLArray, classLoader);
            loaderEntry = (LoaderEntry)loaderTable.get(loaderKey);
            if (loaderEntry == null || (loader = (Loader)loaderEntry.get()) == null) {
                if (loaderEntry != null) {
                    loaderTable.remove(loaderKey);
                    loaderEntry.removed = true;
                }
                AccessControlContext accessControlContext = LoaderHandler.getLoaderAccessControlContext(uRLArray);
                loader = (Loader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        class Sun_rmi_server_LoaderHandler$3 {
                            /* synthetic */ Sun_rmi_server_LoaderHandler$3() {
                            }
                        }
                        return new Loader(null, uRLArray, classLoader);
                    }
                }, accessControlContext);
                loaderEntry = new LoaderEntry(loaderKey, loader);
                loaderTable.put(loaderKey, loaderEntry);
            }
        }
        return loader;
    }

    private static URL[] pathToURLs(String string) throws MalformedURLException {
        Object object;
        URL[] uRLArray = pathToURLsCache;
        synchronized (uRLArray) {
            object = (Object[])pathToURLsCache.get(string);
            if (object != null) {
                URL[] uRLArray2 = (URL[])object[0];
                Object var3_5 = null;
                return uRLArray2;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        uRLArray = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray[n] = new URL(stringTokenizer.nextToken());
            ++n;
        }
        object = pathToURLsCache;
        synchronized (object) {
            pathToURLsCache.put(string, new Object[]{uRLArray, new SoftReference(string)});
        }
        return uRLArray;
    }

    public static void registerCodebaseLoader(ClassLoader classLoader) {
        codebaseLoaders.put(classLoader, null);
    }

    private static String urlsToPath(URL[] uRLArray) {
        if (uRLArray.length == 0) {
            return null;
        }
        if (uRLArray.length == 1) {
            return uRLArray[0].toExternalForm();
        }
        StringBuffer stringBuffer = new StringBuffer(uRLArray[0].toExternalForm());
        int n = 1;
        while (n < uRLArray.length) {
            stringBuffer.append(' ');
            stringBuffer.append(uRLArray[n].toExternalForm());
            ++n;
        }
        return stringBuffer.toString();
    }

    private static class LoaderKey {
        private URL[] urls;
        private ClassLoader parent;
        private int hashValue;

        public LoaderKey(URL[] uRLArray, ClassLoader classLoader) {
            this.urls = uRLArray;
            this.parent = classLoader;
            if (classLoader != null) {
                this.hashValue = classLoader.hashCode();
            }
            int n = 0;
            while (n < uRLArray.length) {
                this.hashValue ^= uRLArray[n].hashCode();
                ++n;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof LoaderKey) {
                LoaderKey loaderKey = (LoaderKey)object;
                if (this.parent != loaderKey.parent) {
                    return false;
                }
                if (this.urls == loaderKey.urls) {
                    return true;
                }
                if (this.urls.length != loaderKey.urls.length) {
                    return false;
                }
                int n = 0;
                while (n < this.urls.length) {
                    if (!this.urls[n].equals(loaderKey.urls[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.hashValue;
        }
    }

    private static class LoaderEntry
    extends WeakReference {
        public LoaderKey key;
        public boolean removed = false;

        public LoaderEntry(LoaderKey loaderKey, Loader loader) {
            super(loader, refQueue);
            this.key = loaderKey;
        }
    }

    private static class Loader
    extends URLClassLoader {
        private ClassLoader parent;
        private String annotation;
        private Permissions permissions;

        /* synthetic */ Loader(3 var1_1, URL[] uRLArray, ClassLoader classLoader) {
            this(uRLArray, classLoader);
        }

        private Loader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
            this.parent = classLoader;
            this.permissions = new Permissions();
            LoaderHandler.addPermissionsForURLs(uRLArray, this.permissions, false);
            this.annotation = LoaderHandler.urlsToPath(uRLArray);
        }

        private void checkPermissions() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                Enumeration enumeration = this.permissions.elements();
                while (enumeration.hasMoreElements()) {
                    securityManager.checkPermission((Permission)enumeration.nextElement());
                }
            }
        }

        public String getClassAnnotation() {
            return this.annotation;
        }

        protected PermissionCollection getPermissions(CodeSource codeSource) {
            PermissionCollection permissionCollection = super.getPermissions(codeSource);
            return permissionCollection;
        }
    }
}

