/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import sun.rmi.server.LoaderHandler;
import sun.security.action.GetBooleanAction;

public class MarshalInputStream
extends ObjectInputStream {
    private boolean skipDefaultResolveClass = false;
    private static final boolean useCodebaseOnly = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.useCodebaseOnly"));
    protected static Map permittedSunClasses = new HashMap(3);
    static /* synthetic */ Class class$sun$rmi$server$Activation$ActivationMonitorImpl;
    static /* synthetic */ Class class$sun$rmi$server$Activation$ActivationSystemImpl;
    static /* synthetic */ Class class$sun$rmi$registry$RegistryImpl;

    static {
        try {
            String string = String.valueOf((class$sun$rmi$server$Activation$ActivationMonitorImpl != null ? class$sun$rmi$server$Activation$ActivationMonitorImpl : (class$sun$rmi$server$Activation$ActivationMonitorImpl = MarshalInputStream.class$("sun.rmi.server.Activation$ActivationMonitorImpl"))).getName()) + "_Stub";
            String string2 = String.valueOf((class$sun$rmi$server$Activation$ActivationSystemImpl != null ? class$sun$rmi$server$Activation$ActivationSystemImpl : (class$sun$rmi$server$Activation$ActivationSystemImpl = MarshalInputStream.class$("sun.rmi.server.Activation$ActivationSystemImpl"))).getName()) + "_Stub";
            String string3 = String.valueOf((class$sun$rmi$registry$RegistryImpl != null ? class$sun$rmi$registry$RegistryImpl : (class$sun$rmi$registry$RegistryImpl = MarshalInputStream.class$("sun.rmi.registry.RegistryImpl"))).getName()) + "_Stub";
            permittedSunClasses.put(string, Class.forName(string));
            permittedSunClasses.put(string2, Class.forName(string2));
            permittedSunClasses.put(string3, Class.forName(string3));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError("Missing system class: " + classNotFoundException.getMessage());
        }
    }

    public MarshalInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    private Class checkSunClass(String string, AccessControlException accessControlException) throws AccessControlException {
        Permission permission = accessControlException.getPermission();
        String string2 = null;
        if (permission != null) {
            string2 = permission.getName();
        }
        Class clazz = (Class)permittedSunClasses.get(string);
        if (string2 == null || clazz == null || !string2.equals("accessClassInPackage.sun.rmi.server") && !string2.equals("accessClassInPackage.sun.rmi.registry")) {
            throw accessControlException;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected Object readLocation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Object object = this.readLocation();
        String string = objectStreamClass.getName();
        if (!this.skipDefaultResolveClass) {
            try {
                return super.resolveClass(objectStreamClass);
            }
            catch (AccessControlException accessControlException) {
                return this.checkSunClass(string, accessControlException);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        try {
            if (!useCodebaseOnly && object != null && object instanceof String) {
                String string2 = (String)object;
                return LoaderHandler.loadClass(string2, string);
            }
            return LoaderHandler.loadClass(string);
        }
        catch (AccessControlException accessControlException) {
            return this.checkSunClass(string, accessControlException);
        }
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader;
        Class[] classArray;
        Object object = this.readLocation();
        if (!useCodebaseOnly && object != null && object instanceof String) {
            classArray = (String)object;
            classLoader = LoaderHandler.getClassLoader((String)classArray);
        } else {
            classLoader = LoaderHandler.getClassLoader(null);
        }
        classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            classArray[n] = Class.forName(stringArray[n], false, classLoader);
            ++n;
        }
        return Proxy.getProxyClass(classLoader, classArray);
    }

    void skipDefaultResolveClass() {
        this.skipDefaultResolveClass = true;
    }
}

