/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.LogStream;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.RemoteProxy;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
    private transient Skeleton skel;
    private transient Map methodTable = null;
    private static Map methodTableCache = new WeakHashMap(11);
    private static Map withoutSkeletons = Collections.synchronizedMap(new WeakHashMap(11));
    static /* synthetic */ Class class$java$rmi$Remote;

    public UnicastServerRef() {
    }

    public UnicastServerRef(int n) {
        super(new LiveRef(n));
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static long computeMethodHash(Method method) {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            String string = UnicastServerRef.getMethodNameAndDescriptor(method);
            if (RemoteProxy.logLevel >= 20) {
                LogStream.log("transport").println("UnicastServerRef.computeMethodHash: string used for method hash: \"" + string + "\"");
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            int n = 0;
            while (n < Math.min(8, byArray.length)) {
                l += (long)(byArray[n] & 0xFF) << n * 8;
                ++n;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static Map createMethodTable(Class clazz) {
        HashMap hashMap = new HashMap(11);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Class[] classArray = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray.length) {
                if ((class$java$rmi$Remote != null ? class$java$rmi$Remote : UnicastServerRef.class$("java.rmi.Remote")).isAssignableFrom(classArray[n])) {
                    Method[] methodArray = classArray[n].getMethods();
                    int n2 = 0;
                    while (n2 < methodArray.length) {
                        final Method method = methodArray[n2];
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                method.setAccessible(true);
                                return null;
                            }
                        });
                        long l = UnicastServerRef.computeMethodHash(method);
                        hashMap.put(new Long(l), method);
                        ++n2;
                    }
                }
                ++n;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(Remote remote, RemoteCall remoteCall) throws IOException {
        try {
            try {
                Object object;
                ObjectOutput objectOutput;
                long l;
                ObjectInput objectInput;
                try {
                    objectInput = remoteCall.getInputStream();
                    int n = objectInput.readInt();
                    if (n >= 0) {
                        if (this.skel == null) throw new UnmarshalException("skeleton class not found but required for client version");
                        this.oldDispatch(remote, remoteCall, n);
                        Object var7_7 = null;
                        remoteCall.releaseInputStream();
                        remoteCall.releaseOutputStream();
                        return;
                    }
                    l = objectInput.readLong();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("error unmarshalling call header", exception);
                }
                MarshalInputStream marshalInputStream = (MarshalInputStream)objectInput;
                marshalInputStream.skipDefaultResolveClass();
                Method method = (Method)this.methodTable.get(new Long(l));
                if (method == null) {
                    throw new UnmarshalException("invalid method hash");
                }
                this.logCall(remote, method);
                Class[] classArray = method.getParameterTypes();
                Object[] objectArray = new Object[classArray.length];
                try {
                    try {
                        this.unmarshalCustomCallData(objectInput);
                        int n = 0;
                        while (n < classArray.length) {
                            objectArray[n] = UnicastRef.unmarshalValue(classArray[n], objectInput);
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        throw new UnmarshalException("error unmarshalling arguments", iOException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                    }
                    objectOutput = null;
                }
                catch (Throwable throwable) {
                    Object var14_22 = null;
                    remoteCall.releaseInputStream();
                    throw throwable;
                }
                remoteCall.releaseInputStream();
                try {}
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
                {
                    object = method.invoke(remote, objectArray);
                }
                try {
                    objectOutput = remoteCall.getResultStream(true);
                    Class clazz = method.getReturnType();
                    if (clazz != Void.TYPE) {
                        UnicastRef.marshalValue(clazz, object, objectOutput);
                    }
                }
                catch (IOException iOException) {
                    throw new MarshalException("error marshalling return", iOException);
                }
            }
            catch (Throwable throwable) {
                RemoteException remoteException;
                this.logCallException(throwable);
                ObjectOutput objectOutput = remoteCall.getResultStream(false);
                if (throwable instanceof Error) {
                    remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
                } else if (throwable instanceof RemoteException) {
                    remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
                }
                objectOutput.writeObject(remoteException);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            throw throwable;
        }
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        return this.exportObject(remote, object, false);
    }

    public RemoteStub exportObject(Remote remote, Object object, boolean bl) throws RemoteException {
        RemoteStub remoteStub = this.setSkeleton(remote);
        Target target = new Target(remote, this, remoteStub, this.ref.getObjID(), bl);
        this.ref.exportObject(target);
        this.methodTable = UnicastServerRef.getMethodTable(remote.getClass());
        return remoteStub;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    private static String getMethodNameAndDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append('(');
        Class[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(classArray[n]));
            ++n;
        }
        stringBuffer.append(')');
        Class clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(clazz));
        }
        return stringBuffer.toString();
    }

    private static Map getMethodTable(Class clazz) {
        SoftReference[] softReferenceArray;
        Map map = methodTableCache;
        synchronized (map) {
            softReferenceArray = (SoftReference[])methodTableCache.get(clazz);
            if (softReferenceArray == null) {
                softReferenceArray = new SoftReference[]{null};
                methodTableCache.put(clazz, softReferenceArray);
            }
        }
        SoftReference[] softReferenceArray2 = softReferenceArray;
        synchronized (softReferenceArray2) {
            Map map2 = null;
            if (softReferenceArray[0] != null) {
                map2 = (Map)softReferenceArray[0].get();
            }
            if (map2 == null) {
                map2 = UnicastServerRef.createMethodTable(clazz);
                softReferenceArray[0] = new SoftReference(map2);
            }
            map = map2;
            Object var4_5 = null;
            return map;
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        if (objectOutput instanceof MarshalOutputStream) {
            throw new InternalError("UnicastServerRef.writeExternal: server reference written to MarshalOutputStream");
        }
        return "UnicastServerRef";
    }

    private static String getTypeDescriptor(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    private void logCall(Remote remote, Object object) {
        String string;
        PrintStream printStream = RemoteServer.getLog();
        if (printStream == null) {
            return;
        }
        try {
            string = this.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            string = "(local)";
        }
        printStream.println("[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
    }

    private void logCallException(Throwable throwable) {
        PrintStream printStream;
        PrintStream printStream2 = RemoteServer.getLog();
        if (printStream2 != null) {
            printStream = printStream2;
            synchronized (printStream) {
                try {
                    printStream2.print("[" + this.getClientHost() + "] ");
                }
                catch (ServerNotActiveException serverNotActiveException) {}
                printStream2.print("exception: ");
                throwable.printStackTrace(printStream2);
            }
        }
        if (wantExceptionLog) {
            PrintStream printStream3 = printStream = System.err;
            synchronized (printStream3) {
                printStream.println();
                try {
                    String string = this.getClientHost();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    String string = "(local)";
                }
                printStream.println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace(printStream);
            }
        }
    }

    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n) throws IOException {
        try {
            try {
                long l;
                ObjectInput objectInput;
                try {
                    objectInput = remoteCall.getInputStream();
                    l = objectInput.readLong();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("error unmarshalling call header", exception);
                }
                this.logCall(remote, this.skel.getOperations()[n]);
                this.unmarshalCustomCallData(objectInput);
                this.skel.dispatch(remote, remoteCall, n, l);
            }
            catch (Throwable throwable) {
                RemoteException remoteException;
                this.logCallException(throwable);
                ObjectOutput objectOutput = remoteCall.getResultStream(false);
                if (throwable instanceof Error) {
                    remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
                } else if (throwable instanceof RemoteException) {
                    remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
                }
                objectOutput.writeObject(remoteException);
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            throw throwable;
        }
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    public RemoteStub setSkeleton(Remote remote) throws RemoteException {
        block2: {
            if (withoutSkeletons.containsKey(remote.getClass())) break block2;
            try {
                this.skel = RemoteProxy.getSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
        return RemoteProxy.getStub(remote, this.getClientRef());
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (objectOutput instanceof MarshalOutputStream) {
            throw new InternalError("UnicastServerRef.writeExternal: server reference written to MarshalOutputStream");
        }
    }
}

