/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.GC;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.LocateDGC;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.Transport;
import sun.security.action.GetLongAction;

final class DGCClient {
    private static long nextSequenceNum = Long.MIN_VALUE;
    private static VMID vmid = new VMID();
    private static final long leaseValue = (Long)AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long cleanInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.cleanInterval", 180000L));
    private static final long gcInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.client.gcInterval", 60000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanConnectRetries = 3;
    private static final ObjID[] emptyObjIDArray = new ObjID[0];

    private DGCClient() {
    }

    private static long computeRenewTime(long l, long l2) {
        return l + l2 / 2L;
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    static void registerRefs(Endpoint endpoint, List list) {
        EndpointEntry endpointEntry;
        while (!(endpointEntry = EndpointEntry.lookup(endpoint)).registerRefs(list)) {
        }
    }

    private static class EndpointEntry {
        private Endpoint endpoint;
        private DGC dgc;
        private Map refTable = new HashMap(5);
        private Set invalidRefs = new HashSet(5);
        private boolean removed = false;
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private Thread renewCleanThread;
        private boolean interruptible = false;
        private ReferenceQueue refQueue = new ReferenceQueue();
        private Set pendingCleans = new HashSet(5);
        private static Map endpointTable = new HashMap(5);
        private static GC.LatencyRequest gcLatencyRequest = null;

        private EndpointEntry(Endpoint endpoint) {
            this.endpoint = endpoint;
            try {
                this.dgc = LocateDGC.getDGC(endpoint);
            }
            catch (RemoteException remoteException) {
                throw new Error("internal error creating DGC stub");
            }
            this.renewCleanThread = (Thread)AccessController.doPrivileged(new RMIThreadAction(new RenewCleanThread(), "RenewClean-" + endpoint, true));
            this.renewCleanThread.start();
        }

        static /* synthetic */ Thread access$0(EndpointEntry endpointEntry) {
            return endpointEntry.renewCleanThread;
        }

        static /* synthetic */ boolean access$3(EndpointEntry endpointEntry) {
            return endpointEntry.interruptible;
        }

        private static ObjID[] createObjIDArray(Set set) {
            ObjID[] objIDArray = new ObjID[set.size()];
            Iterator iterator = set.iterator();
            int n = 0;
            while (n < objIDArray.length) {
                objIDArray[n] = ((RefEntry)iterator.next()).getRef().getObjID();
                ++n;
            }
            return objIDArray;
        }

        public static EndpointEntry lookup(Endpoint endpoint) {
            Map map = endpointTable;
            synchronized (map) {
                EndpointEntry endpointEntry = (EndpointEntry)endpointTable.get(endpoint);
                if (endpointEntry == null) {
                    endpointEntry = new EndpointEntry(endpoint);
                    endpointTable.put(endpoint, endpointEntry);
                    if (gcLatencyRequest == null) {
                        gcLatencyRequest = GC.requestLatency(gcInterval);
                    }
                }
                EndpointEntry endpointEntry2 = endpointEntry;
                Object var3_4 = null;
                return endpointEntry2;
            }
        }

        private void makeCleanCalls() {
            Iterator iterator = this.pendingCleans.iterator();
            while (iterator.hasNext()) {
                CleanRequest cleanRequest = (CleanRequest)iterator.next();
                try {
                    this.dgc.clean(cleanRequest.objIDs, cleanRequest.sequenceNum, vmid, cleanRequest.strong);
                    iterator.remove();
                }
                catch (ConnectException connectException) {
                    if (++cleanRequest.connectFailures < 3) continue;
                    iterator.remove();
                }
                catch (Exception exception) {}
            }
        }

        private void makeDirtyCall(Set set, long l) {
            ObjID[] objIDArray = set != null ? EndpointEntry.createObjIDArray(set) : emptyObjIDArray;
            long l2 = System.currentTimeMillis();
            try {
                Lease lease = this.dgc.dirty(objIDArray, l, new Lease(vmid, leaseValue));
                long l3 = lease.getValue();
                long l4 = DGCClient.computeRenewTime(l2, l3);
                long l5 = l2 + l3;
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    this.setRenewTime(l4);
                    this.expirationTime = l5;
                }
            }
            catch (Exception exception) {
                long l6 = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = l2;
                        this.dirtyFailureDuration = l6 - l2;
                        this.setRenewTime(l6);
                    } else {
                        long l7;
                        int n = this.dirtyFailures - 2;
                        if (n == 0) {
                            this.dirtyFailureDuration = this.dirtyFailureDuration + (l6 - l2) >> 1;
                        }
                        if ((l7 = l6 + (this.dirtyFailureDuration << n)) < this.expirationTime || this.dirtyFailures < 5 || l7 < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(l7);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (set != null) {
                        this.invalidRefs.addAll(set);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            RefEntry refEntry = (RefEntry)iterator.next();
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantomLiveRef) {
            Set set = null;
            Set set2 = null;
            do {
                RefEntry refEntry = phantomLiveRef.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantomLiveRef);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (set == null) {
                        set = new HashSet(5);
                    }
                    set.add(refEntry);
                } else {
                    if (set2 == null) {
                        set2 = new HashSet(5);
                    }
                    set2.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantomLiveRef = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (set != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(set), DGCClient.getNextSequenceNum(), true));
            }
            if (set2 != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(set2), DGCClient.getNextSequenceNum(), false));
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean registerRefs(List list) {
            long l;
            Set set = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                if (this.removed) {
                    return false;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    LiveRef liveRef = (LiveRef)iterator.next();
                    RefEntry refEntry = (RefEntry)this.refTable.get(liveRef);
                    if (refEntry == null) {
                        LiveRef liveRef2 = (LiveRef)liveRef.clone();
                        refEntry = new RefEntry(liveRef2);
                        this.refTable.put(liveRef2, refEntry);
                        if (set == null) {
                            set = new HashSet(5);
                        }
                        set.add(refEntry);
                    }
                    refEntry.addInstanceToRefSet(liveRef);
                }
                if (set == null) {
                    return true;
                }
                set.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                l = DGCClient.getNextSequenceNum();
            }
            this.makeDirtyCall(set, l);
            return true;
        }

        private void removeRefEntry(RefEntry refEntry) {
            this.refTable.remove(refEntry.getRef());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map map = endpointTable;
                synchronized (map) {
                    endpointTable.remove(this.endpoint);
                    Transport transport = this.endpoint.getTransport();
                    transport.free(this.endpoint);
                    if (endpointTable.isEmpty()) {
                        gcLatencyRequest.cancel();
                        gcLatencyRequest = null;
                    }
                    this.removed = true;
                }
            }
        }

        private void setRenewTime(long l) {
            if (l < this.renewTime) {
                this.renewTime = l;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ EndpointEntry this$0;
                        {
                            this.this$0 = endpointEntry;
                        }

                        public Object run() {
                            EndpointEntry.access$0(this.this$0).interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = l;
            }
        }

        private class RenewCleanThread
        implements Runnable {
            RenewCleanThread() {
            }

            public void run() {
                do {
                    long l;
                    long l2;
                    RefEntry.PhantomLiveRef phantomLiveRef = null;
                    boolean bl = false;
                    Set set = null;
                    long l3 = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        l2 = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        l = Math.max(l2, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            l = Math.min(l, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantomLiveRef = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(l);
                    }
                    catch (InterruptedException interruptedException) {}
                    endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantomLiveRef != null) {
                            EndpointEntry.this.processPhantomRefs(phantomLiveRef);
                        }
                        if ((l2 = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            bl = true;
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                set = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            l3 = DGCClient.getNextSequenceNum();
                        }
                    }
                    if (bl) {
                        EndpointEntry.this.makeDirtyCall(set, l3);
                    }
                    if (EndpointEntry.this.pendingCleans.isEmpty()) continue;
                    EndpointEntry.this.makeCleanCalls();
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }

        private static class CleanRequest {
            public ObjID[] objIDs;
            public long sequenceNum;
            public boolean strong;
            public int connectFailures = 0;

            public CleanRequest(ObjID[] objIDArray, long l, boolean bl) {
                this.objIDs = objIDArray;
                this.sequenceNum = l;
                this.strong = bl;
            }
        }

        private class RefEntry {
            private LiveRef ref;
            private Set refSet = new HashSet(5);
            private boolean dirtyFailed = false;

            public RefEntry(LiveRef liveRef) {
                this.ref = liveRef;
            }

            public void addInstanceToRefSet(LiveRef liveRef) {
                this.refSet.add(new PhantomLiveRef(liveRef));
            }

            public LiveRef getRef() {
                return this.ref;
            }

            public boolean hasDirtyFailed() {
                return this.dirtyFailed;
            }

            public boolean isRefSetEmpty() {
                return this.refSet.size() == 0;
            }

            public void markDirtyFailed() {
                this.dirtyFailed = true;
            }

            public void removeInstanceFromRefSet(PhantomLiveRef phantomLiveRef) {
                this.refSet.remove(phantomLiveRef);
            }

            private class PhantomLiveRef
            extends PhantomReference {
                public PhantomLiveRef(LiveRef liveRef) {
                    super(liveRef, EndpointEntry.this.refQueue);
                }

                public RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }
    }
}

