/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteStub;
import java.rmi.server.Unreferenced;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.SequenceEntry;
import sun.rmi.transport.WeakRef;

public final class Target {
    private ObjID id;
    private boolean permanent = false;
    private WeakRef weakImpl;
    private Dispatcher disp;
    private RemoteStub stub;
    private Vector refSet = new Vector();
    private Hashtable sequenceTable = new Hashtable(5);
    private AccessControlContext acc;
    private ClassLoader ccl;
    private int callCount = 0;
    private static int nextThreadNum = 0;
    private Endpoint exportedEndpoint = null;

    public Target(Remote remote, Dispatcher dispatcher, RemoteStub remoteStub, ObjID objID, boolean bl) {
        this.weakImpl = new WeakRef(remote, ObjectTable.reapQueue);
        this.disp = dispatcher;
        this.stub = remoteStub;
        this.id = objID;
        this.acc = AccessController.getContext();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = remote.getClass().getClassLoader();
        this.ccl = Target.checkLoaderAncestry(classLoader, classLoader2) ? classLoader : classLoader2;
        this.permanent = bl;
        if (bl) {
            this.pinImpl();
        }
    }

    private static boolean checkLoaderAncestry(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        ClassLoader classLoader3 = classLoader;
        while (classLoader3 != null) {
            if (classLoader3 == classLoader2) {
                return true;
            }
            classLoader3 = classLoader3.getParent();
        }
        return false;
    }

    synchronized void decrementCallCount() {
        if (--this.callCount < 0) {
            throw new Error("internal error: call count less than zero");
        }
    }

    AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    ClassLoader getContextClassLoader() {
        return this.ccl;
    }

    Dispatcher getDispatcher() {
        return this.disp;
    }

    Endpoint getExportedEndpoint() {
        return this.exportedEndpoint;
    }

    synchronized Remote getImpl() {
        return (Remote)this.weakImpl.get();
    }

    ObjID getObjID() {
        return this.id;
    }

    public RemoteStub getStub() {
        return this.stub;
    }

    WeakRef getWeakImpl() {
        return this.weakImpl;
    }

    synchronized void incrementCallCount() throws NoSuchObjectException {
        if (this.disp != null) {
            ++this.callCount;
        } else {
            throw new NoSuchObjectException("object not accepting new calls");
        }
    }

    boolean isEmpty() {
        return this.refSet.isEmpty();
    }

    boolean isPermanent() {
        return this.permanent;
    }

    synchronized void pinImpl() {
        this.weakImpl.pin();
    }

    private synchronized void refSetRemove(VMID vMID) {
        DGCImpl.getDGCImpl().unregisterTarget(vMID, this);
        if (this.refSet.removeElement(vMID) && this.refSet.isEmpty()) {
            Remote remote;
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("Target.unreferenced: reference set is empty: target = " + this);
            }
            if ((remote = this.getImpl()) instanceof Unreferenced) {
                final Unreferenced unreferenced = (Unreferenced)((Object)remote);
                final Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(new Runnable(){

                    public void run() {
                        unreferenced.unreferenced();
                    }
                }, "Unreferenced-" + nextThreadNum++, false, true));
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(ccl);
                        return null;
                    }
                });
                thread.start();
            }
            this.unpinImpl();
        }
    }

    synchronized void referenced(long l, VMID vMID) {
        SequenceEntry sequenceEntry = (SequenceEntry)this.sequenceTable.get(vMID);
        if (sequenceEntry == null) {
            this.sequenceTable.put(vMID, new SequenceEntry(l));
        } else if (sequenceEntry.sequenceNum < l) {
            sequenceEntry.update(l);
        } else {
            return;
        }
        if (!this.refSet.contains(vMID)) {
            this.pinImpl();
            if (this.getImpl() == null) {
                return;
            }
            if (DGCImpl.logLevel >= 20) {
                LogStream.log("dgc").println("Target.referenced: add to dirty set: " + vMID);
            }
            this.refSet.addElement(vMID);
            DGCImpl.getDGCImpl().registerTarget(vMID, this);
        }
    }

    public void setExportedEndpoint(Endpoint endpoint) {
        if (this.exportedEndpoint == null) {
            this.exportedEndpoint = endpoint;
        }
    }

    synchronized boolean unexport(boolean bl) {
        if (bl || this.callCount == 0 || this.disp == null) {
            this.disp = null;
            this.unpinImpl();
            DGCImpl dGCImpl = DGCImpl.getDGCImpl();
            Enumeration enumeration = this.refSet.elements();
            while (enumeration.hasMoreElements()) {
                VMID vMID = (VMID)enumeration.nextElement();
                dGCImpl.unregisterTarget(vMID, this);
            }
            return true;
        }
        return false;
    }

    synchronized void unpinImpl() {
        if (!this.permanent && this.refSet.isEmpty()) {
            this.weakImpl.unpin();
        }
    }

    synchronized void unreferenced(long l, VMID vMID, boolean bl) {
        SequenceEntry sequenceEntry = (SequenceEntry)this.sequenceTable.get(vMID);
        if (sequenceEntry == null || sequenceEntry.sequenceNum > l) {
            return;
        }
        if (bl) {
            sequenceEntry.retain(l);
        } else if (!sequenceEntry.keep) {
            this.sequenceTable.remove(vMID);
        }
        if (DGCImpl.logLevel >= 20) {
            LogStream.log("dgc").println("Target.unreferenced: remove from dirty set: " + vMID);
        }
        this.refSetRemove(vMID);
    }

    public synchronized void vmidDead(VMID vMID) {
        if (DGCImpl.logLevel >= 10) {
            LogStream.log("dgc").println("Target.notify: removing endpoint " + vMID + " from reference set");
        }
        this.sequenceTable.remove(vMID);
        this.refSetRemove(vMID);
    }
}

