/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.PrintStream;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.rmi.server.Dispatcher;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetPropertyAction;

public abstract class Transport {
    static int logLevel = LogStream.parseLevel(Transport.getLogLevel());

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    public void exportObject(Target target) throws RemoteException {
        ObjectTable.putTarget(target);
    }

    public abstract void free(Endpoint var1);

    public abstract Channel getChannel(Endpoint var1);

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.logLevel"));
    }

    public boolean serviceCall(final RemoteCall remoteCall) {
        try {
            Remote remote;
            ObjID objID;
            try {
                objID = ObjID.read(remoteCall.getInputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("unable to read objID", iOException);
            }
            Target target = ObjectTable.getTarget(objID);
            if (target == null || (remote = target.getImpl()) == null) {
                throw new NoSuchObjectException("no such object in table");
            }
            Endpoint endpoint = target.getExportedEndpoint();
            if (endpoint != null && !endpoint.equals(this.thisEndpoint())) {
                throw new NoSuchObjectException("no such object in table");
            }
            final Dispatcher dispatcher = target.getDispatcher();
            target.incrementCallCount();
            try {
                try {
                    if (logLevel >= 20) {
                        LogStream.log("transport").println("Transport.serviceCall: call dispatcher");
                    }
                    final AccessControlContext accessControlContext = target.getAccessControlContext();
                    ClassLoader classLoader = target.getContextClassLoader();
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader2 = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(classLoader);
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    this.checkAcceptPermission(accessControlContext);
                                    dispatcher.dispatch(remote, remoteCall);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (IOException)privilegedActionException.getException();
                        }
                        Object var15_16 = null;
                        thread.setContextClassLoader(classLoader2);
                    }
                    catch (Throwable throwable) {
                        Object var15_17 = null;
                        thread.setContextClassLoader(classLoader2);
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    boolean bl = false;
                    Object var9_20 = null;
                    target.decrementCallCount();
                    return bl;
                }
                Object var9_21 = null;
                target.decrementCallCount();
            }
            catch (Throwable throwable) {
                Object var9_22 = null;
                target.decrementCallCount();
                throw throwable;
            }
        }
        catch (RemoteException remoteException) {
            Object object;
            PrintStream printStream = RemoteServer.getLog();
            if (printStream != null) {
                object = printStream;
                synchronized (object) {
                    try {
                        printStream.print("[" + RemoteServer.getClientHost() + "] ");
                    }
                    catch (ServerNotActiveException serverNotActiveException) {}
                    printStream.print("exception: ");
                    remoteException.printStackTrace(printStream);
                }
            }
            try {
                object = remoteCall.getResultStream(false);
                object.writeObject(remoteException);
                remoteCall.releaseOutputStream();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    public abstract Endpoint thisEndpoint();
}

