/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.proxy.RMIDirectSocketFactory;
import sun.rmi.transport.proxy.RMIHttpToCGISocketFactory;
import sun.rmi.transport.proxy.RMIHttpToPortSocketFactory;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

public class RMIMasterSocketFactory
extends RMISocketFactory {
    static int logLevel = LogStream.parseLevel(RMIMasterSocketFactory.getLogLevel());
    private static long connectTimeout = RMIMasterSocketFactory.getConnectTimeout();
    private Hashtable successTable = new Hashtable();
    private static final int MaxRememberedHosts = 64;
    private Vector hostList = new Vector(64);
    protected RMISocketFactory initialFactory = new RMIDirectSocketFactory();
    protected Vector altFactoryList = new Vector(2);

    public RMIMasterSocketFactory() {
        boolean bl = false;
        try {
            Boolean bl2;
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("http.proxyHost"));
            if (string == null) {
                string = (String)AccessController.doPrivileged(new GetPropertyAction("proxyHost"));
            }
            if (!(bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.disableHttp"))).booleanValue() && string != null && string.length() > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.altFactoryList.addElement(new RMIHttpToPortSocketFactory());
            this.altFactoryList.addElement(new RMIHttpToCGISocketFactory());
        }
    }

    Socket checkConnector(AsyncConnector asyncConnector) throws IOException {
        Exception exception = asyncConnector.getException();
        if (exception != null) {
            exception.fillInStackTrace();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new Error("internal error: unexpected checked exception: " + exception.toString());
        }
        return asyncConnector.getSocket();
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return this.initialFactory.createServerSocket(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket createSocket(String string, int n) throws IOException {
        IOException iOException;
        AsyncConnector asyncConnector;
        Socket socket;
        Socket socket2;
        RMISocketFactory rMISocketFactory;
        block51: {
            int n2;
            Throwable throwable2;
            block49: {
                if (logLevel >= 10) {
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: host: " + string + ", port: " + n);
                }
                if (this.altFactoryList.size() == 0) {
                    return this.initialFactory.createSocket(string, n);
                }
                rMISocketFactory = (RMISocketFactory)this.successTable.get(string);
                if (rMISocketFactory != null) {
                    if (logLevel < 10) return rMISocketFactory.createSocket(string, n);
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: previously successful factory found: " + rMISocketFactory);
                    return rMISocketFactory.createSocket(string, n);
                }
                socket2 = null;
                socket = null;
                asyncConnector = new AsyncConnector(this.initialFactory, string, n, AccessController.getContext());
                iOException = null;
                try {
                    try {
                        Object object;
                        AsyncConnector asyncConnector2 = asyncConnector;
                        synchronized (asyncConnector2) {
                            object = (Thread)AccessController.doPrivileged(new RMIThreadAction(asyncConnector, "AsyncConnector", true));
                            ((Thread)object).start();
                            try {
                                asyncConnector.wait(connectTimeout);
                            }
                            catch (InterruptedException interruptedException) {}
                            socket2 = this.checkConnector(asyncConnector);
                        }
                        if (socket2 == null) {
                            throw new NoRouteToHostException("connect timed out: " + string);
                        }
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection successful");
                        }
                        Socket socket3 = socket2;
                        Object var10_24 = null;
                        if (iOException == null) return socket3;
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                        }
                        int n3 = 0;
                        while (n3 < this.altFactoryList.size()) {
                            block47: {
                                Object object22;
                                rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n3);
                                try {
                                    if (logLevel >= 10) {
                                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                                    }
                                    object22 = rMISocketFactory.createSocket(string, n);
                                    object = ((Socket)object22).getInputStream();
                                    int n4 = ((InputStream)object).read();
                                    ((Socket)object22).close();
                                }
                                catch (IOException object22) {
                                    if (logLevel >= 10) {
                                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object22);
                                    }
                                    break block47;
                                }
                                if (logLevel >= 10) {
                                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                                }
                                try {
                                    socket = rMISocketFactory.createSocket(string, n);
                                    return socket3;
                                }
                                catch (IOException iOException2) {
                                    return socket3;
                                }
                            }
                            ++n3;
                        }
                        return socket3;
                    }
                    catch (UnknownHostException unknownHostException) {
                        iOException = unknownHostException;
                    }
                    catch (NoRouteToHostException noRouteToHostException) {
                        iOException = noRouteToHostException;
                    }
                }
                catch (Throwable throwable2) {
                    Object var10_26 = null;
                    if (iOException == null) throw throwable2;
                    if (logLevel >= 10) {
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                    }
                    n2 = 0;
                    break block49;
                }
                Object var10_25 = null;
                if (iOException == null) break block51;
                if (logLevel >= 10) {
                    LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: direct socket connection failed: " + iOException);
                }
                int n5 = 0;
                while (n5 < this.altFactoryList.size()) {
                    block50: {
                        Object object3;
                        block53: {
                            rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n5);
                            try {}
                            catch (IOException object3) {
                                if (logLevel < 10) break block50;
                                LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object3);
                                break block50;
                            }
                            if (logLevel < 10) break block53;
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                        }
                        object3 = rMISocketFactory.createSocket(string, n);
                        InputStream inputStream = ((Socket)object3).getInputStream();
                        int n6 = inputStream.read();
                        ((Socket)object3).close();
                        if (logLevel >= 10) {
                            LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                        }
                        try {}
                        catch (IOException iOException3) {}
                        socket = rMISocketFactory.createSocket(string, n);
                        break block51;
                    }
                    ++n5;
                }
                break block51;
            }
            while (true) {
                block52: {
                    Object object4;
                    block54: {
                        if (n2 >= this.altFactoryList.size()) {
                            throw throwable2;
                        }
                        rMISocketFactory = (RMISocketFactory)this.altFactoryList.elementAt(n2);
                        try {}
                        catch (IOException object4) {
                            if (logLevel >= 10) {
                                LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory failed: " + object4);
                            }
                            break block52;
                        }
                        if (logLevel < 10) break block54;
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: trying with factory: " + rMISocketFactory);
                    }
                    object4 = rMISocketFactory.createSocket(string, n);
                    InputStream inputStream = ((Socket)object4).getInputStream();
                    int n7 = inputStream.read();
                    ((Socket)object4).close();
                    if (logLevel >= 10) {
                        LogStream.log("transport").println("RMIMasterSocketFactory.createSocket: factory succeeded");
                    }
                    try {}
                    catch (IOException iOException4) {
                        throw throwable2;
                    }
                    socket = rMISocketFactory.createSocket(string, n);
                    throw throwable2;
                }
                ++n2;
            }
        }
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            try {
                AsyncConnector asyncConnector3 = asyncConnector;
                synchronized (asyncConnector3) {
                    socket2 = this.checkConnector(asyncConnector);
                }
                if (socket2 != null) {
                    if (socket == null) return socket2;
                    socket.close();
                    return socket2;
                }
                asyncConnector.notUsed();
            }
            catch (UnknownHostException unknownHostException) {
                iOException = unknownHostException;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                iOException = noRouteToHostException;
            }
            if (socket == null) throw iOException;
            this.rememberFactory(string, rMISocketFactory);
            return socket;
        }
    }

    private static long getConnectTimeout() {
        return (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.proxy.connectTimeout", 15000L));
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.proxy.logLevel"));
    }

    void rememberFactory(String string, RMISocketFactory rMISocketFactory) {
        Hashtable hashtable = this.successTable;
        synchronized (hashtable) {
            while (this.hostList.size() >= 64) {
                this.successTable.remove(this.hostList.elementAt(0));
                this.hostList.removeElementAt(0);
            }
            this.hostList.addElement(string);
            this.successTable.put(string, rMISocketFactory);
        }
    }

    private class AsyncConnector
    implements Runnable {
        private RMISocketFactory factory;
        private String host;
        private int port;
        private AccessControlContext acc;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(RMISocketFactory rMISocketFactory, String string, int n, AccessControlContext accessControlContext) {
            this.factory = rMISocketFactory;
            this.host = string;
            this.port = n;
            this.acc = accessControlContext;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, n);
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {}
            }
            this.cleanUp = true;
        }

        public void run() {
            try {
                Socket socket = this.factory.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = socket;
                    this.notify();
                }
                RMIMasterSocketFactory.this.rememberFactory(this.host, this.factory);
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = exception;
                    this.notify();
                }
            }
        }
    }
}

