/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThreadAction;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    private static int threadNum = 0;
    private static ThreadLocal threadConnectionHandler = new ThreadLocal();
    private TCPEndpoint endpoint;
    private ServerSocket server = null;
    private Hashtable channelTable = new Hashtable();
    static RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    TCPTransport(TCPEndpoint tCPEndpoint) {
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.<init>: Version = 2, ep = " + tCPEndpoint);
        }
        this.endpoint = tCPEndpoint;
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            int n = 10;
            int n2 = 5000;
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            bl = true;
        }
        return bl;
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedEndpoint(this.endpoint);
        super.exportObject(target);
    }

    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection connection, boolean bl) {
        block18: {
            block19: {
                try {
                    try {
                        DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
                        block13: do {
                            int n;
                            if ((n = dataInputStream.read()) == -1) {
                                if (logLevel >= 10) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: connection closed");
                                }
                                break block18;
                            }
                            if (logLevel >= 10) {
                                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: op = " + n);
                            }
                            switch (n) {
                                case 80: {
                                    StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                                    if (this.serviceCall(streamRemoteCall)) continue block13;
                                    Object var4_9 = null;
                                    break block19;
                                }
                                case 82: {
                                    DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                                    dataOutputStream.writeByte(83);
                                    connection.releaseOutputStream();
                                    break;
                                }
                                case 84: {
                                    DGCAckHandler.received(UID.read(dataInputStream));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + n);
                                }
                            }
                        } while (bl);
                    }
                    catch (IOException iOException) {
                        if (logLevel >= 10) {
                            LogStream logStream = LogStream.log("tcp");
                            logStream.println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: exception: ");
                            iOException.printStackTrace(logStream);
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_11 = null;
                    try {
                        connection.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            connection.close();
            return;
        }
        Object var4_10 = null;
        try {}
        catch (IOException iOException) {
            return;
        }
        connection.close();
    }

    private synchronized void listen() throws RemoteException {
        int n = this.endpoint.getPort();
        if (this.server == null) {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").listen: " + "create socket, port = " + n);
            }
            try {
                this.server = this.endpoint.newServerSocket();
                this.newListener();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private void newListener() {
        Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "TCP Accept-" + ++threadNum, true));
        thread.start();
    }

    /*
     * Loose catch block
     */
    public void run() {
        Object var5_4;
        Throwable throwable;
        block23: {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport.run: listening on port " + this.endpoint.getPort());
            }
            while (true) {
                ServerSocket serverSocket;
                if ((serverSocket = this.server) == null) {
                    return;
                }
                throwable = null;
                try {
                    Socket socket = serverSocket.accept();
                    InetAddress inetAddress = socket.getInetAddress();
                    String string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                    Thread thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(new ConnectionHandler(socket, string), "TCP Connection(" + ++threadNum + ")-" + string, true, true));
                    thread.start();
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                catch (RuntimeException runtimeException) {
                    throwable = runtimeException;
                }
                catch (Error error) {
                    throwable = error;
                }
                var5_4 = null;
                if (throwable == null) continue;
                if (!(throwable instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                    }
                    catch (Exception exception) {}
                }
                if (!(throwable instanceof IOException) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError) && !(throwable instanceof MissingResourceException) && !(throwable instanceof SecurityException)) break block23;
                if (!this.continueAfterAcceptFailure(throwable)) break;
            }
            return;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw (Error)throwable;
        catch (Throwable throwable2) {
            var5_4 = null;
            if (throwable != null) {
                if (!(throwable instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                    }
                    catch (Exception exception) {}
                }
                if (throwable instanceof IOException || throwable instanceof OutOfMemoryError || throwable instanceof NoClassDefFoundError || throwable instanceof MissingResourceException || throwable instanceof SecurityException) {
                    if (!this.continueAfterAcceptFailure(throwable)) {
                        return;
                    }
                } else {
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw (Error)throwable;
                }
            }
            throw throwable2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void shedConnectionCaches() {
        var3_1 = this.channelTable;
        synchronized (var3_1) {
            var1_2 = new TCPChannel[this.channelTable.size()];
            var5_3 = this.channelTable.elements();
            var2_4 = 0;
            while (var5_3.hasMoreElements()) {
                var1_2[var2_4] = (TCPChannel)var5_3.nextElement();
                ++var2_4;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var3_1
            if (true) ** GOTO lbl17
        }
        do {
            var1_2[var2_4].shedCache();
lbl17:
            // 2 sources

        } while (--var2_4 >= 0);
    }

    public Endpoint thisEndpoint() {
        return this.endpoint;
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block30: {
                block29: {
                    threadConnectionHandler.set(this);
                    try {
                        this.socket.setTcpNoDelay(true);
                    }
                    catch (Exception exception) {}
                    try {
                        if (connectionReadTimeout > 0) {
                            this.socket.setSoTimeout(connectionReadTimeout);
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        try {
                            InputStream inputStream = this.socket.getInputStream();
                            InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
                            inputStream2.mark(4);
                            DataInputStream dataInputStream = new DataInputStream(inputStream2);
                            int n = dataInputStream.readInt();
                            if (n == 1347375956) {
                                if (logLevel >= 10) {
                                    LogStream.log("tcp").println("TCPTransport.run: decoding HTTP-wrapped call");
                                }
                                inputStream2.reset();
                                try {
                                    this.socket = new HttpReceiveSocket(this.socket, inputStream2, null);
                                    this.remoteHost = "0.0.0.0";
                                    inputStream = this.socket.getInputStream();
                                    inputStream2 = new BufferedInputStream(inputStream);
                                    dataInputStream = new DataInputStream(inputStream2);
                                    n = dataInputStream.readInt();
                                }
                                catch (IOException iOException) {
                                    throw new RemoteException("Error HTTP-unwrapping call", iOException);
                                }
                            }
                            short s = dataInputStream.readShort();
                            if (n != 1246907721 || s != 2) {
                                TCPTransport.closeSocket(this.socket);
                                Object var2_9 = null;
                                break block29;
                            }
                            OutputStream outputStream = this.socket.getOutputStream();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                            int n2 = this.socket.getPort();
                            if (logLevel >= 10) {
                                LogStream.log("tcp").println("TCPTransport.run: accepted socket from [" + this.remoteHost + ":" + n2 + "]");
                            }
                            byte by = dataInputStream.readByte();
                            switch (by) {
                                case 76: {
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint);
                                    TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                                    TCPTransport.this.handleMessages(tCPConnection, false);
                                    break;
                                }
                                case 75: {
                                    dataOutputStream.writeByte(78);
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "suggesting " + this.remoteHost + ":" + n2);
                                    }
                                    dataOutputStream.writeUTF(this.remoteHost);
                                    dataOutputStream.writeInt(n2);
                                    dataOutputStream.flush();
                                    String string = dataInputStream.readUTF();
                                    int n3 = dataInputStream.readInt();
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "client using " + string + ":" + n3);
                                    }
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint);
                                    TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                                    TCPTransport.this.handleMessages(tCPConnection, true);
                                    break;
                                }
                                case 77: {
                                    ConnectionMultiplexer connectionMultiplexer;
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "accepting multiplex protocol");
                                    }
                                    dataOutputStream.writeByte(78);
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "suggesting " + this.remoteHost + ":" + n2);
                                    }
                                    dataOutputStream.writeUTF(this.remoteHost);
                                    dataOutputStream.writeInt(n2);
                                    dataOutputStream.flush();
                                    TCPEndpoint tCPEndpoint = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), TCPTransport.this.endpoint.getClientSocketFactory(), TCPTransport.this.endpoint.getServerSocketFactory());
                                    if (logLevel >= 20) {
                                        LogStream.log("tcp").println("TCPTransport(" + TCPTransport.this.endpoint.getPort() + ").run: " + "client using " + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort());
                                    }
                                    Hashtable hashtable = TCPTransport.this.channelTable;
                                    synchronized (hashtable) {
                                        TCPChannel tCPChannel = (TCPChannel)TCPTransport.this.getChannel(tCPEndpoint);
                                        connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream2, outputStream, false);
                                        tCPChannel.useMultiplexer(connectionMultiplexer);
                                    }
                                    connectionMultiplexer.run();
                                    break;
                                }
                                default: {
                                    dataOutputStream.writeByte(79);
                                    dataOutputStream.flush();
                                    break;
                                }
                            }
                        }
                        catch (IOException iOException) {
                            if (logLevel >= 10) {
                                LogStream logStream = LogStream.log("tcp");
                                logStream.println("TCPTransport.run: terminated with exception:");
                                iOException.printStackTrace(logStream);
                            }
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_11 = null;
                        TCPTransport.closeSocket(this.socket);
                        throw throwable;
                    }
                }
                TCPTransport.closeSocket(this.socket);
                return;
            }
            Object var2_10 = null;
            TCPTransport.closeSocket(this.socket);
        }
    }
}

