/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;
import sun.security.provider.SeedGenerator;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable {
    private static SecureRandom seeder;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest digest;
    private byte[] state;
    private byte[] remainder;
    private int remCount;

    public SecureRandom() {
        this.init(null);
    }

    private SecureRandom(byte[] byArray) {
        this.init(byArray);
    }

    public byte[] engineGenerateSeed(int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = SeedGenerator.getByte();
            ++n2;
        }
        return byArray;
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        byte[] byArray2 = this.remainder;
        if (this.state == null) {
            SecureRandom.privateStaticInitHelpeR(this);
            byte[] byArray3 = new byte[20];
            seeder.engineNextBytes(byArray3);
            this.state = this.digest.digest(byArray3);
        }
        if ((n3 = this.remCount) > 0) {
            n2 = byArray.length - n4 < 20 - n3 ? byArray.length - n4 : 20 - n3;
            n = 0;
            while (n < n2) {
                byArray[n] = byArray2[n3];
                byArray2[n3++] = 0;
                ++n;
            }
            this.remCount += n2;
            n4 += n2;
        }
        while (n4 < byArray.length) {
            this.digest.update(this.state);
            byArray2 = this.digest.digest();
            SecureRandom.updateState(this.state, byArray2);
            n2 = byArray.length - n4 > 20 ? 20 : byArray.length - n4;
            n = 0;
            while (n < n2) {
                byArray[n4++] = byArray2[n];
                byArray2[n] = 0;
                ++n;
            }
            this.remCount += n2;
        }
        this.remainder = byArray2;
        this.remCount %= 20;
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        if (this.state != null) {
            this.digest.update(this.state);
            int n = 0;
            while (n < this.state.length) {
                this.state[n] = 0;
                ++n;
            }
        }
        this.state = this.digest.digest(byArray);
    }

    private void init(byte[] byArray) {
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    private static synchronized void privateStaticInitHelpeR(SecureRandom secureRandom) {
        if (seeder == null) {
            seeder = new SecureRandom(SeedGenerator.getSystemEntropy());
            seeder.engineSetSeed(secureRandom.engineGenerateSeed(20));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
    }

    private static void updateState(byte[] byArray, byte[] byArray2) {
        int n = 1;
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < byArray.length) {
            n2 = byArray[n3] + byArray2[n3] + n;
            by = (byte)n2;
            bl |= byArray[n3] != by;
            byArray[n3] = by;
            n = n2 >> 8;
            ++n3;
        }
        if (!bl) {
            byArray[0] = (byte)(byArray[0] + 1);
        }
    }
}

