/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import sun.security.util.BigInt;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerInputStream {
    DerInputBuffer buffer;

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray) {
        this.init(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n, int n2) {
        this.init(byArray, n, n2);
    }

    public int available() {
        return this.buffer.available();
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int n = DerInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            throw new IOException("unaligned bit string");
        }
        if (this.buffer.read(byArray = new byte[--n]) != n) {
            throw new IOException("short read of DER bit string");
        }
        return byArray;
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (this.buffer.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public BigInt getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    public Date getGeneralizedTime() throws IOException {
        int n;
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.buffer.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        int n3 = 1000 * Character.digit((char)this.buffer.read(), 10);
        n3 += 100 * Character.digit((char)this.buffer.read(), 10);
        n3 += 10 * Character.digit((char)this.buffer.read(), 10);
        n3 += Character.digit((char)this.buffer.read(), 10);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 12) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l);
        return date;
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n2 = 0;
            while (n3 > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
                --n3;
            }
        }
        return n2;
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerInputStream.getLength(inputStream.read(), inputStream);
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public DerValue[] getSequence(int n) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        int n2 = this.buffer.read();
        if (!bl && n2 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ASCII");
    }

    public Date getUTCTime() throws IOException {
        int n;
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.buffer.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 < 11 || n2 > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int n3 = 10 * Character.digit((char)this.buffer.read(), 10);
        n3 = (n3 += Character.digit((char)this.buffer.read(), 10)) <= 50 ? (n3 += 2000) : (n3 += 1900);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 10) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime() / 1000L * 1000L;
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 45: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
            case 90: 
        }
        date.setTime(l);
        return date;
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)18, "UTF-8", "UTF8");
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int n = DerInputStream.getLength(this.buffer) - 1;
        int n2 = n * 8 - this.buffer.read();
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n2, byArray);
    }

    private void init(byte[] byArray, int n, int n2) {
        if (DerIndefLenConverter.isIndefinite(byArray[n + 1])) {
            try {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
                this.buffer = new DerInputBuffer(derIndefLenConverter.convert(byArray2));
            }
            catch (IOException iOException) {}
        } else {
            this.buffer = new DerInputBuffer(byArray, n, n2);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public void mark(int n) {
        this.buffer.mark(n);
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    private String readString(byte by, String string, String string2) throws IOException {
        if (this.buffer.read() != by) {
            throw new IOException("DER input not a " + string + " string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER " + string + " string");
        }
        return new String(byArray, string2);
    }

    protected DerValue[] readVector(int n) throws IOException {
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n2 ? this : this.subStream(n2, true);
        Vector vector = new Vector(n, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        int n4 = 0;
        while (n4 < n3) {
            derValueArray[n4] = (DerValue)vector.elementAt(n4);
            ++n4;
        }
        return derValueArray;
    }

    public void reset() {
        this.buffer.reset();
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n);
        if (bl) {
            this.buffer.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }
}

