/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import sun.security.util.BigInt;
import sun.security.util.BitArray;
import sun.security.util.ByteArrayLexOrder;
import sun.security.util.ByteArrayTagOrder;
import sun.security.util.DerEncoder;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream() {
    }

    public DerOutputStream(int n) {
        super(n);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    public void putBMPString(String string) throws IOException {
        this.writeString(string, (byte)30, "UnicodeBigUnmarked");
    }

    private void putBigInt(BigInt bigInt) throws IOException {
        byte[] byArray = bigInt.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            this.putLength(byArray.length + 1);
            this.write(0);
        } else {
            this.putLength(byArray.length);
        }
        this.write(byArray, 0, byArray.length);
    }

    public void putBitString(byte[] byArray) throws IOException {
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(0);
        this.write(byArray);
    }

    public void putBoolean(boolean bl) throws IOException {
        this.write(1);
        this.putLength(1);
        if (bl) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putDerValue(DerValue derValue) throws IOException {
        derValue.encode(this);
    }

    public void putEnumerated(BigInt bigInt) throws IOException {
        this.write(10);
        this.putBigInt(bigInt);
    }

    public void putGeneralizedTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(24);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putIA5String(String string) throws IOException {
        this.writeString(string, (byte)22, "ASCII");
    }

    public void putInteger(BigInt bigInt) throws IOException {
        this.write(2);
        this.putBigInt(bigInt);
    }

    public void putLength(int n) throws IOException {
        if (n < 128) {
            this.write((byte)n);
        } else if (n < 256) {
            this.write(-127);
            this.write((byte)n);
        } else if (n < 65536) {
            this.write(-126);
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else if (n < 0x1000000) {
            this.write(-125);
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        } else {
            this.write(-124);
            this.write((byte)(n >> 24));
            this.write((byte)(n >> 16));
            this.write((byte)(n >> 8));
            this.write((byte)n);
        }
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier objectIdentifier) throws IOException {
        objectIdentifier.encode(this);
    }

    public void putOctetString(byte[] byArray) throws IOException {
        this.write((byte)4, byArray);
    }

    public void putOrderedSet(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, tagOrder);
    }

    private void putOrderedSet(byte by, DerEncoder[] derEncoderArray, Comparator comparator) throws IOException {
        DerOutputStream[] derOutputStreamArray = new DerOutputStream[derEncoderArray.length];
        int n = 0;
        while (n < derEncoderArray.length) {
            derOutputStreamArray[n] = new DerOutputStream();
            derEncoderArray[n].derEncode(derOutputStreamArray[n]);
            ++n;
        }
        byte[][] byArray = new byte[derOutputStreamArray.length][];
        int n2 = 0;
        while (n2 < derOutputStreamArray.length) {
            byArray[n2] = derOutputStreamArray[n2].toByteArray();
            ++n2;
        }
        Arrays.sort((Object[])byArray, comparator);
        DerOutputStream derOutputStream = new DerOutputStream();
        int n3 = 0;
        while (n3 < derOutputStreamArray.length) {
            derOutputStream.write(byArray[n3]);
            ++n3;
        }
        this.write(by, derOutputStream);
    }

    public void putOrderedSetOf(byte by, DerEncoder[] derEncoderArray) throws IOException {
        this.putOrderedSet(by, derEncoderArray, lexOrder);
    }

    public void putPrintableString(String string) throws IOException {
        this.writeString(string, (byte)19, "ASCII");
    }

    public void putSequence(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n = 0;
        while (n < derValueArray.length) {
            derValueArray[n].encode(derOutputStream);
            ++n;
        }
        this.write((byte)48, derOutputStream);
    }

    public void putSet(DerValue[] derValueArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        int n = 0;
        while (n < derValueArray.length) {
            derValueArray[n].encode(derOutputStream);
            ++n;
        }
        this.write((byte)49, derOutputStream);
    }

    public void putT61String(String string) throws IOException {
        this.writeString(string, (byte)20, "ASCII");
    }

    public void putTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        this.write(by3);
    }

    public void putUTCTime(Date date) throws IOException {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        String string = "yyMMddHHmmss'Z'";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        this.write(23);
        this.putLength(byArray.length);
        this.write(byArray);
    }

    public void putUTF8String(String string) throws IOException {
        this.writeString(string, (byte)18, "UTF8");
    }

    public void putUnalignedBitString(BitArray bitArray) throws IOException {
        byte[] byArray = bitArray.toByteArray();
        this.write(3);
        this.putLength(byArray.length + 1);
        this.write(byArray.length * 8 - bitArray.length());
        this.write(byArray);
    }

    public void write(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.putLength(derOutputStream.count);
        this.write(derOutputStream.buf, 0, derOutputStream.count);
    }

    public void write(byte by, byte[] byArray) throws IOException {
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeImplicit(byte by, DerOutputStream derOutputStream) throws IOException {
        this.write(by);
        this.write(derOutputStream.buf, 1, derOutputStream.count - 1);
    }

    private void writeString(String string, byte by, String string2) throws IOException {
        byte[] byArray = string.getBytes(string2);
        this.write(by);
        this.putLength(byArray.length);
        this.write(byArray);
    }
}

