/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private static boolean initOidTable = false;
    private static Hashtable oidTable;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    protected DerValue params;
    private static final int[] MD2_data;
    private static final int[] MD5_data;
    private static final int[] SHA1_OIW_data;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    private static final int[] RSAEncryption_data;
    public static final ObjectIdentifier DH_oid;
    public static final ObjectIdentifier DH_PKIX_oid;
    public static final ObjectIdentifier DSA_OIW_oid;
    public static final ObjectIdentifier DSA_oid;
    public static final ObjectIdentifier RSA_oid;
    public static final ObjectIdentifier RSAEncryption_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    public static final ObjectIdentifier md2WithRSAEncryption_oid;
    public static final ObjectIdentifier md5WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static final ObjectIdentifier shaWithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_oid;

    static {
        MD2_data = new int[]{1, 2, 840, 113549, 2, 2};
        MD5_data = new int[]{1, 2, 840, 113549, 2, 5};
        SHA1_OIW_data = new int[]{1, 3, 14, 3, 2, 26};
        MD2_oid = new ObjectIdentifier(MD2_data);
        MD5_oid = new ObjectIdentifier(MD5_data);
        SHA_oid = new ObjectIdentifier(SHA1_OIW_data);
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{1, 2, 5, 8, 1, 1};
        RSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 1};
        DH_oid = new ObjectIdentifier(DH_data);
        DH_PKIX_oid = new ObjectIdentifier(DH_PKIX_data);
        DSA_OIW_oid = new ObjectIdentifier(DSA_OIW_data);
        DSA_oid = new ObjectIdentifier(DSA_PKIX_data);
        RSA_oid = new ObjectIdentifier(RSA_data);
        RSAEncryption_oid = new ObjectIdentifier(RSAEncryption_data);
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        md2WithRSAEncryption_oid = new ObjectIdentifier(md2WithRSAEncryption_data);
        md5WithRSAEncryption_oid = new ObjectIdentifier(md5WithRSAEncryption_data);
        sha1WithRSAEncryption_oid = new ObjectIdentifier(sha1WithRSAEncryption_data);
        sha1WithRSAEncryption_OIW_oid = new ObjectIdentifier(sha1WithRSAEncryption_OIW_data);
        shaWithDSA_OIW_oid = new ObjectIdentifier(shaWithDSA_OIW_data);
        sha1WithDSA_OIW_oid = new ObjectIdentifier(sha1WithDSA_OIW_data);
        sha1WithDSA_oid = new ObjectIdentifier(dsaWithSHA1_PKIX_data);
    }

    public AlgorithmId() {
    }

    public AlgorithmId(ObjectIdentifier objectIdentifier) {
        this.algid = objectIdentifier;
    }

    private AlgorithmId(ObjectIdentifier objectIdentifier, DerValue derValue) throws IOException {
        this.algid = objectIdentifier;
        this.params = derValue;
        if (this.params != null) {
            this.decodeParams();
        }
    }

    private String algName() {
        if (this.algid.equals(MD5_oid)) {
            return "MD5";
        }
        if (this.algid.equals(MD2_oid)) {
            return "MD2";
        }
        if (this.algid.equals(SHA_oid)) {
            return "SHA";
        }
        if (this.algid.equals(RSAEncryption_oid) || this.algid.equals(RSA_oid)) {
            return "RSA";
        }
        if (this.algid.equals(DH_oid) || this.algid.equals(DH_PKIX_oid)) {
            return "Diffie-Hellman";
        }
        if (this.algid.equals(DSA_oid) || this.algid.equals(DSA_OIW_oid)) {
            return "DSA";
        }
        if (this.algid.equals(md5WithRSAEncryption_oid)) {
            return "MD5withRSA";
        }
        if (this.algid.equals(md2WithRSAEncryption_oid)) {
            return "MD2withRSA";
        }
        if (this.algid.equals(sha1WithDSA_oid) || this.algid.equals(sha1WithDSA_OIW_oid) || this.algid.equals(shaWithDSA_OIW_oid)) {
            return "SHA1withDSA";
        }
        if (this.algid.equals(sha1WithRSAEncryption_oid) || this.algid.equals(sha1WithRSAEncryption_OIW_oid)) {
            return "SHA1withRSA";
        }
        return this.algid.toString();
    }

    private static ObjectIdentifier algOID(String string) {
        if (string.indexOf(46) != -1) {
            if (string.startsWith("OID.")) {
                return new ObjectIdentifier(string.substring("OID.".length()));
            }
            return new ObjectIdentifier(string);
        }
        if (string.equalsIgnoreCase("MD5")) {
            return MD5_oid;
        }
        if (string.equalsIgnoreCase("MD2")) {
            return MD2_oid;
        }
        if (string.equalsIgnoreCase("SHA") || string.equalsIgnoreCase("SHA1") || string.equalsIgnoreCase("SHA-1")) {
            return SHA_oid;
        }
        if (string.equalsIgnoreCase("RSA")) {
            return RSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("Diffie-Hellman") || string.equalsIgnoreCase("DH")) {
            return DH_oid;
        }
        if (string.equalsIgnoreCase("DSA")) {
            return DSA_oid;
        }
        if (string.equalsIgnoreCase("MD5withRSA") || string.equalsIgnoreCase("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("MD2withRSA") || string.equalsIgnoreCase("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (string.equalsIgnoreCase("SHAwithDSA") || string.equalsIgnoreCase("SHA1withDSA") || string.equalsIgnoreCase("SHA/DSA") || string.equalsIgnoreCase("SHA1/DSA") || string.equalsIgnoreCase("DSAWithSHA1")) {
            return sha1WithDSA_oid;
        }
        if (string.equalsIgnoreCase("SHA1WithRSA") || string.equalsIgnoreCase("SHA1/RSA")) {
            return sha1WithRSAEncryption_oid;
        }
        if (!initOidTable) {
            Provider[] providerArray = Security.getProviders();
            int n = 0;
            while (n < providerArray.length) {
                Enumeration enumeration = providerArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    int n2;
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.toUpperCase().startsWith("ALG.ALIAS") || (n2 = string2.toUpperCase().indexOf("OID.", 0)) == -1) continue;
                    if ((n2 += "OID.".length()) == string2.length()) break;
                    if (oidTable == null) {
                        oidTable = new Hashtable(11);
                    }
                    String string3 = string2.substring(n2);
                    String string4 = providerArray[n].getProperty(string2).toUpperCase();
                    if (oidTable.get(string4) != null) continue;
                    oidTable.put(string4, new ObjectIdentifier(string3));
                }
                ++n;
            }
            initOidTable = true;
        }
        return (ObjectIdentifier)oidTable.get(string.toUpperCase());
    }

    protected void decodeParams() throws IOException {
        try {
            this.algParams = AlgorithmParameters.getInstance(this.algid.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.algid);
        if (this.params == null) {
            derOutputStream.putNull();
        } else {
            derOutputStream.putDerValue(this.params);
        }
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.algid);
        if (this.params == null) {
            derOutputStream2.putNull();
        } else {
            derOutputStream2.putDerValue(this.params);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public boolean equals(Object object) {
        if (object instanceof AlgorithmId) {
            return this.equals((AlgorithmId)object);
        }
        if (object instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)object);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier objectIdentifier) {
        return this.algid.equals(objectIdentifier);
    }

    public boolean equals(AlgorithmId algorithmId) {
        if (!this.algid.equals(algorithmId.algid)) {
            return false;
        }
        if (this.params == null && algorithmId.params == null) {
            return true;
        }
        if (this.params == null) {
            return false;
        }
        return this.params.equals(algorithmId.params);
    }

    public static AlgorithmId get(String string) throws NoSuchAlgorithmException {
        ObjectIdentifier objectIdentifier = AlgorithmId.algOID(string);
        if (objectIdentifier == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + string);
        }
        return new AlgorithmId(objectIdentifier);
    }

    public static AlgorithmId getAlgorithmId(String string) throws NoSuchAlgorithmException {
        return AlgorithmId.get(string);
    }

    public byte[] getEncodedParams() throws IOException {
        if (this.params == null) {
            return null;
        }
        return this.params.toByteArray();
    }

    public String getName() {
        return this.algName();
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public AlgorithmParameters getParameters() {
        return this.algParams;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.algid.toString());
        stringBuffer.append(this.paramsToString());
        return stringBuffer.toString().hashCode();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        if (this.algParams != null) {
            return this.algParams.toString();
        }
        return ", params unparsed";
    }

    public static AlgorithmId parse(DerValue derValue) throws IOException {
        DerValue derValue2;
        if (derValue.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream derInputStream = derValue.toDerInputStream();
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (derInputStream.available() == 0) {
            derValue2 = null;
        } else {
            derValue2 = derInputStream.getDerValue();
            if (derValue2.tag == 5) {
                derValue2 = null;
            }
        }
        AlgorithmId algorithmId = new AlgorithmId(objectIdentifier, derValue2);
        if (derValue2 != null) {
            algorithmId.decodeParams();
        }
        return algorithmId;
    }

    public String toString() {
        return String.valueOf(this.algName()) + this.paramsToString();
    }
}

