/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.BigInt;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class BasicConstraintsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.BasicConstraints";
    public static final String NAME = "BasicConstraints";
    public static final String IS_CA = "is_ca";
    public static final String PATH_LEN = "path_len";
    private boolean ca = false;
    private int pathLen = -1;

    public BasicConstraintsExtension(Boolean bl, Object object) throws IOException {
        DerValue derValue;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = bl;
        if (object instanceof byte[]) {
            int n = Array.getLength(object);
            byte[] byArray = new byte[n];
            System.arraycopy(object, 0, byArray, 0, n);
            this.extensionValue = byArray;
            DerValue derValue2 = new DerValue(byArray);
            if (derValue2.tag != 48) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            if (derValue2.data == null) {
                return;
            }
            derValue = derValue2.data.getDerValue();
            if (derValue.tag != 1) {
                return;
            }
            this.ca = true;
            if (derValue2.data.available() == 0) {
                this.pathLen = Integer.MAX_VALUE;
                return;
            }
            derValue = derValue2.data.getDerValue();
            if (derValue.tag != 2) {
                throw new IOException("Invalid encoding of BasicConstraints");
            }
        } else {
            throw new IOException("Invalid argument type");
        }
        this.pathLen = derValue.getInteger().toInt();
    }

    public BasicConstraintsExtension(boolean bl, int n) throws IOException {
        this.ca = bl;
        this.pathLen = n;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = bl;
        this.encodeThis();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            this.ca = false;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            this.pathLen = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.BasicConstraints_Id;
            this.critical = this.ca;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    private void encodeThis() throws IOException {
        if (!this.ca && this.pathLen < 0) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.ca) {
            derOutputStream2.putBoolean(this.ca);
        }
        if (this.pathLen >= 0) {
            derOutputStream2.putInteger(new BigInt(this.pathLen));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            return new Boolean(this.ca);
        }
        if (string.equalsIgnoreCase(PATH_LEN)) {
            return new Integer(this.pathLen);
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(IS_CA);
        attributeNameEnumeration.addElement(PATH_LEN);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(IS_CA)) {
            if (!(object instanceof Boolean)) {
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.ca = (Boolean)object;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            if (!(object instanceof Integer)) {
                throw new IOException("Attribute value should be of type Integer.");
            }
            this.pathLen = (Integer)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "BasicConstraints:[\n";
        string = String.valueOf(string) + (this.ca ? "CA:true" : "CA:false") + "\n";
        string = this.pathLen >= 0 ? String.valueOf(string) + "PathLen:" + this.pathLen + "\n" : String.valueOf(string) + "PathLen: undefined\n";
        return String.valueOf(string) + "]\n";
    }
}

