/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class URIName
implements GeneralNameInterface {
    private String name;

    public URIName(String string) {
        this.name = string;
    }

    public URIName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URIName)) {
            return false;
        }
        URIName uRIName = (URIName)object;
        if (this.name.equalsIgnoreCase(uRIName.name)) {
            String string;
            String string2 = this.getRemainder(this.name);
            if (string2 == null ^ (string = this.getRemainder(uRIName.name)) == null) {
                return false;
            }
            if (string2 != null && string != null) {
                return string2.equals(string);
            }
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    private String getRemainder(String string) {
        String string2 = null;
        int n = string.indexOf("//");
        if (n > 0 && (n = string.indexOf(47, n + 2)) > 0 && n + 1 < string.length()) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public int getType() {
        return 6;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public String toString() {
        return "URIName: " + this.name;
    }
}

