/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateValidity;
import sun.security.x509.Extension;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDMap;
import sun.security.x509.SerialNumber;
import sun.security.x509.UniqueIdentity;
import sun.security.x509.X509AttributeName;
import sun.security.x509.X509CertInfo;

public class X509CertImpl
extends X509Certificate
implements DerEncoder {
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly = false;
    private byte[] signedCert = null;
    protected X509CertInfo info = null;
    protected AlgorithmId algId = null;
    protected byte[] signature = null;
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    private static final int NUM_STANDARD_KEY_USAGE = 9;

    public X509CertImpl() {
    }

    public X509CertImpl(InputStream inputStream) throws CertificateException {
        try {
            this.parse(new DerValue(inputStream));
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + iOException);
        }
    }

    public X509CertImpl(DerValue derValue) throws CertificateException {
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + iOException);
        }
    }

    public X509CertImpl(X509CertInfo x509CertInfo) {
        this.info = x509CertInfo;
    }

    public X509CertImpl(byte[] byArray) throws CertificateException {
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + iOException);
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        this.checkValidity(date);
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        CertificateValidity certificateValidity = null;
        try {
            certificateValidity = (CertificateValidity)this.info.get("validity");
        }
        catch (Exception exception) {
            throw new CertificateNotYetValidException("Incorrect validity period");
        }
        if (certificateValidity == null) {
            throw new CertificateNotYetValidException("Null validity period");
        }
        certificateValidity.valid(date);
    }

    public void delete(String string) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + string2);
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() != null) {
                this.info = null;
            } else {
                this.info.delete(x509AttributeName.getSuffix());
            }
        } else if (string2.equalsIgnoreCase(ALG_ID)) {
            this.algId = null;
        } else if (string2.equalsIgnoreCase(SIGNATURE)) {
            this.signature = null;
        } else if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            throw new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + string2);
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (this.signedCert == null) {
            throw new IOException("Null certificate to encode");
        }
        outputStream.write((byte[])this.signedCert.clone());
    }

    public void encode(OutputStream outputStream) throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Null certificate to encode");
        }
        try {
            outputStream.write((byte[])this.signedCert.clone());
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public Object get(String string) throws CertificateParsingException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + string2 + "]");
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() != null) {
                try {
                    return this.info.get(x509AttributeName.getSuffix());
                }
                catch (IOException iOException) {
                    throw new CertificateParsingException(iOException.toString());
                }
                catch (CertificateException certificateException) {
                    throw new CertificateParsingException(certificateException.toString());
                }
            }
            return this.info;
        }
        if (string2.equalsIgnoreCase(ALG_ID)) {
            return this.algId;
        }
        if (string2.equalsIgnoreCase(SIGNATURE)) {
            return this.signature;
        }
        if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            return this.signedCert;
        }
        throw new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + string2);
    }

    public int getBasicConstraints() {
        try {
            String string = OIDMap.getName(new ObjectIdentifier(BASIC_CONSTRAINT_OID));
            if (string == null) {
                return -1;
            }
            BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.get(string);
            if (basicConstraintsExtension == null) {
                return -1;
            }
            if (((Boolean)basicConstraintsExtension.get("is_ca")).booleanValue()) {
                return (Integer)basicConstraintsExtension.get("path_len");
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public Set getCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                return null;
            }
            HashSet hashSet = new HashSet(11);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                if (!extension.isCritical()) continue;
                hashSet.add(extension.getExtensionId().toString());
            }
            return hashSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement("x509.info");
        attributeNameEnumeration.addElement(SIG_ALG);
        attributeNameEnumeration.addElement(SIG);
        attributeNameEnumeration.addElement("x509.signed_cert");
        return attributeNameEnumeration.elements();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Null certificate to encode");
        }
        return (byte[])this.signedCert.clone();
    }

    public byte[] getExtensionValue(String string) {
        try {
            Object object;
            Object object2;
            String string2 = OIDMap.getName(new ObjectIdentifier(string));
            Extension extension = null;
            if (string2 == null) {
                object2 = (CertificateExtensions)this.info.get("extensions");
                if (object2 == null) {
                    return null;
                }
                object = new ObjectIdentifier(string);
                Extension extension2 = null;
                Enumeration enumeration = ((CertificateExtensions)object2).getElements();
                while (enumeration.hasMoreElements()) {
                    extension2 = (Extension)enumeration.nextElement();
                    ObjectIdentifier objectIdentifier = extension2.getExtensionId();
                    if (!objectIdentifier.equals((ObjectIdentifier)object)) continue;
                    extension = extension2;
                    break;
                }
            } else {
                extension = (Extension)this.get(string2);
            }
            if (extension == null) {
                return null;
            }
            object2 = extension.getExtensionValue();
            if (object2 == null) {
                return null;
            }
            object = new DerOutputStream();
            ((DerOutputStream)object).putOctetString((byte[])object2);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Principal getIssuerDN() {
        if (this.info == null) {
            return null;
        }
        try {
            Principal principal = (Principal)this.info.get("issuer.dname");
            return principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean[] getIssuerUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)this.info.get("issuerID.id");
            if (uniqueIdentity == null) {
                return null;
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean[] getKeyUsage() {
        try {
            String string = OIDMap.getName(new ObjectIdentifier(KEY_USAGE_OID));
            if (string == null) {
                return null;
            }
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.get(string);
            if (keyUsageExtension == null) {
                return null;
            }
            boolean[] blArray = keyUsageExtension.getBits();
            if (blArray.length < 9) {
                boolean[] blArray2 = new boolean[9];
                System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
                blArray = blArray2;
            }
            return blArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getName() {
        return NAME;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                return null;
            }
            HashSet hashSet = new HashSet(11);
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                if (extension.isCritical()) continue;
                hashSet.add(extension.getExtensionId().toString());
            }
            return hashSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getNotAfter() {
        if (this.info == null) {
            return null;
        }
        try {
            Date date = (Date)this.info.get("validity.notAfter");
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Date getNotBefore() {
        if (this.info == null) {
            return null;
        }
        try {
            Date date = (Date)this.info.get("validity.notBefore");
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public PublicKey getPublicKey() {
        if (this.info == null) {
            return null;
        }
        try {
            PublicKey publicKey = (PublicKey)this.info.get("key.value");
            return publicKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        if (this.info == null) {
            return null;
        }
        try {
            SerialNumber serialNumber = (SerialNumber)this.info.get("serialNumber.number");
            return serialNumber.getNumber().toBigInteger();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSigAlgName() {
        if (this.algId == null) {
            return null;
        }
        return this.algId.getName();
    }

    public String getSigAlgOID() {
        if (this.algId == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = this.algId.getOID();
        return objectIdentifier.toString();
    }

    public byte[] getSigAlgParams() {
        if (this.algId == null) {
            return null;
        }
        try {
            return this.algId.getEncodedParams();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] byArray = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public Principal getSubjectDN() {
        if (this.info == null) {
            return null;
        }
        try {
            Principal principal = (Principal)this.info.get("subject.dname");
            return principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean[] getSubjectUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)this.info.get("subjectID.id");
            if (uniqueIdentity == null) {
                return null;
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (this.info != null) {
            return this.info.getEncodedInfo();
        }
        throw new CertificateEncodingException("Uninitialized certificate");
    }

    public int getVersion() {
        if (this.info == null) {
            return -1;
        }
        try {
            int n = (Integer)this.info.get("version.number");
            return n + 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.info == null) {
            return false;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)this.info.get("extensions");
            if (certificateExtensions == null) {
                return false;
            }
            return certificateExtensions.hasUnsupportedCriticalExtension();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void parse(DerValue derValue) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateParsingException("cannot over-write existing certificate");
        }
        this.signedCert = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue(), derValue.data.getDerValue()};
        if (derValue.data.available() != 0) {
            throw new CertificateParsingException("signed overrun, bytes = " + derValue.data.available());
        }
        if (derValueArray[0].tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.algId = AlgorithmId.parse(derValueArray[1]);
        this.signature = derValueArray[2].getBitString();
        if (derValueArray[1].data.available() != 0) {
            throw new CertificateParsingException("algid field overrun");
        }
        if (derValueArray[2].data.available() != 0) {
            throw new CertificateParsingException("signed fields overrun");
        }
        this.info = new X509CertInfo(derValueArray[0]);
        AlgorithmId algorithmId = (AlgorithmId)this.info.get("algorithmID.algorithm");
        if (!this.algId.equals(algorithmId)) {
            throw new CertificateException("Signature algorithm mismatch");
        }
        this.readOnly = true;
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + string2);
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() == null) {
                if (!(object instanceof X509CertInfo)) {
                    throw new CertificateException("Attribute value should be of type X509CertInfo.");
                }
                this.info = (X509CertInfo)object;
                this.signedCert = null;
            } else {
                this.info.set(x509AttributeName.getSuffix(), object);
                this.signedCert = null;
            }
        } else {
            throw new CertificateException("Attribute name not recognized or set() not allowed for the same: " + string2);
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(privateKey, string, null);
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CertificateEncodingException("cannot over-write existing certificate");
            }
            Signature signature = null;
            signature = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            this.algId = AlgorithmId.get(signature.getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.info.encode(derOutputStream2);
            byte[] byArray = derOutputStream2.toByteArray();
            this.algId.encode(derOutputStream2);
            signature.update(byArray, 0, byArray.length);
            this.signature = signature.sign();
            derOutputStream2.putBitString(this.signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCert = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public String toString() {
        if (this.info == null || this.algId == null || this.signature == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[\n");
        stringBuffer.append(String.valueOf(this.info.toString()) + "\n");
        stringBuffer.append("  Algorithm: [" + this.algId.toString() + "]\n");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        stringBuffer.append("  Signature:\n" + hexDumpEncoder.encodeBuffer(this.signature));
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, null);
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature signature = null;
        signature = string == null || string.length() == 0 ? Signature.getInstance(this.algId.getName()) : Signature.getInstance(this.algId.getName(), string);
        signature.initVerify(publicKey);
        byte[] byArray = this.info.getEncodedInfo();
        signature.update(byArray, 0, byArray.length);
        if (!signature.verify(this.signature)) {
            throw new SignatureException("Signature does not match.");
        }
    }
}

