/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.ResourceRecord;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingException;

class ResourceRecords {
    Vector question = new Vector();
    Vector answer = new Vector();
    Vector authority = new Vector();
    Vector additional = new Vector();
    boolean zoneXfer;

    ResourceRecords(byte[] byArray, int n2, Header header, boolean bl2) throws NamingException {
        if (bl2) {
            this.answer.ensureCapacity(8192);
        }
        this.zoneXfer = bl2;
        this.add(byArray, n2, header);
    }

    int getFirstAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.firstElement()).getType();
    }

    int getLastAnsType() {
        if (this.answer.size() == 0) {
            return -1;
        }
        return ((ResourceRecord)this.answer.lastElement()).getType();
    }

    void add(byte[] byArray, int n2, Header header) throws NamingException {
        int n3 = 12;
        try {
            ResourceRecord resourceRecord;
            int n4;
            for (n4 = 0; n4 < header.numQuestions; ++n4) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, true, false);
                if (!this.zoneXfer) {
                    this.question.addElement(resourceRecord);
                }
                n3 += resourceRecord.size();
            }
            for (n4 = 0; n4 < header.numAnswers; ++n4) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, false, !this.zoneXfer);
                this.answer.addElement(resourceRecord);
                n3 += resourceRecord.size();
            }
            if (this.zoneXfer) {
                return;
            }
            for (n4 = 0; n4 < header.numAuthorities; ++n4) {
                resourceRecord = new ResourceRecord(byArray, n2, n3, false, true);
                this.authority.addElement(resourceRecord);
                n3 += resourceRecord.size();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new CommunicationException("DNS error: corrupted message");
        }
    }
}

