/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class DecimalDV
extends TypeValidator {
    public final short getAllowedFacets() {
        return 4088;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "decimal"});
        }
    }

    public final int compare(Object object, Object object2) {
        return ((XDecimal)object).compareTo((XDecimal)object2);
    }

    public final int getTotalDigits(Object object) {
        return ((XDecimal)object).totalDigits;
    }

    public final int getFractionDigits(Object object) {
        return ((XDecimal)object).fracDigits;
    }

    static class XDecimal {
        int sign = 1;
        int totalDigits = 0;
        int intDigits = 0;
        int fracDigits = 0;
        String ivalue = "";
        String fvalue = "";
        boolean integer = false;
        private String canonical;

        XDecimal(String string) throws NumberFormatException {
            this.initD(string);
        }

        XDecimal(String string, boolean bl2) throws NumberFormatException {
            if (bl2) {
                this.initI(string);
            } else {
                this.initD(string);
            }
        }

        void initD(String string) throws NumberFormatException {
            int n2;
            int n3 = string.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (string.charAt(0) == '+') {
                n4 = 1;
            } else if (string.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                if (string.charAt(n5) != '.') {
                    throw new NumberFormatException();
                }
                n6 = n5 + 1;
                n7 = n3;
            }
            if (n4 == n5 && n6 == n7) {
                throw new NumberFormatException();
            }
            while (n7 > n6 && string.charAt(n7 - 1) == '0') {
                --n7;
            }
            for (int i2 = n6; i2 < n7; ++i2) {
                if (TypeValidator.isDigit(string.charAt(i2))) continue;
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            this.fracDigits = n7 - n6;
            this.totalDigits = this.intDigits + this.fracDigits;
            if (this.intDigits > 0) {
                this.ivalue = string.substring(n2, n5);
                if (this.fracDigits > 0) {
                    this.fvalue = string.substring(n6, n7);
                }
            } else if (this.fracDigits > 0) {
                this.fvalue = string.substring(n6, n7);
            } else {
                this.sign = 0;
            }
        }

        void initI(String string) throws NumberFormatException {
            int n2;
            int n3 = string.length();
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            int n4 = 0;
            int n5 = 0;
            if (string.charAt(0) == '+') {
                n4 = 1;
            } else if (string.charAt(0) == '-') {
                n4 = 1;
                this.sign = -1;
            }
            for (n2 = n4; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            for (n5 = n2; n5 < n3 && TypeValidator.isDigit(string.charAt(n5)); ++n5) {
            }
            if (n5 < n3) {
                throw new NumberFormatException();
            }
            if (n4 == n5) {
                throw new NumberFormatException();
            }
            this.intDigits = n5 - n2;
            this.fracDigits = 0;
            this.totalDigits = this.intDigits;
            if (this.intDigits > 0) {
                this.ivalue = string.substring(n2, n5);
            } else {
                this.sign = 0;
            }
            this.integer = true;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XDecimal)) {
                return false;
            }
            XDecimal xDecimal = (XDecimal)object;
            if (this.sign != xDecimal.sign) {
                return false;
            }
            if (this.sign == 0) {
                return true;
            }
            return this.intDigits == xDecimal.intDigits && this.fracDigits == xDecimal.fracDigits && this.ivalue.equals(xDecimal.ivalue) && this.fvalue.equals(xDecimal.fvalue);
        }

        public int compareTo(XDecimal xDecimal) {
            if (this.sign != xDecimal.sign) {
                return this.sign > xDecimal.sign ? 1 : -1;
            }
            if (this.sign == 0) {
                return 0;
            }
            return this.sign * this.intComp(xDecimal);
        }

        private int intComp(XDecimal xDecimal) {
            if (this.intDigits != xDecimal.intDigits) {
                return this.intDigits > xDecimal.intDigits ? 1 : -1;
            }
            int n2 = this.ivalue.compareTo(xDecimal.ivalue);
            if (n2 != 0) {
                return n2 > 0 ? 1 : -1;
            }
            n2 = this.fvalue.compareTo(xDecimal.fvalue);
            return n2 == 0 ? 0 : (n2 > 0 ? 1 : -1);
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.makeCanonical();
            }
            return this.canonical;
        }

        private void makeCanonical() {
            if (this.sign == 0) {
                this.canonical = this.integer ? "0" : "0.0";
                return;
            }
            if (this.integer && this.sign > 0) {
                this.canonical = this.ivalue;
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(this.totalDigits + 3);
            if (this.sign == -1) {
                stringBuffer.append('-');
            }
            if (this.intDigits != 0) {
                stringBuffer.append(this.ivalue);
            } else {
                stringBuffer.append('0');
            }
            if (!this.integer) {
                stringBuffer.append('.');
                if (this.fracDigits != 0) {
                    stringBuffer.append(this.fvalue);
                } else {
                    stringBuffer.append('0');
                }
            }
            this.canonical = stringBuffer.toString();
        }
    }
}

