/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    boolean inProgress = true;
    protected Vector<UndoableEdit> edits = new Vector();

    public void undo() throws CannotUndoException {
        super.undo();
        int n2 = this.edits.size();
        while (n2-- > 0) {
            UndoableEdit undoableEdit = this.edits.elementAt(n2);
            undoableEdit.undo();
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        Enumeration<UndoableEdit> enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().redo();
        }
    }

    protected UndoableEdit lastEdit() {
        int n2 = this.edits.size();
        if (n2 > 0) {
            return this.edits.elementAt(n2 - 1);
        }
        return null;
    }

    public void die() {
        int n2 = this.edits.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            UndoableEdit undoableEdit = this.edits.elementAt(i2);
            undoableEdit.die();
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        Enumeration<UndoableEdit> enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().isSignificant()) continue;
            return true;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return super.getPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

