/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshalOutputStream
extends ObjectOutputStream {
    public MarshalOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 1);
    }

    public MarshalOutputStream(OutputStream outputStream, int n2) throws IOException {
        super(outputStream);
        this.useProtocolVersion(n2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                MarshalOutputStream.this.enableReplaceObject(true);
                return null;
            }
        });
    }

    @Override
    protected final Object replaceObject(Object object) throws IOException {
        Target target;
        if (object instanceof Remote && !(object instanceof RemoteStub) && (target = ObjectTable.getTarget((Remote)object)) != null) {
            return target.getStub();
        }
        return object;
    }

    @Override
    protected void annotateClass(Class<?> clazz) throws IOException {
        this.writeLocation(RMIClassLoader.getClassAnnotation(clazz));
    }

    @Override
    protected void annotateProxyClass(Class<?> clazz) throws IOException {
        this.annotateClass(clazz);
    }

    protected void writeLocation(String string) throws IOException {
        this.writeObject(string);
    }
}

