/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.Trie;

class CharTrie
extends Trie {
    private char m_initialValue_;
    private char[] m_data_;

    public CharTrie(InputStream inputStream, Trie.DataManipulate dataManipulate) throws IOException {
        super(inputStream, dataManipulate);
        if (!this.isCharTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a char trie.");
        }
    }

    public final char getCodePointValue(int n2) {
        int n3 = this.getCodePointOffset(n2);
        return n3 >= 0 ? this.m_data_[n3] : this.m_initialValue_;
    }

    public final char getLeadValue(char c2) {
        return this.m_data_[this.getLeadOffset(c2)];
    }

    public final char getBMPValue(char c2) {
        return this.m_data_[this.getBMPOffset(c2)];
    }

    public final char getSurrogateValue(char c2, char c3) {
        int n2 = this.getSurrogateOffset(c2, c3);
        if (n2 > 0) {
            return this.m_data_[n2];
        }
        return this.m_initialValue_;
    }

    public final char getTrailValue(int n2, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n3 = this.m_dataManipulate_.getFoldingOffset(n2);
        if (n3 > 0) {
            return this.m_data_[this.getRawOffset(n3, (char)(c2 & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    public final char getLatin1LinearValue(char c2) {
        return this.m_data_[32 + this.m_dataOffset_ + c2];
    }

    protected final void unserialize(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = this.m_dataOffset_ + this.m_dataLength_;
        this.m_index_ = new char[n2];
        byte[] byArray = new byte[n2 * 2];
        dataInputStream.read(byArray);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.m_index_[i2] = (char)(byArray[n3++] << 8 | byArray[n3++] & 0xFF);
        }
        this.m_data_ = this.m_index_;
        this.m_initialValue_ = this.m_data_[this.m_dataOffset_];
    }

    protected final int getSurrogateOffset(char c2, char c3) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c2));
        if (n2 > 0) {
            return this.getRawOffset(n2, (char)(c3 & 0x3FF));
        }
        return -1;
    }

    protected final int getValue(int n2) {
        return this.m_data_[n2];
    }

    protected final int getInitialValue() {
        return this.m_initialValue_;
    }
}

