/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.cache.CacheUtilities;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.IconDesc;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class CacheImageLoader
implements Runnable {
    private static CacheImageLoader _instance = null;
    private final Object _imageLoadingLock = new Object();
    private boolean _running = false;
    private ArrayList _toLoad = new ArrayList();

    private CacheImageLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        while (!bl) {
            LoadEntry loadEntry = null;
            Object object = this._imageLoadingLock;
            synchronized (object) {
                if (this._toLoad.size() > 0) {
                    loadEntry = (LoadEntry)this._toLoad.remove(0);
                } else {
                    bl = true;
                    this._running = false;
                }
            }
            if (!bl) {
                try {
                    Image image = null;
                    File file = null;
                    DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(loadEntry._id.getLocation(), loadEntry._id.getVersion(), 2);
                    if (diskCacheEntry != null) {
                        file = diskCacheEntry.getFile();
                    }
                    if (file != null) {
                        image = CacheUtilities.getSharedInstance().loadImage(file.getPath());
                    }
                    if (image != null) {
                        CacheImageLoader.publish(loadEntry, image, file, false);
                    }
                    new DelayedImageLoader(this, loadEntry, image, diskCacheEntry).start();
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.ignoredException(malformedURLException);
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                continue;
            }
            if (!Globals.TracePlayerImageLoading) continue;
            Debug.println("image Thread done");
        }
    }

    public static CacheImageLoader getInstance() {
        if (_instance == null) {
            _instance = new CacheImageLoader();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadImage(IconDesc iconDesc, CacheImageLoaderCallback cacheImageLoaderCallback) {
        boolean bl = false;
        Object object = this._imageLoadingLock;
        synchronized (object) {
            if (!this._running) {
                this._running = true;
                bl = true;
            }
            this._toLoad.add(new LoadEntry(this, iconDesc, cacheImageLoaderCallback));
        }
        if (bl) {
            if (Globals.TracePlayerImageLoading) {
                Debug.println("ImageLoader spawning new thread");
            }
            new Thread(this).start();
        }
    }

    static void access$000(LoadEntry loadEntry, Image image, File file, boolean bl) {
        CacheImageLoader.publish(loadEntry, image, file, bl);
    }

    private static void publish(LoadEntry loadEntry, Image image, File file, boolean bl) {
        SwingUtilities.invokeLater(new Runnable(loadEntry, bl, image, file){
            private final LoadEntry val$entry;
            private final boolean val$isComplete;
            private final Image val$image;
            private final File val$file;

            public void run() {
                if (Globals.TracePlayerImageLoading) {
                    Debug.println("Loaded Image succesfully for " + this.val$entry._id);
                }
                if (this.val$isComplete) {
                    this.val$entry._cb.finalImageAvailable(this.val$entry._id, this.val$image, this.val$file);
                } else {
                    this.val$entry._cb.imageAvailable(this.val$entry._id, this.val$image, this.val$file);
                }
            }
            {
                this.val$entry = loadEntry;
                this.val$isComplete = bl;
                this.val$image = image;
                this.val$file = file;
            }
        });
    }

    private class DelayedImageLoader
    extends Thread {
        private LoadEntry _entry;
        private Image _image;
        private DiskCacheEntry _dce;
        private final CacheImageLoader this$0;

        public void run() {
            try {
                File file = null;
                if (DownloadProtocol.isUpdateAvailable(this._entry._id.getLocation(), this._entry._id.getVersion(), 2)) {
                    this._dce = DownloadProtocol.getResource(this._entry._id.getLocation(), this._entry._id.getVersion(), 2, false, null);
                    if (this._dce != null) {
                        file = this._dce.getFile();
                    }
                    if (file != null) {
                        this._image = CacheUtilities.getSharedInstance().loadImage(file.getPath());
                    }
                    CacheImageLoader.access$000(this._entry, this._image, file, false);
                } else if (this._dce != null) {
                    file = this._dce.getFile();
                }
                CacheImageLoader.access$000(this._entry, this._image, file, true);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.ignoredException(malformedURLException);
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
            catch (JNLPException jNLPException) {
                Debug.ignoredException(jNLPException);
            }
        }

        public DelayedImageLoader(CacheImageLoader cacheImageLoader, LoadEntry loadEntry, Image image, DiskCacheEntry diskCacheEntry) {
            this.this$0 = cacheImageLoader;
            this._entry = loadEntry;
            this._image = image;
            this._dce = diskCacheEntry;
        }
    }

    private class LoadEntry {
        public IconDesc _id;
        public CacheImageLoaderCallback _cb;
        private final CacheImageLoader this$0;

        public LoadEntry(CacheImageLoader cacheImageLoader, IconDesc iconDesc, CacheImageLoaderCallback cacheImageLoaderCallback) {
            this.this$0 = cacheImageLoader;
            this._id = iconDesc;
            this._cb = cacheImageLoaderCallback;
        }
    }
}

