/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.debug;

import com.sun.javaws.debug.Debug;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class Globals {
    private static final String JAVAWS_NAME = "javaws-1.4.2_06";
    private static final String JAVAWS_VERSION = "1.4.2_06";
    private static final String JNLP_VERSION = "1.0.1";
    private static final String WIN_ID = "Windows";
    private static boolean _isOffline = false;
    private static final String DEFAULT_LOGHOST = "localhost:8205";
    public static String BootClassPath = "NONE";
    public static String JCOV = "NONE";
    public static boolean TraceSecurity = false;
    public static boolean TraceStartup = false;
    public static boolean TraceSplashScreen = false;
    public static boolean TraceProxies = false;
    public static boolean TraceCache = false;
    public static boolean TraceMuffins = false;
    public static boolean TraceDiskCache = false;
    public static boolean TraceAppletViewer = false;
    public static boolean TraceClassLoading = false;
    public static boolean TraceJRESearch = false;
    public static boolean TraceExtensions = false;
    public static boolean TraceHTMLEntryParsing = false;
    public static boolean TracePlayerImageLoading = false;
    public static boolean TraceCacheEntryManager = false;
    public static boolean TraceLocalAppInstall = false;
    public static boolean TraceDownload = false;
    public static boolean TraceJarDiff = false;
    public static boolean TraceIgnoredExceptions = false;
    public static boolean TraceAutoUpdater = false;
    public static boolean TraceXMLParsing = false;
    public static boolean TraceThreads = false;
    public static boolean TraceHttpsCert = false;
    public static boolean TraceIcoCreation = false;
    public static boolean TracePlayer = false;
    public static boolean TraceConfig = false;
    public static boolean TraceEncoding = false;
    public static boolean RedirectOutput = true;
    public static boolean RedirectErrors = false;
    public static String LogToHost = null;
    public static boolean DebugWindow = false;
    public static boolean SupportJREinstallation = true;
    public static boolean OverrideSystemClassLoader = true;
    public static boolean TCKHarnessRun = false;
    public static boolean TCKResponse = false;
    public static final String JAVA_STARTED = "Java Started";
    public static final String JNLP_LAUNCHING = "JNLP Launching";
    public static final String NEW_VM_STARTING = "JVM Starting";
    public static final String JAVA_SHUTDOWN = "JVM Shutdown";
    public static final String CACHE_CLEAR_OK = "Cache Clear Success";
    public static final String CACHE_CLEAR_FAILED = "Cache Clear Failed";
    public static String osName = Globals.getGeneralOsName();
    public static String osArch = System.getProperty("os.arch");
    private static String _osNameProperty;
    private static String _osArchProperty;
    private static String _javaVersionProperty;
    static Class class$com$sun$javaws$debug$Globals;

    private static void readOptionFile() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(".javawsrc");
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                fileInputStream = new FileInputStream(Globals.getProperty("user.home") + File.separator + ".javawsrc");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                return;
            }
        }
        try {
            Properties properties = new Properties();
            properties.load(fileInputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                Globals.parseOption(string + "=" + string2, false);
            }
        }
        catch (IOException iOException) {}
    }

    private static void setTCKOptions() {
        if (TCKHarnessRun) {
            RedirectErrors = true;
            RedirectOutput = true;
            if (LogToHost == null) {
                System.err.println("Warning: LogHost = null");
            }
        }
    }

    public static boolean isOffline() {
        return _isOffline;
    }

    public static boolean isWindowsPlatform() {
        String string = Globals.getOperatingSystemID();
        return string != null && string.startsWith(WIN_ID);
    }

    public static void setOffline(boolean bl) {
        _isOffline = bl;
    }

    public static String getArchitectureID() {
        if (_osArchProperty == null) {
            _osArchProperty = Globals.getProperty("os.arch");
        }
        return _osArchProperty;
    }

    public static String getBuildID() {
        String string = null;
        InputStream inputStream = (class$com$sun$javaws$debug$Globals == null ? (class$com$sun$javaws$debug$Globals = Globals.class$("com.sun.javaws.debug.Globals")) : class$com$sun$javaws$debug$Globals).getResourceAsStream("/build.id");
        if (inputStream != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string == null || string.length() == 0 ? "<internal>" : string;
    }

    public static String getComponentName() {
        return JAVAWS_NAME;
    }

    private static String getGeneralOsName() {
        String string = System.getProperty("os.name");
        if (string != null && string.startsWith(WIN_ID)) {
            string = WIN_ID;
        }
        return string;
    }

    public static String getJavaVersion() {
        if (_javaVersionProperty == null) {
            _javaVersionProperty = Globals.getProperty("java.version");
        }
        return _javaVersionProperty;
    }

    public static String getOperatingSystemID() {
        if (_osNameProperty == null) {
            _osNameProperty = Globals.getProperty("os.name");
        }
        return _osNameProperty;
    }

    public static String getUserAgent() {
        return "JNLP/1.0.1 javaws/1.4.2_06 (" + Globals.getBuildID() + ")" + " J2SE/" + System.getProperty("java.version");
    }

    private static void parseOption(String string, boolean bl) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(61);
        if (n == -1) {
            string2 = string;
            string3 = null;
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2.length() > 0 && (string2.startsWith("-") || string2.startsWith("+"))) {
            string2 = string2.substring(1);
            String string4 = string3 = string.startsWith("+") ? "true" : "false";
        }
        if (bl && !string2.startsWith("x") && !string2.startsWith("Trace")) {
            string2 = null;
        }
        if (string2 != null && Globals.setOption(string2, string3)) {
            System.out.println("# Option: " + string2 + "=" + string3);
        } else {
            System.out.println("# Ignoring option: " + string);
        }
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void getDebugOptionsFromProperties(Properties properties) {
        int n = 0;
        String string;
        while ((string = properties.getProperty("javaws.debug." + n)) != null) {
            Globals.parseOption(string, true);
            ++n;
        }
        return;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getProperty(String string) {
        return System.getProperty(string);
    }

    private static boolean setOption(String string, String string2) {
        boolean bl;
        block10: {
            Class<?> clazz = new String().getClass();
            bl = true;
            try {
                Field field = new Globals().getClass().getDeclaredField(string);
                if ((field.getModifiers() & 8) == 0) {
                    return false;
                }
                Class<?> clazz2 = field.getType();
                if (clazz2 == clazz) {
                    field.set(null, string2);
                    break block10;
                }
                if (clazz2 == Boolean.TYPE) {
                    field.setBoolean(null, Boolean.valueOf(string2));
                    break block10;
                }
                if (clazz2 == Integer.TYPE) {
                    field.setInt(null, Integer.parseInt(string2));
                    break block10;
                }
                if (clazz2 == Float.TYPE) {
                    field.setFloat(null, Float.parseFloat(string2));
                    break block10;
                }
                if (clazz2 == Double.TYPE) {
                    field.setDouble(null, Double.parseDouble(string2));
                    break block10;
                }
                if (clazz2 == Long.TYPE) {
                    field.setLong(null, Long.parseLong(string2));
                    break block10;
                }
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return bl;
    }

    public static String[] parseOptions(String[] stringArray) {
        String[] stringArray2;
        Globals.readOptionFile();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length) {
            if ((stringArray2 = stringArray[n++]).startsWith("-XX:") && !bl) {
                Globals.parseOption(stringArray2.substring(4), false);
            } else {
                arrayList.add(stringArray2);
            }
            if (stringArray2.startsWith("-")) continue;
            bl = true;
        }
        Globals.setTCKOptions();
        Debug.openSocketStream();
        stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }
}

