/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Globals;
import com.sun.javaws.Launcher;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.DefaultLocalApplicationProperties;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.util.VersionID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class Cache {
    public static final char RESOURCE_TYPE = 'R';
    public static final char APPLICATION_TYPE = 'A';
    public static final char EXTENSION_TYPE = 'E';
    public static final char MUFFIN_TYPE = 'P';
    public static final char MUFFIN_TAG_INDEX = '\u0000';
    public static final char MUFFIN_MAXSIZE_INDEX = '\u0001';
    private static DiskCache _activeCache = null;
    private static DiskCache _readOnlyCache = null;
    private static DiskCache _muffincache = null;
    private static final String LAST_ACCESSED_FILE_NAME = "lastAccessed";
    private static final String INDIRECT_EXTENSION = ".ind";
    private static HashMap _loadedProperties;
    private static final char[] cacheTypes;
    static /* synthetic */ Class class$com$sun$javaws$cache$Cache;

    private static void initialize() {
        DiskCache diskCache = new DiskCache(Cache.getUserBaseDir());
        DiskCache diskCache2 = null;
        File file = Cache.getSysBaseDir();
        if (file != null) {
            diskCache2 = new DiskCache(file);
        }
        File file2 = Cache.getMuffinCacheBaseDir();
        _muffincache = new DiskCache(file2);
        _loadedProperties = new HashMap();
        if (diskCache2 != null && Globals.isSystemCache()) {
            _readOnlyCache = null;
            _activeCache = diskCache2;
        } else {
            _readOnlyCache = diskCache2;
            _activeCache = diskCache;
            if (Globals.isSystemCache()) {
                Globals.setSystemCache(false);
                Trace.println((String)"There is no system cache configured, \"-system\" option ignored");
            }
        }
    }

    public static boolean canWrite() {
        return _activeCache.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache() {
        boolean bl;
        LocalApplicationProperties localApplicationProperties;
        Object object;
        Object object2;
        String string = Config.getProperty((String)"deployment.javaws.cachedir");
        String string2 = Config.getProperty((String)"deployment.user.cachedir") + File.separator + "javaws";
        final File file = new File(string);
        File file2 = new File(string2);
        Iterator iterator = _activeCache.getOrphans();
        while (iterator.hasNext()) {
            object2 = (DiskCacheEntry)iterator.next();
        }
        iterator = _activeCache.getJnlpCacheEntries();
        object2 = new ArrayList();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        while (iterator.hasNext()) {
            DiskCacheEntry diskCacheEntry = (DiskCacheEntry)iterator.next();
            object = null;
            localApplicationProperties = null;
            try {
                object = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                localApplicationProperties = Cache.getLocalApplicationProperties(diskCacheEntry, (LaunchDesc)object);
                if (localApplicationProperties == null || !localApplicationProperties.isLocallyInstalled()) continue;
                localInstallHandler.uninstall((LaunchDesc)object, localApplicationProperties, true);
                ((ArrayList)object2).add(diskCacheEntry);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
        boolean bl2 = bl = string.startsWith(string2) || string2.startsWith(string);
        if (!bl && file.exists() && file.isDirectory()) {
            Cache.copy(file, file2, new FilenameFilter(){

                public boolean accept(File file2, String string) {
                    if (file2.equals(file) || file2.getParentFile().equals(file)) {
                        return !string.equals("splashes");
                    }
                    if (string.length() == 0) {
                        return false;
                    }
                    char c = string.charAt(0);
                    for (int i = 0; i < cacheTypes.length; ++i) {
                        if (c != cacheTypes[i]) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        Config.setProperty((String)"deployment.javaws.cachedir", null);
        Config.storeIfDirty();
        object = class$com$sun$javaws$cache$Cache == null ? (class$com$sun$javaws$cache$Cache = Cache.class$("com.sun.javaws.cache.Cache")) : class$com$sun$javaws$cache$Cache;
        synchronized (object) {
            Cache.initialize();
        }
        iterator = ((ArrayList)object2).iterator();
        while (iterator.hasNext()) {
            try {
                object = null;
                localApplicationProperties = null;
                DiskCacheEntry diskCacheEntry = (DiskCacheEntry)iterator.next();
                object = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                localApplicationProperties = Cache.getLocalApplicationProperties(diskCacheEntry, (LaunchDesc)object);
                localInstallHandler.doInstall((LaunchDesc)object, localApplicationProperties);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File file, File file2, FilenameFilter filenameFilter) {
        if (file.isDirectory()) {
            file2.mkdirs();
            File[] fileArray = file.listFiles(filenameFilter);
            for (int i = 0; i < fileArray.length; ++i) {
                Cache.copy(fileArray[i], new File(file2.getPath() + File.separator + fileArray[i].getName()), filenameFilter);
            }
        } else {
            byte[] byArray = new byte[1024];
            FileOutputStream fileOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file2);
                fileInputStream = new FileInputStream(file);
                while (true) {
                    int n;
                    if ((n = fileInputStream.read(byArray)) == -1) {
                    }
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void saveRemovedApp(URL uRL, String string) {
        Properties properties = Cache.getRemovedApps();
        properties.setProperty(uRL.toString(), string);
        Cache.setRemovedApps(properties);
    }

    public static void setRemovedApps(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Cache.getRemovePath());
            properties.store(fileOutputStream, "Removed JNLP Applications");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Properties getRemovedApps() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(Cache.getRemovePath());
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    public static String getRemovePath() {
        return Config.getJavawsCacheDir() + File.separator + "removed.apps";
    }

    private static File getMuffinCacheBaseDir() {
        String string = Config.getJavawsCacheDir() + File.separator + "muffins";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        Trace.println((String)("Muffin Cache = " + file), (TraceLevel)TraceLevel.CACHE);
        return file;
    }

    private static File getUserBaseDir() {
        String string = Config.getJavawsCacheDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        Trace.println((String)("User cache dir = " + file), (TraceLevel)TraceLevel.CACHE);
        return file;
    }

    private static File getSysBaseDir() {
        String string = Config.getSystemCacheDirectory();
        if (string == null || string.length() == 0) {
            return null;
        }
        File file = new File(string + File.separator + "javaws");
        if (!file.exists()) {
            file.mkdirs();
        }
        Trace.println((String)("System cache dir = " + file), (TraceLevel)TraceLevel.CACHE);
        return file;
    }

    public static void remove() {
        Iterator iterator = _activeCache.getJnlpCacheEntries();
        while (iterator.hasNext()) {
            DiskCacheEntry diskCacheEntry = (DiskCacheEntry)iterator.next();
            LaunchDesc launchDesc = null;
            try {
                launchDesc = LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            if (launchDesc == null) continue;
            LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(diskCacheEntry, launchDesc);
            Cache.remove(diskCacheEntry, localApplicationProperties, launchDesc);
        }
        Cache.uninstallActiveCache();
        Cache.uninstallMuffinCache();
    }

    public static void remove(String string, LocalApplicationProperties localApplicationProperties, LaunchDesc launchDesc) {
        try {
            DiskCacheEntry diskCacheEntry = Cache.getCacheEntryFromFile(new File(string));
            Cache.remove(diskCacheEntry, localApplicationProperties, launchDesc);
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
        }
    }

    public static void remove(DiskCacheEntry diskCacheEntry, LocalApplicationProperties localApplicationProperties, LaunchDesc launchDesc) {
        Object object;
        Object object2;
        InformationDesc informationDesc = launchDesc.getInformation();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (launchDesc.isApplicationDescriptor() && launchDesc.getLocation() != null) {
            Cache.saveRemovedApp(launchDesc.getLocation(), informationDesc.getTitle());
        }
        localApplicationProperties.refresh();
        if (localApplicationProperties.isLocallyInstalled()) {
            if (launchDesc.isApplicationDescriptor()) {
                if (localInstallHandler != null) {
                    localInstallHandler.uninstall(launchDesc, localApplicationProperties, true);
                }
            } else if (launchDesc.isInstaller()) {
                object2 = new ArrayList();
                ((ArrayList)object2).add(diskCacheEntry.getFile());
                try {
                    object = localApplicationProperties.getInstallDirectory();
                    Launcher.executeUninstallers((ArrayList)object2);
                    JREInfo.removeJREsIn((String)object);
                    Cache.deleteFile(new File((String)object));
                }
                catch (ExitException exitException) {
                    Trace.ignoredException((Exception)exitException);
                }
            }
        }
        object2 = localApplicationProperties.getRegisteredTitle();
        Config.getInstance().addRemoveProgramsRemove((String)object2, Globals.isSystemCache());
        localInstallHandler.removeAssociations(launchDesc, localApplicationProperties);
        SplashScreen.removeCustomSplash(launchDesc);
        if (informationDesc != null) {
            RContentDesc[] rContentDescArray;
            Object object3;
            object = informationDesc.getIcons();
            if (object != null) {
                for (int i = 0; i < ((IconDesc[])object).length; ++i) {
                    URL uRL = object[i].getLocation();
                    object3 = object[i].getVersion();
                    Cache.removeEntries('R', uRL, (String)object3);
                }
            }
            if ((rContentDescArray = informationDesc.getRelatedContent()) != null) {
                for (int i = 0; i < rContentDescArray.length; ++i) {
                    object3 = rContentDescArray[i].getIcon();
                    if (object3 == null) continue;
                    Cache.removeEntries('R', (URL)object3, null);
                }
            }
        }
        if ((object = launchDesc.getCanonicalHome()) != null) {
            Cache.removeEntries('A', (URL)object, null);
            Cache.removeEntries('E', (URL)object, null);
        }
        if (diskCacheEntry != null) {
            Cache.removeEntry(diskCacheEntry);
        }
    }

    private static void deleteFile(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                Cache.deleteFile(fileArray[i]);
            }
        }
        file.delete();
    }

    private static void removeEntries(char c, URL uRL, String string) {
        if (uRL == null) {
            return;
        }
        try {
            DiskCacheEntry[] diskCacheEntryArray = Cache.getCacheEntries(c, uRL, string, true);
            for (int i = 0; i < diskCacheEntryArray.length; ++i) {
                Cache.removeEntry(diskCacheEntryArray[i]);
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
    }

    public static File getCachedLaunchedFile(URL uRL) throws IOException {
        DiskCacheEntry diskCacheEntry = Cache.getCacheEntry('A', uRL, null);
        return diskCacheEntry == null ? null : diskCacheEntry.getFile();
    }

    public static File getCachedFile(URL uRL) {
        File file = null;
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    File file2 = Cache.createNativeLibDir(uRL2, null);
                    return new File(file2, string2);
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignoredException((Exception)malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return null;
        }
        if (uRL.toString().endsWith(".jnlp")) {
            try {
                file = Cache.getCachedLaunchedFile(uRL);
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return file;
    }

    public static LocalApplicationProperties getLocalApplicationProperties(DiskCacheEntry diskCacheEntry, LaunchDesc launchDesc) {
        return Cache.getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, diskCacheEntry.getType() == 'A');
    }

    public static LocalApplicationProperties getLocalApplicationProperties(String string, LaunchDesc launchDesc) {
        DiskCacheEntry diskCacheEntry = Cache.getCacheEntryFromFile(new File(string));
        if (diskCacheEntry == null) {
            return null;
        }
        return Cache.getLocalApplicationProperties(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), launchDesc, diskCacheEntry.getType() == 'A');
    }

    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL, LaunchDesc launchDesc) {
        return Cache.getLocalApplicationProperties(uRL, null, launchDesc, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalApplicationProperties getLocalApplicationProperties(URL uRL, String string, LaunchDesc launchDesc, boolean bl) {
        LocalApplicationProperties localApplicationProperties;
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toString().intern() + "?" + string;
        HashMap hashMap = _loadedProperties;
        synchronized (hashMap) {
            localApplicationProperties = (LocalApplicationProperties)_loadedProperties.get(string2);
            if (localApplicationProperties == null) {
                localApplicationProperties = new DefaultLocalApplicationProperties(uRL, string, launchDesc, bl);
                _loadedProperties.put(string2, localApplicationProperties);
            } else {
                localApplicationProperties.refreshIfNecessary();
            }
        }
        return localApplicationProperties;
    }

    public static LaunchDesc getLaunchDesc(URL uRL, String string) {
        try {
            DiskCacheEntry diskCacheEntry = Cache.getCacheEntry('A', uRL, string);
            if (diskCacheEntry != null) {
                try {
                    return LaunchDescFactory.buildDescriptor(diskCacheEntry.getFile());
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException((Exception)iOException);
        }
        return null;
    }

    public static String getNewExtensionInstallDirectory() throws IOException {
        String string = Cache.getUserBaseDir().getAbsolutePath() + File.separator + "ext";
        String string2 = null;
        int n = 0;
        do {
            File file;
            if (!(file = new File(string2 = string + File.separator + "E" + new Date().getTime() + File.separator)).mkdirs()) {
                string2 = null;
            }
            Thread.yield();
        } while (string2 == null && ++n < 50);
        if (string2 == null) {
            throw new IOException("Unable to create temp. dir for extension");
        }
        return string2;
    }

    private static String createUniqueIndirectFile() throws IOException {
        String string = Cache.getUserBaseDir().getAbsolutePath() + File.separator + "indirect";
        File file = new File(string);
        file.mkdirs();
        File file2 = File.createTempFile("indirect", INDIRECT_EXTENSION, file);
        return file2.getAbsolutePath();
    }

    public static void removeEntry(DiskCacheEntry diskCacheEntry) {
        _activeCache.removeEntry(diskCacheEntry);
    }

    public static long getLastAccessed(boolean bl) {
        if (bl) {
            if (_readOnlyCache == null) {
                return 0L;
            }
            return _readOnlyCache.getLastUpdate();
        }
        return _activeCache.getLastUpdate();
    }

    public static long getLastAccessed() {
        return _activeCache.getLastUpdate();
    }

    public static void setLastAccessed() {
        _activeCache.recordLastUpdate();
    }

    public static String[] getBaseDirsForHost(URL uRL) {
        String[] stringArray;
        if (_readOnlyCache == null) {
            stringArray = new String[]{_activeCache.getBaseDirForHost(uRL)};
        } else {
            stringArray = new String[2];
            stringArray[0] = _readOnlyCache.getBaseDirForHost(uRL);
            stringArray[0] = _activeCache.getBaseDirForHost(uRL);
        }
        return stringArray;
    }

    public static long getCacheSize() throws IOException {
        return _activeCache.getCacheSize();
    }

    public static void clean() {
        _activeCache.cleanResources();
    }

    public static long getOrphanSize(boolean bl) {
        if (bl) {
            if (_readOnlyCache == null) {
                return 0L;
            }
            return _readOnlyCache.getOrphanSize();
        }
        return _activeCache.getOrphanSize();
    }

    public static void cleanResources() {
        _activeCache.cleanResources();
    }

    public static long getCacheSize(boolean bl) {
        try {
            if (bl) {
                if (_readOnlyCache == null) {
                    return -1L;
                }
                return _readOnlyCache.getCacheSize();
            }
            return _activeCache.getCacheSize();
        }
        catch (Exception exception) {
            Trace.ignoredException((Exception)exception);
            return 0L;
        }
    }

    public static String[] getCacheVersions(char c, URL uRL) throws IOException {
        String[] stringArray = _activeCache.getCacheVersions(c, uRL);
        String[] stringArray2 = new String[]{};
        String[] stringArray3 = stringArray;
        if (_readOnlyCache != null && (stringArray2 = _readOnlyCache.getCacheVersions(c, uRL)).length > 0) {
            stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        }
        if (stringArray3.length > 1) {
            Arrays.sort(stringArray3, new Comparator(){

                public int compare(Object object, Object object2) {
                    VersionID versionID = new VersionID((String)object);
                    VersionID versionID2 = new VersionID((String)object2);
                    return versionID.isGreaterThan(versionID2) ? -1 : 1;
                }
            });
        }
        return stringArray3;
    }

    public static DiskCacheEntry[] getCacheEntries(char c, URL uRL, String string, boolean bl) throws IOException {
        DiskCacheEntry[] diskCacheEntryArray = _activeCache.getCacheEntries(c, uRL, string, bl);
        DiskCacheEntry[] diskCacheEntryArray2 = new DiskCacheEntry[]{};
        if (_readOnlyCache != null) {
            diskCacheEntryArray2 = _readOnlyCache.getCacheEntries(c, uRL, string, bl);
        }
        if (diskCacheEntryArray2.length == 0) {
            return diskCacheEntryArray;
        }
        int n = diskCacheEntryArray2.length + diskCacheEntryArray.length;
        DiskCacheEntry[] diskCacheEntryArray3 = new DiskCacheEntry[n];
        int n2 = 0;
        for (n2 = 0; n2 < diskCacheEntryArray2.length; ++n2) {
            diskCacheEntryArray3[n2] = diskCacheEntryArray2[n2];
        }
        for (int i = 0; i < diskCacheEntryArray.length; ++i) {
            diskCacheEntryArray3[n2++] = diskCacheEntryArray[i];
        }
        return diskCacheEntryArray3;
    }

    public static DiskCacheEntry getMuffinCacheEntryFromFile(File file) {
        return _muffincache.getCacheEntryFromFile(file);
    }

    public static DiskCacheEntry getCacheEntryFromFile(File file) {
        DiskCacheEntry diskCacheEntry;
        DiskCacheEntry diskCacheEntry2 = _activeCache.getCacheEntryFromFile(file);
        if (_readOnlyCache != null && (diskCacheEntry = _readOnlyCache.getCacheEntryFromFile(file)) != null && diskCacheEntry.newerThan(diskCacheEntry2)) {
            return diskCacheEntry;
        }
        return diskCacheEntry2;
    }

    public static File getTempCacheFile(URL uRL, String string) throws IOException {
        return _activeCache.getTempCacheFile(uRL, string);
    }

    public static DiskCacheEntry getCacheEntry(char c, URL uRL, String string) throws IOException {
        DiskCacheEntry diskCacheEntry;
        DiskCacheEntry diskCacheEntry2 = _activeCache.getCacheEntry(c, uRL, string);
        if (_readOnlyCache != null && (diskCacheEntry = _readOnlyCache.getCacheEntry(c, uRL, string)) != null && diskCacheEntry.newerThan(diskCacheEntry2)) {
            return diskCacheEntry;
        }
        return diskCacheEntry2;
    }

    public static File createNativeLibDir(URL uRL, String string) throws IOException {
        return _activeCache.createNativeLibDir(uRL, string);
    }

    public static Iterator getJnlpCacheEntries(boolean bl) {
        if (bl) {
            if (_readOnlyCache == null) {
                return new ArrayList().iterator();
            }
            return _readOnlyCache.getJnlpCacheEntries();
        }
        return _activeCache.getJnlpCacheEntries();
    }

    public static File putMappedImage(URL uRL, String string, File file) throws IOException {
        return _activeCache.putMappedImage(uRL, string, file);
    }

    public static byte[] getLapData(char c, URL uRL, String string, boolean bl) throws IOException {
        if (bl) {
            return _readOnlyCache == null ? null : _readOnlyCache.getLapData(c, uRL, string);
        }
        return _activeCache.getLapData(c, uRL, string);
    }

    public static void putLapData(char c, URL uRL, String string, byte[] byArray) throws IOException {
        _activeCache.putLapData(c, uRL, string, byArray);
    }

    public static void insertEntry(char c, URL uRL, String string, File file, long l) throws IOException {
        _activeCache.insertEntry(c, uRL, string, file, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCanonicalLaunchDesc(URL uRL, LaunchDesc launchDesc) throws IOException {
        if (launchDesc.isApplicationDescriptor()) {
            File file = Cache.getTempCacheFile(uRL, null);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                fileOutputStream.write(launchDesc.getSource().getBytes());
            }
            finally {
                fileOutputStream.close();
            }
            Cache.insertEntry('A', uRL, null, file, new Date().getTime());
        }
    }

    public static void uninstallActiveCache() {
        _activeCache.uninstallCache();
    }

    public static long getMuffinSize(URL uRL) throws IOException {
        return _muffincache.getMuffinSize(uRL);
    }

    public static long[] getMuffinAttributes(URL uRL) throws IOException {
        return _muffincache.getMuffinAttributes(uRL);
    }

    public static void putMuffinAttributes(URL uRL, int n, long l) throws IOException {
        _muffincache.putMuffinAttributes(uRL, n, l);
    }

    public static URL[] getAccessibleMuffins(URL uRL) throws IOException {
        return _muffincache.getAccessibleMuffins(uRL);
    }

    public static void insertMuffinEntry(URL uRL, File file, int n, long l) throws IOException {
        _muffincache.insertMuffinEntry(uRL, file, n, l);
    }

    public static File getMuffinFileForURL(URL uRL) {
        return _muffincache.getMuffinFileForURL(uRL);
    }

    public static DiskCacheEntry getMuffinEntry(char c, URL uRL) throws IOException {
        return _muffincache.getMuffinEntry(c, uRL);
    }

    public static boolean isMainMuffinFile(File file) throws IOException {
        return _muffincache.isMainMuffinFile(file);
    }

    public static void removeMuffinEntry(DiskCacheEntry diskCacheEntry) {
        _muffincache.removeMuffinEntry(diskCacheEntry);
    }

    public static void uninstallMuffinCache() {
        _muffincache.uninstallCache();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Cache.initialize();
        cacheTypes = new char[]{'D', 'X', 'V', 'I', 'R', 'A', 'E', 'P'};
    }
}

