/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherBox;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeHash;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.Record;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;

class InputRecord
extends ByteArrayInputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    boolean formatVerified = true;
    private boolean isClosed;
    private boolean appDataValid;
    private ProtocolVersion helloVersion;
    static final Debug debug = Debug.getInstance("ssl");
    private static final byte[] v2NoCipher = new byte[]{-128, 3, 0, 0, 1};

    InputRecord() {
        super(new byte[16665]);
        this.setHelloVersion(ProtocolVersion.DEFAULT_HELLO);
        this.pos = 5;
        this.lastHashed = this.count = 5;
    }

    void setHelloVersion(ProtocolVersion protocolVersion) {
        this.helloVersion = protocolVersion;
    }

    ProtocolVersion getHelloVersion() {
        return this.helloVersion;
    }

    void enableFormatChecks() {
        this.formatVerified = false;
    }

    boolean isAppDataValid() {
        return this.appDataValid;
    }

    void setAppDataValid(boolean bl) {
        this.appDataValid = bl;
    }

    byte contentType() {
        return this.buf[0];
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        this.handshakeHash = handshakeHash;
    }

    HandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    boolean checkMAC(MAC mAC) {
        int n = mAC.MAClen();
        if (n == 0) {
            return true;
        }
        int n2 = this.count - n;
        if (n2 < 5) {
            return false;
        }
        byte[] byArray = mAC.compute(this.contentType(), this.buf, 5, n2 - 5);
        if (n != byArray.length) {
            throw new RuntimeException("Internal MAC error");
        }
        for (int i = 0; i < n; ++i) {
            if (this.buf[n2 + i] == byArray[i]) continue;
            return false;
        }
        this.count -= n;
        return true;
    }

    void decrypt(CipherBox cipherBox) throws BadPaddingException {
        int n = this.count - 5;
        this.count = 5 + cipherBox.decrypt(this.buf, 5, n);
    }

    void ignore(int n) {
        if (n > 0) {
            this.pos += n;
            this.lastHashed = this.pos;
        }
    }

    void doHashes() {
        int n = this.pos - this.lastHashed;
        if (n > 0) {
            this.hashInternal(this.buf, this.lastHashed, n);
            this.lastHashed = this.pos;
        }
    }

    private void hashInternal(byte[] byArray, int n, int n2) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                System.out.println("[read] MD5 and SHA1 hashes:  len = " + n2);
                hexDumpEncoder.encodeBuffer((InputStream)new ByteArrayInputStream(byArray, n, n2), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.handshakeHash.update(byArray, n, n2);
    }

    void queueHandshake(InputRecord inputRecord) throws IOException {
        int n;
        this.doHashes();
        if (this.pos > 5) {
            n = this.count - this.pos;
            if (n != 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 5, n);
            }
            this.lastHashed = this.pos = 5;
            this.count = 5 + n;
        }
        if (this.buf.length < (n = inputRecord.available() + this.count)) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        System.arraycopy(inputRecord.buf, inputRecord.pos, this.buf, this.count, n - this.count);
        this.count = n;
        n = inputRecord.lastHashed - inputRecord.pos;
        if (this.pos == 5) {
            this.lastHashed += n;
        } else {
            throw new SSLProtocolException("?? confused buffer hashing ??");
        }
        inputRecord.pos = inputRecord.count;
    }

    public void close() {
        this.appDataValid = false;
        this.isClosed = true;
        this.mark = 0;
        this.pos = 0;
        this.count = 0;
    }

    private static int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            return n4;
        }
        return n3;
    }

    void read(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (this.isClosed) {
            return;
        }
        int n = InputRecord.readFully(inputStream, this.buf, 0, 5);
        if (n == -1) {
            throw new EOFException("SSL peer shut down incorrectly");
        }
        if (n != 5) {
            throw new SSLProtocolException("bad header read; count = " + n);
        }
        this.lastHashed = this.pos = 5;
        if (!this.formatVerified) {
            this.formatVerified = true;
            if (this.buf[0] != 22 && this.buf[0] != 21) {
                this.handleUnknownRecord(inputStream, outputStream);
            } else {
                this.readV3Record(inputStream, outputStream);
            }
        } else {
            this.readV3Record(inputStream, outputStream);
        }
    }

    private void readV3Record(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        ProtocolVersion protocolVersion = ProtocolVersion.valueOf(this.buf[1], this.buf[2]);
        if (protocolVersion.v < ProtocolVersion.MIN.v || protocolVersion.major > ProtocolVersion.MAX.major) {
            throw new SSLException("Unsupported record version " + protocolVersion);
        }
        this.count = ((this.buf[3] & 0xFF) << 8) + (this.buf[4] & 0xFF);
        if (this.count < 0 || this.count > Short.MAX_VALUE) {
            throw new SSLProtocolException("Bad InputRecord size, count = " + this.count + ", buf.length = " + this.buf.length);
        }
        if (this.count > this.buf.length - 5) {
            byte[] byArray = new byte[this.count + 5];
            System.arraycopy(this.buf, 0, byArray, 0, 5);
            this.buf = byArray;
        }
        if ((n = InputRecord.readFully(inputStream, this.buf, 5, this.count)) != this.count) {
            throw new SSLException("SSL peer shut down incorrectly");
        }
        this.count += 5;
        if (debug != null && Debug.isOn("record")) {
            if (this.count < 0 || this.count > 16660) {
                System.out.println(Thread.currentThread().getName() + ", Bad InputRecord size" + ", count = " + this.count);
            }
            System.out.println(Thread.currentThread().getName() + ", READ: " + protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + this.available());
        }
    }

    private void handleUnknownRecord(InputStream inputStream, OutputStream outputStream) throws IOException {
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 1) {
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is disabled");
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(this.buf[3], this.buf[4]);
            if (protocolVersion == ProtocolVersion.SSL20Hello) {
                try {
                    this.writeBuffer(outputStream, v2NoCipher, 0, v2NoCipher.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int n = ((this.buf[0] & 0x7F) << 8) + (this.buf[1] & 0xFF) - 3;
            byte[] byArray = new byte[n];
            int n2 = InputRecord.readFully(inputStream, byArray, 0, n);
            if (n2 == -1) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            if (n2 != n) {
                throw new SSLProtocolException("Bad SSL v2.0 ClientHello record");
            }
            this.hashInternal(this.buf, 2, 3);
            this.hashInternal(byArray, 0, n);
            this.V2toV3ClientHello(byArray);
            this.lastHashed = this.count;
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", READ:  SSL v2, contentType = " + InputRecord.contentName(this.contentType()) + ", translated length = " + this.available());
            }
            return;
        }
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        for (int i = 0; i < v2NoCipher.length; ++i) {
            if (this.buf[i] == v2NoCipher[i]) continue;
            throw new SSLException("Unrecognized SSL message, plaintext connection?");
        }
        throw new SSLException("SSL V2.0 servers are not supported.");
    }

    void writeBuffer(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        outputStream.write(byArray, 0, n2);
        outputStream.flush();
    }

    private void V2toV3ClientHello(byte[] byArray) throws SSLException {
        int n;
        this.buf[0] = 22;
        this.buf[1] = this.buf[3];
        this.buf[2] = this.buf[4];
        this.buf[5] = 1;
        this.buf[9] = this.buf[1];
        this.buf[10] = this.buf[2];
        this.count = 11;
        int n2 = ((byArray[0] & 0xFF) << 8) + (byArray[1] & 0xFF);
        int n3 = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
        int n4 = ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        int n5 = 6 + n2 + n3;
        if (n4 < 32) {
            for (n = 0; n < 32 - n4; ++n) {
                this.buf[this.count++] = 0;
            }
            System.arraycopy(byArray, n5, this.buf, this.count, n4);
            this.count += n4;
        } else {
            System.arraycopy(byArray, n5 + (n4 - 32), this.buf, this.count, 32);
            this.count += 32;
        }
        this.buf[this.count++] = (byte)n3;
        System.arraycopy(byArray, n5 -= n3, this.buf, this.count, n3);
        this.count += n3;
        n5 -= n2;
        int n6 = this.count + 2;
        for (n = 0; n < n2; n += 3) {
            if (byArray[n5 + n] != 0) continue;
            this.buf[n6++] = byArray[n5 + n + 1];
            this.buf[n6++] = byArray[n5 + n + 2];
        }
        this.buf[this.count++] = (byte)((n6 -= this.count + 2) >>> 8);
        this.buf[this.count++] = (byte)n6;
        this.count += n6;
        this.buf[this.count++] = 1;
        this.buf[this.count++] = 0;
        this.buf[3] = (byte)(this.count - 5);
        this.buf[4] = (byte)(this.count - 5 >>> 8);
        this.buf[6] = 0;
        this.buf[7] = (byte)(this.count - 5 - 4 >>> 8);
        this.buf[8] = (byte)(this.count - 5 - 4);
        this.pos = 5;
    }

    static String contentName(int n) {
        switch (n) {
            case 20: {
                return "Change Cipher Spec";
            }
            case 21: {
                return "Alert";
            }
            case 22: {
                return "Handshake";
            }
            case 23: {
                return "Application Data";
            }
        }
        return "contentType = " + n;
    }
}

