/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.MacData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.EncryptedPrivateKeyInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int[] keyBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] certBag = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] pkcs9Name = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] pkcs9KeyId = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static final int[] pkcs9certType = new int[]{1, 2, 840, 113549, 1, 9, 22, 1};
    private static final int[] pbeWithSHAAnd40BitRC2CBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 6};
    private static final int[] pbeWithSHAAnd3KeyTripleDESCBC = new int[]{1, 2, 840, 113549, 1, 12, 1, 3};
    private static ObjectIdentifier PKCS8ShroudedKeyBag_OID;
    private static ObjectIdentifier CertBag_OID;
    private static ObjectIdentifier PKCS9FriendlyName_OID;
    private static ObjectIdentifier PKCS9LocalKeyId_OID;
    private static ObjectIdentifier PKCS9CertType_OID;
    private static ObjectIdentifier pbeWithSHAAnd40BitRC2CBC_OID;
    private static ObjectIdentifier pbeWithSHAAnd3KeyTripleDESCBC_OID;
    private static volatile int counter;
    private static final int iterationCount = 1024;
    private static final int SALT_LEN = 20;
    private SecureRandom random;
    private Hashtable entries = new Hashtable();
    private ArrayList keyList = new ArrayList();
    private LinkedHashMap certs = new LinkedHashMap();

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        AlgorithmParameters algorithmParameters;
        ObjectIdentifier objectIdentifier;
        Object object;
        Object object2;
        byte[] byArray;
        Object object3;
        Object v = this.entries.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v == null || !(v instanceof KeyEntry)) {
            return null;
        }
        byte[] byArray2 = ((KeyEntry)v).protectedPrivKey;
        try {
            object3 = new EncryptedPrivateKeyInfo(byArray2);
            byArray = ((EncryptedPrivateKeyInfo)object3).getEncryptedData();
            object2 = new DerValue(((EncryptedPrivateKeyInfo)object3).getAlgorithm().encode());
            object = ((DerValue)object2).toDerInputStream();
            objectIdentifier = ((DerInputStream)object).getOID();
            algorithmParameters = this.parseAlgParameters((DerInputStream)object);
        }
        catch (IOException iOException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
            unrecoverableKeyException.initCause(iOException);
            throw unrecoverableKeyException;
        }
        try {
            object3 = this.getPBEKey(cArray);
            object2 = Cipher.getInstance(objectIdentifier.toString());
            ((Cipher)object2).init(2, (Key)object3, algorithmParameters);
            object = ((Cipher)object2).doFinal(byArray);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object);
            DerValue derValue = new DerValue((byte[])object);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n = derInputStream.getInteger();
            DerValue[] derValueArray = derInputStream.getSequence(2);
            AlgorithmId algorithmId = new AlgorithmId(derValueArray[0].getOID());
            String string2 = algorithmId.getName();
            KeyFactory keyFactory = KeyFactory.getInstance(string2);
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            object2 = new UnrecoverableKeyException("Get Key failed: " + exception.getMessage());
            ((Throwable)object2).initCause(exception);
            throw object2;
        }
        return privateKey;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return (Certificate[])((KeyEntry)v).chain.clone();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            if (((KeyEntry)v).chain == null) {
                return null;
            }
            return ((KeyEntry)v).chain[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            return new Date(((KeyEntry)v).date.getTime());
        }
        return null;
    }

    public synchronized void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            KeyEntry keyEntry = new KeyEntry();
            keyEntry.date = new Date();
            if (key instanceof PrivateKey) {
                if (!key.getFormat().equals("PKCS#8") && !key.getFormat().equals("PKCS8")) {
                    throw new KeyStoreException("Private key is not encodedas PKCS#8");
                }
            } else {
                throw new KeyStoreException("Key is not a PrivateKey");
            }
            keyEntry.protectedPrivKey = this.encryptPrivateKey(key.getEncoded(), cArray);
            if (certificateArray != null) {
                if (certificateArray.length > 1 && !this.validateChain(certificateArray)) {
                    throw new KeyStoreException("Certificate chain is not validate");
                }
                keyEntry.chain = (Certificate[])certificateArray.clone();
            }
            keyEntry.keyId = ("Time " + keyEntry.date.getTime()).getBytes("UTF8");
            keyEntry.alias = string.toLowerCase();
            this.entries.put(string.toLowerCase(), keyEntry);
        }
        catch (Exception exception) {
            KeyStoreException keyStoreException = new KeyStoreException("Key protection  algorithm not found: " + exception);
            keyStoreException.initCause(exception);
            throw keyStoreException;
        }
    }

    public synchronized void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            new EncryptedPrivateKeyInfo(byArray);
        }
        catch (IOException iOException) {
            KeyStoreException keyStoreException = new KeyStoreException("Private key is not stored as PKCS#8 EncryptedPrivateKeyInfo: " + iOException);
            keyStoreException.initCause(iOException);
            throw keyStoreException;
        }
        KeyEntry keyEntry = new KeyEntry();
        keyEntry.date = new Date();
        keyEntry.protectedPrivKey = (byte[])byArray.clone();
        if (certificateArray != null) {
            keyEntry.chain = (Certificate[])certificateArray.clone();
        }
        this.entries.put(string.toLowerCase(), keyEntry);
    }

    private byte[] getSalt() {
        byte[] byArray = new byte[20];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byArray = this.random.generateSeed(20);
        return byArray;
    }

    private AlgorithmParameters getAlgorithmParameters(String string) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.getSalt(), 1024);
        try {
            algorithmParameters = AlgorithmParameters.getInstance(string);
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getAlgorithmParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private AlgorithmParameters parseAlgParameters(DerInputStream derInputStream) throws IOException {
        AlgorithmParameters algorithmParameters = null;
        try {
            DerValue derValue;
            if (derInputStream.available() == 0) {
                derValue = null;
            } else {
                derValue = derInputStream.getDerValue();
                if (derValue.tag == 5) {
                    derValue = null;
                }
            }
            if (derValue != null) {
                algorithmParameters = AlgorithmParameters.getInstance("PBE");
                algorithmParameters.init(derValue.toByteArray());
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException("parseAlgParameters failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return algorithmParameters;
    }

    private SecretKey getPBEKey(char[] cArray) throws IOException {
        SecretKey secretKey = null;
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBE");
            secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("getSecretKey failed: " + exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return secretKey;
    }

    private byte[] encryptPrivateKey(byte[] byArray, char[] cArray) throws IOException, NoSuchAlgorithmException, UnrecoverableKeyException {
        byte[] byArray2 = null;
        try {
            AlgorithmParameters algorithmParameters = this.getAlgorithmParameters("PBEWithSHA1AndDESede");
            SecretKey secretKey = this.getPBEKey(cArray);
            Cipher cipher = Cipher.getInstance("PBEWithSHA1AndDESede");
            cipher.init(1, (Key)secretKey, algorithmParameters);
            byte[] byArray3 = cipher.doFinal(byArray);
            AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd3KeyTripleDESCBC_OID, algorithmParameters);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(algorithmId, byArray3);
            byArray2 = encryptedPrivateKeyInfo.getEncoded();
        }
        catch (Exception exception) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Encrypt Private Key failed: " + exception.getMessage());
            unrecoverableKeyException.initCause(exception);
            throw unrecoverableKeyException;
        }
        return byArray2;
    }

    public synchronized void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Object v = this.entries.get(string.toLowerCase());
        if (v != null && v instanceof KeyEntry) {
            throw new KeyStoreException("Cannot overwrite own certificate");
        }
        throw new KeyStoreException("TrustedCertEntry not supported");
    }

    public synchronized void engineDeleteEntry(String string) throws KeyStoreException {
        this.entries.remove(string.toLowerCase());
    }

    public Enumeration engineAliases() {
        return this.entries.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.entries.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.entries.size();
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.entries.get(string.toLowerCase());
        return v != null && v instanceof KeyEntry;
    }

    public boolean engineIsCertificateEntry(String string) {
        return false;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Certificate certificate2 = null;
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.entries.get(string);
            if (!(v instanceof KeyEntry)) continue;
            if (((KeyEntry)v).chain != null) {
                certificate2 = ((KeyEntry)v).chain[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public synchronized void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (cArray == null) {
            throw new IllegalArgumentException("password can't be null");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(3);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream.write(byArray);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        byte[] byArray2 = this.createSafeContent();
        ContentInfo contentInfo = new ContentInfo(byArray2);
        contentInfo.encode(derOutputStream4);
        byte[] byArray3 = this.createEncryptedData(cArray);
        ContentInfo contentInfo2 = new ContentInfo(ContentInfo.ENCRYPTED_DATA_OID, new DerValue(byArray3));
        contentInfo2.encode(derOutputStream4);
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.write((byte)48, derOutputStream4);
        byte[] byArray4 = derOutputStream5.toByteArray();
        ContentInfo contentInfo3 = new ContentInfo(byArray4);
        contentInfo3.encode(derOutputStream3);
        byte[] byArray5 = derOutputStream3.toByteArray();
        derOutputStream.write(byArray5);
        byte[] byArray6 = this.calculateMac(cArray, byArray4);
        derOutputStream.write(byArray6);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        derOutputStream6.write((byte)48, derOutputStream);
        byte[] byArray7 = derOutputStream6.toByteArray();
        outputStream.write(byArray7);
        outputStream.flush();
    }

    private byte[] generateHash(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("generateHash failed: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        return byArray2;
    }

    private byte[] calculateMac(char[] cArray, byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        String string = "SHA1";
        try {
            byte[] byArray3 = this.getSalt();
            Mac mac = Mac.getInstance("HmacPBESHA1");
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, 1024);
            SecretKey secretKey = this.getPBEKey(cArray);
            mac.init(secretKey, pBEParameterSpec);
            mac.update(byArray);
            byte[] byArray4 = mac.doFinal();
            MacData macData = new MacData(string, byArray4, byArray3, 1024);
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.write(macData.getEncoded());
            byArray2 = derOutputStream.toByteArray();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("calculateMac failed: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        return byArray2;
    }

    private boolean validateChain(Certificate[] certificateArray) {
        for (int i = 0; i < certificateArray.length - 1; ++i) {
            X500Principal x500Principal;
            X500Principal x500Principal2 = ((X509Certificate)certificateArray[i]).getIssuerX500Principal();
            if (x500Principal2.equals(x500Principal = ((X509Certificate)certificateArray[i + 1]).getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    private byte[] getBagAttributes(String string, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(PKCS9FriendlyName_OID);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream3.putBMPString(string);
        derOutputStream2.write((byte)49, derOutputStream3);
        derOutputStream4.write((byte)48, derOutputStream2);
        byte[] byArray2 = derOutputStream4.toByteArray();
        DerOutputStream derOutputStream5 = new DerOutputStream();
        derOutputStream5.putOID(PKCS9LocalKeyId_OID);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        DerOutputStream derOutputStream7 = new DerOutputStream();
        if (byArray != null) {
            derOutputStream6.putOctetString(byArray);
            derOutputStream5.write((byte)49, derOutputStream6);
        }
        derOutputStream7.write((byte)48, derOutputStream5);
        byte[] byArray3 = derOutputStream7.toByteArray();
        DerOutputStream derOutputStream8 = new DerOutputStream();
        derOutputStream8.write(byArray2);
        derOutputStream8.write(byArray3);
        derOutputStream.write((byte)49, derOutputStream8);
        byte[] byArray4 = derOutputStream.toByteArray();
        return byArray4;
    }

    private byte[] createEncryptedData(char[] cArray) throws CertificateException, IOException {
        Object object;
        Object object2;
        Object object3;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object4 = this.entries.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = this.entries.get(object3);
            if (!(object2 instanceof KeyEntry)) continue;
            int n = ((KeyEntry)object2).chain == null ? 0 : ((KeyEntry)object2).chain.length;
            for (int i = 0; i < n; ++i) {
                object = new DerOutputStream();
                object.putOID(CertBag_OID);
                DerOutputStream derOutputStream2 = new DerOutputStream();
                derOutputStream2.putOID(PKCS9CertType_OID);
                DerOutputStream derOutputStream3 = new DerOutputStream();
                X509Certificate x509Certificate = (X509Certificate)((KeyEntry)object2).chain[i];
                derOutputStream3.putOctetString(x509Certificate.getEncoded());
                derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
                DerOutputStream derOutputStream4 = new DerOutputStream();
                derOutputStream4.write((byte)48, derOutputStream2);
                byte[] byArray = derOutputStream4.toByteArray();
                DerOutputStream derOutputStream5 = new DerOutputStream();
                derOutputStream5.write(byArray);
                object.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream5);
                byte[] byArray2 = this.getBagAttributes((String)object3, ((KeyEntry)object2).keyId);
                ((OutputStream)object).write(byArray2);
                derOutputStream.write((byte)48, (DerOutputStream)object);
            }
        }
        object4 = new DerOutputStream();
        object4.write((byte)48, derOutputStream);
        object3 = ((ByteArrayOutputStream)object4).toByteArray();
        object2 = this.encryptContent((byte[])object3, cArray);
        DerOutputStream derOutputStream6 = new DerOutputStream();
        DerOutputStream derOutputStream7 = new DerOutputStream();
        derOutputStream6.putInteger(0);
        derOutputStream6.write((byte[])object2);
        derOutputStream7.write((byte)48, derOutputStream6);
        object = derOutputStream7.toByteArray();
        return (byte[])object;
    }

    private byte[] createSafeContent() throws CertificateException, IOException {
        Object object;
        DerOutputStream derOutputStream = new DerOutputStream();
        Object object2 = this.entries.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            Object v = this.entries.get(object);
            if (!(v instanceof KeyEntry)) continue;
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putOID(PKCS8ShroudedKeyBag_OID);
            byte[] byArray = ((KeyEntry)v).protectedPrivKey;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = null;
            try {
                encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(byArray);
            }
            catch (IOException iOException) {
                throw new IOException("Private key not stored as PKCS#8 EncryptedPrivateKeyInfo" + iOException.getMessage());
            }
            DerOutputStream derOutputStream3 = new DerOutputStream();
            derOutputStream3.write(encryptedPrivateKeyInfo.getEncoded());
            derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream3);
            byte[] byArray2 = this.getBagAttributes((String)object, ((KeyEntry)v).keyId);
            derOutputStream2.write(byArray2);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        object2 = new DerOutputStream();
        object2.write((byte)48, derOutputStream);
        object = ((ByteArrayOutputStream)object2).toByteArray();
        return (byte[])object;
    }

    private byte[] encryptContent(byte[] byArray, char[] cArray) throws IOException {
        Object object;
        Object object2;
        byte[] byArray2 = null;
        AlgorithmParameters algorithmParameters = this.getAlgorithmParameters("PBEWithSHA1AndRC2_40");
        DerOutputStream derOutputStream = new DerOutputStream();
        AlgorithmId algorithmId = new AlgorithmId(pbeWithSHAAnd40BitRC2CBC_OID, algorithmParameters);
        algorithmId.encode(derOutputStream);
        byte[] byArray3 = derOutputStream.toByteArray();
        try {
            object2 = this.getPBEKey(cArray);
            object = Cipher.getInstance("PBEWithSHA1AndRC2_40");
            ((Cipher)object).init(1, (Key)object2, algorithmParameters);
            byArray2 = ((Cipher)object).doFinal(byArray);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failed to encrypt safe contents entry: " + exception);
            iOException.initCause(exception);
            throw iOException;
        }
        object2 = new DerOutputStream();
        object2.putOID(ContentInfo.DATA_OID);
        ((OutputStream)object2).write(byArray3);
        object = new DerOutputStream();
        object.putOctetString(byArray2);
        object2.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), (DerOutputStream)object);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, (DerOutputStream)object2);
        byte[] byArray4 = derOutputStream2.toByteArray();
        return byArray4;
    }

    public synchronized void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object var4_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        if (inputStream == null) {
            return;
        }
        DerValue derValue = new DerValue(inputStream);
        DerInputStream derInputStream = derValue.toDerInputStream();
        int n = derInputStream.getInteger();
        if (n != 3) {
            throw new IOException("PKCS12 keystore not in version 3 format");
        }
        this.entries.clear();
        ContentInfo contentInfo = new ContentInfo(derInputStream);
        ObjectIdentifier objectIdentifier = contentInfo.getContentType();
        if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
            throw new IOException("public key protected PKCS12 not supported");
        }
        byte[] byArray = contentInfo.getData();
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        int n2 = derValueArray.length;
        for (int i = 0; i < n2; ++i) {
            object5 = null;
            object4 = new DerInputStream(derValueArray[i].toByteArray());
            object3 = new ContentInfo((DerInputStream)object4);
            objectIdentifier = ((ContentInfo)object3).getContentType();
            object2 = null;
            if (objectIdentifier.equals(ContentInfo.DATA_OID)) {
                object2 = ((ContentInfo)object3).getData();
            } else if (objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) {
                Object object6;
                if (cArray == null) continue;
                object = ((ContentInfo)object3).getContent().toDerInputStream();
                int n3 = ((DerInputStream)object).getInteger();
                DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                object5 = derValueArray2[1].toByteArray();
                if (!derValueArray2[2].isContextSpecific((byte)0)) {
                    throw new IOException("encrypted content not present!");
                }
                byte by = 4;
                if (derValueArray2[2].isConstructed()) {
                    by = (byte)(by | 0x20);
                }
                derValueArray2[2].resetTag(by);
                object2 = derValueArray2[2].getOctetString();
                DerInputStream derInputStream3 = derValueArray2[1].toDerInputStream();
                ObjectIdentifier objectIdentifier3 = derInputStream3.getOID();
                AlgorithmParameters algorithmParameters = this.parseAlgParameters(derInputStream3);
                try {
                    SecretKey secretKey = this.getPBEKey(cArray);
                    object6 = Cipher.getInstance(objectIdentifier3.toString());
                    ((Cipher)object6).init(2, (Key)secretKey, algorithmParameters);
                    object2 = ((Cipher)object6).doFinal((byte[])object2);
                }
                catch (Exception exception) {
                    object6 = new IOException("failed to decrypt safe contents entry: " + exception);
                    ((Throwable)object6).initCause(exception);
                    throw object6;
                }
            } else {
                throw new IOException("public key protected PKCS12 not supported");
            }
            object = new DerInputStream((byte[])object2);
            this.loadSafeContents((DerInputStream)object, cArray);
        }
        if (cArray != null && derInputStream.available() > 0) {
            MacData macData = new MacData(derInputStream);
            try {
                object2 = macData.getDigestAlgName().toUpperCase();
                if (((String)object2).equals("SHA") || ((String)object2).equals("SHA1") || ((String)object2).equals("SHA-1")) {
                    object2 = "SHA1";
                }
                object3 = Mac.getInstance("HmacPBE" + (String)object2);
                object4 = new PBEParameterSpec(macData.getSalt(), macData.getIterations());
                object5 = this.getPBEKey(cArray);
                ((Mac)object3).init((Key)object5, (AlgorithmParameterSpec)object4);
                ((Mac)object3).update(byArray);
                object = ((Mac)object3).doFinal();
                if (!Arrays.equals(macData.getDigest(), (byte[])object)) {
                    throw new SecurityException("Failed PKCS12 integrity checking");
                }
            }
            catch (Exception exception) {
                object3 = new IOException("Integrity check failed: " + exception);
                ((Throwable)object3).initCause(exception);
                throw object3;
            }
        }
        Object[] objectArray = this.keyList.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            object3 = (KeyEntry)objectArray[i];
            if (((KeyEntry)object3).keyId == null) continue;
            object4 = new ArrayList();
            object5 = (X509Certificate)this.certs.get(new KeyId(((KeyEntry)object3).keyId));
            while (object5 != null) {
                ((ArrayList)object4).add(object5);
                object = ((X509Certificate)object5).getIssuerX500Principal();
                if (((X500Principal)object).equals(((X509Certificate)object5).getSubjectX500Principal())) break;
                object5 = (X509Certificate)this.certs.get(object);
            }
            if (((ArrayList)object4).size() <= 0) continue;
            ((KeyEntry)object3).chain = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
        }
        this.certs.clear();
        this.keyList.clear();
    }

    private void loadSafeContents(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            DerValue[] derValueArray2 = null;
            DerInputStream derInputStream2 = derValueArray[i].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(PKCS8ShroudedKeyBag_OID)) {
                object5 = new KeyEntry();
                ((KeyEntry)object5).protectedPrivKey = derValue.toByteArray();
                derValueArray2 = object5;
            } else if (objectIdentifier.equals(CertBag_OID)) {
                object5 = new DerInputStream(derValue.toByteArray());
                object4 = ((DerInputStream)object5).getSequence(2);
                object3 = object4[0].getOID();
                if (!object4[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object4[1].tag);
                }
                DerValue derValue2 = object4[1].data.getDerValue();
                object2 = CertificateFactory.getInstance("X509");
                object = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray2 = object;
            }
            try {
                object5 = derInputStream2.getSet(2);
            }
            catch (IOException iOException) {
                throw new IOException("Entry does not have any attributes: " + iOException.getMessage());
            }
            object4 = null;
            object3 = null;
            for (int j = 0; j < ((Object)object5).length; ++j) {
                DerValue[] derValueArray3;
                object2 = new DerInputStream(((DerValue)object5[j]).toByteArray());
                object = ((DerInputStream)object2).getSequence(2);
                ObjectIdentifier objectIdentifier2 = object[0].getOID();
                DerInputStream derInputStream3 = new DerInputStream(object[1].toByteArray());
                try {
                    derValueArray3 = derInputStream3.getSet(1);
                }
                catch (IOException iOException) {
                    throw new IOException("Entry does not have any attributes: " + iOException.getMessage());
                }
                if (objectIdentifier2.equals(PKCS9FriendlyName_OID)) {
                    object4 = derValueArray3[0].getBMPString();
                    continue;
                }
                if (!objectIdentifier2.equals(PKCS9LocalKeyId_OID)) continue;
                object3 = derValueArray3[0].getOctetString();
            }
            if (derValueArray2 instanceof KeyEntry) {
                KeyEntry keyEntry = (KeyEntry)derValueArray2;
                if (object3 == null) continue;
                keyEntry.keyId = (byte[])object3;
                object2 = new String((byte[])object3, "UTF8");
                object = null;
                if (((String)object2).startsWith("Time ")) {
                    try {
                        object = new Date(Long.parseLong(((String)object2).substring(5)));
                    }
                    catch (Exception exception) {
                        object = null;
                    }
                }
                if (object == null) {
                    object = new Date();
                }
                keyEntry.date = object;
                this.keyList.add(keyEntry);
                if (object4 == null) {
                    object4 = this.getUnfriendlyName();
                }
                keyEntry.alias = object4;
                this.entries.put(((String)object4).toLowerCase(), keyEntry);
                continue;
            }
            if (!(derValueArray2 instanceof X509Certificate)) continue;
            X509Certificate x509Certificate = (X509Certificate)derValueArray2;
            if (object3 != null && !this.certs.containsKey(object2 = new KeyId((byte[])object3))) {
                this.certs.put(object2, derValueArray2);
            }
            if (object4 != null && !this.certs.containsKey(object4)) {
                this.certs.put(object4, derValueArray2);
            }
            if ((object2 = x509Certificate.getSubjectX500Principal()) == null || this.certs.containsKey(object2)) continue;
            this.certs.put(object2, derValueArray2);
        }
    }

    private String getUnfriendlyName() {
        return String.valueOf(++counter);
    }

    static {
        counter = 0;
        try {
            PKCS8ShroudedKeyBag_OID = new ObjectIdentifier(keyBag);
            CertBag_OID = new ObjectIdentifier(certBag);
            PKCS9FriendlyName_OID = new ObjectIdentifier(pkcs9Name);
            PKCS9LocalKeyId_OID = new ObjectIdentifier(pkcs9KeyId);
            PKCS9CertType_OID = new ObjectIdentifier(pkcs9certType);
            pbeWithSHAAnd40BitRC2CBC_OID = new ObjectIdentifier(pbeWithSHAAnd40BitRC2CBC);
            pbeWithSHAAnd3KeyTripleDESCBC_OID = new ObjectIdentifier(pbeWithSHAAnd3KeyTripleDESCBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class KeyEntry {
        Date date;
        byte[] protectedPrivKey;
        Certificate[] chain;
        byte[] keyId;
        String alias;

        private KeyEntry() {
        }
    }

    private static class KeyId {
        byte[] keyId;

        KeyId(byte[] byArray) {
            this.keyId = byArray;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.keyId.length; ++i) {
                n += this.keyId[i];
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            return Arrays.equals(this.keyId, keyId.keyId);
        }
    }
}

