/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;

final class X509KeyManagerImpl
extends X509ExtendedKeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final String[] STRING0 = new String[0];
    private Map credentialsMap = new HashMap();
    private Map serverAliasCache = new HashMap();

    X509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Certificate[] certificateArray;
            Key key;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || !((key = keyStore.getKey(string, cArray)) instanceof PrivateKey) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length == 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (!(certificateArray instanceof X509Certificate[])) {
                object = new X509Certificate[certificateArray.length];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                certificateArray = object;
            }
            object = new X509Credentials((PrivateKey)key, (X509Certificate[])certificateArray);
            this.credentialsMap.put(string, object);
            if (debug == null || !Debug.isOn("keymanager")) continue;
            System.out.println("***");
            System.out.println("found key for : " + string);
            for (int i = 0; i < certificateArray.length; ++i) {
                System.out.println("chain [" + i + "] = " + certificateArray[i]);
            }
            System.out.println("***");
        }
    }

    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        X509Credentials x509Credentials = (X509Credentials)this.credentialsMap.get(string);
        if (x509Credentials == null) {
            return null;
        }
        return (X509Certificate[])x509Credentials.certificates.clone();
    }

    public PrivateKey getPrivateKey(String string) {
        if (string == null) {
            return null;
        }
        X509Credentials x509Credentials = (X509Credentials)this.credentialsMap.get(string);
        if (x509Credentials == null) {
            return null;
        }
        return x509Credentials.privateKey;
    }

    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getClientAliases(stringArray[i], principalArray);
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            return stringArray2[0];
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            stringArray = (String[])this.serverAliasCache.get(string);
            if (stringArray == null) {
                stringArray = this.getServerAliases(string, principalArray);
                if (stringArray == null) {
                    stringArray = STRING0;
                }
                this.serverAliasCache.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseServerAlias(string, principalArray, null);
    }

    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray);
    }

    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray);
    }

    private String[] getAliases(String string, Principal[] principalArray) {
        if (string == null) {
            return null;
        }
        if (principalArray == null) {
            principalArray = new X500Principal[]{};
        }
        if (!(principalArray instanceof X500Principal[])) {
            principalArray = X509KeyManagerImpl.convertPrincipals(principalArray);
        }
        X500Principal[] x500PrincipalArray = (X500Principal[])principalArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (Map.Entry entry : this.credentialsMap.entrySet()) {
            String string2 = (String)entry.getKey();
            X509Credentials x509Credentials = (X509Credentials)entry.getValue();
            X509Certificate[] x509CertificateArray = x509Credentials.certificates;
            if (!string.equals(x509CertificateArray[0].getPublicKey().getAlgorithm())) continue;
            if (principalArray.length == 0) {
                arrayList.add(string2);
                if (debug == null || !Debug.isOn("keymanager")) continue;
                System.out.println("matching alias: " + string2);
                continue;
            }
            Set set = x509Credentials.getIssuerX500Principals();
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                if (!set.contains(principalArray[i])) continue;
                arrayList.add(string2);
                if (debug == null || !Debug.isOn("keymanager")) continue block0;
                System.out.println("matching alias: " + string2);
                continue block0;
            }
        }
        String[] stringArray = arrayList.toArray(STRING0);
        return stringArray.length == 0 ? null : stringArray;
    }

    private static X500Principal[] convertPrincipals(Principal[] principalArray) {
        ArrayList<Principal> arrayList = new ArrayList<Principal>(principalArray.length);
        for (int i = 0; i < principalArray.length; ++i) {
            Principal principal = principalArray[i];
            if (principal instanceof X500Principal) {
                arrayList.add(principal);
                continue;
            }
            try {
                arrayList.add(new X500Principal(principal.getName()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new X500Principal[arrayList.size()]);
    }

    private static class X509Credentials {
        PrivateKey privateKey;
        X509Certificate[] certificates;
        private Set issuerX500Principals;

        X509Credentials(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = privateKey;
            this.certificates = x509CertificateArray;
        }

        synchronized Set getIssuerX500Principals() {
            if (this.issuerX500Principals == null) {
                this.issuerX500Principals = new HashSet();
                for (int i = 0; i < this.certificates.length; ++i) {
                    this.issuerX500Principals.add(this.certificates[i].getIssuerX500Principal());
                }
            }
            return this.issuerX500Principals;
        }
    }
}

