/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_JP;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022_JP;
import sun.nio.cs.ext.SJIS;
import sun.security.action.GetPropertyAction;

public class JISAutoDetect
extends Charset
implements HistoricallyNamedCharset {
    private static final int EUCJP_MASK = 1;
    private static final int SJIS2B_MASK = 2;
    private static final int SJIS1B_MASK = 4;
    private static final int EUCJP_KANA1_MASK = 8;
    private static final int EUCJP_KANA2_MASK = 16;
    private static final int SS2 = 142;
    private static final int SS3 = 143;

    public JISAutoDetect() {
        super("x-JISAutoDetect", ExtendedCharsets.aliasesFor("x-JISAutoDetect"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof SJIS || charset instanceof EUC_JP || charset instanceof ISO2022_JP;
    }

    public boolean canEncode() {
        return false;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public String historicalName() {
        return "JISAutoDetect";
    }

    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteMask1() {
        return Decoder.maskTable1;
    }

    public byte[] getByteMask2() {
        return Decoder.maskTable2;
    }

    public static final boolean canBeSJIS1B(int n) {
        return (n & 4) != 0;
    }

    public static final boolean canBeEUCJP(int n) {
        return (n & 1) != 0;
    }

    public static final boolean canBeEUCKana(int n, int n2) {
        return (n & 8) != 0 && (n2 & 0x10) != 0;
    }

    private static class Decoder
    extends CharsetDecoder {
        private static String convName = null;
        private static String SJISName = Decoder.getSJISName();
        private static String EUCJPName = Decoder.getEUCJPName();
        private Charset csDetected = null;
        private CharsetDecoder detectedDecoder;
        private static final byte[] maskTable1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 5, 5, 5, 13, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};
        private static final byte[] maskTable2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 0};

        public Decoder(Charset charset) {
            super(charset, 0.5f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            byte by = 0;
            byte by2 = 0;
            boolean bl = false;
            try {
                while (byteBuffer.remaining() > 1) {
                    by = 0;
                    by2 = 0;
                    int n5 = byteBuffer.get() & 0xFF;
                    if (n5 == 27) {
                        convName = "ISO2022JP";
                        break;
                    }
                    if (!bl && n5 < 128) {
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)n5);
                        n2 = byteBuffer.position();
                        continue;
                    }
                    bl = true;
                    by = maskTable1[n5];
                    if (n5 == 142) {
                        ++n4;
                    }
                    if (by == 0) continue;
                    if (byteBuffer.remaining() >= 1) {
                        int n6 = byteBuffer.get() & 0xFF;
                        by2 = maskTable2[n6];
                        int n7 = by & by2;
                        if (n7 == 1) {
                            convName = EUCJPName;
                            break;
                        }
                        if (n7 == 2 || n7 == 4 || JISAutoDetect.canBeSJIS1B(by) && by2 == 0) {
                            convName = SJISName;
                            break;
                        }
                        if (n5 == 143 && JISAutoDetect.canBeEUCJP(by2)) {
                            if (byteBuffer.remaining() >= 1) {
                                int n8 = byteBuffer.get() & 0xFF;
                                if (!JISAutoDetect.canBeEUCJP(maskTable2[n8])) {
                                    convName = SJISName;
                                }
                            } else {
                                convName = SJISName;
                            }
                        }
                        if (!JISAutoDetect.canBeEUCKana(by, by2)) continue;
                        ++n3;
                        continue;
                    }
                    if ((by & 4) == 0) continue;
                    convName = SJISName;
                    break;
                }
                if (bl && convName == null) {
                    convName = n3 > 1 || n4 > 1 ? EUCJPName : SJISName;
                }
                if (convName != null) {
                    this.csDetected = Charset.forName(convName);
                    this.detectedDecoder = this.csDetected.newDecoder();
                    byteBuffer.position(n2);
                    this.detectedDecoder.decode(byteBuffer, charBuffer, true);
                } else {
                    Charset charset = Charset.forName("ISO-8859-1");
                    CharsetDecoder charsetDecoder = charset.newDecoder();
                    charsetDecoder.decode(byteBuffer, charBuffer, true);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected void implReset() {
            if (this.detectedDecoder != null) {
                this.detectedDecoder.reset();
            }
        }

        public boolean isAutoDetecting() {
            return true;
        }

        public boolean isCharsetDetected() {
            return this.csDetected != null;
        }

        public Charset detectedCharset() {
            return this.csDetected;
        }

        private static String getSJISName() {
            GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
            String string = AccessController.doPrivileged(getPropertyAction);
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "PCK";
            }
            if (string.startsWith("Windows")) {
                return "windows-31J";
            }
            return "Shift_JIS";
        }

        private static String getEUCJPName() {
            GetPropertyAction getPropertyAction = new GetPropertyAction("os.name");
            String string = AccessController.doPrivileged(getPropertyAction);
            if (string.equals("Solaris") || string.equals("SunOS")) {
                return "x-eucjp-open";
            }
            return "EUC_JP";
        }
    }
}

