/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class SJIS
extends Charset
implements HistoricallyNamedCharset {
    public SJIS() {
        super("Shift_JIS", ExtendedCharsets.aliasesFor("Shift_JIS"));
    }

    public String historicalName() {
        return "SJIS";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof JIS_X_0201 || charset instanceof SJIS || charset instanceof JIS_X_0208;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        byte[] byArray = new byte[]{63};
        return new Encoder(this).replaceWith(byArray);
    }

    static class Decoder
    extends JIS_X_0208_Decoder {
        JIS_X_0201.Decoder jis0201;

        protected Decoder(Charset charset) {
            super(charset);
            this.jis0201 = new JIS_X_0201.Decoder(charset);
        }

        protected char decodeSingle(int n) {
            if ((n & 0xFF80) == 0) {
                return (char)n;
            }
            return this.jis0201.decode(n);
        }

        protected char decodeDouble(int n, int n2) {
            int n3;
            int n4 = n2 < 159 ? 1 : 0;
            int n5 = n3 = n < 160 ? 112 : 176;
            int n6 = n4 == 1 ? (n2 > 127 ? 32 : 31) : 126;
            int n7 = (n - n3 << 1) - n4;
            int n8 = n2 - n6;
            return super.decodeDouble(n7, n8);
        }
    }

    static class Encoder
    extends JIS_X_0208_Encoder {
        private JIS_X_0201.Encoder jis0201;
        short[] j0208Index1;
        String[] j0208Index2;

        protected Encoder(Charset charset) {
            super(charset);
            this.jis0201 = new JIS_X_0201.Encoder(charset);
            this.j0208Index1 = JIS_X_0208_Encoder.getIndex1();
            this.j0208Index2 = JIS_X_0208_Encoder.getIndex2();
        }

        public boolean canEncode(char c) {
            return this.encodeSingle(c) != -1 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char c) {
            if ((c & 0xFF80) == 0) {
                return (byte)c;
            }
            byte by = this.jis0201.encode(c);
            if (by == 0) {
                return -1;
            }
            return by;
        }

        protected int encodeDouble(char c) {
            int n;
            int n2 = this.j0208Index1[c >> 8] << 8;
            char c2 = this.j0208Index2[n2 >> 12].charAt((n2 & 0xFFF) + (c & 0xFF));
            if (c2 == '\u0000') {
                return 0;
            }
            int n3 = c2 >> 8 & 0xFF;
            int n4 = c2 & 0xFF;
            int n5 = n = n3 < 95 ? 112 : 176;
            int n6 = n3 % 2 == 1 ? (n4 > 95 ? 32 : 31) : 126;
            return (n3 + 1 >> 1) + n << 8 | n4 + n6;
        }
    }
}

