/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.CORBAObjectImpl;
import com.sun.corba.se.impl.corba.PrincipalImpl;
import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerRead;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputStreamBase;
import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.encoding.MarkAndResetHandler;
import com.sun.corba.se.impl.encoding.RestorableInputStream;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.CacheTable;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.se.impl.orbutil.RepositoryIdInterface;
import com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.se.impl.orbutil.RepositoryIdUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import com.sun.corba.se.spi.protocol.CorbaClientDelegate;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA.portable.ValueFactory;

public class CDRInputStream_1_0
extends CDRInputStreamBase
implements RestorableInputStream {
    private static final String kReadMethod = "read";
    private static final int maxBlockLength = 0x7FFFFF00;
    protected BufferManagerRead bufferManagerRead;
    protected ByteBufferWithInfo bbwi;
    private boolean debug = false;
    protected boolean littleEndian;
    protected ORB orb;
    protected ORBUtilSystemException wrapper;
    protected OMGSystemException omgWrapper;
    protected ValueHandler valueHandler = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private CacheTable codebaseCache = null;
    protected int blockLength = 0x7FFFFF00;
    protected int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    protected int valueIndirection = 0;
    protected int stringIndirection = 0;
    protected boolean isChunked = false;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.BTCConverter charConverter;
    private CodeSetConversion.BTCConverter wcharConverter;
    private boolean specialNoOptionalDataState = false;
    private static final String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    protected MarkAndResetHandler markAndResetHandler = null;

    public CDRInputStreamBase dup() {
        CDRInputStreamBase cDRInputStreamBase = null;
        try {
            cDRInputStreamBase = (CDRInputStreamBase)this.getClass().newInstance();
        }
        catch (Exception exception) {
            throw this.wrapper.couldNotDuplicateCdrInputStream(exception);
        }
        cDRInputStreamBase.init(this.orb, this.bbwi.byteBuffer, this.bbwi.buflen, this.littleEndian, this.bufferManagerRead);
        ((CDRInputStream_1_0)cDRInputStreamBase).bbwi.position(this.bbwi.position());
        ((CDRInputStream_1_0)cDRInputStreamBase).bbwi.byteBuffer.limit(this.bbwi.buflen);
        return cDRInputStreamBase;
    }

    public void init(org.omg.CORBA.ORB oRB, ByteBuffer byteBuffer, int n2, boolean bl2, BufferManagerRead bufferManagerRead) {
        this.orb = (ORB)oRB;
        this.wrapper = ORBUtilSystemException.get((ORB)oRB, "rpc.encoding");
        this.omgWrapper = OMGSystemException.get((ORB)oRB, "rpc.encoding");
        this.littleEndian = bl2;
        this.bufferManagerRead = bufferManagerRead;
        this.bbwi = new ByteBufferWithInfo(oRB, byteBuffer, 0);
        this.bbwi.buflen = n2;
        this.bbwi.byteBuffer.limit(this.bbwi.buflen);
        this.markAndResetHandler = this.bufferManagerRead.getMarkAndResetHandler();
        this.debug = ((ORB)oRB).transportDebugFlag;
    }

    void performORBVersionSpecificInit() {
        this.createRepositoryIdHandlers();
    }

    private final void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    void setHeaderPadding(boolean bl2) {
        throw this.wrapper.giopVersionError();
    }

    protected final int computeAlignment(int n2, int n3) {
        int n4;
        if (n3 > 1 && (n4 = n2 & n3 - 1) != 0) {
            return n3 - n4;
        }
        return 0;
    }

    public int getSize() {
        return this.bbwi.position();
    }

    protected void checkBlockLength(int n2, int n3) {
        if (!this.isChunked) {
            return;
        }
        if (this.specialNoOptionalDataState) {
            throw this.omgWrapper.rmiiiopOptionalDataIncompatible1();
        }
        boolean bl2 = false;
        if (this.blockLength == this.get_offset()) {
            this.blockLength = 0x7FFFFF00;
            this.start_block();
            if (this.blockLength == 0x7FFFFF00) {
                bl2 = true;
            }
        } else if (this.blockLength < this.get_offset()) {
            throw this.wrapper.chunkOverflow();
        }
        int n4 = this.computeAlignment(this.bbwi.position(), n2) + n3;
        if (this.blockLength != 0x7FFFFF00 && this.blockLength < this.get_offset() + n4) {
            throw this.omgWrapper.rmiiiopOptionalDataIncompatible2();
        }
        if (bl2) {
            int n5 = this.read_long();
            this.bbwi.position(this.bbwi.position() - 4);
            if (n5 < 0) {
                throw this.omgWrapper.rmiiiopOptionalDataIncompatible3();
            }
        }
    }

    protected void alignAndCheck(int n2, int n3) {
        this.checkBlockLength(n2, n3);
        int n4 = this.computeAlignment(this.bbwi.position(), n2);
        this.bbwi.position(this.bbwi.position() + n4);
        if (this.bbwi.position() + n3 > this.bbwi.buflen) {
            this.grow(n2, n3);
        }
    }

    protected void grow(int n2, int n3) {
        this.bbwi.needed = n3;
        this.bbwi = this.bufferManagerRead.underflow(this.bbwi);
    }

    public final void consumeEndian() {
        this.littleEndian = this.read_boolean();
    }

    public final double read_longdouble() {
        throw this.wrapper.longDoubleNotImplemented(CompletionStatus.COMPLETED_MAYBE);
    }

    public final boolean read_boolean() {
        return this.read_octet() != 0;
    }

    public final char read_char() {
        this.alignAndCheck(1, 1);
        return this.getConvertedChars(1, this.getCharConverter())[0];
    }

    public char read_wchar() {
        int n2;
        int n3;
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n3 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        } else {
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n3 = this.bbwi.byteBuffer.get(this.bbwi.position()) & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        }
        return (char)((n2 << 8) + (n3 << 0));
    }

    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        byte by = this.bbwi.byteBuffer.get(this.bbwi.position());
        this.bbwi.position(this.bbwi.position() + 1);
        return by;
    }

    public final short read_short() {
        int n2;
        int n3;
        this.alignAndCheck(2, 2);
        if (this.littleEndian) {
            n3 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 0 & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 8 & 0xFF00;
            this.bbwi.position(this.bbwi.position() + 1);
        } else {
            n2 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 8 & 0xFF00;
            this.bbwi.position(this.bbwi.position() + 1);
            n3 = this.bbwi.byteBuffer.get(this.bbwi.position()) << 0 & 0xFF;
            this.bbwi.position(this.bbwi.position() + 1);
        }
        return (short)(n2 | n3);
    }

    public final short read_ushort() {
        return this.read_short();
    }

    public final int read_long() {
        int n2;
        int n3;
        int n4;
        int n5;
        this.alignAndCheck(4, 4);
        int n6 = this.bbwi.position();
        if (this.littleEndian) {
            n5 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n4 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n3 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n2 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
        } else {
            n2 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n3 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n4 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
            n5 = this.bbwi.byteBuffer.get(n6++) & 0xFF;
        }
        this.bbwi.position(n6);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public final int read_ulong() {
        return this.read_long();
    }

    public final long read_longlong() {
        long l2;
        long l3;
        this.alignAndCheck(8, 8);
        if (this.littleEndian) {
            l3 = (long)this.read_long() & 0xFFFFFFFFL;
            l2 = (long)this.read_long() << 32;
        } else {
            l2 = (long)this.read_long() << 32;
            l3 = (long)this.read_long() & 0xFFFFFFFFL;
        }
        return l2 | l3;
    }

    public final long read_ulonglong() {
        return this.read_longlong();
    }

    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    protected final void checkForNegativeLength(int n2) {
        if (n2 < 0) {
            throw this.wrapper.negativeStringLength(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n2));
        }
    }

    protected final String readStringOrIndirection(boolean bl2) {
        int n2 = this.read_long();
        if (bl2) {
            if (n2 == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        this.checkForNegativeLength(n2);
        if (this.orb != null && ORBUtility.isLegacyORB(this.orb)) {
            return this.legacyReadString(n2);
        }
        return this.internalReadString(n2);
    }

    private final String internalReadString(int n2) {
        if (n2 == 0) {
            return new String("");
        }
        char[] cArray = this.getConvertedChars(n2 - 1, this.getCharConverter());
        this.read_octet();
        return new String(cArray, 0, this.getCharConverter().getNumChars());
    }

    private final String legacyReadString(int n2) {
        int n3;
        if (n2 == 0) {
            return new String("");
        }
        char[] cArray = new char[--n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            int n4;
            int n5 = this.bbwi.buflen - this.bbwi.position();
            if (n5 <= 0) {
                this.grow(1, 1);
                n5 = this.bbwi.buflen - this.bbwi.position();
            }
            n3 = (n4 = n2 - i2) < n5 ? n4 : n5;
            for (int i3 = 0; i3 < n3; ++i3) {
                cArray[i2 + i3] = (char)(this.bbwi.byteBuffer.get(this.bbwi.position() + i3) & 0xFF);
            }
            this.bbwi.position(this.bbwi.position() + n3);
        }
        if (this.bbwi.position() + 1 > this.bbwi.buflen) {
            this.alignAndCheck(1, 1);
        }
        this.bbwi.position(this.bbwi.position() + 1);
        return new String(cArray);
    }

    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    public String read_wstring() {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = this.read_long();
        if (n2 == 0) {
            return new String("");
        }
        this.checkForNegativeLength(n2);
        char[] cArray = new char[--n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = this.read_wchar();
        }
        this.read_wchar();
        return new String(cArray);
    }

    public final void read_octet_array(byte[] byArray, int n2, int n3) {
        int n4;
        if (byArray == null) {
            throw this.wrapper.nullParam();
        }
        if (n3 == 0) {
            return;
        }
        this.alignAndCheck(1, 1);
        for (int i2 = n2; i2 < n3 + n2; i2 += n4) {
            int n5;
            int n6 = this.bbwi.buflen - this.bbwi.position();
            if (n6 <= 0) {
                this.grow(1, 1);
                n6 = this.bbwi.buflen - this.bbwi.position();
            }
            n4 = (n5 = n3 + n2 - i2) < n6 ? n5 : n6;
            for (int i3 = 0; i3 < n4; ++i3) {
                byArray[i2 + i3] = this.bbwi.byteBuffer.get(this.bbwi.position() + i3);
            }
            this.bbwi.position(this.bbwi.position() + n4);
        }
    }

    public Principal read_Principal() {
        int n2 = this.read_long();
        byte[] byArray = new byte[n2];
        this.read_octet_array(byArray, 0, n2);
        PrincipalImpl principalImpl = new PrincipalImpl();
        ((Principal)principalImpl).name(byArray);
        return principalImpl;
    }

    public TypeCode read_TypeCode() {
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        typeCodeImpl.read_value(this.parent);
        return typeCodeImpl;
    }

    public Any read_any() {
        Any any = this.orb.create_any();
        TypeCodeImpl typeCodeImpl = new TypeCodeImpl(this.orb);
        try {
            typeCodeImpl.read_value(this.parent);
        }
        catch (MARSHAL mARSHAL) {
            if (typeCodeImpl.kind().value() != 29) {
                throw mARSHAL;
            }
            this.dprintThrowable(mARSHAL);
        }
        any.read_value(this.parent, typeCodeImpl);
        return any;
    }

    public Object read_Object() {
        return this.read_Object(null);
    }

    public Object read_Object(Class clazz) {
        IOR iOR = IORFactories.makeIOR(this.parent);
        if (clazz == null || StubAdapter.isStubClass(clazz)) {
            return CDRInputStream_1_0.internalIORToObject(iOR, clazz, this.orb);
        }
        try {
            Class clazz2 = Utility.loadStubClass(iOR.getTypeId(), iOR.getProfile().getCodebase(), clazz);
            return CDRInputStream_1_0.internalIORToObject(iOR, clazz2, this.orb);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.readObjectLoadClassFailure(iOR.getTypeId(), clazz == null ? "null" : clazz.getName());
        }
    }

    public static Object internalIORToObject(IOR iOR, Class clazz, ORB oRB) {
        ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get(oRB, "rpc.encoding");
        if (iOR.isNil()) {
            return null;
        }
        java.lang.Object object = iOR.getProfile().getServant();
        if (object != null) {
            if (object instanceof Tie) {
                String string = iOR.getProfile().getCodebase();
                Object object2 = (Object)((java.lang.Object)Utility.loadStub((Tie)object, clazz, string, false));
                if (object2 != null) {
                    return object2;
                }
                throw oRBUtilSystemException.readObjectException();
            }
            if (object instanceof Object) {
                if (object instanceof InvokeHandler) {
                    return CDRInputStream_1_0.createDelegate(iOR, clazz, oRB);
                }
                return (Object)object;
            }
            throw oRBUtilSystemException.badServantReadObject();
        }
        return CDRInputStream_1_0.createDelegate(iOR, clazz, oRB);
    }

    protected static Object createDelegate(IOR iOR, Class clazz, ORB oRB) {
        CorbaClientDelegate corbaClientDelegate = ORBUtility.makeClientDelegate(iOR);
        return CDRInputStream_1_0.loadStub(iOR, clazz, corbaClientDelegate);
    }

    protected static Object loadStub(IOR iOR, Class clazz, Delegate delegate) {
        ORBUtilSystemException oRBUtilSystemException;
        block7: {
            java.lang.Object object;
            block8: {
                oRBUtilSystemException = ORBUtilSystemException.get("rpc.encoding");
                if (clazz != null) {
                    try {
                        return CDRInputStream_1_0.newStub(clazz, delegate);
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        break block7;
                    }
                }
                try {
                    object = iOR.getTypeId();
                    if (((String)object).length() > 0) {
                        String string = iOR.getProfile().getCodebase();
                        Class clazz2 = Utility.loadStubClass((String)object, string, null);
                        return CDRInputStream_1_0.newStub(clazz2, delegate);
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block8;
                    throw (ThreadDeath)throwable;
                }
            }
            object = new CORBAObjectImpl();
            StubAdapter.setDelegate(object, delegate);
            return object;
        }
        throw oRBUtilSystemException.readObjectException();
    }

    protected static Object newStub(Class clazz, Delegate delegate) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (Remote.class.isAssignableFrom(clazz)) {
            Object object = (Object)clazz.newInstance();
            StubAdapter.setDelegate(object, delegate);
            return object;
        }
        try {
            Object object = (Object)clazz.newInstance();
            StubAdapter.setDelegate(object, delegate);
            return object;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            Class[] classArray = new Class[]{Delegate.class};
            java.lang.Object[] objectArray = new java.lang.Object[]{delegate};
            Constructor constructor = clazz.getConstructor(classArray);
            return (Object)constructor.newInstance(objectArray);
        }
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        boolean bl2 = this.read_boolean();
        if (bl2) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    public Serializable read_value() {
        return this.read_value((Class)null);
    }

    private Serializable handleIndirection() {
        int n2 = this.read_long() + this.get_offset() - 4;
        if (this.valueCache != null && this.valueCache.containsVal(n2)) {
            Serializable serializable = (Serializable)this.valueCache.getKey(n2);
            return serializable;
        }
        throw new IndirectionException(n2);
    }

    private String readRepositoryIds(int n2, Class clazz, String string) {
        switch (this.repIdUtil.getTypeInfo(n2)) {
            case 0: {
                if (clazz == null) {
                    if (string != null) {
                        return string;
                    }
                    throw this.wrapper.expectedTypeNullAndNoRepId(CompletionStatus.COMPLETED_MAYBE);
                }
                return this.repIdStrs.createForAnyType(clazz);
            }
            case 2: {
                return this.read_repositoryId();
            }
            case 6: {
                return this.read_repositoryIds();
            }
        }
        throw this.wrapper.badValueTag(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)Integer.toHexString(n2));
    }

    public Serializable read_value(Class clazz) {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            return this.handleIndirection();
        }
        int n3 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        java.lang.Object object = null;
        String string = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string = this.read_codebase_URL();
        }
        String string2 = this.readRepositoryIds(n2, clazz, null);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (string2.equals(this.repIdStrs.getWStringValueRepId())) {
            object = this.read_wstring();
        } else if (string2.equals(this.repIdStrs.getClassDescValueRepId())) {
            object = this.readClass();
        } else {
            Class clazz2 = clazz;
            if (clazz == null || !string2.equals(this.repIdStrs.createForAnyType(clazz))) {
                clazz2 = this.getClassFromString(string2, string, clazz);
            }
            if (clazz2 == null) {
                throw this.wrapper.couldNotFindClass(CompletionStatus.COMPLETED_MAYBE, new ClassNotFoundException());
            }
            if (clazz2 != null && IDLEntity.class.isAssignableFrom(clazz2)) {
                object = this.readIDLValue(n3, string2, clazz2, string);
            } else {
                try {
                    if (this.valueHandler == null) {
                        this.valueHandler = ORBUtility.createValueHandler(this.orb);
                    }
                    object = this.valueHandler.readValue(this.parent, n3, clazz2, string2, this.getCodeBase());
                }
                catch (SystemException systemException) {
                    throw systemException;
                }
                catch (Exception exception) {
                    throw this.wrapper.valuehandlerReadException(CompletionStatus.COMPLETED_MAYBE, exception);
                }
                catch (Error error) {
                    throw this.wrapper.valuehandlerReadError(CompletionStatus.COMPLETED_MAYBE, error);
                }
            }
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n3);
        this.isChunked = bl2;
        this.start_block();
        return (Serializable)object;
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        String string;
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        java.lang.Object object = null;
        String string2 = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string2 = this.read_codebase_URL();
        }
        if (!(string = this.readRepositoryIds(n2, null, null)).equals(boxedValueHelper.get_id())) {
            boxedValueHelper = Utility.getHelper(null, string2, string);
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (boxedValueHelper instanceof ValueHelper) {
            object = this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n4);
        } else {
            this.valueIndirection = n4;
            object = boxedValueHelper.read_value(this.parent);
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n4);
        this.isChunked = bl2;
        this.start_block();
        return (Serializable)object;
    }

    private boolean isCustomType(ValueHelper valueHelper) {
        try {
            TypeCode typeCode = valueHelper.get_type();
            int n2 = typeCode.kind().value();
            if (n2 == 29) {
                return typeCode.type_modifier() == 1;
            }
        }
        catch (BadKind badKind) {
            throw this.wrapper.badKind(badKind);
        }
        return false;
    }

    public Serializable read_value(Serializable serializable) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(serializable, this.valueIndirection);
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(this.parent);
        }
        return serializable;
    }

    public Serializable read_value(String string) {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            return null;
        }
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(n3)) {
                Serializable serializable = (Serializable)this.valueCache.getKey(n3);
                return serializable;
            }
            throw new IndirectionException(n3);
        }
        int n4 = this.get_offset() - 4;
        boolean bl2 = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(n2);
        Serializable serializable = null;
        String string2 = null;
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            string2 = this.read_codebase_URL();
        }
        String string3 = this.readRepositoryIds(n2, null, string);
        ValueFactory valueFactory = Utility.getFactory(null, string2, this.orb, string3);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        this.valueIndirection = n4;
        serializable = valueFactory.read_value(this.parent);
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(serializable, n4);
        this.isChunked = bl2;
        this.start_block();
        return serializable;
    }

    private Class readClass() {
        String string = null;
        String string2 = null;
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            string = (String)((java.lang.Object)this.read_value(String.class));
            string2 = (String)((java.lang.Object)this.read_value(String.class));
        } else {
            string2 = (String)((java.lang.Object)this.read_value(String.class));
            string = (String)((java.lang.Object)this.read_value(String.class));
        }
        if (this.debug) {
            this.dprint("readClass codebases: " + string + " rep Id: " + string2);
        }
        Class clazz = null;
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string2);
        try {
            clazz = repositoryIdInterface.getClassFromType(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.cnfeReadClass(CompletionStatus.COMPLETED_MAYBE, classNotFoundException, repositoryIdInterface.getClassName());
        }
        catch (MalformedURLException malformedURLException) {
            throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, repositoryIdInterface.getClassName(), string);
        }
        return clazz;
    }

    private java.lang.Object readIDLValueWithHelper(ValueHelper valueHelper, int n2) {
        Method method;
        java.lang.Object object;
        try {
            object = new Class[]{InputStream.class, valueHelper.get_class()};
            method = valueHelper.getClass().getDeclaredMethod(kReadMethod, (Class)object);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Serializable serializable = valueHelper.read_value(this.parent);
            return serializable;
        }
        object = null;
        try {
            object = valueHelper.get_class().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw this.wrapper.couldNotInstantiateHelper(instantiationException, (java.lang.Object)valueHelper.get_class());
        }
        catch (IllegalAccessException illegalAccessException) {
            return valueHelper.read_value(this.parent);
        }
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, false);
        }
        this.valueCache.put(object, n2);
        if (object instanceof CustomMarshal && this.isCustomType(valueHelper)) {
            ((CustomMarshal)object).unmarshal(this.parent);
            return object;
        }
        try {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, object};
            method.invoke(valueHelper, objectArray);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(illegalAccessException, (java.lang.Object)valueHelper.get_class());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(invocationTargetException, (java.lang.Object)valueHelper.get_class());
        }
    }

    private java.lang.Object readBoxedIDLEntity(Class clazz, String string) {
        Class clazz2 = null;
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz3 = clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{InputStream.class};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz3.getDeclaredMethod(CDRInputStream_1_0.kReadMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent};
            return method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(classNotFoundException, clazz2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(noSuchMethodException, clazz2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(illegalAccessException, clazz2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.couldNotInvokeHelperReadMethod(invocationTargetException, clazz2);
        }
    }

    private java.lang.Object readIDLValue(int n2, String string, Class clazz, String string2) {
        ValueFactory valueFactory;
        try {
            valueFactory = Utility.getFactory(clazz, string2, this.orb, string);
        }
        catch (MARSHAL mARSHAL) {
            if (!StreamableValue.class.isAssignableFrom(clazz) && !CustomValue.class.isAssignableFrom(clazz) && ValueBase.class.isAssignableFrom(clazz)) {
                BoxedValueHelper boxedValueHelper = Utility.getHelper(clazz, string2, string);
                if (boxedValueHelper instanceof ValueHelper) {
                    return this.readIDLValueWithHelper((ValueHelper)boxedValueHelper, n2);
                }
                return boxedValueHelper.read_value(this.parent);
            }
            return this.readBoxedIDLEntity(clazz, string2);
        }
        this.valueIndirection = n2;
        return valueFactory.read_value(this.parent);
    }

    private void readEndTag() {
        if (this.isChunked) {
            int n2 = this.read_long();
            if (n2 >= 0) {
                throw this.wrapper.positiveEndTag(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n2), (java.lang.Object)new Integer(this.get_offset() - 4));
            }
            if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
                if (n2 < this.chunkedValueNestingLevel) {
                    throw this.wrapper.unexpectedEnclosingValuetype(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n2), (java.lang.Object)new Integer(this.chunkedValueNestingLevel));
                }
                if (n2 != this.chunkedValueNestingLevel) {
                    this.bbwi.position(this.bbwi.position() - 4);
                }
            } else if (n2 != this.end_flag) {
                this.bbwi.position(this.bbwi.position() - 4);
            }
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    protected int get_offset() {
        return this.bbwi.position();
    }

    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00;
        this.blockLength = this.read_long();
        if (this.blockLength > 0 && this.blockLength < 0x7FFFFF00) {
            this.blockLength += this.get_offset();
        } else {
            this.blockLength = 0x7FFFFF00;
            this.bbwi.position(this.bbwi.position() - 4);
        }
    }

    private void handleEndOfValue() {
        if (!this.isChunked) {
            return;
        }
        while (this.blockLength != 0x7FFFFF00) {
            this.end_block();
            this.start_block();
        }
        int n2 = this.read_long();
        this.bbwi.position(this.bbwi.position() - 4);
        if (n2 < 0) {
            return;
        }
        if (n2 != 0 && n2 < 0x7FFFFF00) {
            throw this.wrapper.couldNotSkipBytes(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(n2), (java.lang.Object)new Integer(this.get_offset()));
        }
        this.read_value();
        this.handleEndOfValue();
    }

    private void end_block() {
        if (this.blockLength != 0x7FFFFF00) {
            if (this.blockLength == this.get_offset()) {
                this.blockLength = 0x7FFFFF00;
            } else if (this.blockLength > this.get_offset()) {
                this.skipToOffset(this.blockLength);
            } else {
                throw this.wrapper.badChunkLength(new Integer(this.blockLength), new Integer(this.get_offset()));
            }
        }
    }

    private int readValueTag() {
        return this.read_long();
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public final void read_boolean_array(boolean[] blArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            blArray[i2 + n2] = this.read_boolean();
        }
    }

    public final void read_char_array(char[] cArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2 + n2] = this.read_char();
        }
    }

    public final void read_wchar_array(char[] cArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            cArray[i2 + n2] = this.read_wchar();
        }
    }

    public final void read_short_array(short[] sArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            sArray[i2 + n2] = this.read_short();
        }
    }

    public final void read_ushort_array(short[] sArray, int n2, int n3) {
        this.read_short_array(sArray, n2, n3);
    }

    public final void read_long_array(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2 + n2] = this.read_long();
        }
    }

    public final void read_ulong_array(int[] nArray, int n2, int n3) {
        this.read_long_array(nArray, n2, n3);
    }

    public final void read_longlong_array(long[] lArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            lArray[i2 + n2] = this.read_longlong();
        }
    }

    public final void read_ulonglong_array(long[] lArray, int n2, int n3) {
        this.read_longlong_array(lArray, n2, n3);
    }

    public final void read_float_array(float[] fArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray[i2 + n2] = this.read_float();
        }
    }

    public final void read_double_array(double[] dArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2 + n2] = this.read_double();
        }
    }

    public final void read_any_array(Any[] anyArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            anyArray[i2 + n2] = this.read_any();
        }
    }

    private String read_repositoryIds() {
        int n2 = this.read_long();
        if (n2 == -1) {
            int n3 = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n3)) {
                return (String)this.repositoryIdCache.getKey(n3);
            }
            throw this.wrapper.unableToLocateRepIdArray(new Integer(n3));
        }
        int n4 = this.get_offset();
        String string = this.read_repositoryId();
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(this.orb, false);
        }
        this.repositoryIdCache.put(string, n4);
        for (int i2 = 1; i2 < n2; ++i2) {
            this.read_repositoryId();
        }
        return string;
    }

    private final String read_repositoryId() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsOrderedVal(n2)) {
                return (String)this.repositoryIdCache.getKey(n2);
            }
            throw this.wrapper.badRepIdIndirection(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(this.bbwi.position()));
        }
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(this.orb, false);
        }
        this.repositoryIdCache.put(string, this.stringIndirection);
        return string;
    }

    private final String read_codebase_URL() {
        String string = this.readStringOrIndirection(true);
        if (string == null) {
            int n2 = this.read_long() + this.get_offset() - 4;
            if (this.codebaseCache != null && this.codebaseCache.containsVal(n2)) {
                return (String)this.codebaseCache.getKey(n2);
            }
            throw this.wrapper.badCodebaseIndirection(CompletionStatus.COMPLETED_MAYBE, (java.lang.Object)new Integer(this.bbwi.position()));
        }
        if (this.codebaseCache == null) {
            this.codebaseCache = new CacheTable(this.orb, false);
        }
        this.codebaseCache.put(string, this.stringIndirection);
        return string;
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n2, int n3) {
        this.read_any_array(anySeqHolder.value, n2, n3);
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n2, int n3) {
        this.read_boolean_array(booleanSeqHolder.value, n2, n3);
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n2, int n3) {
        this.read_char_array(charSeqHolder.value, n2, n3);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n2, int n3) {
        this.read_wchar_array(wCharSeqHolder.value, n2, n3);
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n2, int n3) {
        this.read_octet_array(octetSeqHolder.value, n2, n3);
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n2, int n3) {
        this.read_short_array(shortSeqHolder.value, n2, n3);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n2, int n3) {
        this.read_ushort_array(uShortSeqHolder.value, n2, n3);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n2, int n3) {
        this.read_long_array(longSeqHolder.value, n2, n3);
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n2, int n3) {
        this.read_ulong_array(uLongSeqHolder.value, n2, n3);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n2, int n3) {
        this.read_ulonglong_array(uLongLongSeqHolder.value, n2, n3);
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n2, int n3) {
        this.read_longlong_array(longLongSeqHolder.value, n2, n3);
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n2, int n3) {
        this.read_float_array(floatSeqHolder.value, n2, n3);
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n2, int n3) {
        this.read_double_array(doubleSeqHolder.value, n2, n3);
    }

    public BigDecimal read_fixed(short s2, short s3) {
        StringBuffer stringBuffer = this.read_fixed_buffer();
        if (s2 != stringBuffer.length()) {
            throw this.wrapper.badFixed(new Integer(s2), new Integer(stringBuffer.length()));
        }
        stringBuffer.insert(s2 - s3, '.');
        return new BigDecimal(stringBuffer.toString());
    }

    public BigDecimal read_fixed() {
        return new BigDecimal(this.read_fixed_buffer().toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl2 = false;
        boolean bl3 = true;
        while (bl3) {
            byte by = this.read_octet();
            int n2 = (by & 0xF0) >> 4;
            int n3 = by & 0xF;
            if (bl2 || n2 != 0) {
                stringBuffer.append(Character.forDigit(n2, 10));
                bl2 = true;
            }
            if (n3 == 12) {
                if (!bl2) {
                    return new StringBuffer("0.0");
                }
                bl3 = false;
                continue;
            }
            if (n3 == 13) {
                stringBuffer.insert(0, '-');
                bl3 = false;
                continue;
            }
            stringBuffer.append(Character.forDigit(n3, 10));
            bl2 = true;
        }
        return stringBuffer;
    }

    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    public void printBuffer() {
        CDRInputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("----- Input Buffer -----");
        System.out.println();
        System.out.println("Current position: " + byteBufferWithInfo.position());
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        try {
            char[] cArray = new char[16];
            for (int i2 = 0; i2 < byteBufferWithInfo.buflen; i2 += 16) {
                int n2;
                int n3;
                for (n3 = 0; n3 < 16 && n3 + i2 < byteBufferWithInfo.buflen; ++n3) {
                    String string;
                    n2 = byteBufferWithInfo.byteBuffer.get(i2 + n3);
                    if (n2 < 0) {
                        n2 = 256 + n2;
                    }
                    if ((string = Integer.toHexString(n2)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n3 < 16) {
                    System.out.print("   ");
                    ++n3;
                }
                for (n2 = 0; n2 < 16 && n2 + i2 < byteBufferWithInfo.buflen; ++n2) {
                    cArray[n2] = ORBUtility.isPrintable((char)byteBufferWithInfo.byteBuffer.get(i2 + n2)) ? (int)byteBufferWithInfo.byteBuffer.get(i2 + n2) : 46;
                }
                System.out.println(new String(cArray, 0, n2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("------------------------");
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = null;
        if (this.bbwi != null) {
            byteBuffer = this.bbwi.byteBuffer;
        }
        return byteBuffer;
    }

    public int getBufferLength() {
        return this.bbwi.buflen;
    }

    public void setBufferLength(int n2) {
        this.bbwi.buflen = n2;
        this.bbwi.byteBuffer.limit(this.bbwi.buflen);
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bbwi.byteBuffer = byteBuffer;
    }

    public int getIndex() {
        return this.bbwi.position();
    }

    public void setIndex(int n2) {
        this.bbwi.position(n2);
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void orb(org.omg.CORBA.ORB oRB) {
        this.orb = (ORB)oRB;
    }

    public BufferManagerRead getBufferManager() {
        return this.bufferManagerRead;
    }

    private void skipToOffset(int n2) {
        int n3;
        int n4 = n2 - this.get_offset();
        for (int i2 = 0; i2 < n4; i2 += n3) {
            int n5;
            int n6 = this.bbwi.buflen - this.bbwi.position();
            if (n6 <= 0) {
                this.grow(1, 1);
                n6 = this.bbwi.buflen - this.bbwi.position();
            }
            n3 = (n5 = n4 - i2) < n6 ? n5 : n6;
            this.bbwi.position(this.bbwi.position() + n3);
        }
    }

    public java.lang.Object createStreamMemento() {
        return new StreamMemento();
    }

    public void restoreInternalState(java.lang.Object object) {
        StreamMemento streamMemento = (StreamMemento)object;
        this.blockLength = streamMemento.blockLength_;
        this.end_flag = streamMemento.end_flag_;
        this.chunkedValueNestingLevel = streamMemento.chunkedValueNestingLevel_;
        this.valueIndirection = streamMemento.valueIndirection_;
        this.stringIndirection = streamMemento.stringIndirection_;
        this.isChunked = streamMemento.isChunked_;
        this.valueHandler = streamMemento.valueHandler_;
        this.specialNoOptionalDataState = streamMemento.specialNoOptionalDataState_;
        this.bbwi = streamMemento.bbwi_;
    }

    public int getPosition() {
        return this.get_offset();
    }

    public void mark(int n2) {
        this.markAndResetHandler.mark(this);
    }

    public void reset() {
        this.markAndResetHandler.reset();
    }

    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    private Class getClassFromString(String string, String string2, Class clazz) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        try {
            try {
                return repositoryIdInterface.getClassFromType(clazz, string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    if (this.getCodeBase() == null) {
                        return null;
                    }
                    string2 = this.getCodeBase().implementation(string);
                    if (string2 == null) {
                        return null;
                    }
                    return repositoryIdInterface.getClassFromType(clazz, string2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.dprintThrowable(classNotFoundException2);
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, string, string2);
        }
    }

    private Class getClassFromString(String string, String string2) {
        RepositoryIdInterface repositoryIdInterface = this.repIdStrs.getFromString(string);
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                switch (i2) {
                    case 0: {
                        return repositoryIdInterface.getClassFromType();
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        string2 = this.getCodeBase().implementation(string);
                    }
                }
                if (string2 == null) continue;
                return repositoryIdInterface.getClassFromType(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw this.wrapper.malformedUrl(CompletionStatus.COMPLETED_MAYBE, malformedURLException, string, string2);
            }
        }
        this.dprint("getClassFromString failed with rep id " + string + " and codebase " + string2);
        return null;
    }

    char[] getConvertedChars(int n2, CodeSetConversion.BTCConverter bTCConverter) {
        if (this.bbwi.buflen - this.bbwi.position() >= n2) {
            byte[] byArray;
            if (this.bbwi.byteBuffer.hasArray()) {
                byArray = this.bbwi.byteBuffer.array();
            } else {
                byArray = new byte[this.bbwi.buflen];
                for (int i2 = 0; i2 < this.bbwi.buflen; ++i2) {
                    byArray[i2] = this.bbwi.byteBuffer.get(i2);
                }
            }
            char[] cArray = bTCConverter.getChars(byArray, this.bbwi.position(), n2);
            this.bbwi.position(this.bbwi.position() + n2);
            return cArray;
        }
        byte[] byArray = new byte[n2];
        this.read_octet_array(byArray, 0, byArray.length);
        return bTCConverter.getChars(byArray, 0, n2);
    }

    protected CodeSetConversion.BTCConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharBTCConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.BTCConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharBTCConverter();
        }
        return this.wcharConverter;
    }

    protected void dprintThrowable(Throwable throwable) {
        if (this.debug && throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void dprint(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    void alignOnBoundary(int n2) {
        int n3 = this.computeAlignment(this.bbwi.position(), n2);
        if (this.bbwi.position() + n3 <= this.bbwi.buflen) {
            this.bbwi.position(this.bbwi.position() + n3);
        }
    }

    public void resetCodeSetConverters() {
        this.charConverter = null;
        this.wcharConverter = null;
    }

    public void start_value() {
        int n2 = this.readValueTag();
        if (n2 == 0) {
            this.specialNoOptionalDataState = true;
            return;
        }
        if (n2 == -1) {
            throw this.wrapper.customWrapperIndirection(CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repIdUtil.isCodeBasePresent(n2)) {
            throw this.wrapper.customWrapperWithCodebase(CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.repIdUtil.getTypeInfo(n2) != 2) {
            throw this.wrapper.customWrapperNotSingleRepid(CompletionStatus.COMPLETED_MAYBE);
        }
        this.read_repositoryId();
        this.start_block();
        --this.end_flag;
        --this.chunkedValueNestingLevel;
    }

    public void end_value() {
        if (this.specialNoOptionalDataState) {
            this.specialNoOptionalDataState = false;
            return;
        }
        this.handleEndOfValue();
        this.readEndTag();
        this.start_block();
    }

    public void close() throws IOException {
        this.getBufferManager().close(this.bbwi);
        if (this.bbwi != null && this.getByteBuffer() != null) {
            java.lang.Object object;
            int n2 = System.identityHashCode(this.bbwi.byteBuffer);
            MessageMediator messageMediator = this.parent.getMessageMediator();
            if (messageMediator != null && (object = (CDROutputObject)messageMediator.getOutputObject()) != null) {
                ByteBuffer byteBuffer = ((CDROutputStream)object).getByteBuffer();
                int n3 = 0;
                if (byteBuffer != null && n2 == (n3 = System.identityHashCode(byteBuffer))) {
                    ((CDROutputStream)object).setByteBuffer(null);
                    ((CDROutputObject)object).setByteBufferWithInfo(null);
                }
            }
            object = this.orb.getByteBufferPool();
            if (this.debug) {
                int n4 = System.identityHashCode(this.bbwi.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append(".close - releasing ByteBuffer id (");
                stringBuffer.append(n4).append(") to ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            object.releaseByteBuffer(this.bbwi.byteBuffer);
            this.bbwi.byteBuffer = null;
            this.bbwi = null;
        }
    }

    protected class StreamMemento {
        private int blockLength_;
        private int end_flag_;
        private int chunkedValueNestingLevel_;
        private int valueIndirection_;
        private int stringIndirection_;
        private boolean isChunked_;
        private ValueHandler valueHandler_;
        private ByteBufferWithInfo bbwi_;
        private boolean specialNoOptionalDataState_;

        public StreamMemento() {
            this.blockLength_ = CDRInputStream_1_0.this.blockLength;
            this.end_flag_ = CDRInputStream_1_0.this.end_flag;
            this.chunkedValueNestingLevel_ = CDRInputStream_1_0.this.chunkedValueNestingLevel;
            this.valueIndirection_ = CDRInputStream_1_0.this.valueIndirection;
            this.stringIndirection_ = CDRInputStream_1_0.this.stringIndirection;
            this.isChunked_ = CDRInputStream_1_0.this.isChunked;
            this.valueHandler_ = CDRInputStream_1_0.this.valueHandler;
            this.specialNoOptionalDataState_ = CDRInputStream_1_0.this.specialNoOptionalDataState;
            this.bbwi_ = new ByteBufferWithInfo(CDRInputStream_1_0.this.bbwi);
        }
    }
}

