/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.BufferManagerFactory;
import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDROutputStream_1_0;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.encoding.CorbaOutputObject;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import java.io.IOException;
import org.omg.CORBA.portable.InputStream;

public class CDROutputObject
extends CorbaOutputObject {
    private Message header;
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private OMGSystemException omgWrapper;
    private CorbaConnection connection;

    private CDROutputObject(ORB oRB, GIOPVersion gIOPVersion, Message message, BufferManagerWrite bufferManagerWrite, byte by, CorbaMessageMediator corbaMessageMediator) {
        super(oRB, gIOPVersion, false, bufferManagerWrite, by, corbaMessageMediator != null && corbaMessageMediator.getConnection() != null ? ((CorbaConnection)corbaMessageMediator.getConnection()).shouldUseDirectByteBuffers() : false);
        this.header = message;
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.encoding");
        this.omgWrapper = OMGSystemException.get(oRB, "rpc.encoding");
        this.getBufferManager().setOutputObject(this);
        this.corbaMessageMediator = corbaMessageMediator;
    }

    public CDROutputObject(ORB oRB, MessageMediator messageMediator, Message message, byte by) {
        this(oRB, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), message, BufferManagerFactory.newBufferManagerWrite(((CorbaMessageMediator)messageMediator).getGIOPVersion(), oRB), by, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB oRB, MessageMediator messageMediator, Message message, byte by, int n2) {
        this(oRB, ((CorbaMessageMediator)messageMediator).getGIOPVersion(), message, BufferManagerFactory.newBufferManagerWrite(n2, oRB), by, (CorbaMessageMediator)messageMediator);
    }

    public CDROutputObject(ORB oRB, CorbaMessageMediator corbaMessageMediator, GIOPVersion gIOPVersion, CorbaConnection corbaConnection, Message message, byte by) {
        this(oRB, gIOPVersion, message, BufferManagerFactory.newBufferManagerWrite(gIOPVersion, oRB), by, corbaMessageMediator);
        this.connection = corbaConnection;
    }

    public Message getMessageHeader() {
        return this.header;
    }

    public final void finishSendingMessage() {
        this.getBufferManager().sendMessage();
    }

    public void writeTo(CorbaConnection corbaConnection) throws IOException {
        ByteBufferWithInfo byteBufferWithInfo = this.getByteBufferWithInfo();
        this.getMessageHeader().setSize(byteBufferWithInfo.byteBuffer, byteBufferWithInfo.getSize());
        if (this.orb() != null) {
            if (((ORB)this.orb()).transportDebugFlag) {
                this.dprint(".writeTo: " + corbaConnection);
            }
            if (((ORB)this.orb()).giopDebugFlag) {
                CDROutputStream_1_0.printBuffer(byteBufferWithInfo);
            }
        }
        byteBufferWithInfo.byteBuffer.position(0).limit(byteBufferWithInfo.getSize());
        corbaConnection.write(byteBufferWithInfo.byteBuffer);
    }

    public InputStream create_input_stream() {
        return null;
    }

    public CorbaConnection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        return (CorbaConnection)this.corbaMessageMediator.getConnection();
    }

    public final ByteBufferWithInfo getByteBufferWithInfo() {
        return super.getByteBufferWithInfo();
    }

    public final void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        super.setByteBufferWithInfo(byteBufferWithInfo);
    }

    protected CodeSetConversion.CTBConverter createCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            return super.createCharCTBConverter();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), false);
    }

    protected CodeSetConversion.CTBConverter createWCharCTBConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            if (this.getConnection().isServer()) {
                throw this.omgWrapper.noClientWcharCodesetCtx();
            }
            throw this.omgWrapper.noServerWcharCodesetCmp();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet());
        if (entry == null) {
            throw this.wrapper.unknownCodeset(entry);
        }
        boolean bl2 = ((ORB)this.orb()).getORBData().useByteOrderMarkers();
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
                return CodeSetConversion.impl().getCTBConverter(entry, false, bl2);
            }
            if (this.getGIOPVersion().equals(GIOPVersion.V1_1)) {
                return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), false);
            }
        }
        return CodeSetConversion.impl().getCTBConverter(entry, this.isLittleEndian(), bl2);
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.getConnection() == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.getConnection().getCodeSetContext();
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CDROutputObject", string);
    }
}

