/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.CDROutputStreamBase;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.CacheTable;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.se.impl.orbutil.RepositoryIdUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    protected boolean littleEndian;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBufferWithInfo bbwi;
    protected ORB orb;
    protected ORBUtilSystemException wrapper;
    protected boolean debug = false;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    protected byte streamFormatVersion;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};

    public void init(org.omg.CORBA.ORB oRB, boolean bl2, BufferManagerWrite bufferManagerWrite, byte by, boolean bl3) {
        this.orb = (ORB)oRB;
        this.wrapper = ORBUtilSystemException.get(this.orb, "rpc.encoding");
        this.debug = this.orb.transportDebugFlag;
        this.littleEndian = bl2;
        this.bufferManagerWrite = bufferManagerWrite;
        this.bbwi = new ByteBufferWithInfo(oRB, bufferManagerWrite, bl3);
        this.streamFormatVersion = by;
        this.createRepositoryIdHandlers();
    }

    public void init(org.omg.CORBA.ORB oRB, boolean bl2, BufferManagerWrite bufferManagerWrite, byte by) {
        this.init(oRB, bl2, bufferManagerWrite, by, true);
    }

    private final void createRepositoryIdHandlers() {
        if (this.orb != null) {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
        } else {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
        }
    }

    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.bbwi.position()];
        for (int i2 = 0; i2 < this.bbwi.position(); ++i2) {
            byArray[i2] = this.bbwi.byteBuffer.get(i2);
        }
        return byArray;
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    void setHeaderPadding(boolean bl2) {
        throw this.wrapper.giopVersionError();
    }

    protected void handleSpecialChunkBegin(int n2) {
    }

    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment(int n2) {
        int n3;
        if (n2 > 1 && (n3 = this.bbwi.position() & n2 - 1) != 0) {
            return n2 - n3;
        }
        return 0;
    }

    protected void alignAndReserve(int n2, int n3) {
        this.bbwi.position(this.bbwi.position() + this.computeAlignment(n2));
        if (this.bbwi.position() + n3 > this.bbwi.buflen) {
            this.grow(n2, n3);
        }
    }

    protected void grow(int n2, int n3) {
        this.bbwi.needed = n3;
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    public final void write_longdouble(double d2) {
        throw this.wrapper.longDoubleNotImplemented(CompletionStatus.COMPLETED_MAYBE);
    }

    public void write_octet(byte by) {
        this.alignAndReserve(1, 1);
        this.bbwi.byteBuffer.put(this.bbwi.position(), by);
        this.bbwi.position(this.bbwi.position() + 1);
    }

    public final void write_boolean(boolean bl2) {
        this.write_octet(bl2 ? (byte)1 : 0);
    }

    public void write_char(char c2) {
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(c2);
        if (cTBConverter.getNumBytes() > 1) {
            throw this.wrapper.invalidSingleCharCtb(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_octet(cTBConverter.getBytes()[0]);
    }

    private final void writeLittleEndianWchar(char c2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(c2 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(c2 >>> 8 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeBigEndianWchar(char c2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(c2 >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(c2 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeLittleEndianShort(short s2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(s2 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(s2 >>> 8 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeBigEndianShort(short s2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(s2 >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(s2 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeLittleEndianLong(int n2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(n2 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(n2 >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(n2 >>> 16 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(n2 >>> 24 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 4);
    }

    private final void writeBigEndianLong(int n2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(n2 >>> 24 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(n2 >>> 16 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(n2 >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(n2 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 4);
    }

    private final void writeLittleEndianLongLong(long l2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(l2 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(l2 >>> 8 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(l2 >>> 16 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(l2 >>> 24 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 4, (byte)(l2 >>> 32 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 5, (byte)(l2 >>> 40 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 6, (byte)(l2 >>> 48 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 7, (byte)(l2 >>> 56 & 0xFFL));
        this.bbwi.position(this.bbwi.position() + 8);
    }

    private final void writeBigEndianLongLong(long l2) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(l2 >>> 56 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(l2 >>> 48 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(l2 >>> 40 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(l2 >>> 32 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 4, (byte)(l2 >>> 24 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 5, (byte)(l2 >>> 16 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 6, (byte)(l2 >>> 8 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 7, (byte)(l2 & 0xFFL));
        this.bbwi.position(this.bbwi.position() + 8);
    }

    public void write_wchar(char c2) {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(c2);
        } else {
            this.writeBigEndianWchar(c2);
        }
    }

    public void write_short(short s2) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s2);
        } else {
            this.writeBigEndianShort(s2);
        }
    }

    public final void write_ushort(short s2) {
        this.write_short(s2);
    }

    public void write_long(int n2) {
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n2);
        } else {
            this.writeBigEndianLong(n2);
        }
    }

    public final void write_ulong(int n2) {
        this.write_long(n2);
    }

    public void write_longlong(long l2) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l2);
        } else {
            this.writeBigEndianLongLong(l2);
        }
    }

    public final void write_ulonglong(long l2) {
        this.write_longlong(l2);
    }

    public final void write_float(float f2) {
        this.write_long(Float.floatToIntBits(f2));
    }

    public final void write_double(double d2) {
        this.write_longlong(Double.doubleToLongBits(d2));
    }

    public void write_string(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(string);
        int n2 = cTBConverter.getNumBytes() + 1;
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + n2);
        this.write_long(n2);
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.write_octet((byte)0);
        this.handleSpecialChunkEnd();
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        int n2 = string.length() + 1;
        this.handleSpecialChunkBegin(4 + n2 * 2 + this.computeAlignment(4));
        this.write_long(n2);
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            this.write_wchar(string.charAt(i2));
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] byArray, int n2, int n3) {
        int n4;
        boolean bl2 = true;
        for (int i2 = n2; i2 < n3 + n2; i2 += n4) {
            int n5;
            int n6;
            if (this.bbwi.position() + 1 > this.bbwi.buflen || bl2) {
                bl2 = false;
                this.alignAndReserve(1, 1);
            }
            n4 = (n6 = n3 + n2 - i2) < (n5 = this.bbwi.buflen - this.bbwi.position()) ? n6 : n5;
            for (int i3 = 0; i3 < n4; ++i3) {
                this.bbwi.byteBuffer.put(this.bbwi.position() + i3, byArray[i2 + i3]);
            }
            this.bbwi.position(this.bbwi.position() + n4);
        }
    }

    public final void write_octet_array(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        this.internalWriteOctetArray(byArray, n2, n3);
        this.handleSpecialChunkEnd();
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this.parent);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR iOR = IORFactories.makeIOR(this.orb);
            iOR.write(this.parent);
            return;
        }
        if (object instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR iOR = ORBUtility.connectAndGetIOR(this.orb, object);
        iOR.write(this.parent);
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl2 = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl2 = true;
        }
        this.write_boolean(bl2);
        if (bl2) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    private void writeWStringValue(String string) {
        int n2 = this.writeValueTag(this.mustChunk, false, null);
        this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
        this.updateIndirectionTable(n2, string, string);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        this.write_wstring(string);
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeArray(Serializable serializable, Class clazz) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler(this.orb);
        }
        int n2 = this.writeValueTag(this.mustChunk, false, Util.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
        this.updateIndirectionTable(n2, serializable, serializable);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        if (this.valueHandler instanceof ValueHandlerMultiFormat) {
            ValueHandlerMultiFormat valueHandlerMultiFormat = (ValueHandlerMultiFormat)this.valueHandler;
            valueHandlerMultiFormat.writeValue(this.parent, serializable, this.streamFormatVersion);
        } else {
            this.valueHandler.writeValue(this.parent, serializable);
        }
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeValueBase(ValueBase valueBase, Class clazz) {
        this.mustChunk = true;
        int n2 = this.writeValueTag(true, false, Util.getCodebase(clazz));
        String string = valueBase._truncatable_ids()[0];
        this.write_repositoryId(string);
        this.updateIndirectionTable(n2, valueBase, valueBase);
        this.start_block();
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.writeIDLValue(valueBase, string);
        this.end_block();
        this.writeEndTag(true);
    }

    private void writeRMIIIOPValueType(Serializable serializable, Class clazz) {
        Serializable serializable2;
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler(this.orb);
        }
        if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
            this.write_long(0);
            return;
        }
        if (serializable != serializable2) {
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                this.writeIndirection(-1, this.valueCache.getVal(serializable));
                return;
            }
            clazz = serializable.getClass();
        }
        if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
            this.mustChunk = true;
        }
        int n2 = this.writeValueTag(this.mustChunk, false, Util.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
        this.updateIndirectionTable(n2, serializable, serializable2);
        if (this.mustChunk) {
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.start_block();
        } else {
            --this.end_flag;
        }
        if (this.valueHandler instanceof ValueHandlerMultiFormat) {
            ValueHandlerMultiFormat valueHandlerMultiFormat = (ValueHandlerMultiFormat)this.valueHandler;
            valueHandlerMultiFormat.writeValue(this.parent, serializable, this.streamFormatVersion);
        } else {
            this.valueHandler.writeValue(this.parent, serializable);
        }
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<? extends java.lang.Object> clazz = serializable.getClass();
        boolean bl2 = this.mustChunk;
        if (this.mustChunk) {
            this.mustChunk = true;
        }
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            this.writeArray(serializable, clazz);
        } else if (serializable instanceof ValueBase) {
            this.writeValueBase((ValueBase)serializable, clazz);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            this.writeWStringValue((String)((java.lang.Object)serializable));
        } else if (serializable instanceof Class) {
            this.writeClass(string, (Class)serializable);
        } else {
            this.writeRMIIIOPValueType(serializable, clazz);
        }
        this.mustChunk = bl2;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        int n2;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        boolean bl2 = this.mustChunk;
        boolean bl3 = false;
        if (boxedValueHelper instanceof ValueHelper) {
            try {
                n2 = ((ValueHelper)boxedValueHelper).get_type().type_modifier();
            }
            catch (BadKind badKind) {
                n2 = 0;
            }
            if (serializable instanceof CustomMarshal && n2 == 1) {
                bl3 = true;
                this.mustChunk = true;
            }
            if (n2 == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            n2 = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n2, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            if (bl3) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            n2 = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n2, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value(this.parent, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl2;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.bbwi.position();
    }

    public void start_block() {
        if (this.debug) {
            this.dprint("CDROutputStream_1_0 start_block, position" + this.bbwi.position());
        }
        this.write_long(0);
        this.inBlock = true;
        this.blockSizePosition = this.get_offset();
        this.blockSizeIndex = this.bbwi.position();
        if (this.debug) {
            this.dprint("CDROutputStream_1_0 start_block, blockSizeIndex " + this.blockSizeIndex);
        }
    }

    protected void writeLongWithoutAlign(int n2) {
        if (this.littleEndian) {
            this.writeLittleEndianLong(n2);
        } else {
            this.writeBigEndianLong(n2);
        }
    }

    public void end_block() {
        if (this.debug) {
            this.dprint("CDROutputStream_1_0.java end_block");
        }
        if (!this.inBlock) {
            return;
        }
        if (this.debug) {
            this.dprint("CDROutputStream_1_0.java end_block, in a block");
        }
        this.inBlock = false;
        if (this.get_offset() == this.blockSizePosition) {
            this.bbwi.position(this.bbwi.position() - 4);
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            return;
        }
        int n2 = this.bbwi.position();
        this.bbwi.position(this.blockSizeIndex - 4);
        this.writeLongWithoutAlign(n2 - this.blockSizeIndex);
        this.bbwi.position(n2);
        this.blockSizeIndex = -1;
        this.blockSizePosition = -1;
    }

    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    public final void write_boolean_array(boolean[] blArray, int n2, int n3) {
        if (blArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_boolean(blArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_char_array(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_char(cArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_wchar_array(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_wchar(cArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_short_array(short[] sArray, int n2, int n3) {
        if (sArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_short(sArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ushort_array(short[] sArray, int n2, int n3) {
        this.write_short_array(sArray, n2, n3);
    }

    public final void write_long_array(int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n3 * 4);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_long(nArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulong_array(int[] nArray, int n2, int n3) {
        this.write_long_array(nArray, n2, n3);
    }

    public final void write_longlong_array(long[] lArray, int n2, int n3) {
        if (lArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n3 * 8);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_longlong(lArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulonglong_array(long[] lArray, int n2, int n3) {
        this.write_longlong_array(lArray, n2, n3);
    }

    public final void write_float_array(float[] fArray, int n2, int n3) {
        if (fArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n3 * 4);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_float(fArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_double_array(double[] dArray, int n2, int n3) {
        if (dArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n3 * 8);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_double(dArray[n2 + i2]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_string_array(String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_string(stringArray[n2 + i2]);
        }
    }

    public void write_wstring_array(String[] stringArray, int n2, int n3) {
        if (stringArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_wstring(stringArray[n2 + i2]);
        }
    }

    public final void write_any_array(Any[] anyArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.write_any(anyArray[n2 + i2]);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        if (this.bbwi.byteBuffer.hasArray()) {
            byArray = this.bbwi.byteBuffer.array();
        } else {
            int n2 = this.bbwi.position();
            byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = this.bbwi.byteBuffer.get(i2);
            }
        }
        outputStream.write(byArray, 0, this.bbwi.position());
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        byte[] byArray = null;
        if (this.bbwi.byteBuffer.hasArray()) {
            byArray = this.bbwi.byteBuffer.array();
        } else {
            int n2 = this.bbwi.position();
            byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = this.bbwi.byteBuffer.get(i2);
            }
        }
        outputStream.write_long(this.bbwi.position());
        outputStream.write_octet_array(byArray, 0, this.bbwi.position());
    }

    public final int getSize() {
        return this.bbwi.position();
    }

    public int getIndex() {
        return this.bbwi.position();
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setIndex(int n2) {
        this.bbwi.position(n2);
    }

    public ByteBufferWithInfo getByteBufferWithInfo() {
        return this.bbwi;
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = null;
        if (this.bbwi != null) {
            byteBuffer = this.bbwi.byteBuffer;
        }
        return byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bbwi.byteBuffer = byteBuffer;
    }

    private final void updateIndirectionTable(int n2, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, true);
        }
        this.valueCache.put(object, n2);
        if (object2 != object) {
            this.valueCache.put(object2, n2);
        }
    }

    private final void write_repositoryId(String string) {
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.writeIndirection(-1, this.repositoryIdCache.getVal(string));
            return;
        }
        this.write_string(string);
    }

    private void write_codebase(String string, int n2) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.writeIndirection(-1, this.codebaseCache.getVal(string));
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(this.orb, true);
            }
            this.codebaseCache.put(string, n2);
        }
    }

    private final int writeValueTag(boolean bl2, boolean bl3, String string) {
        int n2 = 0;
        if (bl2 && bl3) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                n2 = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                n2 = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl2 && !bl3) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                n2 = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                n2 = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
            n2 = this.get_offset() - 4;
        } else {
            this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
            n2 = this.get_offset() - 4;
            this.write_codebase(string, this.get_offset());
        }
        return n2;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this.parent);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl2 = false;
            if (boxedValueHelper instanceof ValueHelper && serializable instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)boxedValueHelper).get_type().type_modifier() == 1) {
                        bl2 = true;
                    }
                }
                catch (BadKind badKind) {
                    throw this.wrapper.badTypecodeForCustomValue(CompletionStatus.COMPLETED_MAYBE, badKind);
                }
            }
            if (bl2) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl2) {
        if (bl2) {
            if (this.get_offset() == this.end_flag_position && this.bbwi.position() == this.end_flag_index) {
                this.bbwi.position(this.bbwi.position() - 4);
            }
            this.writeNestingLevel();
            this.end_flag_index = this.bbwi.position();
            this.end_flag_position = this.get_offset();
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    private void writeClass(String string, Class clazz) {
        if (string == null) {
            string = this.repIdStrs.getClassDescValueRepId();
        }
        int n2 = this.writeValueTag(this.mustChunk, false, null);
        this.updateIndirectionTable(n2, clazz, clazz);
        this.write_repositoryId(string);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        this.writeClassBody(clazz);
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeClassBody(Class clazz) {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = this.repIdStrs.createForJavaType(iDLEntity);
        Class<? extends java.lang.Object> clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n2 = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n2, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz2.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, invocationTargetException);
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public void write_fixed(BigDecimal bigDecimal, short s2, short s3) {
        String string;
        String string2;
        int n2;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n2 = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n2 == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s2);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s3) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int n2) {
        char c2;
        int n3;
        int n4 = string.length();
        byte by = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            c2 = string.charAt(n3);
            if (c2 == '-' || c2 == '+' || c2 == '.') continue;
            ++n5;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            c2 = string.charAt(n3);
            if (c2 == '-' || c2 == '+' || c2 == '.') continue;
            byte by2 = (byte)Character.digit(c2, 10);
            if (by2 == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (n5 % 2 == 0) {
                by = (byte)(by | by2);
                this.write_octet(by);
                by = 0;
            } else {
                by = (byte)(by | by2 << 4);
            }
            --n5;
        }
        by = n2 == -1 ? (byte)((byte)(by | 0xD)) : (byte)((byte)(by | 0xC));
        this.write_octet(by);
    }

    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    public void printBuffer() {
        CDROutputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("+++++++ Output Buffer ++++++++");
        System.out.println();
        System.out.println("Current position: " + byteBufferWithInfo.position());
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        char[] cArray = new char[16];
        try {
            for (int i2 = 0; i2 < byteBufferWithInfo.position(); i2 += 16) {
                int n2;
                int n3;
                for (n3 = 0; n3 < 16 && n3 + i2 < byteBufferWithInfo.position(); ++n3) {
                    String string;
                    n2 = byteBufferWithInfo.byteBuffer.get(i2 + n3);
                    if (n2 < 0) {
                        n2 = 256 + n2;
                    }
                    if ((string = Integer.toHexString(n2)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n3 < 16) {
                    System.out.print("   ");
                    ++n3;
                }
                for (n2 = 0; n2 < 16 && n2 + i2 < byteBufferWithInfo.position(); ++n2) {
                    cArray[n2] = ORBUtility.isPrintable((char)byteBufferWithInfo.byteBuffer.get(i2 + n2)) ? (int)byteBufferWithInfo.byteBuffer.get(i2 + n2) : 46;
                }
                System.out.println(new String(cArray, 0, n2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    public void writeIndirection(int n2, int n3) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(n2);
        this.write_long(n3 - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    protected void dprint(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    void alignOnBoundary(int n2) {
        this.alignAndReserve(n2, 0);
    }

    public void start_value(String string) {
        if (this.debug) {
            this.dprint("start_value w/ rep id " + string + " called at pos " + this.get_offset() + " position " + this.bbwi.position());
        }
        if (this.inBlock) {
            this.end_block();
        }
        this.writeValueTag(true, false, null);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
    }

    public void end_value() {
        if (this.debug) {
            this.dprint("end_value called at pos " + this.get_offset() + " position " + this.bbwi.position());
        }
        this.end_block();
        this.writeEndTag(true);
        if (this.debug) {
            this.dprint("mustChunk is " + this.mustChunk);
        }
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void close() throws IOException {
        this.getBufferManager().close();
        if (this.getByteBufferWithInfo() != null && this.getByteBuffer() != null) {
            java.lang.Object object;
            int n2 = System.identityHashCode(this.bbwi.byteBuffer);
            MessageMediator messageMediator = this.parent.getMessageMediator();
            if (messageMediator != null && (object = (CDRInputObject)messageMediator.getInputObject()) != null) {
                ByteBuffer byteBuffer = ((CDRInputStream)object).getByteBuffer();
                int n3 = 0;
                if (byteBuffer != null && n2 == (n3 = System.identityHashCode(byteBuffer))) {
                    ((CDRInputStream)object).setByteBuffer(null);
                    ((CDRInputStream)object).setByteBufferWithInfo(null);
                }
            }
            object = this.orb.getByteBufferPool();
            if (this.debug) {
                int n4 = System.identityHashCode(this.bbwi.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append(".close - releasing ByteBuffer id (");
                stringBuffer.append(n4).append(") to ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            object.releaseByteBuffer(this.getByteBuffer());
            this.bbwi.byteBuffer = null;
            this.bbwi = null;
        }
    }
}

