/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.javax.rmi;

import com.sun.corba.se.impl.util.RepositoryId;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.spi.presentation.rmi.StubAdapter;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class PortableRemoteObject
implements PortableRemoteObjectDelegate {
    public void exportObject(Remote remote) throws RemoteException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (Util.getTie(remote) != null) {
            throw new ExportException(remote.getClass().getName() + " already exported");
        }
        Tie tie = Utility.loadTie(remote);
        if (tie != null) {
            Util.registerTarget(tie, remote);
        } else {
            UnicastRemoteObject.exportObject(remote);
        }
    }

    public Remote toStub(Remote remote) throws NoSuchObjectException {
        Remote remote2 = null;
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (remote instanceof Stub) {
            return remote;
        }
        if (remote instanceof RemoteStub) {
            return remote;
        }
        Tie tie = Util.getTie(remote);
        if (tie != null) {
            remote2 = Utility.loadStub(tie, null, null, true);
        } else if (Utility.loadTie(remote) == null) {
            remote2 = RemoteObject.toStub(remote);
        }
        if (remote2 == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return remote2;
    }

    public void unexportObject(Remote remote) throws NoSuchObjectException {
        if (remote == null) {
            throw new NullPointerException("invalid argument");
        }
        if (remote instanceof Stub || remote instanceof RemoteStub) {
            throw new NoSuchObjectException("Can only unexport a server object.");
        }
        Tie tie = Util.getTie(remote);
        if (tie != null) {
            Util.unexportObject(remote);
        } else if (Utility.loadTie(remote) == null) {
            UnicastRemoteObject.unexportObject(remote, true);
        } else {
            throw new NoSuchObjectException("Object not exported.");
        }
    }

    public java.lang.Object narrow(java.lang.Object object, Class clazz) {
        java.lang.Object object2 = null;
        if (object == null) {
            return null;
        }
        if (clazz == null) {
            throw new NullPointerException("invalid argument");
        }
        Class<? extends java.lang.Object> clazz2 = object.getClass();
        try {
            String string;
            Object object3;
            if (clazz.isAssignableFrom(clazz2)) {
                object2 = object;
            } else if (clazz.isInterface() && clazz != Serializable.class && clazz != Externalizable.class && (object3 = (Object)object)._is_a(string = RepositoryId.createForAnyType(clazz))) {
                object2 = Utility.loadStub(object3, clazz);
            }
        }
        catch (Exception exception) {
            ClassCastException classCastException = new ClassCastException();
            classCastException.initCause(exception);
            throw classCastException;
        }
        if (object2 == null) {
            throw new ClassCastException();
        }
        return object2;
    }

    public void connect(Remote remote, Remote remote2) throws RemoteException {
        boolean bl2;
        if (remote == null || remote2 == null) {
            throw new NullPointerException("invalid argument");
        }
        ORB oRB = null;
        try {
            if (StubAdapter.isStub(remote2)) {
                oRB = StubAdapter.getORB(remote2);
            } else {
                Tie tie = Util.getTie(remote2);
                if (tie == null) {
                    if (Utility.loadTie(remote2) != null) {
                        throw new RemoteException("'source' object not exported");
                    }
                } else {
                    oRB = tie.orb();
                }
            }
        }
        catch (SystemException systemException) {
            throw new RemoteException("'source' object not connected");
        }
        Tie tie = null;
        if (remote instanceof RemoteStub) {
            bl2 = false;
        } else if (remote instanceof Stub) {
            bl2 = true;
        } else {
            tie = Util.getTie(remote);
            if (tie != null) {
                bl2 = true;
            } else {
                if (Utility.loadTie(remote) != null) {
                    throw new RemoteException("'target' servant not exported");
                }
                bl2 = false;
            }
        }
        if (!bl2) {
            if (oRB != null) {
                throw new RemoteException("'source' object exported to IIOP, 'target' is JRMP");
            }
        } else {
            if (oRB == null) {
                throw new RemoteException("'source' object is JRMP, 'target' is IIOP");
            }
            try {
                if (tie != null) {
                    try {
                        ORB oRB2 = tie.orb();
                        if (oRB2 == oRB) {
                            return;
                        }
                        throw new RemoteException("'target' object was already connected");
                    }
                    catch (SystemException systemException) {
                        tie.orb(oRB);
                    }
                } else {
                    ((Stub)((java.lang.Object)remote)).connect(oRB);
                }
            }
            catch (SystemException systemException) {
                throw new RemoteException("'target' object was already connected");
            }
        }
    }
}

