/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orb;

import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.legacy.connection.USLPort;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.oa.poa.BadServerIdHandler;
import com.sun.corba.se.impl.orbutil.ORBClassLoader;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.legacy.connection.EndPointInfo;
import com.sun.corba.se.spi.legacy.connection.ORBSocketFactory;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.Operation;
import com.sun.corba.se.spi.orb.OperationFactory;
import com.sun.corba.se.spi.orb.ParserData;
import com.sun.corba.se.spi.orb.ParserDataFactory;
import com.sun.corba.se.spi.orb.StringPair;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import com.sun.corba.se.spi.transport.CorbaContactInfoListFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class ParserTable {
    private static String MY_CLASS_NAME = ParserTable.class.getName();
    private static ParserTable myInstance = new ParserTable();
    private ORBUtilSystemException wrapper = ORBUtilSystemException.get("orb.lifecycle");
    private ParserData[] parserData;

    public static ParserTable get() {
        return myInstance;
    }

    public ParserData[] getParserData() {
        return this.parserData;
    }

    private ParserTable() {
        String string = "65537,65801,65568";
        String[] stringArray = new String[]{"subcontract", "poa", "transport"};
        USLPort[] uSLPortArray = new USLPort[]{new USLPort("FOO", 2701), new USLPort("BAR", 3333)};
        ORBInitializer[] oRBInitializerArray = new ORBInitializer[]{null, new TestORBInitializer1(), new TestORBInitializer2()};
        StringPair[] stringPairArray = new StringPair[]{new StringPair("foo.bar.blech.NonExistent", "dummy"), new StringPair(MY_CLASS_NAME + "$TestORBInitializer1", "dummy"), new StringPair(MY_CLASS_NAME + "$TestORBInitializer2", "dummy")};
        Acceptor[] acceptorArray = new Acceptor[]{new TestAcceptor2(), new TestAcceptor1(), null};
        StringPair[] stringPairArray2 = new StringPair[]{new StringPair("foo.bar.blech.NonExistent", "dummy"), new StringPair(MY_CLASS_NAME + "$TestAcceptor1", "dummy"), new StringPair(MY_CLASS_NAME + "$TestAcceptor2", "dummy")};
        StringPair[] stringPairArray3 = new StringPair[]{new StringPair("Foo", "ior:930492049394"), new StringPair("Bar", "ior:3453465785633576")};
        URL uRL = null;
        String string2 = "corbaloc::camelot/NameService";
        try {
            uRL = new URL(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ParserData[] parserDataArray = new ParserData[]{ParserDataFactory.make("com.sun.CORBA.ORBDebug", OperationFactory.listAction(",", OperationFactory.stringAction()), "debugFlags", new String[0], stringArray, "subcontract,poa,transport"), ParserDataFactory.make("org.omg.CORBA.ORBInitialHost", OperationFactory.stringAction(), "ORBInitialHost", "", "Foo", "Foo"), ParserDataFactory.make("org.omg.CORBA.ORBInitialPort", OperationFactory.integerAction(), "ORBInitialPort", new Integer(900), new Integer(27314), "27314"), ParserDataFactory.make("com.sun.CORBA.ORBServerHost", OperationFactory.stringAction(), "ORBServerHost", "", "camelot", "camelot"), ParserDataFactory.make("com.sun.CORBA.ORBServerPort", OperationFactory.integerAction(), "ORBServerPort", new Integer(0), new Integer(38143), "38143"), ParserDataFactory.make("com.sun.CORBA.INTERNAL USE ONLY: listen on all interfaces", OperationFactory.stringAction(), "listenOnAllInterfaces", "com.sun.CORBA.INTERNAL USE ONLY: listen on all interfaces", "foo", "foo"), ParserDataFactory.make("org.omg.CORBA.ORBId", OperationFactory.stringAction(), "orbId", "", "foo", "foo"), ParserDataFactory.make("com.sun.CORBA.ORBid", OperationFactory.stringAction(), "orbId", "", "foo", "foo"), ParserDataFactory.make("org.omg.CORBA.ORBServerId", OperationFactory.integerAction(), "persistentServerId", new Integer(-1), new Integer(1234), "1234"), ParserDataFactory.make("org.omg.CORBA.ORBServerId", OperationFactory.setFlagAction(), "persistentServerIdInitialized", Boolean.FALSE, Boolean.TRUE, "1234"), ParserDataFactory.make("org.omg.CORBA.ORBServerId", OperationFactory.setFlagAction(), "orbServerIdPropertySpecified", Boolean.FALSE, Boolean.TRUE, "1234"), ParserDataFactory.make("com.sun.CORBA.connection.ORBHighWaterMark", OperationFactory.integerAction(), "highWaterMark", new Integer(240), new Integer(3745), "3745"), ParserDataFactory.make("com.sun.CORBA.connection.ORBLowWaterMark", OperationFactory.integerAction(), "lowWaterMark", new Integer(100), new Integer(12), "12"), ParserDataFactory.make("com.sun.CORBA.connection.ORBNumberToReclaim", OperationFactory.integerAction(), "numberToReclaim", new Integer(5), new Integer(231), "231"), ParserDataFactory.make("com.sun.CORBA.giop.ORBGIOPVersion", this.makeGVOperation(), "giopVersion", GIOPVersion.DEFAULT_VERSION, new GIOPVersion(2, 3), "2.3"), ParserDataFactory.make("com.sun.CORBA.giop.ORBFragmentSize", this.makeFSOperation(), "giopFragmentSize", new Integer(1024), new Integer(65536), "65536"), ParserDataFactory.make("com.sun.CORBA.giop.ORBBufferSize", OperationFactory.integerAction(), "giopBufferSize", new Integer(1024), new Integer(234000), "234000"), ParserDataFactory.make("com.sun.CORBA.giop.ORBGIOP11BuffMgr", this.makeBMGROperation(), "giop11BuffMgr", new Integer(0), new Integer(1), "CLCT"), ParserDataFactory.make("com.sun.CORBA.giop.ORBGIOP12BuffMgr", this.makeBMGROperation(), "giop12BuffMgr", new Integer(2), new Integer(0), "GROW"), ParserDataFactory.make("com.sun.CORBA.giop.ORBTargetAddressing", OperationFactory.compose(OperationFactory.integerRangeAction(0, 3), OperationFactory.convertIntegerToShort()), "giopTargetAddressPreference", new Short(3), new Short(2), "2"), ParserDataFactory.make("com.sun.CORBA.giop.ORBTargetAddressing", this.makeADOperation(), "giopAddressDisposition", new Short(0), new Short(2), "2"), ParserDataFactory.make("com.sun.CORBA.codeset.AlwaysSendCodeSetCtx", OperationFactory.booleanAction(), "alwaysSendCodeSetCtx", Boolean.TRUE, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.CORBA.codeset.UseByteOrderMarkers", OperationFactory.booleanAction(), "useByteOrderMarkers", true, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.CORBA.codeset.UseByteOrderMarkersInEncaps", OperationFactory.booleanAction(), "useByteOrderMarkersInEncaps", false, Boolean.FALSE, "false"), ParserDataFactory.make("com.sun.CORBA.codeset.charsets", this.makeCSOperation(), "charData", CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.getCharComponent(), CodeSetComponentInfo.createFromString(string), string), ParserDataFactory.make("com.sun.CORBA.codeset.wcharsets", this.makeCSOperation(), "wcharData", CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.getWCharComponent(), CodeSetComponentInfo.createFromString(string), string), ParserDataFactory.make("com.sun.CORBA.ORBAllowLocalOptimization", OperationFactory.booleanAction(), "allowLocalOptimization", Boolean.FALSE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.CORBA.connection.ORBSocketFactoryClass", this.makeSFOperation(), "socketFactory", null, new TestORBSocketFactory(), MY_CLASS_NAME + "$TestORBSocketFactory"), ParserDataFactory.make("com.sun.CORBA.connection.ORBListenSocket", this.makeUSLOperation(), "userSpecifiedListenPorts", new USLPort[0], uSLPortArray, "FOO:2701,BAR:3333"), ParserDataFactory.make("com.sun.CORBA.transport.ORBContactInfoList", this.makeContactInfoListFactoryOperation(), "corbaContactInfoListFactory", null, new TestContactInfoListFactory(), MY_CLASS_NAME + "$TestContactInfoListFactory"), ParserDataFactory.make("com.sun.CORBA.POA.ORBPersistentServerPort", OperationFactory.integerAction(), "persistentServerPort", new Integer(0), new Integer(2743), "2743"), ParserDataFactory.make("com.sun.CORBA.POA.ORBPersistentServerPort", OperationFactory.setFlagAction(), "persistentPortInitialized", Boolean.FALSE, Boolean.TRUE, "2743"), ParserDataFactory.make("com.sun.CORBA.POA.ORBServerId", OperationFactory.integerAction(), "persistentServerId", new Integer(0), new Integer(294), "294"), ParserDataFactory.make("com.sun.CORBA.POA.ORBServerId", OperationFactory.setFlagAction(), "persistentServerIdInitialized", Boolean.FALSE, Boolean.TRUE, "294"), ParserDataFactory.make("com.sun.CORBA.POA.ORBActivated", OperationFactory.booleanAction(), "serverIsORBActivated", Boolean.FALSE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.CORBA.POA.ORBBadServerIdHandlerClass", OperationFactory.classAction(), "badServerIdHandlerClass", null, TestBadServerIdHandler.class, MY_CLASS_NAME + "$TestBadServerIdHandler"), ParserDataFactory.make("org.omg.PortableInterceptor.ORBInitializerClass.", this.makeROIOperation(), "orbInitializers", new ORBInitializer[0], oRBInitializerArray, stringPairArray, ORBInitializer.class), ParserDataFactory.make("com.sun.CORBA.transport.ORBAcceptor", this.makeAcceptorInstantiationOperation(), "acceptors", new Acceptor[0], acceptorArray, stringPairArray2, Acceptor.class), ParserDataFactory.make("com.sun.CORBA.transport.ORBAcceptorSocketType", OperationFactory.stringAction(), "acceptorSocketType", "SocketChannel", "foo", "foo"), ParserDataFactory.make("com.sun.CORBA.transport.ORBUseNIOSelectToWait", OperationFactory.booleanAction(), "acceptorSocketUseSelectThreadToWait", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.CORBA.transport.ORBAcceptorSocketUseWorkerThreadForEvent", OperationFactory.booleanAction(), "acceptorSocketUseWorkerThreadForEvent", Boolean.FALSE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.CORBA.transport.ORBConnectionSocketType", OperationFactory.stringAction(), "connectionSocketType", "SocketChannel", "foo", "foo"), ParserDataFactory.make("com.sun.CORBA.transport.ORBUseNIOSelectToWait", OperationFactory.booleanAction(), "connectionSocketUseSelectThreadToWait", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("com.sun.CORBA.transport.ORBConnectionSocketUseWorkerThreadForEvent", OperationFactory.booleanAction(), "connectionSocketUseWorkerThreadForEvent", Boolean.TRUE, Boolean.TRUE, "true"), ParserDataFactory.make("org.omg.CORBA.ORBInitRef", OperationFactory.identityAction(), "orbInitialReferences", new StringPair[0], stringPairArray3, stringPairArray3, StringPair.class)};
        this.parserData = parserDataArray;
    }

    private Operation makeUSLOperation() {
        Operation[] operationArray = new Operation[]{OperationFactory.stringAction(), OperationFactory.integerAction()};
        Operation operation = OperationFactory.sequenceAction(":", operationArray);
        Operation operation2 = new Operation(){

            public Object operate(Object object) {
                Object[] objectArray = (Object[])object;
                String string = (String)objectArray[0];
                Integer n2 = (Integer)objectArray[1];
                return new USLPort(string, n2);
            }
        };
        Operation operation3 = OperationFactory.compose(operation, operation2);
        Operation operation4 = OperationFactory.listAction(",", operation3);
        return operation4;
    }

    private Operation makeMapOperation(final Map map) {
        return new Operation(){

            public Object operate(Object object) {
                return map.get(object);
            }
        };
    }

    private Operation makeBMGROperation() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("GROW", new Integer(0));
        hashMap.put("CLCT", new Integer(1));
        hashMap.put("STRM", new Integer(2));
        return this.makeMapOperation(hashMap);
    }

    private Operation makeSFOperation() {
        Operation operation = new Operation(){

            public Object operate(Object object) {
                String string = (String)object;
                try {
                    Class clazz = ORBClassLoader.loadClass(string);
                    if (ORBSocketFactory.class.isAssignableFrom(clazz)) {
                        return clazz.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalSocketFactoryType(clazz.toString());
                }
                catch (Exception exception) {
                    throw ParserTable.this.wrapper.badCustomSocketFactory(exception, (Object)string);
                }
            }
        };
        return operation;
    }

    private Operation makeContactInfoListFactoryOperation() {
        Operation operation = new Operation(){

            public Object operate(Object object) {
                String string = (String)object;
                try {
                    Class clazz = ORBClassLoader.loadClass(string);
                    if (CorbaContactInfoListFactory.class.isAssignableFrom(clazz)) {
                        return clazz.newInstance();
                    }
                    throw ParserTable.this.wrapper.illegalContactInfoListFactoryType(clazz.toString());
                }
                catch (Exception exception) {
                    throw ParserTable.this.wrapper.badContactInfoListFactory(exception, (Object)string);
                }
            }
        };
        return operation;
    }

    private Operation makeCSOperation() {
        Operation operation = new Operation(){

            public Object operate(Object object) {
                String string = (String)object;
                return CodeSetComponentInfo.createFromString(string);
            }
        };
        return operation;
    }

    private Operation makeADOperation() {
        Operation operation = new Operation(){
            private Integer[] map = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(0)};

            public Object operate(Object object) {
                int n2 = (Integer)object;
                return this.map[n2];
            }
        };
        Operation operation2 = OperationFactory.integerRangeAction(0, 3);
        Operation operation3 = OperationFactory.compose(operation2, operation);
        Operation operation4 = OperationFactory.compose(operation3, OperationFactory.convertIntegerToShort());
        return operation4;
    }

    private Operation makeFSOperation() {
        Operation operation = new Operation(){

            public Object operate(Object object) {
                int n2 = (Integer)object;
                if (n2 < 32) {
                    throw ParserTable.this.wrapper.fragmentSizeMinimum(new Integer(n2), new Integer(32));
                }
                if (n2 % 8 != 0) {
                    throw ParserTable.this.wrapper.fragmentSizeDiv(new Integer(n2), new Integer(8));
                }
                return object;
            }
        };
        Operation operation2 = OperationFactory.compose(OperationFactory.integerAction(), operation);
        return operation2;
    }

    private Operation makeGVOperation() {
        Operation operation = OperationFactory.listAction(".", OperationFactory.integerAction());
        Operation operation2 = new Operation(){

            public Object operate(Object object) {
                Object[] objectArray = (Object[])object;
                int n2 = (Integer)objectArray[0];
                int n3 = (Integer)objectArray[1];
                return new GIOPVersion(n2, n3);
            }
        };
        Operation operation3 = OperationFactory.compose(operation, operation2);
        return operation3;
    }

    private Operation makeROIOperation() {
        Operation operation = OperationFactory.classAction();
        Operation operation2 = OperationFactory.suffixAction();
        Operation operation3 = OperationFactory.compose(operation2, operation);
        Operation operation4 = OperationFactory.maskErrorAction(operation3);
        Operation operation5 = new Operation(){

            public Object operate(Object object) {
                final Class clazz = (Class)object;
                if (clazz == null) {
                    return null;
                }
                if (ORBInitializer.class.isAssignableFrom(clazz)) {
                    ORBInitializer oRBInitializer = null;
                    try {
                        oRBInitializer = (ORBInitializer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws InstantiationException, IllegalAccessException {
                                return clazz.newInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ParserTable.this.wrapper.orbInitializerFailure(privilegedActionException.getException(), (Object)clazz.getName());
                    }
                    catch (Exception exception) {
                        throw ParserTable.this.wrapper.orbInitializerFailure(exception, (Object)clazz.getName());
                    }
                    return oRBInitializer;
                }
                throw ParserTable.this.wrapper.orbInitializerType(clazz.getName());
            }
        };
        Operation operation6 = OperationFactory.compose(operation4, operation5);
        return operation6;
    }

    private Operation makeAcceptorInstantiationOperation() {
        Operation operation = OperationFactory.classAction();
        Operation operation2 = OperationFactory.suffixAction();
        Operation operation3 = OperationFactory.compose(operation2, operation);
        Operation operation4 = OperationFactory.maskErrorAction(operation3);
        Operation operation5 = new Operation(){

            public Object operate(Object object) {
                final Class clazz = (Class)object;
                if (clazz == null) {
                    return null;
                }
                if (Acceptor.class.isAssignableFrom(clazz)) {
                    Acceptor acceptor = null;
                    try {
                        acceptor = (Acceptor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws InstantiationException, IllegalAccessException {
                                return clazz.newInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ParserTable.this.wrapper.acceptorInstantiationFailure(privilegedActionException.getException(), (Object)clazz.getName());
                    }
                    catch (Exception exception) {
                        throw ParserTable.this.wrapper.acceptorInstantiationFailure(exception, (Object)clazz.getName());
                    }
                    return acceptor;
                }
                throw ParserTable.this.wrapper.acceptorInstantiationTypeFailure(clazz.getName());
            }
        };
        Operation operation6 = OperationFactory.compose(operation4, operation5);
        return operation6;
    }

    private Operation makeInitRefOperation() {
        return new Operation(){

            public Object operate(Object object) {
                String[] stringArray = (String[])object;
                if (stringArray.length != 2) {
                    throw ParserTable.this.wrapper.orbInitialreferenceSyntax();
                }
                return stringArray[0] + "=" + stringArray[1];
            }
        };
    }

    public static final class TestAcceptor1
    implements Acceptor {
        public boolean equals(Object object) {
            return object instanceof TestAcceptor1;
        }

        public boolean initialize() {
            return true;
        }

        public boolean initialized() {
            return true;
        }

        public String getConnectionCacheType() {
            return "FOO";
        }

        public void setConnectionCache(InboundConnectionCache inboundConnectionCache) {
        }

        public InboundConnectionCache getConnectionCache() {
            return null;
        }

        public boolean shouldRegisterAcceptEvent() {
            return true;
        }

        public void setUseSelectThreadForConnections(boolean bl2) {
        }

        public boolean shouldUseSelectThreadForConnections() {
            return true;
        }

        public void setUseWorkerThreadForConnections(boolean bl2) {
        }

        public boolean shouldUseWorkerThreadForConnections() {
            return true;
        }

        public void accept() {
        }

        public void close() {
        }

        public EventHandler getEventHandler() {
            return null;
        }

        public MessageMediator createMessageMediator(Broker broker, Connection connection) {
            return null;
        }

        public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }

        public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }
    }

    public static final class TestAcceptor2
    implements Acceptor {
        public boolean equals(Object object) {
            return object instanceof TestAcceptor2;
        }

        public boolean initialize() {
            return true;
        }

        public boolean initialized() {
            return true;
        }

        public String getConnectionCacheType() {
            return "FOO";
        }

        public void setConnectionCache(InboundConnectionCache inboundConnectionCache) {
        }

        public InboundConnectionCache getConnectionCache() {
            return null;
        }

        public boolean shouldRegisterAcceptEvent() {
            return true;
        }

        public void setUseSelectThreadForConnections(boolean bl2) {
        }

        public boolean shouldUseSelectThreadForConnections() {
            return true;
        }

        public void setUseWorkerThreadForConnections(boolean bl2) {
        }

        public boolean shouldUseWorkerThreadForConnections() {
            return true;
        }

        public void accept() {
        }

        public void close() {
        }

        public EventHandler getEventHandler() {
            return null;
        }

        public MessageMediator createMessageMediator(Broker broker, Connection connection) {
            return null;
        }

        public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }

        public OutputObject createOutputObject(Broker broker, MessageMediator messageMediator) {
            return null;
        }
    }

    public final class TestBadServerIdHandler
    implements BadServerIdHandler {
        public boolean equals(Object object) {
            return object instanceof TestBadServerIdHandler;
        }

        public void handle(ObjectKey objectKey) {
        }
    }

    public static final class TestContactInfoListFactory
    implements CorbaContactInfoListFactory {
        public boolean equals(Object object) {
            return object instanceof TestContactInfoListFactory;
        }

        public void setORB(ORB oRB) {
        }

        public CorbaContactInfoList create(IOR iOR) {
            return null;
        }
    }

    public static final class TestORBInitializer1
    extends LocalObject
    implements ORBInitializer {
        public boolean equals(Object object) {
            return object instanceof TestORBInitializer1;
        }

        public void pre_init(ORBInitInfo oRBInitInfo) {
        }

        public void post_init(ORBInitInfo oRBInitInfo) {
        }
    }

    public static final class TestORBInitializer2
    extends LocalObject
    implements ORBInitializer {
        public boolean equals(Object object) {
            return object instanceof TestORBInitializer2;
        }

        public void pre_init(ORBInitInfo oRBInitInfo) {
        }

        public void post_init(ORBInitInfo oRBInitInfo) {
        }
    }

    public static final class TestORBSocketFactory
    implements ORBSocketFactory {
        public boolean equals(Object object) {
            return object instanceof TestORBSocketFactory;
        }

        public ServerSocket createServerSocket(String string, int n2) {
            return null;
        }

        public EndPointInfo getEndPointInfo(org.omg.CORBA.ORB oRB, IOR iOR, EndPointInfo endPointInfo) {
            return null;
        }

        public Socket createSocket(EndPointInfo endPointInfo) {
            return null;
        }
    }
}

