/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import com.sun.corba.se.impl.orbutil.ObjectWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class ObjectUtility {
    private boolean useToString;
    private boolean isIndenting;
    private int initialLevel;
    private int increment;
    private ClassMap classToPrinter = new ClassMap();
    private static ObjectUtility standard = new ObjectUtility(false, true, 0, 4);
    private static ObjectUtility compact = new ObjectUtility(true, false, 0, 4);
    private ObjectPrinter propertiesPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Properties)) {
                throw new Error();
            }
            Properties properties = (Properties)object;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                objectWriter.startElement();
                objectWriter.append(string);
                objectWriter.append("=");
                objectWriter.append(string2);
                objectWriter.endElement();
            }
        }
    };
    private ObjectPrinter collectionPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Collection)) {
                throw new Error();
            }
            Collection collection = (Collection)object;
            for (Object e2 : collection) {
                objectWriter.startElement();
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, e2);
                objectWriter.endElement();
            }
        }
    };
    private ObjectPrinter mapPrinter = new ObjectPrinter(){

        public void print(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
            if (!(object instanceof Map)) {
                throw new Error();
            }
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                objectWriter.startElement();
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, entry.getKey());
                objectWriter.append("=>");
                ObjectUtility.this.objectToStringHelper(identityHashMap, objectWriter, entry.getValue());
                objectWriter.endElement();
            }
        }
    };

    private ObjectUtility(boolean bl2, boolean bl3, int n2, int n3) {
        this.useToString = bl2;
        this.isIndenting = bl3;
        this.initialLevel = n2;
        this.increment = n3;
        this.classToPrinter.put(Properties.class, this.propertiesPrinter);
        this.classToPrinter.put(Collection.class, this.collectionPrinter);
        this.classToPrinter.put(Map.class, this.mapPrinter);
    }

    public static ObjectUtility make(boolean bl2, boolean bl3, int n2, int n3) {
        return new ObjectUtility(bl2, bl3, n2, n3);
    }

    public static ObjectUtility make(boolean bl2, boolean bl3) {
        return new ObjectUtility(bl2, bl3, 0, 4);
    }

    public static ObjectUtility make() {
        return standard;
    }

    public static String defaultObjectToString(Object object) {
        return standard.objectToString(object);
    }

    public static String compactObjectToString(Object object) {
        return compact.objectToString(object);
    }

    public String objectToString(Object object) {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        ObjectWriter objectWriter = ObjectWriter.make(this.isIndenting, this.initialLevel, this.increment);
        this.objectToStringHelper(identityHashMap, objectWriter, object);
        return objectWriter.toString();
    }

    public static boolean equals(Object object, Object object2) {
        HashSet hashSet = new HashSet();
        IdentityHashMap identityHashMap = new IdentityHashMap();
        return ObjectUtility.equalsHelper(identityHashMap, hashSet, object, object2);
    }

    public static Object concatenateArrays(Object object, Object object2) {
        int n2;
        Class<?> clazz = object.getClass().getComponentType();
        Class<?> clazz2 = object2.getClass().getComponentType();
        int n3 = Array.getLength(object);
        int n4 = Array.getLength(object2);
        if (clazz == null || clazz2 == null) {
            throw new IllegalStateException("Arguments must be arrays");
        }
        if (!clazz.equals(clazz2)) {
            throw new IllegalStateException("Arguments must be arrays with the same component type");
        }
        Object object3 = Array.newInstance(clazz, n3 + n4);
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Array.set(object3, n5++, Array.get(object, n2));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            Array.set(object3, n5++, Array.get(object2, n2));
        }
        return object3;
    }

    private void objectToStringHelper(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        if (object == null) {
            objectWriter.append("null");
            objectWriter.endElement();
        } else {
            Class<? extends Object> clazz = object.getClass();
            objectWriter.startObject(object);
            if (identityHashMap.keySet().contains(object)) {
                objectWriter.endObject("*VISITED*");
            } else {
                identityHashMap.put(object, null);
                if (this.mustUseToString(clazz)) {
                    objectWriter.endObject(object.toString());
                } else {
                    ObjectPrinter objectPrinter = (ObjectPrinter)this.classToPrinter.get(clazz);
                    if (objectPrinter != null) {
                        objectPrinter.print(identityHashMap, objectWriter, object);
                        objectWriter.endObject();
                    } else {
                        Class<?> clazz2 = clazz.getComponentType();
                        if (clazz2 == null) {
                            this.handleObject(identityHashMap, objectWriter, object);
                        } else {
                            this.handleArray(identityHashMap, objectWriter, object);
                            objectWriter.endObject();
                        }
                    }
                }
            }
        }
    }

    private boolean mustUseToString(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == Integer.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == StringBuffer.class || clazz == Long.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class) {
            return true;
        }
        if (this.useToString) {
            try {
                clazz.getDeclaredMethod("toString", null);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private void handleObject(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        Class<? extends Object> clazz = object.getClass();
        try {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                Field field = fieldArray[i2];
                int n2 = field.getModifiers();
                if (Modifier.isStatic(n2)) continue;
                objectWriter.startElement();
                objectWriter.append(field.getName());
                objectWriter.append(":");
                try {
                    field.setAccessible(true);
                    Object object2 = field.get(object);
                    this.objectToStringHelper(identityHashMap, objectWriter, object2);
                }
                catch (Exception exception) {
                    objectWriter.append("???");
                }
                objectWriter.endElement();
            }
            objectWriter.endObject();
        }
        catch (Exception exception) {
            objectWriter.endObject(object.toString());
        }
    }

    private void handleArray(IdentityHashMap identityHashMap, ObjectWriter objectWriter, Object object) {
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                objectWriter.startElement();
                objectWriter.append(blArray[i2]);
                objectWriter.endElement();
            }
        } else if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                objectWriter.startElement();
                objectWriter.append(byArray[i3]);
                objectWriter.endElement();
            }
        } else if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            for (int i4 = 0; i4 < sArray.length; ++i4) {
                objectWriter.startElement();
                objectWriter.append(sArray[i4]);
                objectWriter.endElement();
            }
        } else if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            for (int i5 = 0; i5 < nArray.length; ++i5) {
                objectWriter.startElement();
                objectWriter.append(nArray[i5]);
                objectWriter.endElement();
            }
        } else if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            for (int i6 = 0; i6 < lArray.length; ++i6) {
                objectWriter.startElement();
                objectWriter.append(lArray[i6]);
                objectWriter.endElement();
            }
        } else if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            for (int i7 = 0; i7 < cArray.length; ++i7) {
                objectWriter.startElement();
                objectWriter.append(cArray[i7]);
                objectWriter.endElement();
            }
        } else if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            for (int i8 = 0; i8 < fArray.length; ++i8) {
                objectWriter.startElement();
                objectWriter.append(fArray[i8]);
                objectWriter.endElement();
            }
        } else if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            for (int i9 = 0; i9 < dArray.length; ++i9) {
                objectWriter.startElement();
                objectWriter.append(dArray[i9]);
                objectWriter.endElement();
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i10 = 0; i10 < objectArray.length; ++i10) {
                objectWriter.startElement();
                this.objectToStringHelper(identityHashMap, objectWriter, objectArray[i10]);
                objectWriter.endElement();
            }
        }
    }

    private static boolean equalsHelper(Map map, Set set, Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == object2;
        }
        Object object3 = map.get(object);
        if (object3 == null) {
            object3 = object2;
            map.put(object, object3);
        }
        if (object == object3) {
            return true;
        }
        if (object2 != object3) {
            return false;
        }
        Pair pair = new Pair(object, object2);
        if (set.contains(pair)) {
            return true;
        }
        set.add(pair);
        if (object instanceof Object[] && object2 instanceof Object[]) {
            return ObjectUtility.equalArrays(map, set, (Object[])object, (Object[])object2);
        }
        if (object instanceof Map && object2 instanceof Map) {
            return ObjectUtility.equalMaps(map, set, (Map)object, (Map)object2);
        }
        if (object instanceof Set && object2 instanceof Set) {
            return ObjectUtility.equalSets(map, set, (Set)object, (Set)object2);
        }
        if (object instanceof List && object2 instanceof List) {
            return ObjectUtility.equalLists(map, set, (List)object, (List)object2);
        }
        if (object instanceof boolean[] && object2 instanceof boolean[]) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (object instanceof char[] && object2 instanceof char[]) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (object instanceof double[] && object2 instanceof double[]) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        if (object instanceof float[] && object2 instanceof float[]) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (object instanceof int[] && object2 instanceof int[]) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (object instanceof long[] && object2 instanceof long[]) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        Class<? extends Object> clazz = object.getClass();
        if (clazz != object2.getClass()) {
            return object.equals(object2);
        }
        return ObjectUtility.equalsObject(map, set, clazz, object, object2);
    }

    private static boolean equalsObject(Map map, Set set, Class clazz, Object object, Object object2) {
        Class<Object> clazz2 = Object.class;
        if (clazz == clazz2) {
            return true;
        }
        Class[] classArray = new Class[]{clazz2};
        try {
            Method method = clazz.getDeclaredMethod("equals", classArray);
            return object.equals(object2);
        }
        catch (Exception exception) {
            if (ObjectUtility.equalsObjectFields(map, set, clazz, object, object2)) {
                return ObjectUtility.equalsObject(map, set, clazz.getSuperclass(), object, object2);
            }
            return false;
        }
    }

    private static boolean equalsObjectFields(Map map, Set set, Class clazz, Object object, Object object2) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            try {
                Field field = fieldArray[i2];
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object object3 = field.get(object);
                Object object4 = field.get(object2);
                if (ObjectUtility.equalsHelper(map, set, object3, object4)) continue;
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
        }
        return true;
    }

    private static boolean equalArrays(Map map, Set set, Object[] objectArray, Object[] objectArray2) {
        int n2 = objectArray.length;
        if (n2 != objectArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (ObjectUtility.equalsHelper(map, set, objectArray[i2], objectArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static boolean equalMaps(Map map, Set set, Map map2, Map map3) {
        if (map3.size() != map2.size()) {
            return false;
        }
        try {
            for (Map.Entry entry : map2.entrySet()) {
                Object k2 = entry.getKey();
                Object v2 = entry.getValue();
                if (!(v2 == null ? map3.get(k2) != null || !map3.containsKey(k2) : !ObjectUtility.equalsHelper(map, set, v2, map3.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    private static boolean equalSets(Map map, Set set, Set set2, Set set3) {
        if (set2.size() != set3.size()) {
            return false;
        }
        for (Object e2 : set2) {
            boolean bl2 = false;
            Iterator iterator = set3.iterator();
            while (iterator.hasNext() && !bl2) {
                Object e3 = iterator.next();
                bl2 = ObjectUtility.equals(e2, e3);
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    private static boolean equalLists(Map map, Set set, List list, List list2) {
        ListIterator listIterator = list.listIterator();
        ListIterator listIterator2 = list2.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            Object e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? ObjectUtility.equalsHelper(map, set, e2, e3) : e3 == null) continue;
            return false;
        }
        return !listIterator.hasNext() && !listIterator2.hasNext();
    }

    private static class ClassMap {
        ArrayList data = new ArrayList();

        public Object get(Class clazz) {
            for (Object[] objectArray : this.data) {
                Class clazz2 = (Class)objectArray[0];
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return objectArray[1];
            }
            return null;
        }

        public void put(Class clazz, Object object) {
            Object[] objectArray = new Object[]{clazz, object};
            this.data.add(objectArray);
        }
    }

    private static interface ObjectPrinter {
        public void print(IdentityHashMap var1, ObjectWriter var2, Object var3);
    }

    private static class Pair {
        private Object obj1;
        private Object obj2;

        Pair(Object object, Object object2) {
            this.obj1 = object;
            this.obj2 = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)object;
            return pair.obj1 == this.obj1 && pair.obj2 == this.obj2;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj1) ^ System.identityHashCode(this.obj2);
        }
    }
}

