/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.orbutil.ObjectUtility;
import com.sun.corba.se.impl.presentation.rmi.IDLType;
import com.sun.corba.se.impl.presentation.rmi.IDLTypeException;
import com.sun.corba.se.impl.presentation.rmi.IDLTypesUtil;
import com.sun.corba.se.spi.presentation.rmi.IDLNameTranslator;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class IDLNameTranslatorImpl
implements IDLNameTranslator {
    private static String[] IDL_KEYWORDS = new String[]{"abstract", "any", "attribute", "boolean", "case", "char", "const", "context", "custom", "default", "double", "enum", "exception", "factory", "FALSE", "fixed", "float", "in", "inout", "interface", "long", "module", "native", "Object", "octet", "oneway", "out", "private", "public", "raises", "readonly", "sequence", "short", "string", "struct", "supports", "switch", "TRUE", "truncatable", "typedef", "unsigned", "union", "ValueBase", "valuetype", "void", "wchar", "wstring"};
    private static char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String UNDERSCORE = "_";
    private static final String INNER_CLASS_SEPARATOR = "__";
    private static final String[] BASE_IDL_ARRAY_MODULE_TYPE = new String[]{"org", "omg", "boxedRMI"};
    private static final String BASE_IDL_ARRAY_ELEMENT_TYPE = "seq";
    private static final String LEADING_UNDERSCORE_CHAR = "J";
    private static final String ID_CONTAINER_CLASH_CHAR = "_";
    private static final String OVERLOADED_TYPE_SEPARATOR = "__";
    private static final String ATTRIBUTE_METHOD_CLASH_MANGLE_CHARS = "__";
    private static final String GET_ATTRIBUTE_PREFIX = "_get_";
    private static final String SET_ATTRIBUTE_PREFIX = "_set_";
    private static final String IS_ATTRIBUTE_PREFIX = "_get_";
    private static Set idlKeywords_ = new HashSet();
    private Class[] interf_;
    private Map methodToIDLNameMap_;
    private Map IDLNameToMethodMap_;

    public static IDLNameTranslator get(Class clazz) {
        return new IDLNameTranslatorImpl(new Class[]{clazz});
    }

    public static IDLNameTranslator get(Class[] classArray) {
        return new IDLNameTranslatorImpl(classArray);
    }

    public static String getExceptionId(Class clazz) {
        IDLType iDLType = IDLNameTranslatorImpl.classToIDLType(clazz);
        return iDLType.getExceptionName();
    }

    public Class[] getInterfaces() {
        return this.interf_;
    }

    public Method getMethod(String string) {
        return (Method)this.IDLNameToMethodMap_.get(string);
    }

    public String getIDLName(Method method) {
        return (String)this.methodToIDLNameMap_.get(method);
    }

    private IDLNameTranslatorImpl(Class[] classArray) {
        try {
            IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                iDLTypesUtil.validateRemoteInterface(classArray[i2]);
            }
            this.interf_ = classArray;
            this.buildNameTranslation();
        }
        catch (IDLTypeException iDLTypeException) {
            String string = iDLTypeException.getMessage();
            IllegalStateException illegalStateException = new IllegalStateException(string);
            illegalStateException.initCause(iDLTypeException);
            throw illegalStateException;
        }
    }

    private void buildNameTranslation() {
        Object object4;
        Object object2;
        Object object32;
        HashMap<Method, IDLMethodInfo> hashMap = new HashMap<Method, IDLMethodInfo>();
        for (int i2 = 0; i2 < this.interf_.length; ++i2) {
            object32 = this.interf_[i2];
            object2 = new IDLTypesUtil();
            object4 = ((Class)object32).getMethods();
            for (int i3 = 0; i3 < ((Method[])object4).length; ++i3) {
                Method method = object4[i3];
                IDLMethodInfo iDLMethodInfo = new IDLMethodInfo();
                iDLMethodInfo.method = method;
                if (((IDLTypesUtil)object2).isPropertyAccessorMethod(method, (Class)object32)) {
                    String string;
                    iDLMethodInfo.isProperty = true;
                    iDLMethodInfo.originalName = string = ((IDLTypesUtil)object2).getAttributeNameForProperty(method.getName());
                    iDLMethodInfo.mangledName = string;
                } else {
                    iDLMethodInfo.isProperty = false;
                    iDLMethodInfo.originalName = method.getName();
                    iDLMethodInfo.mangledName = method.getName();
                }
                hashMap.put(method, iDLMethodInfo);
            }
        }
        block2: for (Object object32 : hashMap.values()) {
            for (Object object4 : hashMap.values()) {
                if (object32 == object4 || ((IDLMethodInfo)object32).originalName.equals(((IDLMethodInfo)object4).originalName) || !((IDLMethodInfo)object32).originalName.equalsIgnoreCase(((IDLMethodInfo)object4).originalName)) continue;
                ((IDLMethodInfo)object32).mangledName = this.mangleCaseSensitiveCollision(((IDLMethodInfo)object32).originalName);
                continue block2;
            }
        }
        for (Object object32 : hashMap.values()) {
            ((IDLMethodInfo)object32).mangledName = IDLNameTranslatorImpl.mangleIdentifier(((IDLMethodInfo)object32).mangledName, ((IDLMethodInfo)object32).isProperty);
        }
        block5: for (Object object32 : hashMap.values()) {
            if (((IDLMethodInfo)object32).isProperty) continue;
            for (Object object4 : hashMap.values()) {
                if (object32 == object4 || ((IDLMethodInfo)object4).isProperty || !((IDLMethodInfo)object32).originalName.equals(((IDLMethodInfo)object4).originalName)) continue;
                ((IDLMethodInfo)object32).mangledName = IDLNameTranslatorImpl.mangleOverloadedMethod(((IDLMethodInfo)object32).mangledName, ((IDLMethodInfo)object32).method);
                continue block5;
            }
        }
        block7: for (Object object32 : hashMap.values()) {
            if (!((IDLMethodInfo)object32).isProperty) continue;
            for (Object object4 : hashMap.values()) {
                if (object32 == object4 || ((IDLMethodInfo)object4).isProperty || !((IDLMethodInfo)object32).mangledName.equals(((IDLMethodInfo)object4).mangledName)) continue;
                ((IDLMethodInfo)object32).mangledName = ((IDLMethodInfo)object32).mangledName + "__";
                continue block7;
            }
        }
        for (int i4 = 0; i4 < this.interf_.length; ++i4) {
            object32 = this.interf_[i4];
            object2 = IDLNameTranslatorImpl.getMappedContainerName((Class)object32);
            for (IDLMethodInfo iDLMethodInfo : hashMap.values()) {
                if (iDLMethodInfo.isProperty || !IDLNameTranslatorImpl.identifierClashesWithContainer((String)object2, iDLMethodInfo.mangledName)) continue;
                iDLMethodInfo.mangledName = IDLNameTranslatorImpl.mangleContainerClash(iDLMethodInfo.mangledName);
            }
        }
        this.methodToIDLNameMap_ = new HashMap();
        this.IDLNameToMethodMap_ = new HashMap();
        for (Object object32 : hashMap.values()) {
            object2 = ((IDLMethodInfo)object32).mangledName;
            if (((IDLMethodInfo)object32).isProperty) {
                object4 = ((IDLMethodInfo)object32).method.getName();
                String string = "";
                string = ((String)object4).startsWith("get") ? "_get_" : (((String)object4).startsWith("set") ? SET_ATTRIBUTE_PREFIX : "_get_");
                object2 = string + ((IDLMethodInfo)object32).mangledName;
            }
            this.methodToIDLNameMap_.put(((IDLMethodInfo)object32).method, object2);
            if (this.IDLNameToMethodMap_.containsKey(object2)) {
                object4 = (Method)this.IDLNameToMethodMap_.get(object2);
                throw new IllegalStateException("Error : methods " + object4 + " and " + ((IDLMethodInfo)object32).method + " both result in IDL name '" + (String)object2 + "'");
            }
            this.IDLNameToMethodMap_.put(object2, ((IDLMethodInfo)object32).method);
        }
    }

    private static String mangleIdentifier(String string) {
        return IDLNameTranslatorImpl.mangleIdentifier(string, false);
    }

    private static String mangleIdentifier(String string, boolean bl2) {
        String string2 = string;
        if (IDLNameTranslatorImpl.hasLeadingUnderscore(string2)) {
            string2 = IDLNameTranslatorImpl.mangleLeadingUnderscore(string2);
        }
        if (!bl2 && IDLNameTranslatorImpl.isIDLKeyword(string2)) {
            string2 = IDLNameTranslatorImpl.mangleIDLKeywordClash(string2);
        }
        if (!IDLNameTranslatorImpl.isIDLIdentifier(string2)) {
            string2 = IDLNameTranslatorImpl.mangleUnicodeChars(string2);
        }
        return string2;
    }

    private static boolean isIDLKeyword(String string) {
        String string2 = string.toUpperCase();
        return idlKeywords_.contains(string2);
    }

    private static String mangleIDLKeywordClash(String string) {
        return "_" + string;
    }

    private static String mangleLeadingUnderscore(String string) {
        return LEADING_UNDERSCORE_CHAR + string;
    }

    private static boolean hasLeadingUnderscore(String string) {
        return string.startsWith("_");
    }

    static String mangleUnicodeChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (IDLNameTranslatorImpl.isIDLIdentifierChar(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            String string2 = IDLNameTranslatorImpl.charToUnicodeRepresentation(c2);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    String mangleCaseSensitiveCollision(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("_");
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isUpperCase(c2)) continue;
            if (bl2) {
                stringBuffer.append("_");
            }
            stringBuffer.append(i2);
            bl2 = true;
        }
        return stringBuffer.toString();
    }

    private static String mangleContainerClash(String string) {
        return string + "_";
    }

    private static boolean identifierClashesWithContainer(String string, String string2) {
        return string2.equalsIgnoreCase(string);
    }

    public static String charToUnicodeRepresentation(char n2) {
        int n3;
        int n4;
        int n5 = n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = n5;
        while (n6 > 0) {
            n4 = n6 / 16;
            n3 = n6 % 16;
            stringBuffer.insert(0, HEX_DIGITS[n3]);
            n6 = n4;
        }
        n4 = 4 - stringBuffer.length();
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuffer.insert(0, "0");
        }
        stringBuffer.insert(0, "U");
        return stringBuffer.toString();
    }

    private static boolean isIDLIdentifier(String string) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            boolean bl3 = bl2 = i2 == 0 ? IDLNameTranslatorImpl.isIDLAlphabeticChar(c2) : IDLNameTranslatorImpl.isIDLIdentifierChar(c2);
            if (!bl2) break;
        }
        return bl2;
    }

    private static boolean isIDLIdentifierChar(char c2) {
        return IDLNameTranslatorImpl.isIDLAlphabeticChar(c2) || IDLNameTranslatorImpl.isIDLDecimalDigit(c2) || IDLNameTranslatorImpl.isUnderscore(c2);
    }

    private static boolean isIDLAlphabeticChar(char c2) {
        boolean bl2 = c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '\u00c0' && c2 <= '\u00ff' && c2 != '\u00d7' && c2 != '\u00f7';
        return bl2;
    }

    private static boolean isIDLDecimalDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isUnderscore(char c2) {
        return c2 == '_';
    }

    private static String mangleOverloadedMethod(String string, Method method) {
        IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
        String string2 = string + "__";
        Class<?>[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            String string3;
            Class<?> clazz = classArray[i2];
            if (i2 > 0) {
                string2 = string2 + "__";
            }
            IDLType iDLType = IDLNameTranslatorImpl.classToIDLType(clazz);
            String string4 = iDLType.getModuleName();
            String string5 = iDLType.getMemberName();
            String string6 = string3 = string4.length() > 0 ? string4 + "_" + string5 : string5;
            if (!iDLTypesUtil.isPrimitive(clazz) && iDLTypesUtil.getSpecialCaseIDLTypeMapping(clazz) == null && IDLNameTranslatorImpl.isIDLKeyword(string3)) {
                string3 = IDLNameTranslatorImpl.mangleIDLKeywordClash(string3);
            }
            string3 = IDLNameTranslatorImpl.mangleUnicodeChars(string3);
            string2 = string2 + string3;
        }
        return string2;
    }

    private static IDLType classToIDLType(Class clazz) {
        IDLType iDLType = null;
        IDLTypesUtil iDLTypesUtil = new IDLTypesUtil();
        if (iDLTypesUtil.isPrimitive(clazz)) {
            iDLType = iDLTypesUtil.getPrimitiveIDLTypeMapping(clazz);
        } else if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            int n2 = 1;
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
                ++n2;
            }
            IDLType iDLType2 = IDLNameTranslatorImpl.classToIDLType(clazz2);
            String[] stringArray = BASE_IDL_ARRAY_MODULE_TYPE;
            if (iDLType2.hasModule()) {
                stringArray = (String[])ObjectUtility.concatenateArrays(stringArray, iDLType2.getModules());
            }
            String string = BASE_IDL_ARRAY_ELEMENT_TYPE + n2 + "_" + iDLType2.getMemberName();
            iDLType = new IDLType(clazz, stringArray, string);
        } else {
            iDLType = iDLTypesUtil.getSpecialCaseIDLTypeMapping(clazz);
            if (iDLType == null) {
                String string;
                String string2 = IDLNameTranslatorImpl.getUnmappedContainerName(clazz);
                if (IDLNameTranslatorImpl.hasLeadingUnderscore(string2 = string2.replaceAll("\\$", "__"))) {
                    string2 = IDLNameTranslatorImpl.mangleLeadingUnderscore(string2);
                }
                if ((string = IDLNameTranslatorImpl.getPackageName(clazz)) == null) {
                    iDLType = new IDLType(clazz, string2);
                } else {
                    if (iDLTypesUtil.isEntity(clazz)) {
                        string = "org.omg.boxedIDL." + string;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n3 = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        String string3 = stringTokenizer.nextToken();
                        String string4 = IDLNameTranslatorImpl.hasLeadingUnderscore(string3) ? IDLNameTranslatorImpl.mangleLeadingUnderscore(string3) : string3;
                        stringArray[n3++] = string4;
                    }
                    iDLType = new IDLType(clazz, stringArray, string2);
                }
            }
        }
        return iDLType;
    }

    private static String getPackageName(Class clazz) {
        String string;
        int n2;
        Package package_ = clazz.getPackage();
        String string2 = null;
        string2 = package_ != null ? package_.getName() : ((n2 = (string = clazz.getName()).indexOf(46)) == -1 ? null : string.substring(0, n2));
        return string2;
    }

    private static String getMappedContainerName(Class clazz) {
        String string = IDLNameTranslatorImpl.getUnmappedContainerName(clazz);
        return IDLNameTranslatorImpl.mangleIdentifier(string);
    }

    private static String getUnmappedContainerName(Class clazz) {
        String string = null;
        String string2 = IDLNameTranslatorImpl.getPackageName(clazz);
        String string3 = clazz.getName();
        if (string2 != null) {
            int n2 = string2.length();
            string = string3.substring(n2 + 1);
        } else {
            string = string3;
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IDLNameTranslator[");
        for (int i2 = 0; i2 < this.interf_.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.interf_[i2].getName());
        }
        stringBuffer.append("]\n");
        for (Method method : this.methodToIDLNameMap_.keySet()) {
            String string = (String)this.methodToIDLNameMap_.get(method);
            stringBuffer.append(string + ":" + method + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        Class clazz = Remote.class;
        if (stringArray.length > 0) {
            object = stringArray[0];
            try {
                clazz = Class.forName((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(-1);
            }
        }
        System.out.println("Building name translation for " + clazz);
        try {
            object = IDLNameTranslatorImpl.get(clazz);
            System.out.println(object);
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
    }

    static {
        for (int i2 = 0; i2 < IDL_KEYWORDS.length; ++i2) {
            String string = IDL_KEYWORDS[i2];
            String string2 = string.toUpperCase();
            idlKeywords_.add(string2);
        }
    }

    private static class IDLMethodInfo {
        public Method method;
        public boolean isProperty;
        public String originalName;
        public String mangledName;

        private IDLMethodInfo() {
        }
    }
}

