/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.orbutil.graph.Graph;
import com.sun.corba.se.impl.orbutil.graph.GraphImpl;
import com.sun.corba.se.impl.orbutil.graph.Node;
import com.sun.corba.se.impl.presentation.rmi.DynamicMethodMarshallerImpl;
import com.sun.corba.se.impl.presentation.rmi.IDLNameTranslatorImpl;
import com.sun.corba.se.impl.presentation.rmi.ReflectiveTie;
import com.sun.corba.se.impl.presentation.rmi.StubFactoryImpl;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
import com.sun.corba.se.spi.presentation.rmi.IDLNameTranslator;
import com.sun.corba.se.spi.presentation.rmi.PresentationManager;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.rmi.CORBA.Tie;

public class PresentationManagerImpl
implements PresentationManager {
    private Map classToClassData = new HashMap();
    private Map methodToDMM = new HashMap();
    private ORB orb;

    public PresentationManagerImpl(ORB oRB) {
        this.orb = oRB;
    }

    public Tie getTie() {
        ReflectiveTie reflectiveTie = new ReflectiveTie();
        reflectiveTie.orb(this.orb);
        return reflectiveTie;
    }

    public synchronized DynamicMethodMarshaller getDynamicMethodMarshaller(Method method) {
        if (method == null) {
            return null;
        }
        DynamicMethodMarshaller dynamicMethodMarshaller = (DynamicMethodMarshaller)this.methodToDMM.get(method);
        if (dynamicMethodMarshaller == null) {
            dynamicMethodMarshaller = new DynamicMethodMarshallerImpl(this.orb, method);
            this.methodToDMM.put(method, dynamicMethodMarshaller);
        }
        return dynamicMethodMarshaller;
    }

    public synchronized PresentationManager.ClassData getClassData(Class clazz) {
        PresentationManager.ClassData classData = (PresentationManager.ClassData)this.classToClassData.get(clazz);
        if (classData == null) {
            classData = new ClassDataImpl(clazz);
            this.classToClassData.put(clazz, classData);
        }
        return classData;
    }

    private Set getRootSet(Class clazz, NodeImpl nodeImpl, Graph graph) {
        Set set = null;
        if (clazz.isInterface()) {
            graph.add(nodeImpl);
            set = graph.getRoots();
        } else {
            HashSet<NodeImpl> hashSet = new HashSet<NodeImpl>();
            for (Class clazz2 = clazz; clazz2 != null && !clazz2.equals(Object.class); clazz2 = clazz2.getSuperclass()) {
                NodeImpl nodeImpl2 = new NodeImpl(clazz2);
                graph.add(nodeImpl2);
                hashSet.add(nodeImpl2);
            }
            graph.getRoots();
            graph.removeAll(hashSet);
            set = graph.getRoots();
        }
        return set;
    }

    private Class[] getInterfaces(Set set) {
        Class[] classArray = new Class[set.size()];
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            NodeImpl nodeImpl = (NodeImpl)iterator.next();
            classArray[n2++] = nodeImpl.getInterface();
        }
        return classArray;
    }

    private String[] makeTypeIds(NodeImpl nodeImpl, Graph graph, Set set) {
        HashSet hashSet = new HashSet(graph);
        hashSet.removeAll(set);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (set.size() > 1) {
            arrayList.add(nodeImpl.getTypeId());
        }
        this.addNodes(arrayList, set);
        this.addNodes(arrayList, hashSet);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addNodes(List list, Set set) {
        for (NodeImpl nodeImpl : set) {
            String string = nodeImpl.getTypeId();
            list.add(string);
        }
    }

    private class ClassDataImpl
    implements PresentationManager.ClassData {
        private IDLNameTranslator nameTranslator;
        private String[] typeIds;
        private PresentationManager.StubFactory stubFactory;

        public ClassDataImpl(Class clazz) {
            GraphImpl graphImpl = new GraphImpl();
            NodeImpl nodeImpl = new NodeImpl(clazz);
            Set set = PresentationManagerImpl.this.getRootSet(clazz, nodeImpl, graphImpl);
            Class[] classArray = PresentationManagerImpl.this.getInterfaces(set);
            this.nameTranslator = IDLNameTranslatorImpl.get(classArray);
            this.typeIds = PresentationManagerImpl.this.makeTypeIds(nodeImpl, graphImpl, set);
            this.stubFactory = new StubFactoryImpl(PresentationManagerImpl.this, this);
        }

        public IDLNameTranslator getIDLNameTranslator() {
            return this.nameTranslator;
        }

        public String[] getTypeIds() {
            return this.typeIds;
        }

        public PresentationManager.StubFactory getStubFactory() {
            return this.stubFactory;
        }
    }

    private static class NodeImpl
    implements Node {
        private Class interf;

        public Class getInterface() {
            return this.interf;
        }

        public NodeImpl(Class clazz) {
            this.interf = clazz;
        }

        public String getTypeId() {
            return "RMI:" + this.interf.getName() + ":0000000000000000";
        }

        public Set getChildren() {
            HashSet<NodeImpl> hashSet = new HashSet<NodeImpl>();
            Class[] classArray = this.interf.getInterfaces();
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                Class clazz = classArray[i2];
                if (!Remote.class.isAssignableFrom(clazz) || Remote.class.equals((Object)clazz)) continue;
                hashSet.add(new NodeImpl(clazz));
            }
            return hashSet;
        }

        public String toString() {
            return "NodeImpl[" + this.interf + "]";
        }

        public int hashCode() {
            return this.interf.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NodeImpl)) {
                return false;
            }
            NodeImpl nodeImpl = (NodeImpl)object;
            return nodeImpl.interf.equals(this.interf);
        }
    }
}

