/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.core.ServiceContexts;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBClassLoader;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.AddressingDispositionException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.IORAddressingInfo;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateRequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.TargetAddress;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPFactories;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaConnection;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.IOP.TaggedProfile;

public abstract class MessageBase
implements Message {
    public byte[] giopHeader;
    private ByteBuffer byteBuffer;
    private static ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.protocol");

    public static String typeToString(int n2) {
        return MessageBase.typeToString((byte)n2);
    }

    public static String typeToString(byte by) {
        String string = by + "/";
        switch (by) {
            case 0: {
                string = string + "GIOPRequest";
                break;
            }
            case 1: {
                string = string + "GIOPReply";
                break;
            }
            case 2: {
                string = string + "GIOPCancelRequest";
                break;
            }
            case 3: {
                string = string + "GIOPLocateRequest";
                break;
            }
            case 4: {
                string = string + "GIOPLocateReply";
                break;
            }
            case 5: {
                string = string + "GIOPCloseConnection";
                break;
            }
            case 6: {
                string = string + "GIOPMessageError";
                break;
            }
            case 7: {
                string = string + "GIOPFragment";
                break;
            }
            default: {
                string = string + "Unknown";
            }
        }
        return string;
    }

    public static MessageBase readGIOPMessage(ORB oRB, CorbaConnection corbaConnection) {
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        ByteBuffer byteBuffer;
        boolean bl2 = oRB.giopDebugFlag;
        MessageBase messageBase = null;
        try {
            byteBuffer = corbaConnection.read(12, 0, 12);
        }
        catch (IOException iOException) {
            throw wrapper.ioexceptionWhenReadingConnection(iOException);
        }
        if (bl2) {
            MessageBase.dprint(".readGIOPMessage: " + MessageBase.typeToString(byteBuffer.get(7)));
            MessageBase.dprint(".readGIOPMessage: GIOP header is: ");
            ByteBuffer byteBuffer2 = byteBuffer.asReadOnlyBuffer();
            byteBuffer2.position(0).limit(12);
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo((org.omg.CORBA.ORB)oRB, byteBuffer2);
            byteBufferWithInfo.buflen = 12;
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        if ((n6 = (n5 = byteBuffer.get(0) << 24 & 0xFF000000) | (n4 = byteBuffer.get(1) << 16 & 0xFF0000) | (n3 = byteBuffer.get(2) << 8 & 0xFF00) | (n2 = byteBuffer.get(3) << 0 & 0xFF)) != 1195986768) {
            throw wrapper.giopMagicError(CompletionStatus.COMPLETED_MAYBE);
        }
        GIOPVersion gIOPVersion = oRB.getORBData().getGIOPVersion();
        if (bl2) {
            MessageBase.dprint(".readGIOPMessage: Message GIOP version: " + byteBuffer.get(4) + '.' + byteBuffer.get(5));
            MessageBase.dprint(".readGIOPMessage: ORB Max GIOP Version: " + gIOPVersion);
        }
        if ((byteBuffer.get(4) > gIOPVersion.getMajor() || byteBuffer.get(4) == gIOPVersion.getMajor() && byteBuffer.get(5) > gIOPVersion.getMinor()) && byteBuffer.get(7) != 6) {
            throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
        }
        MessageBase.AreFragmentsAllowed(byteBuffer.get(4), byteBuffer.get(5), byteBuffer.get(6), byteBuffer.get(7));
        switch (byteBuffer.get(7)) {
            case 0: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating RequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new RequestMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new RequestMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new RequestMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 3: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating LocateRequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new LocateRequestMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new LocateRequestMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new LocateRequestMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 2: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating CancelRequestMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new CancelRequestMessage_1_0();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new CancelRequestMessage_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new CancelRequestMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 1: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating ReplyMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new ReplyMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new ReplyMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new ReplyMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 4: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating LocateReplyMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new LocateReplyMessage_1_0(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new LocateReplyMessage_1_1(oRB);
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new LocateReplyMessage_1_2(oRB);
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 5: 
            case 6: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating Message for CloseConnection or MessageError");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
                    messageBase = new Message_1_0();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new Message_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new Message_1_1();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            case 7: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: creating FragmentMessage");
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) break;
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 1) {
                    messageBase = new FragmentMessage_1_1();
                    break;
                }
                if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 2) {
                    messageBase = new FragmentMessage_1_2();
                    break;
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
            default: {
                if (bl2) {
                    MessageBase.dprint(".readGIOPMessage: UNKNOWN MESSAGE TYPE: " + byteBuffer.get(7));
                }
                throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        if (byteBuffer.get(4) == 1 && byteBuffer.get(5) == 0) {
            object2 = (Message_1_0)messageBase;
            ((Message_1_0)object2).magic = n6;
            ((Message_1_0)object2).GIOP_version = new GIOPVersion(byteBuffer.get(4), byteBuffer.get(5));
            ((Message_1_0)object2).byte_order = byteBuffer.get(6) == 1;
            ((Message_1_0)object2).message_type = byteBuffer.get(7);
            ((Message_1_0)object2).message_size = MessageBase.readSize(byteBuffer.get(8), byteBuffer.get(9), byteBuffer.get(10), byteBuffer.get(11), ((Message_1_0)object2).isLittleEndian()) + 12;
        } else {
            object2 = (Message_1_1)messageBase;
            ((Message_1_1)object2).magic = n6;
            ((Message_1_1)object2).GIOP_version = new GIOPVersion(byteBuffer.get(4), byteBuffer.get(5));
            ((Message_1_1)object2).flags = byteBuffer.get(6);
            ((Message_1_1)object2).message_type = byteBuffer.get(7);
            ((Message_1_1)object2).message_size = MessageBase.readSize(byteBuffer.get(8), byteBuffer.get(9), byteBuffer.get(10), byteBuffer.get(11), ((Message_1_1)object2).isLittleEndian()) + 12;
        }
        if (bl2) {
            MessageBase.dprint(".readGIOPMessage: header construction complete.");
            object2 = byteBuffer.asReadOnlyBuffer();
            object = new byte[12];
            ((Buffer)object2).position(0).limit(12);
            ((ByteBuffer)object2).get((byte[])object, 0, ((byte[])object).length);
            messageBase.giopHeader = object;
        }
        int n7 = messageBase.getSize() - 12;
        try {
            byteBuffer = corbaConnection.read(byteBuffer, 12, n7);
        }
        catch (IOException iOException) {
            throw wrapper.ioexceptionWhenReadingConnection(iOException);
        }
        messageBase.setByteBuffer(byteBuffer);
        if (bl2) {
            MessageBase.dprint(".readGIOPMessage: received message:");
            object = byteBuffer.asReadOnlyBuffer();
            ((Buffer)object).position(0).limit(messageBase.getSize());
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo((org.omg.CORBA.ORB)oRB, (ByteBuffer)object);
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        return messageBase;
    }

    private static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, int n2, boolean bl2, byte[] byArray, String string, ServiceContexts serviceContexts, Principal principal) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new RequestMessage_1_0(oRB, serviceContexts, n2, bl2, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new RequestMessage_1_1(oRB, serviceContexts, n2, bl2, new byte[]{0, 0, 0}, byArray, string, principal);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            byte by = 3;
            by = bl2 ? (byte)3 : 0;
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            return new RequestMessage_1_2(oRB, n2, by, new byte[]{0, 0, 0}, targetAddress, string, serviceContexts);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static RequestMessage createRequest(ORB oRB, GIOPVersion gIOPVersion, int n2, boolean bl2, IOR iOR, short s2, String string, ServiceContexts serviceContexts, Principal principal) {
        if (s2 == 0) {
            IIOPProfile iIOPProfile = iOR.getProfile();
            ObjectKey objectKey = iIOPProfile.getObjectKey();
            byte[] byArray = objectKey.getBytes(oRB);
            return MessageBase.createRequest(oRB, gIOPVersion, n2, bl2, byArray, string, serviceContexts, principal);
        }
        if (!gIOPVersion.equals(GIOPVersion.V1_2)) {
            throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
        }
        byte by = 3;
        by = bl2 ? (byte)3 : 0;
        TargetAddress targetAddress = new TargetAddress();
        if (s2 == 1) {
            IIOPProfile iIOPProfile = iOR.getProfile();
            targetAddress.profile(iIOPProfile.getIOPProfile());
        } else if (s2 == 2) {
            IORAddressingInfo iORAddressingInfo = new IORAddressingInfo(0, iOR.getIOPIOR());
            targetAddress.ior(iORAddressingInfo);
        } else {
            throw wrapper.illegalTargetAddressDisposition(CompletionStatus.COMPLETED_NO);
        }
        return new RequestMessage_1_2(oRB, n2, by, new byte[]{0, 0, 0}, targetAddress, string, serviceContexts);
    }

    public static ReplyMessage createReply(ORB oRB, GIOPVersion gIOPVersion, int n2, int n3, ServiceContexts serviceContexts, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new ReplyMessage_1_0(oRB, serviceContexts, n2, n3, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new ReplyMessage_1_1(oRB, serviceContexts, n2, n3, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new ReplyMessage_1_2(oRB, n2, n3, serviceContexts, iOR);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateRequestMessage createLocateRequest(ORB oRB, GIOPVersion gIOPVersion, int n2, byte[] byArray) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateRequestMessage_1_0(oRB, n2, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateRequestMessage_1_1(oRB, n2, byArray);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            TargetAddress targetAddress = new TargetAddress();
            targetAddress.object_key(byArray);
            return new LocateRequestMessage_1_2(oRB, n2, targetAddress);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static LocateReplyMessage createLocateReply(ORB oRB, GIOPVersion gIOPVersion, int n2, int n3, IOR iOR) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new LocateReplyMessage_1_0(oRB, n2, n3, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new LocateReplyMessage_1_1(oRB, n2, n3, iOR);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new LocateReplyMessage_1_2(oRB, n2, n3, iOR);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static CancelRequestMessage createCancelRequest(GIOPVersion gIOPVersion, int n2) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new CancelRequestMessage_1_0(n2);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new CancelRequestMessage_1_1(n2);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new CancelRequestMessage_1_2(n2);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createCloseConnection(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 5, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 5, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static Message createMessageError(GIOPVersion gIOPVersion) {
        if (gIOPVersion.equals(GIOPVersion.V1_0)) {
            return new Message_1_0(1195986768, false, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_1)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_1, 0, 6, 0);
        }
        if (gIOPVersion.equals(GIOPVersion.V1_2)) {
            return new Message_1_1(1195986768, GIOPVersion.V1_2, 0, 6, 0);
        }
        throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
    }

    public static FragmentMessage createFragmentMessage(GIOPVersion gIOPVersion) {
        return null;
    }

    public static int getRequestId(Message message) {
        switch (message.getType()) {
            case 0: {
                return ((RequestMessage)message).getRequestId();
            }
            case 1: {
                return ((ReplyMessage)message).getRequestId();
            }
            case 3: {
                return ((LocateRequestMessage)message).getRequestId();
            }
            case 4: {
                return ((LocateReplyMessage)message).getRequestId();
            }
            case 2: {
                return ((CancelRequestMessage)message).getRequestId();
            }
            case 7: {
                return ((FragmentMessage)message).getRequestId();
            }
        }
        throw wrapper.illegalGiopMsgType(CompletionStatus.COMPLETED_MAYBE);
    }

    public static void setFlag(ByteBuffer byteBuffer, int n2) {
        byte by = byteBuffer.get(6);
        by = (byte)(by | n2);
        byteBuffer.put(6, by);
    }

    public static void clearFlag(byte[] byArray, int n2) {
        byArray[6] = (byte)(byArray[6] & (0xFF ^ n2));
    }

    private static void AreFragmentsAllowed(byte by, byte by2, byte by3, byte by4) {
        if (by == 1 && by2 == 0 && by4 == 7) {
            throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
        }
        if ((by3 & 2) == 2) {
            switch (by4) {
                case 2: 
                case 5: 
                case 6: {
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
                case 3: 
                case 4: {
                    if (by != 1 || by2 != 1) break;
                    throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
                }
            }
        }
    }

    static ObjectKey extractObjectKey(byte[] byArray, ORB oRB) {
        try {
            ObjectKey objectKey;
            if (byArray != null && (objectKey = oRB.getObjectKeyFactory().create(byArray)) != null) {
                return objectKey;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw wrapper.invalidObjectKey();
    }

    static ObjectKey extractObjectKey(TargetAddress targetAddress, ORB oRB) {
        short s2 = oRB.getORBData().getGIOPTargetAddressPreference();
        short s3 = targetAddress.discriminator();
        switch (s2) {
            case 0: {
                if (s3 == 0) break;
                throw new AddressingDispositionException(0);
            }
            case 1: {
                if (s3 == 1) break;
                throw new AddressingDispositionException(1);
            }
            case 2: {
                if (s3 == 2) break;
                throw new AddressingDispositionException(2);
            }
            case 3: {
                break;
            }
            default: {
                throw wrapper.orbTargetAddrPreferenceInExtractObjectkeyInvalid();
            }
        }
        try {
            switch (s3) {
                case 0: {
                    byte[] byArray = targetAddress.object_key();
                    if (byArray == null) break;
                    ObjectKey objectKey = oRB.getObjectKeyFactory().create(byArray);
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
                case 1: {
                    IIOPProfile iIOPProfile = null;
                    TaggedProfile taggedProfile = targetAddress.profile();
                    if (taggedProfile == null) break;
                    iIOPProfile = IIOPFactories.makeIIOPProfile(oRB, taggedProfile);
                    ObjectKey objectKey = iIOPProfile.getObjectKey();
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
                case 2: {
                    IORAddressingInfo iORAddressingInfo = targetAddress.ior();
                    if (iORAddressingInfo == null) break;
                    TaggedProfile taggedProfile = iORAddressingInfo.ior.profiles[iORAddressingInfo.selected_profile_index];
                    IIOPProfile iIOPProfile = IIOPFactories.makeIIOPProfile(oRB, taggedProfile);
                    ObjectKey objectKey = iIOPProfile.getObjectKey();
                    if (objectKey != null) {
                        return objectKey;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw wrapper.invalidObjectKey();
    }

    private static int readSize(byte by, byte by2, byte by3, byte by4, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (!bl2) {
            n5 = by << 24 & 0xFF000000;
            n4 = by2 << 16 & 0xFF0000;
            n3 = by3 << 8 & 0xFF00;
            n2 = by4 << 0 & 0xFF;
        } else {
            n5 = by4 << 24 & 0xFF000000;
            n4 = by3 << 16 & 0xFF0000;
            n3 = by2 << 8 & 0xFF00;
            n2 = by << 0 & 0xFF;
        }
        return n5 | n4 | n3 | n2;
    }

    static void nullCheck(Object object) {
        if (object == null) {
            throw wrapper.nullNotAllowed();
        }
    }

    static SystemException getSystemException(String string, int n2, CompletionStatus completionStatus, String string2, ORBUtilSystemException oRBUtilSystemException) {
        SystemException systemException = null;
        try {
            Class clazz = ORBClassLoader.loadClass(string);
            if (string2 == null) {
                systemException = (SystemException)clazz.newInstance();
            } else {
                Class[] classArray = new Class[]{String.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{string2};
                systemException = (SystemException)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw oRBUtilSystemException.badSystemExceptionInReply(CompletionStatus.COMPLETED_MAYBE, exception);
        }
        systemException.minor = n2;
        systemException.completed = completionStatus;
        return systemException;
    }

    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    private static void dprint(String string) {
        ORBUtility.dprint("MessageBase", string);
    }
}

