/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.core.ServiceContexts;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_0;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class ReplyMessage_1_0
extends Message_1_0
implements ReplyMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private ServiceContexts service_contexts = null;
    private int request_id = 0;
    private int reply_status = 0;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;

    ReplyMessage_1_0(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
    }

    ReplyMessage_1_0(ORB oRB, ServiceContexts serviceContexts, int n2, int n3, IOR iOR) {
        super(1195986768, false, (byte)1, 0);
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.service_contexts = serviceContexts;
        this.request_id = n2;
        this.reply_status = n3;
        this.ior = iOR;
    }

    public int getRequestId() {
        return this.request_id;
    }

    public int getReplyStatus() {
        return this.reply_status;
    }

    public short getAddrDisposition() {
        return 0;
    }

    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    public void setServiceContexts(ServiceContexts serviceContexts) {
        this.service_contexts = serviceContexts;
    }

    public SystemException getSystemException(String string) {
        return MessageBase.getSystemException(this.exClassName, this.minorCode, this.completionStatus, string, this.wrapper);
    }

    public IOR getIOR() {
        return this.ior;
    }

    public void setIOR(IOR iOR) {
        this.ior = iOR;
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) {
        super.read(inputStream);
        this.service_contexts = new ServiceContexts((InputStream)inputStream);
        this.request_id = inputStream.read_ulong();
        this.reply_status = inputStream.read_long();
        ReplyMessage_1_0.isValidReplyStatus(this.reply_status);
        if (this.reply_status == 2) {
            String string = inputStream.read_string();
            this.exClassName = ORBUtility.classNameOf(string);
            this.minorCode = inputStream.read_long();
            int n2 = inputStream.read_long();
            switch (n2) {
                case 0: {
                    this.completionStatus = CompletionStatus.COMPLETED_YES;
                    break;
                }
                case 1: {
                    this.completionStatus = CompletionStatus.COMPLETED_NO;
                    break;
                }
                case 2: {
                    this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                    break;
                }
                default: {
                    throw this.wrapper.badCompletionStatusInReply(CompletionStatus.COMPLETED_MAYBE, (Object)new Integer(n2));
                }
            }
        } else if (this.reply_status != 1 && this.reply_status == 3) {
            CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
            this.ior = IORFactories.makeIOR(cDRInputStream);
        }
    }

    public void write(org.omg.CORBA.portable.OutputStream outputStream) {
        super.write(outputStream);
        if (this.service_contexts != null) {
            this.service_contexts.write((OutputStream)outputStream, GIOPVersion.V1_0);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        outputStream.write_ulong(this.request_id);
        outputStream.write_long(this.reply_status);
    }

    public static void isValidReplyStatus(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("rpc.protocol");
                throw oRBUtilSystemException.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }
}

