/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.core.ServiceContexts;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.CDROutputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_2;
import com.sun.corba.se.impl.protocol.giopmsgheaders.RequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.TargetAddress;
import com.sun.corba.se.impl.protocol.giopmsgheaders.TargetAddressHelper;
import com.sun.corba.se.spi.ior.ObjectKey;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Principal;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class RequestMessage_1_2
extends Message_1_2
implements RequestMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private byte response_flags = 0;
    private byte[] reserved = null;
    private TargetAddress target = null;
    private String operation = null;
    private ServiceContexts service_contexts = null;
    private ObjectKey objectKey = null;

    RequestMessage_1_2(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
    }

    RequestMessage_1_2(ORB oRB, int n2, byte by, byte[] byArray, TargetAddress targetAddress, String string, ServiceContexts serviceContexts) {
        super(1195986768, GIOPVersion.V1_2, (byte)0, (byte)0, 0);
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.request_id = n2;
        this.response_flags = by;
        this.reserved = byArray;
        this.target = targetAddress;
        this.operation = string;
        this.service_contexts = serviceContexts;
    }

    public int getRequestId() {
        return this.request_id;
    }

    public boolean isResponseExpected() {
        return (this.response_flags & 1) == 1;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public ObjectKey getObjectKey() {
        if (this.objectKey == null) {
            this.objectKey = MessageBase.extractObjectKey(this.target, this.orb);
        }
        return this.objectKey;
    }

    public String getOperation() {
        return this.operation;
    }

    public Principal getPrincipal() {
        return null;
    }

    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    public void read(org.omg.CORBA.portable.InputStream inputStream) {
        super.read(inputStream);
        this.request_id = inputStream.read_ulong();
        this.response_flags = inputStream.read_octet();
        this.reserved = new byte[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            this.reserved[i2] = inputStream.read_octet();
        }
        this.target = TargetAddressHelper.read(inputStream);
        this.getObjectKey();
        this.operation = inputStream.read_string();
        this.service_contexts = new ServiceContexts((InputStream)inputStream);
        ((CDRInputStream)inputStream).setHeaderPadding(true);
    }

    public void write(org.omg.CORBA.portable.OutputStream outputStream) {
        super.write(outputStream);
        outputStream.write_ulong(this.request_id);
        outputStream.write_octet(this.response_flags);
        RequestMessage_1_2.nullCheck(this.reserved);
        if (this.reserved.length != 3) {
            throw this.wrapper.badReservedLength(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            outputStream.write_octet(this.reserved[i2]);
        }
        RequestMessage_1_2.nullCheck(this.target);
        TargetAddressHelper.write(outputStream, this.target);
        outputStream.write_string(this.operation);
        if (this.service_contexts != null) {
            this.service_contexts.write((OutputStream)outputStream, GIOPVersion.V1_2);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        ((CDROutputStream)outputStream).setHeaderPadding(true);
    }

    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }
}

