/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.pept.transport.ByteBufferPool;
import com.sun.corba.se.spi.orb.ORB;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBufferPoolImpl
implements ByteBufferPool {
    private ORB itsOrb;
    private int itsByteBufferSize;
    private ArrayList itsPool;
    private int itsObjectCounter = 0;
    private boolean debug;

    public ByteBufferPoolImpl(ORB oRB) {
        this.itsByteBufferSize = oRB.getORBData().getGIOPFragmentSize();
        this.itsPool = new ArrayList();
        this.itsOrb = oRB;
        this.debug = oRB.transportDebugFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer(int n2) {
        ByteBuffer byteBuffer = null;
        if (n2 <= this.itsByteBufferSize) {
            int n3;
            ArrayList arrayList = this.itsPool;
            synchronized (arrayList) {
                n3 = this.itsPool.size();
                if (n3 > 0) {
                    byteBuffer = (ByteBuffer)this.itsPool.remove(n3 - 1);
                    byteBuffer.clear();
                }
            }
            if (n3 <= 0) {
                byteBuffer = ByteBuffer.allocateDirect(this.itsByteBufferSize);
            }
            ++this.itsObjectCounter;
        } else {
            byteBuffer = ByteBuffer.allocate(n2);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            ArrayList arrayList = this.itsPool;
            synchronized (arrayList) {
                Object object;
                boolean bl2 = false;
                int n2 = 0;
                if (this.debug) {
                    for (int i2 = 0; i2 < this.itsPool.size() && !bl2; ++i2) {
                        object = (ByteBuffer)this.itsPool.get(i2);
                        if (byteBuffer != object) continue;
                        bl2 = true;
                        n2 = System.identityHashCode(byteBuffer);
                    }
                }
                if (!bl2 || !this.debug) {
                    this.itsPool.add(byteBuffer);
                } else {
                    String string = Thread.currentThread().getName();
                    object = new Throwable(string + ": Duplicate ByteBuffer reference (" + n2 + ")");
                    ((Throwable)object).printStackTrace(System.out);
                }
            }
            --this.itsObjectCounter;
        } else {
            byteBuffer = null;
        }
    }

    public int activeCount() {
        return this.itsObjectCounter;
    }
}

