/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.se.impl.protocol.NotLocalLocalCRDImpl;
import com.sun.corba.se.impl.transport.CorbaContactInfoListIteratorImpl;
import com.sun.corba.se.impl.transport.SharedCDRContactInfoImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.IIOPAddress;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
import com.sun.corba.se.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CorbaContactInfoListImpl
implements CorbaContactInfoList {
    protected ORB orb;
    protected LocalClientRequestDispatcher LocalClientRequestDispatcher;
    protected IOR targetIOR;
    protected IOR effectiveTargetIOR;
    protected List effectiveTargetIORContactInfoList;
    protected long effectiveTargetIORTimestamp;
    protected boolean isCachedHashValue = false;
    protected int cachedHashValue;

    public CorbaContactInfoListImpl(ORB oRB) {
        this.orb = oRB;
        this.effectiveTargetIORTimestamp = 0L;
    }

    public CorbaContactInfoListImpl(ORB oRB, IOR iOR) {
        this(oRB);
        this.setTargetIOR(iOR);
    }

    public synchronized Iterator iterator() {
        this.createContactInfoList();
        return new CorbaContactInfoListIteratorImpl(this.orb, this, this.effectiveTargetIORContactInfoList.iterator());
    }

    public synchronized void setTargetIOR(IOR iOR) {
        this.targetIOR = iOR;
        this.setEffectiveTargetIOR(iOR);
        this.isCachedHashValue = false;
    }

    public synchronized IOR getTargetIOR() {
        return this.targetIOR;
    }

    public synchronized void setEffectiveTargetIOR(IOR iOR) {
        this.effectiveTargetIOR = iOR;
        this.effectiveTargetIORContactInfoList = null;
        this.setLocalSubcontract();
        ++this.effectiveTargetIORTimestamp;
    }

    public synchronized IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    public synchronized long getEffectiveTargetIORTimestamp() {
        return this.effectiveTargetIORTimestamp;
    }

    public synchronized LocalClientRequestDispatcher getLocalClientRequestDispatcher() {
        return this.LocalClientRequestDispatcher;
    }

    public synchronized int hashCode() {
        if (!this.isCachedHashValue) {
            this.cachedHashValue = this.targetIOR.stringify().hashCode();
            this.isCachedHashValue = true;
        }
        return this.cachedHashValue;
    }

    protected void createContactInfoList() {
        if (this.effectiveTargetIORContactInfoList != null) {
            return;
        }
        this.effectiveTargetIORContactInfoList = new ArrayList();
        IIOPProfile iIOPProfile = this.effectiveTargetIOR.getProfile();
        if (iIOPProfile.isLocal()) {
            SharedCDRContactInfoImpl sharedCDRContactInfoImpl = new SharedCDRContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition());
            this.effectiveTargetIORContactInfoList.add(sharedCDRContactInfoImpl);
        } else {
            this.addRemoteContactInfos(iIOPProfile, this.effectiveTargetIORContactInfoList);
        }
    }

    protected void addRemoteContactInfos(IIOPProfile iIOPProfile, List list) {
        IIOPProfileTemplate iIOPProfileTemplate = (IIOPProfileTemplate)iIOPProfile.getTaggedProfileTemplate();
        IIOPAddress iIOPAddress = iIOPProfileTemplate.getPrimaryAddress();
        String string = iIOPAddress.getHost().toLowerCase();
        int n2 = iIOPAddress.getPort();
        ContactInfo contactInfo = this.createContactInfo(string, n2);
        list.add(contactInfo);
        Iterator iterator = iIOPProfileTemplate.iteratorById(3);
        while (iterator.hasNext()) {
            AlternateIIOPAddressComponent alternateIIOPAddressComponent = (AlternateIIOPAddressComponent)iterator.next();
            string = alternateIIOPAddressComponent.getAddress().getHost().toLowerCase();
            n2 = alternateIIOPAddressComponent.getAddress().getPort();
            contactInfo = this.createContactInfo(string, n2);
            list.add(contactInfo);
        }
    }

    protected ContactInfo createContactInfo(String string, int n2) {
        return new SocketOrChannelContactInfoImpl(this.orb, this, this.effectiveTargetIOR, this.orb.getORBData().getGIOPAddressDisposition(), string, n2);
    }

    protected void setLocalSubcontract() {
        if (!this.effectiveTargetIOR.getProfile().isLocal()) {
            this.LocalClientRequestDispatcher = new NotLocalLocalCRDImpl();
            return;
        }
        int n2 = this.effectiveTargetIOR.getProfile().getObjectKeyTemplate().getSubcontractId();
        LocalClientRequestDispatcherFactory localClientRequestDispatcherFactory = this.orb.getRequestDispatcherRegistry().getLocalClientRequestDispatcherFactory(n2);
        this.LocalClientRequestDispatcher = localClientRequestDispatcherFactory.create(n2, this.effectiveTargetIOR);
    }
}

