/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.ContactInfoList;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import com.sun.corba.se.spi.transport.CorbaContactInfoListIterator;
import java.util.Iterator;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaContactInfoListIteratorImpl
implements CorbaContactInfoListIterator {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected CorbaContactInfo successContactInfo;
    protected CorbaContactInfo failureContactInfo;
    protected RuntimeException failureException;
    protected Iterator effectiveTargetIORIterator;
    protected Object previousContactInfo;
    protected boolean isAddrDispositionRetry;

    public CorbaContactInfoListIteratorImpl(ORB oRB, CorbaContactInfoList corbaContactInfoList, Iterator iterator) {
        this.orb = oRB;
        this.contactInfoList = corbaContactInfoList;
        this.effectiveTargetIORIterator = iterator;
        this.previousContactInfo = null;
        this.isAddrDispositionRetry = false;
        this.successContactInfo = null;
        this.failureContactInfo = null;
        this.failureException = null;
    }

    public boolean hasNext() {
        if (this.isAddrDispositionRetry) {
            return true;
        }
        return this.effectiveTargetIORIterator.hasNext();
    }

    public Object next() {
        if (this.isAddrDispositionRetry) {
            this.isAddrDispositionRetry = false;
            return this.previousContactInfo;
        }
        this.previousContactInfo = this.effectiveTargetIORIterator.next();
        return this.previousContactInfo;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public void reportSuccess(ContactInfo contactInfo) {
        this.successContactInfo = (CorbaContactInfo)contactInfo;
    }

    public boolean reportException(ContactInfo contactInfo, RuntimeException runtimeException) {
        this.failureContactInfo = (CorbaContactInfo)contactInfo;
        this.failureException = runtimeException;
        if (runtimeException instanceof COMM_FAILURE) {
            SystemException systemException = (SystemException)runtimeException;
            if (systemException.completed == CompletionStatus.COMPLETED_NO) {
                if (this.hasNext()) {
                    return true;
                }
                if (this.contactInfoList.getEffectiveTargetIOR() != this.contactInfoList.getTargetIOR()) {
                    this.updateEffectiveTargetIOR(this.contactInfoList.getTargetIOR());
                    return true;
                }
            }
        }
        return false;
    }

    public RuntimeException getFailureException() {
        if (this.failureException == null) {
            return ORBUtilSystemException.get(this.orb, "rpc.transport").invalidContactInfoListIteratorFailureException();
        }
        return this.failureException;
    }

    public void reportAddrDispositionRetry(CorbaContactInfo corbaContactInfo, short s2) {
        ((CorbaContactInfo)this.previousContactInfo).setAddressingDisposition(s2);
        this.isAddrDispositionRetry = true;
    }

    public void reportRedirect(CorbaContactInfo corbaContactInfo, IOR iOR) {
        this.updateEffectiveTargetIOR(iOR);
    }

    public void updateEffectiveTargetIOR(IOR iOR) {
        this.contactInfoList.setEffectiveTargetIOR(iOR);
        ((CorbaInvocationInfo)this.orb.getInvocationInfo()).setContactInfoListIterator(this.contactInfoList.iterator());
    }
}

