/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import java.util.Collection;
import java.util.Hashtable;

public class CorbaOutboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements OutboundConnectionCache {
    protected Hashtable connectionCache = new Hashtable();

    public CorbaOutboundConnectionCacheImpl(ORB oRB, ContactInfo contactInfo) {
        super(oRB, contactInfo.getConnectionCacheType(), ((CorbaContactInfo)contactInfo).getMonitoringName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection get(ContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".get: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.dprintStatistics();
            return (Connection)this.connectionCache.get(contactInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ContactInfo contactInfo, Connection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + contactInfo + " " + ((Object)contactInfo).hashCode() + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.put(contactInfo, connection);
            connection.setConnectionCache(this);
            this.dprintStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ContactInfo contactInfo) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + contactInfo + " " + ((Object)contactInfo).hashCode());
        }
        Object object = this.backingStore();
        synchronized (object) {
            if (contactInfo != null) {
                this.connectionCache.remove(contactInfo);
            }
            this.dprintStatistics();
        }
    }

    protected Collection values() {
        return this.connectionCache.values();
    }

    protected Object backingStore() {
        return this.connectionCache;
    }

    protected void registerWithMonitoring() {
        MonitoredObject monitoredObject;
        MonitoredObject monitoredObject2;
        MonitoredObject monitoredObject3 = this.orb.getMonitoringManager().getRootMonitoredObject();
        MonitoredObject monitoredObject4 = monitoredObject3.getChild("Connections");
        if (monitoredObject4 == null) {
            monitoredObject4 = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Connections", "Statistics on inbound/outbound connections");
            monitoredObject3.addChild(monitoredObject4);
        }
        if ((monitoredObject2 = monitoredObject4.getChild("Outbound")) == null) {
            monitoredObject2 = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Outbound", "Statistics on outbound connections");
            monitoredObject4.addChild(monitoredObject2);
        }
        if ((monitoredObject = monitoredObject2.getChild(this.getMonitoringName())) == null) {
            monitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.getMonitoringName(), "Connection statistics");
            monitoredObject2.addChild(monitoredObject);
        }
        LongMonitoredAttributeBase longMonitoredAttributeBase = new LongMonitoredAttributeBase("NumberOfConnections", "The total number of connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfConnections());
            }
        };
        monitoredObject.addAttribute(longMonitoredAttributeBase);
        longMonitoredAttributeBase = new LongMonitoredAttributeBase("NumberOfIdleConnections", "The number of idle connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfIdleConnections());
            }
        };
        monitoredObject.addAttribute(longMonitoredAttributeBase);
        longMonitoredAttributeBase = new LongMonitoredAttributeBase("NumberOfBusyConnections", "The number of busy connections"){

            public Object getValue() {
                return new Long(CorbaOutboundConnectionCacheImpl.this.numberOfBusyConnections());
            }
        };
        monitoredObject.addAttribute(longMonitoredAttributeBase);
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaOutboundConnectionCacheImpl", string);
    }
}

