/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.encoding.CachedCodeBase;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.CancelRequestMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.transport.CorbaResponseWaitingRoomImpl;
import com.sun.corba.se.impl.transport.EventHandlerBase;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.EventHandler;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.pept.transport.ResponseWaitingRoom;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaResponseWaitingRoom;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public class SocketOrChannelConnectionImpl
extends EventHandlerBase
implements CorbaConnection,
Work {
    public static boolean dprintWriteLocks = false;
    protected long enqueueTime;
    protected SocketChannel socketChannel;
    protected CorbaContactInfo contactInfo;
    protected Acceptor acceptor;
    protected ConnectionCache connectionCache;
    protected Socket socket;
    protected long timeStamp = 0L;
    protected boolean isServer = false;
    protected int requestId = 5;
    protected CorbaResponseWaitingRoom responseWaitingRoom;
    protected int state;
    protected Object stateEvent = new Object();
    protected Object writeEvent = new Object();
    protected boolean writeLocked;
    protected int serverRequestCount = 0;
    Map serverRequestMap = null;
    protected boolean postInitialContexts = false;
    protected IOR codeBaseServerIOR;
    protected CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    protected ORBUtilSystemException wrapper;
    protected CodeSetComponentInfo.CodeSetContext codeSetContext = null;
    protected MessageMediator clientReply_1_1;
    protected MessageMediator serverRequest_1_1;

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    protected SocketOrChannelConnectionImpl(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.setWork(this);
        this.responseWaitingRoom = new CorbaResponseWaitingRoomImpl(oRB, this);
    }

    protected SocketOrChannelConnectionImpl(ORB oRB, boolean bl2, boolean bl3) {
        this(oRB);
        this.setUseSelectThreadToWait(bl2);
        this.setUseWorkerThreadForEvent(bl3);
    }

    public SocketOrChannelConnectionImpl(ORB oRB, CorbaContactInfo corbaContactInfo, String string, boolean bl2, boolean bl3, String string2, int n2) {
        this(oRB, bl2, bl3);
        this.contactInfo = corbaContactInfo;
        try {
            if (string.equals("SocketChannel")) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string2, n2);
                this.socketChannel = SocketChannel.open(inetSocketAddress);
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = new Socket(string2, n2);
            }
            this.setSocketOptions(this.socket);
            if (this.socketChannel != null) {
                boolean bl4 = !bl2;
                this.socketChannel.configureBlocking(bl4);
            } else {
                this.setUseSelectThreadToWait(false);
            }
            if (oRB.transportDebugFlag) {
                this.dprint(".initialize: connection created: " + this.socket);
            }
        }
        catch (Throwable throwable) {
            throw this.wrapper.connectFailure(throwable);
        }
        this.state = 1;
    }

    public SocketOrChannelConnectionImpl(ORB oRB, CorbaContactInfo corbaContactInfo, String string, int n2) {
        this(oRB, corbaContactInfo, oRB.getORBData().connectionSocketType(), oRB.getORBData().connectionSocketUseSelectThreadToWait(), oRB.getORBData().connectionSocketUseWorkerThreadForEvent(), string, n2);
    }

    public SocketOrChannelConnectionImpl(ORB oRB, Acceptor acceptor, Socket socket, boolean bl2, boolean bl3) {
        this(oRB, bl2, bl3);
        this.socket = socket;
        this.socketChannel = socket.getChannel();
        if (this.socketChannel != null) {
            try {
                boolean bl4 = !bl2;
                this.socketChannel.configureBlocking(bl4);
            }
            catch (IOException iOException) {
                RuntimeException runtimeException = new RuntimeException();
                runtimeException.initCause(iOException);
                throw runtimeException;
            }
        }
        this.acceptor = acceptor;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.isServer = true;
        this.state = 2;
    }

    public SocketOrChannelConnectionImpl(ORB oRB, Acceptor acceptor, Socket socket) {
        this(oRB, acceptor, socket, socket.getChannel() == null ? false : oRB.getORBData().connectionSocketUseSelectThreadToWait(), socket.getChannel() == null ? false : oRB.getORBData().connectionSocketUseWorkerThreadForEvent());
    }

    public boolean shouldRegisterReadEvent() {
        return true;
    }

    public boolean shouldRegisterServerReadEvent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        try {
            CorbaMessageMediator corbaMessageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".read->: " + this);
            }
            if ((corbaMessageMediator = this.readBits()) != null) {
                boolean bl2 = this.dispatch(corbaMessageMediator);
                return bl2;
            }
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".read<-: " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CorbaMessageMediator readBits() {
        try {
            MessageMediator messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits->: " + this);
            }
            if (this.contactInfo != null) {
                messageMediator = this.contactInfo.createMessageMediator(this.orb, this);
            } else if (this.acceptor != null) {
                messageMediator = this.acceptor.createMessageMediator(this.orb, this);
            } else {
                throw new RuntimeException("SocketOrChannelConnectionImpl.readReadBits");
            }
            CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
            return corbaMessageMediator;
        }
        catch (ThreadDeath threadDeath) {
            block19: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": ThreadDeath: " + threadDeath, threadDeath);
                }
                try {
                    this.purgeCalls(this.wrapper.connectionAbort(threadDeath), false, false);
                }
                catch (Throwable throwable) {
                    if (!this.orb.transportDebugFlag) break block19;
                    this.dprint(".readBits: " + this + ": purgeCalls: Throwable: " + throwable, throwable);
                }
            }
            throw threadDeath;
        }
        catch (Throwable throwable) {
            block20: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".readBits: " + this + ": Throwable: " + throwable, throwable);
                }
                try {
                    if (throwable instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException iOException) {
                    if (!this.orb.transportDebugFlag) break block20;
                    this.dprint(".readBits: " + this + ": sendMessageError: IOException: " + iOException, iOException);
                }
            }
            this.orb.getTransportManager().getSelector(0).unregisterForEvent(this);
            this.purgeCalls(this.wrapper.connectionAbort(throwable), true, false);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".readBits<-: " + this);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatch(CorbaMessageMediator corbaMessageMediator) {
        try {
            boolean bl2;
            if (this.orb.transportDebugFlag) {
                this.dprint(".dispatch->: " + this);
            }
            boolean bl3 = bl2 = corbaMessageMediator.getProtocolHandler().handleRequest(corbaMessageMediator);
            return bl3;
        }
        catch (ThreadDeath threadDeath) {
            block15: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".dispatch: ThreadDeath", threadDeath);
                }
                try {
                    this.purgeCalls(this.wrapper.connectionAbort(threadDeath), false, false);
                }
                catch (Throwable throwable) {
                    if (!this.orb.transportDebugFlag) break block15;
                    this.dprint(".dispatch: purgeCalls: Throwable", throwable);
                }
            }
            throw threadDeath;
        }
        catch (Throwable throwable) {
            block16: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".dispatch: Throwable", throwable);
                }
                try {
                    if (throwable instanceof INTERNAL) {
                        this.sendMessageError(GIOPVersion.DEFAULT_VERSION);
                    }
                }
                catch (IOException iOException) {
                    if (!this.orb.transportDebugFlag) break block16;
                    this.dprint(".dispatch: sendMessageError: IOException", iOException);
                }
            }
            this.purgeCalls(this.wrapper.connectionAbort(throwable), false, false);
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".dispatch<-: " + this);
            }
        }
        return true;
    }

    public boolean shouldUseDirectByteBuffers() {
        return this.getSocketChannel() != null;
    }

    public ByteBuffer read(int n2, int n3, int n4) throws IOException {
        if (this.shouldUseDirectByteBuffers()) {
            ByteBuffer byteBuffer = this.orb.getByteBufferPool().getByteBuffer(n2);
            if (this.orb.transportDebugFlag) {
                int n5 = System.identityHashCode(byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append(".read: got ByteBuffer id (");
                stringBuffer.append(n5).append(") from ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            byteBuffer.position(n3);
            byteBuffer.limit(n2);
            this.readFully(byteBuffer, n4);
            return byteBuffer;
        }
        byte[] byArray = new byte[n2];
        this.readFully(this.getSocket().getInputStream(), byArray, n3, n4);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.limit(n2);
        return byteBuffer;
    }

    public ByteBuffer read(ByteBuffer byteBuffer, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        if (this.shouldUseDirectByteBuffers()) {
            if (!byteBuffer.isDirect()) {
                throw this.wrapper.unexpectedNonDirectByteBufferWithChannelSocket();
            }
            if (n4 > byteBuffer.capacity()) {
                if (this.orb.transportDebugFlag) {
                    int n5 = System.identityHashCode(byteBuffer);
                    StringBuffer stringBuffer = new StringBuffer(80);
                    stringBuffer.append(".read: releasing ByteBuffer id (").append(n5).append(") to ByteBufferPool.");
                    String string = stringBuffer.toString();
                    this.dprint(string);
                }
                this.orb.getByteBufferPool().releaseByteBuffer(byteBuffer);
                byteBuffer = this.orb.getByteBufferPool().getByteBuffer(n4);
            }
            byteBuffer.position(n2);
            byteBuffer.limit(n4);
            this.readFully(byteBuffer, n3);
            byteBuffer.position(0);
            byteBuffer.limit(n4);
            return byteBuffer;
        }
        if (byteBuffer.isDirect()) {
            throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
        }
        byte[] byArray = new byte[n4];
        this.readFully(this.getSocket().getInputStream(), byArray, n2, n3);
        return ByteBuffer.wrap(byArray);
    }

    public void readFully(ByteBuffer byteBuffer, int n2) throws IOException {
        int n3;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = 0;
            boolean bl2 = false;
            n3 = this.getSocketChannel().read(byteBuffer);
            if (n3 >= 0) continue;
            throw new IOException("End-of-stream");
        }
        this.getConnectionCache().stampTime(this);
    }

    public void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = 0;
            boolean bl2 = false;
            n4 = inputStream.read(byArray, n2 + i2, n3 - i2);
            if (n4 >= 0) continue;
            throw new IOException();
        }
        this.getConnectionCache().stampTime(this);
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        if (this.shouldUseDirectByteBuffers()) {
            do {
                this.getSocketChannel().write(byteBuffer);
            } while (byteBuffer.hasRemaining());
        } else {
            if (!byteBuffer.hasArray()) {
                throw this.wrapper.unexpectedDirectByteBufferWithNonChannelSocket();
            }
            byte[] byArray = byteBuffer.array();
            this.getSocket().getOutputStream().write(byArray, 0, byteBuffer.limit());
            this.getSocket().getOutputStream().flush();
        }
        this.getConnectionCache().stampTime(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        try {
            Object object;
            block19: {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".close->: " + this);
                }
                this.writeLock();
                if (this.isBusy()) {
                    this.writeUnlock();
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".close: isBusy so no close: " + this);
                    }
                    return;
                }
                try {
                    try {
                        this.sendCloseConnection(GIOPVersion.V1_0);
                    }
                    catch (Throwable throwable) {
                        this.wrapper.exceptionWhenSendingCloseConnection(throwable);
                    }
                    object = this.stateEvent;
                    synchronized (object) {
                        this.state = 3;
                        this.stateEvent.notifyAll();
                    }
                    this.purgeCalls(this.wrapper.connectionRebind(), false, true);
                }
                catch (Exception exception) {
                    if (!this.orb.transportDebugFlag) break block19;
                    this.dprint(".close: exception: " + this, exception);
                }
            }
            try {
                object = this.orb.getTransportManager().getSelector(0);
                object.unregisterForEvent(this);
                if (this.socketChannel != null) {
                    this.socketChannel.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".close: " + this, iOException);
                }
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".close<-: " + this);
            }
        }
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public EventHandler getEventHandler() {
        return this;
    }

    public OutputObject createOutputObject(MessageMediator messageMediator) {
        throw new RuntimeException("*****SocketOrChannelConnectionImpl.createOutputObject - should not be called.");
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isBusy() {
        return this.serverRequestCount > 0 || this.getResponseWaitingRoom().numberRegistered() > 0;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long l2) {
        this.timeStamp = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(String string) {
        Object object = this.stateEvent;
        synchronized (object) {
            if (string.equals("ESTABLISHED")) {
                this.state = 2;
                this.stateEvent.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void writeLock() {
        try {
            if (SocketOrChannelConnectionImpl.dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeLock->: " + this);
            }
            block23: while (true) {
                var1_1 = this.state;
                switch (var1_1) {
                    case 1: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state != 1) {
                            // MONITOREXIT : var2_2
                            continue block23;
                        }
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException var3_4) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl19
                            this.dprint(".writeLock: OPENING InterruptedException: " + this);
                        }
lbl19:
                        // 3 sources

                        continue block23;
                    }
                    case 2: {
                        var2_2 = this.writeEvent;
                        // MONITORENTER : var2_2
                        if (!this.writeLocked) {
                            this.writeLocked = true;
                            // MONITOREXIT : var2_2
                            return;
                        }
                        try {
                            while (this.state == 2 && this.writeLocked) {
                                this.writeEvent.wait(100L);
                            }
                        }
                        catch (InterruptedException var3_5) {
                            if (!this.orb.transportDebugFlag) ** GOTO lbl36
                            this.dprint(".writeLock: ESTABLISHED InterruptedException: " + this);
                        }
lbl36:
                        // 3 sources

                        continue block23;
                    }
                    case 5: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 5) throw this.wrapper.writeErrorSend();
                        // MONITOREXIT : var2_2
                        continue block23;
                    }
                    case 4: {
                        var2_2 = this.stateEvent;
                        // MONITORENTER : var2_2
                        if (this.state == 4) throw this.wrapper.connectionCloseRebind();
                        // MONITOREXIT : var2_2
                        continue block23;
                    }
                }
                if (this.orb.transportDebugFlag == false) throw new RuntimeException(".writeLock: bad state");
                this.dprint(".writeLock: default: " + this);
                throw new RuntimeException(".writeLock: bad state");
            }
        }
        finally {
            if (SocketOrChannelConnectionImpl.dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeLock<-: " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnlock() {
        try {
            if (dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeUnlock->: " + this);
            }
            Object object = this.writeEvent;
            synchronized (object) {
                this.writeLocked = false;
                this.writeEvent.notify();
            }
        }
        finally {
            if (dprintWriteLocks && this.orb.transportDebugFlag) {
                this.dprint(".writeUnlock<-: " + this);
            }
        }
    }

    public void sendWithoutLock(OutputObject outputObject) {
        try {
            CDROutputObject cDROutputObject = (CDROutputObject)outputObject;
            cDROutputObject.writeTo(this);
        }
        catch (IOException iOException) {
            throw this.wrapper.writeErrorSend(iOException);
        }
    }

    public void registerWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.registerWaiter(messageMediator);
    }

    public void unregisterWaiter(MessageMediator messageMediator) {
        this.responseWaitingRoom.unregisterWaiter(messageMediator);
    }

    public InputObject waitForResponse(MessageMediator messageMediator) {
        return this.responseWaitingRoom.waitForResponse(messageMediator);
    }

    public void setConnectionCache(ConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    public SelectableChannel getChannel() {
        return this.socketChannel;
    }

    public int getInterestOps() {
        return 1;
    }

    public Connection getConnection() {
        return this;
    }

    public String getName() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        try {
            CorbaMessageMediator corbaMessageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork->: " + this);
            }
            if ((corbaMessageMediator = this.readBits()) != null) {
                this.dispatch(corbaMessageMediator);
            }
        }
        catch (Throwable throwable) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork: ignoring Throwable: " + throwable + " " + this);
            }
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".doWork<-: " + this);
            }
        }
    }

    public void setEnqueueTime(long l2) {
        this.enqueueTime = l2;
    }

    public long getEnqueueTime() {
        return this.enqueueTime;
    }

    public ResponseWaitingRoom getResponseWaitingRoom() {
        return this.responseWaitingRoom;
    }

    public void serverRequestMapPut(int n2, CorbaMessageMediator corbaMessageMediator) {
        this.serverRequestMap.put(new Integer(n2), corbaMessageMediator);
    }

    public CorbaMessageMediator serverRequestMapGet(int n2) {
        return (CorbaMessageMediator)this.serverRequestMap.get(new Integer(n2));
    }

    public void serverRequestMapRemove(int n2) {
        this.serverRequestMap.remove(new Integer(n2));
    }

    public Socket getSocket() {
        return this.socket;
    }

    public synchronized void serverRequestProcessingBegins() {
        ++this.serverRequestCount;
    }

    public synchronized void serverRequestProcessingEnds() {
        --this.serverRequestCount;
    }

    public synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public ORB getBroker() {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeSetComponentInfo.CodeSetContext getCodeSetContext() {
        if (this.codeSetContext == null) {
            SocketOrChannelConnectionImpl socketOrChannelConnectionImpl = this;
            synchronized (socketOrChannelConnectionImpl) {
                return this.codeSetContext;
            }
        }
        return this.codeSetContext;
    }

    public synchronized void setCodeSetContext(CodeSetComponentInfo.CodeSetContext codeSetContext) {
        if (this.codeSetContext == null) {
            if (OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet()) == null || OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet()) == null) {
                throw this.wrapper.badCodesetsFromClient();
            }
            this.codeSetContext = codeSetContext;
        }
    }

    public MessageMediator clientRequestMapGet(int n2) {
        return this.responseWaitingRoom.getMessageMediator(n2);
    }

    public void clientReply_1_1_Put(MessageMediator messageMediator) {
        this.clientReply_1_1 = messageMediator;
    }

    public MessageMediator clientReply_1_1_Get() {
        return this.clientReply_1_1;
    }

    public void clientReply_1_1_Remove() {
        this.clientReply_1_1 = null;
    }

    public void serverRequest_1_1_Put(MessageMediator messageMediator) {
        this.serverRequest_1_1 = messageMediator;
    }

    public MessageMediator serverRequest_1_1_Get() {
        return this.serverRequest_1_1;
    }

    public void serverRequest_1_1_Remove() {
        this.serverRequest_1_1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStateString(int n2) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (n2) {
                case 1: {
                    return "OPENING";
                }
                case 2: {
                    return "ESTABLISHED";
                }
                case 3: {
                    return "CLOSE_SENT";
                }
                case 4: {
                    return "CLOSE_RECVD";
                }
                case 5: {
                    return "ABORT";
                }
            }
            return "???";
        }
    }

    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void purgeCalls(SystemException systemException, boolean bl2, boolean bl3) {
        int n2 = systemException.minor;
        try {
            block23: {
                block22: {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".purgeCalls->: " + n2 + "/" + bl2 + "/" + bl3 + " " + this);
                    }
                    Object object = this.stateEvent;
                    synchronized (object) {
                        if (this.state == 5 || this.state == 4) {
                            if (!this.orb.transportDebugFlag) return;
                            this.dprint(".purgeCalls: exiting since state is: " + this.getStateString(this.state) + " " + this);
                            return;
                        }
                    }
                    try {
                        if (!bl3) {
                            this.writeLock();
                        }
                    }
                    catch (SystemException systemException2) {
                        if (!this.orb.transportDebugFlag) break block22;
                        this.dprint(".purgeCalls: SystemException" + systemException2 + "; continuing " + this);
                    }
                }
                Object object = this.stateEvent;
                synchronized (object) {
                    if (n2 == 1398079697) {
                        this.state = 4;
                        systemException.completed = CompletionStatus.COMPLETED_NO;
                    } else {
                        this.state = 5;
                        systemException.completed = CompletionStatus.COMPLETED_MAYBE;
                    }
                    this.stateEvent.notifyAll();
                }
                try {
                    this.socket.getInputStream().close();
                    this.socket.getOutputStream().close();
                    this.socket.close();
                }
                catch (Exception exception) {
                    if (!this.orb.transportDebugFlag) break block23;
                    this.dprint(".purgeCalls: Exception closing socket: " + exception + " " + this);
                }
            }
            this.responseWaitingRoom.signalExceptionToAllWaiters(systemException);
            if (this.contactInfo != null) {
                ((OutboundConnectionCache)this.getConnectionCache()).remove(this.contactInfo);
            } else if (this.acceptor != null) {
                ((InboundConnectionCache)this.getConnectionCache()).remove(this);
            }
            this.writeUnlock();
            return;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".purgeCalls<-: " + n2 + "/" + bl2 + "/" + bl3 + " " + this);
            }
        }
    }

    public void sendCloseConnection(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createCloseConnection(gIOPVersion);
        this.sendHelper(gIOPVersion, message);
    }

    public void sendMessageError(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createMessageError(gIOPVersion);
        this.sendHelper(gIOPVersion, message);
    }

    public void sendCancelRequest(GIOPVersion gIOPVersion, int n2) throws IOException {
        CancelRequestMessage cancelRequestMessage = MessageBase.createCancelRequest(gIOPVersion, n2);
        this.sendHelper(gIOPVersion, cancelRequestMessage);
    }

    protected void sendHelper(GIOPVersion gIOPVersion, Message message) throws IOException {
        CDROutputObject cDROutputObject = new CDROutputObject(this.orb, null, gIOPVersion, this, message, 1);
        message.write(cDROutputObject);
        cDROutputObject.writeTo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCancelRequestWithLock(GIOPVersion gIOPVersion, int n2) throws IOException {
        this.writeLock();
        try {
            this.sendCancelRequest(gIOPVersion, n2);
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void setCodeBaseIOR(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    public final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    public final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    protected void setSocketOptions(Socket socket) {
        block2: {
            try {
                socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                if (!this.orb.transportDebugFlag) break block2;
                this.dprint(".setSocketOptions:", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            return "SocketOrChannelConnectionImpl[ " + (this.socketChannel == null ? this.socket.toString() : this.socketChannel.toString()) + " " + this.getStateString(this.state) + " " + this.shouldUseSelectThreadToWait() + " " + this.shouldUseWorkerThreadForEvent() + "]";
        }
    }

    public void dprint(String string) {
        ORBUtility.dprint("SocketOrChannelConnectionImpl", string);
    }

    protected void dprint(String string, Throwable throwable) {
        this.dprint(string);
        throwable.printStackTrace(System.out);
    }
}

