/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.print.PrinterGraphics;
import java.security.AccessController;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import sun.awt.AppContext;
import sun.font.FontDesignMetrics;
import sun.print.ProxyPrintGraphics;
import sun.security.action.GetPropertyAction;

public class SwingUtilities2 {
    private static LSBCacheEntry[] fontCache;
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static LSBCacheEntry searchKey;
    public static final Object FRC_KEY;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    private static final FontRenderContext DEFAULT_FRC;
    public static final FontRenderContext AA_FRC;
    private static final boolean AA_TEXT;
    private static final boolean AA_TEXT_DEFINED;
    public static final Object AA_TEXT_PROPERTY_KEY;

    private static boolean drawTextAntialiased(JComponent jComponent) {
        if (!AA_TEXT_DEFINED) {
            if (jComponent != null) {
                return (Boolean)jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY);
            }
            return false;
        }
        return AA_TEXT;
    }

    public static boolean drawTextAntialiased(boolean bl2) {
        if (!AA_TEXT_DEFINED) {
            return bl2;
        }
        return AA_TEXT;
    }

    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return SwingUtilities2.getLeftSideBearing(jComponent, fontMetrics, string.charAt(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(JComponent jComponent, FontMetrics fontMetrics, char c2) {
        char c3 = c2;
        if (c3 < 'X' && c3 >= 'W') {
            Object var4_4 = null;
            FontRenderContext fontRenderContext = SwingUtilities2.getFRC(jComponent, fontMetrics);
            Font font = fontMetrics.getFont();
            Class<SwingUtilities2> clazz = SwingUtilities2.class;
            synchronized (SwingUtilities2.class) {
                LSBCacheEntry lSBCacheEntry = null;
                if (searchKey == null) {
                    searchKey = new LSBCacheEntry(fontRenderContext, font);
                } else {
                    searchKey.reset(fontRenderContext, font);
                }
                for (LSBCacheEntry lSBCacheEntry2 : fontCache) {
                    if (!searchKey.equals(lSBCacheEntry2)) continue;
                    lSBCacheEntry = lSBCacheEntry2;
                    break;
                }
                if (lSBCacheEntry == null) {
                    lSBCacheEntry = searchKey;
                    SwingUtilities2.fontCache[SwingUtilities2.nextIndex] = searchKey;
                    searchKey = null;
                    nextIndex = (nextIndex + 1) % 6;
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return lSBCacheEntry.getLeftSideBearing(c2);
            }
        }
        return 0;
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) {
        return SwingUtilities2.getFontMetrics(jComponent, graphics, graphics.getFont());
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics, Font font) {
        if (jComponent != null) {
            return jComponent.getFontMetrics(font);
        }
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return fontMetrics.stringWidth(string);
    }

    public static String clipStringIfNecessary(JComponent jComponent, FontMetrics fontMetrics, String string, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities2.stringWidth(jComponent, fontMetrics, string);
        if (n3 > n2) {
            return SwingUtilities2.clipString(jComponent, fontMetrics, string, n2);
        }
        return string;
    }

    public static String clipString(JComponent jComponent, FontMetrics fontMetrics, String string, int n2) {
        int n3;
        String string2 = "...";
        int n4 = SwingUtilities2.stringWidth(jComponent, fontMetrics, string2);
        int n5 = string.length();
        for (n3 = 0; n3 < n5 && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n2; ++n3) {
        }
        string = string.substring(0, n3) + string2;
        return string;
    }

    private static FontRenderContext getFRC(JComponent jComponent, FontMetrics fontMetrics) {
        if (fontMetrics instanceof FontDesignMetrics) {
            return ((FontDesignMetrics)fontMetrics).getFRC();
        }
        assert (false);
        return DEFAULT_FRC;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n2, int n3) {
        Graphics2D graphics2D;
        if (string == null || string.length() <= 0) {
            return;
        }
        if (SwingUtilities2.isPrinting(graphics) && (graphics2D = SwingUtilities2.getGraphics2D(graphics)) != null) {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), DEFAULT_FRC);
            textLayout.draw(graphics2D, n2, n3);
            return;
        }
        if (SwingUtilities2.drawTextAntialiased(jComponent) && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(string, n2, n3);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n2, n3);
        }
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n2, int n3, int n4) {
        SwingUtilities2.drawString(jComponent, graphics, string, n3, n4);
        if (n2 >= 0 && n2 < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = n3 + SwingUtilities2.stringWidth(jComponent, fontMetrics, string.substring(0, n2));
            int n6 = n4;
            int n7 = fontMetrics.charWidth(string.charAt(n2));
            int n8 = 1;
            graphics.fillRect(n5, n6 + 1, n7, n8);
        }
    }

    public static int loc2IndexFileList(JList jList, Point point) {
        Object object;
        int n2 = jList.locationToIndex(point);
        if (n2 != -1 && (object = jList.getClientProperty("List.isFileList")) instanceof Boolean && ((Boolean)object).booleanValue() && !SwingUtilities2.pointIsInActualBounds(jList, n2, point)) {
            n2 = -1;
        }
        return n2;
    }

    private static boolean pointIsInActualBounds(JList jList, int n2, Point point) {
        ListCellRenderer listCellRenderer = jList.getCellRenderer();
        ListModel listModel = jList.getModel();
        Object object = listModel.getElementAt(n2);
        Component component = listCellRenderer.getListCellRendererComponent(jList, object, n2, false, false);
        Dimension dimension = component.getPreferredSize();
        Rectangle rectangle = jList.getCellBounds(n2, n2);
        if (!component.getComponentOrientation().isLeftToRight()) {
            rectangle.x += rectangle.width - dimension.width;
        }
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        return rectangle.contains(point);
    }

    public static int drawChars(JComponent jComponent, Graphics graphics, char[] cArray, int n2, int n3, int n4, int n5) {
        Object object;
        Graphics2D graphics2D;
        if (n3 <= 0) {
            return n4;
        }
        int n6 = n4 + SwingUtilities2.getFontMetrics(jComponent, graphics).charsWidth(cArray, n2, n3);
        if (SwingUtilities2.isPrinting(graphics) && (graphics2D = SwingUtilities2.getGraphics2D(graphics)) != null) {
            object = graphics2D.getFontRenderContext();
            FontRenderContext fontRenderContext = (FontRenderContext)AppContext.getAppContext().get(FRC_KEY);
            if (fontRenderContext != null && !SwingUtilities2.isFontRenderContextCompatible((FontRenderContext)object, fontRenderContext)) {
                TextLayout textLayout = new TextLayout(new String(cArray, n2, n3), graphics2D.getFont(), fontRenderContext);
                textLayout.draw(graphics2D, n4, n5);
                return n6;
            }
        }
        if (SwingUtilities2.drawTextAntialiased(jComponent) && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(cArray, n2, n3, n4, n5);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawChars(cArray, n2, n3, n4, n5);
        }
        return n6;
    }

    public static float drawString(JComponent jComponent, Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        Graphics2D graphics2D = SwingUtilities2.getGraphics2D(graphics);
        if (graphics2D == null) {
            graphics.drawString(attributedCharacterIterator, n2, n3);
            return n2;
        }
        FontRenderContext fontRenderContext = SwingUtilities2.isPrinting(graphics) ? (FontRenderContext)AppContext.getAppContext().get(FRC_KEY) : (SwingUtilities2.drawTextAntialiased(jComponent) ? AA_FRC : graphics2D.getFontRenderContext());
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        textLayout.draw(graphics2D, n2, n3);
        return textLayout.getAdvance();
    }

    public static boolean isFontRenderContextCompatible(FontRenderContext fontRenderContext, FontRenderContext fontRenderContext2) {
        return fontRenderContext != null ? fontRenderContext.equals(fontRenderContext2) : fontRenderContext2 == null;
    }

    public static Graphics2D getGraphics2D(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            return (Graphics2D)graphics;
        }
        if (graphics instanceof ProxyPrintGraphics) {
            return (Graphics2D)((ProxyPrintGraphics)graphics).getGraphics();
        }
        return null;
    }

    public static FontRenderContext getFontRenderContext(Component component) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        FontRenderContext fontRenderContext = null;
        fontRenderContext = fontMetrics instanceof FontDesignMetrics ? ((FontDesignMetrics)fontMetrics).getFRC() : DEFAULT_FRC;
        return fontRenderContext;
    }

    static boolean isPrinting(Graphics graphics) {
        return graphics instanceof PrinterGraphics || graphics instanceof PrintGraphics;
    }

    static {
        FRC_KEY = new StringBuilder("FontRenderContext");
        DEFAULT_FRC = new FontRenderContext(null, false, false);
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        fontCache = new LSBCacheEntry[6];
        Object t2 = AccessController.doPrivileged(new GetPropertyAction("swing.aatext"));
        AA_TEXT_DEFINED = t2 != null;
        AA_TEXT = "true".equals(t2);
        AA_FRC = new FontRenderContext(null, true, false);
    }

    private static class LSBCacheEntry {
        private static final byte UNSET = 127;
        private static final char[] oneChar = new char[1];
        private byte[] lsbCache = new byte[1];
        private Font font;
        private FontRenderContext frc;

        public LSBCacheEntry(FontRenderContext fontRenderContext, Font font) {
            this.reset(fontRenderContext, font);
        }

        public void reset(FontRenderContext fontRenderContext, Font font) {
            this.font = font;
            this.frc = fontRenderContext;
            for (int i2 = this.lsbCache.length - 1; i2 >= 0; --i2) {
                this.lsbCache[i2] = 127;
            }
        }

        public int getLeftSideBearing(char c2) {
            int n2 = c2 - 87;
            assert (n2 >= 0 && n2 < 1);
            byte by = this.lsbCache[n2];
            if (by == 127) {
                LSBCacheEntry.oneChar[0] = c2;
                GlyphVector glyphVector = this.font.createGlyphVector(this.frc, oneChar);
                this.lsbCache[n2] = by = (byte)glyphVector.getGlyphPixelBounds((int)0, (FontRenderContext)this.frc, (float)0.0f, (float)0.0f).x;
            }
            return by;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LSBCacheEntry)) {
                return false;
            }
            LSBCacheEntry lSBCacheEntry = (LSBCacheEntry)object;
            return this.font.equals(lSBCacheEntry.font) && this.frc.equals(lSBCacheEntry.frc);
        }

        public int hashCode() {
            int n2 = 17;
            if (this.font != null) {
                n2 = 37 * n2 + this.font.hashCode();
            }
            if (this.frc != null) {
                n2 = 37 * n2 + this.frc.hashCode();
            }
            return n2;
        }
    }
}

