/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.Metacity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;

class GTKPainter
extends SynthPainter {
    static final GTKPainter INSTANCE = new GTKPainter();
    static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets TEMP_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets BUTTON_DEFAULT_BORDER_INSETS = new Insets(1, 1, 1, 1);

    GTKPainter() {
    }

    private GTKEngine getEngine(SynthContext synthContext) {
        return ((GTKStyle)synthContext.getStyle()).getEngine(synthContext);
    }

    private String getName(SynthContext synthContext) {
        return synthContext.getRegion().isSubregion() ? null : synthContext.getComponent().getName();
    }

    Insets getInsets(SynthContext synthContext, Insets insets) {
        String string;
        Region region = synthContext.getRegion();
        String string2 = string = region.isSubregion() ? null : synthContext.getComponent().getName();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON || region == Region.CHECK_BOX || region == Region.RADIO_BUTTON || region == Region.ARROW_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM) {
            if ("Spinner.previousButton" == string || "Spinner.nextButton" == string) {
                return this.getSpinnerButtonInsets(synthContext, insets);
            }
            return this.getButtonInsets(synthContext, insets);
        }
        if (region == Region.MENU || region == Region.MENU_ITEM) {
            return this.getMenuItemInsets(synthContext, insets);
        }
        if (region == Region.FORMATTED_TEXT_FIELD) {
            return this.getTextFieldInsets(synthContext, insets);
        }
        if (region == Region.INTERNAL_FRAME) {
            insets = Metacity.INSTANCE.getBorderInsets(synthContext, insets);
        } else if (region != Region.DESKTOP_ICON) {
            if (region == Region.LABEL) {
                if ("TableHeader.renderer" == string) {
                    return this.getButtonInsets(synthContext, insets);
                }
                if ("ComboBox.renderer" == string || "ComboBox.listRenderer" == string) {
                    return this.getTextFieldInsets(synthContext, insets);
                }
                if ("Tree.cellRenderer" == string) {
                    return this.getTreeCellRendererInsets(synthContext, insets);
                }
            } else {
                if (region == Region.MENU_BAR) {
                    return this.getMenuBarInsets(synthContext, insets);
                }
                if (region == Region.OPTION_PANE) {
                    return this.getOptionPaneInsets(synthContext, insets);
                }
                if (region == Region.POPUP_MENU) {
                    return this.getPopupMenuInsets(synthContext, insets);
                }
                if (region == Region.PROGRESS_BAR) {
                    return this.getProgressBarInsets(synthContext, insets);
                }
                if (region == Region.SCROLL_BAR) {
                    return this.getScrollBarInsets(synthContext, insets);
                }
                if (region == Region.SEPARATOR) {
                    return this.getSeparatorInsets(synthContext, insets);
                }
                if (region == Region.SLIDER) {
                    return this.getSliderInsets(synthContext, insets);
                }
                if (region == Region.SLIDER_TRACK) {
                    return this.getSliderTrackInsets(synthContext, insets);
                }
                if (region == Region.SPINNER) {
                    return this.getSpinnerInsets(synthContext, insets);
                }
                if (region == Region.TABBED_PANE) {
                    return this.getTabbedPaneInsets(synthContext, insets);
                }
                if (region == Region.TABBED_PANE_CONTENT) {
                    return this.getTabbedPaneContentInsets(synthContext, insets);
                }
                if (region == Region.TABBED_PANE_TAB) {
                    return this.getTabbedPaneTabInsets(synthContext, insets);
                }
                if (region == Region.TEXT_FIELD || region == Region.PASSWORD_FIELD) {
                    if (string == "Tree.cellEditor") {
                        return this.getTreeCellEditorInsets(synthContext, insets);
                    }
                    return this.getTextFieldInsets(synthContext, insets);
                }
                if (region == Region.TOOL_BAR) {
                    return this.getToolBarInsets(synthContext, insets);
                }
                if (region == Region.TOOL_TIP) {
                    return this.getToolTipInsets(synthContext, insets);
                }
            }
        }
        return insets;
    }

    public void paintCheckBoxBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintRadioButtonCheckBoxBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintFormattedTextFieldBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintTextFieldBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintToolBarDragWindowBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintToolBarBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintToolBarBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintToolBarBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintPasswordFieldBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintTextFieldBackground(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paintTextFieldBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        if (this.getName(synthContext) == "Tree.cellEditor") {
            this.paintTreeCellEditorBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        } else {
            this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        }
    }

    public void paintRadioButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintRadioButtonCheckBoxBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintRadioButtonMenuItemBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintRadioButtonCheckBoxMenuItemBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    public void paintLabelBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        String string = this.getName(synthContext);
        if ("TableHeader.renderer" == string || string == "GTKFileChooser.directoryListLabel" || string == "GTKFileChooser.fileListLabel") {
            this.paintButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5, "button");
        } else if (string == "ComboBox.renderer") {
            this.paintTextFieldBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        }
    }

    public void paintInternalFrameBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paintDesktopPaneBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    public void paintDesktopIconBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Metacity.INSTANCE.paintFrameBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    public void paintCheckBoxMenuItemBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.paintRadioButtonCheckBoxMenuItemBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5);
    }

    private Insets getButtonInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n4 = gTKStyle.getXThickness();
        int n5 = gTKStyle.getYThickness();
        int n6 = n2 + n3 + n4;
        int n7 = n2 + n3 + n5;
        JComponent jComponent = synthContext.getComponent();
        insets.left = insets.right = n6;
        insets.top = insets.bottom = n7;
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets2 = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            insets.left += insets2.left;
            insets.right += insets2.right;
            insets.top += insets2.top;
            insets.bottom += insets2.bottom;
        }
        return insets;
    }

    public void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        String string = this.getName(synthContext);
        if (string != null && string.startsWith("InternalFrameTitlePane.")) {
            Metacity.INSTANCE.paintButtonBackground(synthContext, graphics, n2, n3, n4, n5);
        } else {
            this.paintButtonBackground(synthContext, this.getEngine(synthContext), graphics, n2, n3, n4, n5, "button");
        }
    }

    private void paintButtonBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5, String string) {
        boolean bl2;
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl3 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        int n11 = gTKStyle.getXThickness();
        int n12 = gTKStyle.getYThickness();
        JComponent jComponent = synthContext.getComponent();
        AbstractButton abstractButton = jComponent instanceof AbstractButton ? (AbstractButton)jComponent : null;
        boolean bl4 = bl2 = abstractButton == null || abstractButton.isContentAreaFilled() && abstractButton.isBorderPainted();
        if (jComponent instanceof JButton && ((JButton)jComponent).isDefaultCapable()) {
            Insets insets = gTKStyle.getClassSpecificInsetsValue(synthContext, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            if (bl2 && (n6 & 0x400) == 1024) {
                gTKEngine.paintBox(synthContext, graphics, 1, 0, "buttondefault", n2, n3, n4, n5);
            }
            n2 += insets.left;
            n3 += insets.top;
            n4 -= insets.left + insets.right;
            n5 -= insets.top + insets.bottom;
        }
        if (!bl3 && (n6 & 0x100) == 256) {
            n2 += n10;
            n3 += n10;
            n4 -= 2 * n10;
            n5 -= 2 * n10;
        }
        if (bl2 && (!(jComponent.getParent() instanceof JToolBar) || n7 != 1)) {
            int n13 = (n6 & 4) == 4 ? 0 : 1;
            gTKEngine.paintBox(synthContext, graphics, n7, n13, string, n2, n3, n4, n5);
        }
        if ((n6 & 0x100) == 256 && (abstractButton == null || abstractButton.isFocusPainted())) {
            if (bl3) {
                n2 += n11 + n9;
                n3 += n12 + n9;
                n4 -= 2 * (n11 + n9);
                n5 -= 2 * (n12 + n9);
            } else {
                n2 -= n10;
                n3 -= n10;
                n4 += 2 * n10;
                n5 += 2 * n10;
            }
            gTKEngine.paintFocus(synthContext, graphics, n7, string, n2, n3, n4, n5);
        }
    }

    public void paintArrowButtonForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n7 = GTKLookAndFeel.synthStateToGTKState(Region.ARROW_BUTTON, synthContext.getComponentState());
        int n8 = n7 == 4 ? 0 : 1;
        switch (n6) {
            case 1: {
                n6 = 100;
                break;
            }
            case 5: {
                n6 = 101;
                break;
            }
            case 3: {
                n6 = 103;
                break;
            }
            case 7: {
                n6 = 102;
            }
        }
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "arrow";
        if (string == "ScrollBar.button") {
            if (jComponent.getParent() instanceof JScrollBar) {
                string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
            }
        } else if (string == "Spinner.nextButton") {
            string2 = "spinbutton";
        } else if (string == "Spinner.previousButton") {
            string2 = "spinbutton";
        }
        gTKEngine.paintArrow(synthContext, graphics, n7, n8, n6, string2, n2, n3, n4, n5);
    }

    public void paintArrowButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        JComponent jComponent = synthContext.getComponent();
        String string = jComponent.getName();
        String string2 = "button";
        if (string == "ScrollBar.button") {
            if (jComponent.getParent() instanceof JScrollBar) {
                string2 = ((JScrollBar)jComponent.getParent()).getOrientation() == 0 ? "hscrollbar" : "vscrollbar";
            }
        } else if ("Spinner.previousButton" == string) {
            string2 = "spinbutton_down";
        } else if ("Spinner.nextButton" == string) {
            string2 = "spinbutton_up";
        }
        this.paintButtonBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5, string2);
    }

    private void paintRadioButtonCheckBoxBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((n6 & 2) != 0) {
            gTKEngine.paintFlatBoxNormal(synthContext, graphics, 2, "checkbutton", n2, n3, n4, n5);
        }
    }

    private void paintRadioButtonCheckBoxMenuItemBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            if (GTKLookAndFeel.is2_2()) {
                gTKEngine.paintBox(synthContext, graphics, n6, 4, "menuitem", n2, n3, n4, n5);
            } else {
                gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
            }
        }
    }

    public void paintListBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(Region.LIST, synthContext.getComponentState());
        if (synthContext.getComponent().getName() == "ComboBox.list") {
            // empty if block
        }
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    private Insets getMenuBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 0);
        int n3 = gTKStyle.getXThickness();
        int n4 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n2 + n4;
        insets.left = insets.right = n2 + n3;
        return insets;
    }

    public void paintMenuBarBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "shadow-type", 1);
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n7, n6, "menubar", n2, n3, n4, n5);
    }

    public void paintMenuBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if (n6 == 2) {
            if (GTKLookAndFeel.is2_2()) {
                gTKEngine.paintBox(synthContext, graphics, n6, 4, "menuitem", n2, n3, n4, n5);
            } else {
                gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
            }
        }
    }

    private Insets getMenuItemInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "internal-padding", 0);
        int n3 = gTKStyle.getXThickness();
        int n4 = gTKStyle.getYThickness();
        insets.top = insets.bottom = n2 + n4;
        insets.left = insets.right = n2 + n3;
        return insets;
    }

    public void paintMenuItemBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        if ((synthContext.getComponentState() & 2) != 0) {
            if (GTKLookAndFeel.is2_2()) {
                gTKEngine.paintBox(synthContext, graphics, n6, 4, "menuitem", n2, n3, n4, n5);
            } else {
                gTKEngine.paintBox(synthContext, graphics, n6, 1, "menuitem", n2, n3, n4, n5);
            }
        }
    }

    private Insets getPopupMenuInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 2;
        insets.top = 2;
        insets.right = 2;
        insets.left = 2;
        return insets;
    }

    public void paintPopupMenuBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintBox(synthContext, graphics, n6, 1, "menu", n2, n3, n4, n5);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n7 = gTKStyle.getXThickness();
        int n8 = gTKStyle.getYThickness();
        gTKEngine.paintBackground(synthContext, graphics, n6, gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.BACKGROUND), n2 + n7, n3 + n8, n4 - n7 - n7, n5 - n8 - n8);
    }

    private Insets getProgressBarInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        gTKEngine.paintBox(synthContext, graphics, 1, 0, "trough", n2, n3, n4, n5);
    }

    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 || n5 != 0) {
            this.getEngine(synthContext).paintBox(synthContext, graphics, 2, 1, "bar", n2, n3, n4, n5);
        }
    }

    public void paintViewportBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.getEngine(synthContext).paintShadow(synthContext, graphics, 1, 0, "scrolled_window", n2, n3, n4, n5);
    }

    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.getEngine(synthContext).paintShadow(synthContext, graphics, 1, 0, "scrolled_window", n2, n3, n4, n5);
    }

    Insets getScrollPaneInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.right = insets.left = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    private Insets getSeparatorInsets(SynthContext synthContext, Insets insets) {
        return insets;
    }

    public void paintSeparatorBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        if (((JSeparator)synthContext.getComponent()).getOrientation() == 0) {
            gTKEngine.paintHline(synthContext, graphics, 1, "hseparator", n2, n3, n4, n5);
        } else {
            gTKEngine.paintVline(synthContext, graphics, 1, "vseparator", n2, n3, n4, n5);
        }
    }

    private Insets getSliderInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getSliderTrackInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        insets.left = insets.right = n2 + n3;
        insets.bottom = insets.right;
        insets.top = insets.right;
        return insets;
    }

    public void paintSliderTrackBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        gTKEngine.paintBox(synthContext, graphics, n7, 0, "trough", n2, n3, n4, n5);
        if ((n6 & 0x100) == 256) {
            int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n2 -= (n8 += gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1)), n3 -= n8, n4 += 2 * n8, n5 += 2 * n8);
        }
    }

    public void paintSliderThumbBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        n6 = n6 == 0 ? 0 : 1;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n2, n3, n4, n5, n6);
    }

    public void paintSpinnerBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
    }

    private Insets getSpinnerInsets(SynthContext synthContext, Insets insets) {
        return insets;
    }

    private Insets getSpinnerButtonInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.left = 1;
        insets.right = 1;
        return insets;
    }

    public void paintSplitPaneDividerBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = ((JSplitPane)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1;
        gTKEngine.paintHandle(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), -100, "paned", n2, n3, n4, n5, n6);
    }

    public void paintSplitPaneDragDivider(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        this.paintSplitPaneDividerForeground(synthContext, graphics, n2, n3, n4, n5, n6);
    }

    public void paintSplitPaneDividerForeground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(synthContext.getStyle().getColor(synthContext, GTKColorType.BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
        this.paintSplitPaneDividerBackground(synthContext, graphics, n2, n3, n4, n5);
    }

    private Insets getTabbedPaneInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    private Insets getTabbedPaneContentInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    public void paintTabbedPaneContentBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        JTabbedPane jTabbedPane = (JTabbedPane)synthContext.getComponent();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        int n6 = GTKLookAndFeel.SwingOrientationConstantToGTK(jTabbedPane.getTabPlacement());
        int n7 = 0;
        int n8 = 0;
        int n9 = jTabbedPane.getSelectedIndex();
        if (n9 != -1) {
            Rectangle rectangle = jTabbedPane.getBoundsAt(n9);
            if (n6 == 2 || n6 == 3) {
                n7 = rectangle.x - 1;
                n8 = rectangle.width;
            } else {
                n7 = rectangle.y - 1;
                n8 = rectangle.height;
            }
        }
        gTKEngine.paintBoxGap(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "notebook", n2, n3, n4, n5, n6, n7, n8);
    }

    private Insets getTabbedPaneTabInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        int n4 = 0;
        int n5 = 2;
        n4 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        insets.left = insets.right = n4 + n5 + n2;
        insets.top = insets.bottom = n4 + n5 + n3;
        return insets;
    }

    public void paintTabbedPaneTabBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n8 = synthContext.getComponentState();
        int n9 = ((JTabbedPane)synthContext.getComponent()).getSelectedIndex();
        int n10 = n9 == n6 ? 0 : 2;
        n8 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n8);
        switch (((JTabbedPane)synthContext.getComponent()).getTabPlacement()) {
            case 1: {
                n7 = 3;
                n3 += n10;
                n5 -= n10;
                break;
            }
            case 3: {
                n5 -= n10;
                n7 = 2;
                break;
            }
            case 2: {
                n2 += n10;
                n4 -= n10;
                n7 = 1;
                break;
            }
            default: {
                n4 -= n10;
                n7 = 0;
            }
        }
        gTKEngine.paintExtension(synthContext, graphics, n8, 1, "tab", n2, n3, n4, n5, n7, n6);
    }

    public void paintTextAreaBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    private void paintTextFieldBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n7 = synthContext.getComponentState();
        int n8 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n7);
        int n9 = gTKStyle.getXThickness();
        int n10 = gTKStyle.getYThickness();
        this.paintTextBackground(synthContext, gTKEngine, graphics, n2, n3, n4, n5);
        n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n7);
        if (!bl2 && (n7 & 0x100) == 256) {
            n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            n2 += n6;
            n3 += n6;
            n4 -= 2 * n6;
            n5 -= 2 * n6;
        } else {
            n6 = 0;
        }
        gTKEngine.paintShadow(synthContext, graphics, 1, 0, "entry", n2, n3, n4, n5);
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), 1, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n2 + n9, n3 + n10, n4 - 2 * n9, n5 - 2 * n10);
        gTKEngine.paintFlatBoxText(synthContext, graphics, 1, "entry_bg", n2 + n9, n3 + n10, n4 - 2 * n9, n5 - 2 * n10);
        if (n6 > 0) {
            gTKEngine.paintFocus(synthContext, graphics, n8, "entry", n2 -= n6, n3 -= n6, n4 += 2 * n6, n5 += 2 * n6);
        }
    }

    private Insets getTextFieldInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n2 = gTKStyle.getXThickness();
        int n3 = gTKStyle.getYThickness();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n4 = 0;
        if (!bl2) {
            n4 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        }
        insets.left = insets.right = n4 + n2 + 2;
        insets.top = insets.bottom = n4 + n3 + 2;
        return insets;
    }

    private void paintTextBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent.isOpaque() && jComponent.getBackground() instanceof ColorUIResource) {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), 1, GTKColorType.TEXT_BACKGROUND));
            graphics.fillRect(n2, n3, n4, n5);
        }
    }

    private Insets getOptionPaneInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 6;
        insets.top = 6;
        insets.right = 6;
        insets.left = 6;
        return insets;
    }

    public void paintToggleButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        boolean bl2 = gTKStyle.getClassSpecificBoolValue(synthContext, "interior-focus", true);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        int n11 = gTKStyle.getXThickness();
        int n12 = gTKStyle.getYThickness();
        JToggleButton jToggleButton = (JToggleButton)synthContext.getComponent();
        if (!bl2 && (n6 & 0x100) == 256) {
            n2 += n10;
            n3 += n10;
            n4 -= 2 * n10;
            n5 -= 2 * n10;
        }
        int n13 = 1;
        if (jToggleButton.isSelected() || (n6 & 4) != 0) {
            n13 = 0;
        }
        if (jToggleButton.isContentAreaFilled() && jToggleButton.isBorderPainted()) {
            gTKEngine.paintBox(synthContext, graphics, n7, n13, "button", n2, n3, n4, n5);
        }
        if ((n6 & 0x100) == 256 && jToggleButton.isFocusPainted()) {
            if (bl2) {
                n2 += n11 + n9;
                n3 += n12 + n9;
                n4 -= 2 * (n11 + n9);
                n5 -= 2 * (n12 + n9);
            } else {
                n2 -= n10;
                n3 -= n10;
                n4 += 2 * n10;
                n5 += 2 * n10;
            }
            gTKEngine.paintFocus(synthContext, graphics, n7, "button", n2, n3, n4, n5);
        }
    }

    public void paintRootPaneBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxNormal(synthContext, graphics, n6, "base", n2, n3, n4, n5);
    }

    public void paintScrollBarBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        int n8 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        int n9 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
        int n10 = n8 + n9;
        gTKEngine.paintBox(synthContext, graphics, 4, 0, "trough", n2 + n10, n3 + n10, n4 - 2 * n10, n5 - 2 * n10);
        if ((n6 & 0x100) == 256) {
            gTKEngine.paintFocus(synthContext, graphics, 1, "trough", n2, n3, n4, n5);
        }
    }

    private Insets getScrollBarInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (synthContext.getComponent().isFocusable()) {
            n2 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
            int n3 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-padding", 1);
            int n4 = n2 + n3;
            int n5 = n2 + n3;
            insets.left = insets.right = n4;
            insets.top = insets.bottom = n5;
        }
        n2 = gTKStyle.getClassSpecificIntValue(synthContext, "trough-border", 1);
        insets.left += n2;
        insets.right += n2;
        insets.top += n2;
        insets.bottom += n2;
        return insets;
    }

    public void paintScrollBarThumbBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        n6 = n6 == 1 ? 1 : 0;
        gTKEngine.paintSlider(synthContext, graphics, GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState()), 1, "slider", n2, n3, n4, n5, n6);
    }

    private void paintToolBarBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        graphics.setColor(gTKStyle.getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.BACKGROUND));
        gTKEngine.paintFlatBox(synthContext, graphics, n7, "handlebox_bin", n2, n3, n4, n5);
    }

    private Insets getToolBarInsets(SynthContext synthContext, Insets insets) {
        int n2;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n3 = gTKStyle.getXThickness();
        insets.top = insets.bottom = (n2 = gTKStyle.getYThickness());
        insets.right = insets.left = n3;
        return insets;
    }

    public void paintToolBarContentBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = synthContext.getComponentState();
        int n7 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), n6);
        this.getEngine(synthContext).paintShadow(synthContext, graphics, 1, 1, "handlebox_bin", n2, n3, n4, n5);
    }

    public void paintToolTipBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        this.getEngine(synthContext).paintFlatBoxNormal(synthContext, graphics, 1, "tooltip", n2, n3, n4, n5);
    }

    private Insets getToolTipInsets(SynthContext synthContext, Insets insets) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        insets.left = insets.right = gTKStyle.getXThickness();
        insets.top = insets.bottom = gTKStyle.getYThickness();
        return insets;
    }

    public void paintTreeCellBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        this.getEngine(synthContext).paintFlatBoxText(synthContext, graphics, n6, "cell_odd", n2, n3, n4, n5);
    }

    public void paintTreeCellFocus(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        GTKEngine gTKEngine = this.getEngine(synthContext);
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFocus(synthContext, graphics, n6, "treeview", n2, n3, n4, n5);
    }

    private Insets getTreeCellRendererInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private Insets getTreeCellEditorInsets(SynthContext synthContext, Insets insets) {
        insets.bottom = 1;
        insets.top = 1;
        insets.right = 1;
        insets.left = 1;
        return insets;
    }

    private void paintTreeCellEditorBackground(SynthContext synthContext, GTKEngine gTKEngine, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        gTKEngine.paintFlatBoxText(synthContext, graphics, n6, "entry_bg", n2, n3, n4, n5);
    }

    public void paintTreeBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
    }

    public void paintViewportBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6 = GTKLookAndFeel.synthStateToGTKState(synthContext.getRegion(), synthContext.getComponentState());
        graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), n6, GTKColorType.TEXT_BACKGROUND));
        graphics.fillRect(n2, n3, n4, n5);
    }

    static class ListTableFocusBorder
    extends AbstractBorder
    implements UIResource {
        ListTableFocusBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(Color.BLACK);
            GTKEngine.INSTANCE._paintFocus(graphics, n2, n3, n4, n5, GTKEngine.DEFAULT_FOCUS_PATTERN, 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                return this.getBorderInsets(component);
            }
            insets.bottom = 1;
            insets.top = 1;
            insets.right = 1;
            insets.left = 1;
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

