/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.SwingUtilities2;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKParser;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class Metacity
implements SynthConstants {
    static Metacity INSTANCE;
    private static final String[] themeNames;
    private static boolean errorLogged;
    private static DocumentBuilder documentBuilder;
    private static Document xmlDoc;
    private static String userHome;
    private Node frame_style_set;
    private Map<String, Object> frameGeometry;
    private Map<String, Map<String, Object>> frameGeometries;
    private LayoutManager titlePaneLayout = new TitlePaneLayout();
    private ColorizeImageFilter imageFilter = new ColorizeImageFilter();
    private URL themeDir = null;
    private SynthContext context;
    private String themeName;
    private ArithmeticExpressionEvaluator aee = new ArithmeticExpressionEvaluator();
    private Map<String, Integer> variables;
    private RoundRectClipShape roundedClipShape;
    private HashMap<String, Image> images = new HashMap();

    protected Metacity(String string) throws IOException, ParserConfigurationException, SAXException {
        Object object;
        String string2;
        Node node;
        int n2;
        Object object2;
        this.themeName = string;
        this.themeDir = Metacity.getThemeDir(string);
        if (this.themeDir != null) {
            object2 = new URL(this.themeDir, "metacity-theme-1.xml");
            xmlDoc = Metacity.getXMLDoc((URL)object2);
            if (xmlDoc == null) {
                throw new IOException(((URL)object2).toString());
            }
        } else {
            throw new FileNotFoundException(string);
        }
        this.variables = new HashMap<String, Integer>();
        object2 = xmlDoc.getElementsByTagName("constant");
        int n3 = object2.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            node = object2.item(n2);
            string2 = this.getStringAttr(node, "name");
            if (string2 == null || (object = this.getStringAttr(node, "value")) == null) continue;
            try {
                this.variables.put(string2, Integer.parseInt((String)object));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(string, numberFormatException);
            }
        }
        this.frameGeometries = new HashMap<String, Map<String, Object>>();
        object2 = xmlDoc.getElementsByTagName("frame_geometry");
        n3 = object2.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            node = object2.item(n2);
            string2 = this.getStringAttr(node, "name");
            if (string2 == null) continue;
            object = new HashMap();
            this.frameGeometries.put(string2, (Map<String, Object>)object);
            String string3 = this.getStringAttr(node, "parent");
            if (string3 != null) {
                ((HashMap)object).putAll(this.frameGeometries.get(string3));
            }
            ((HashMap)object).put("has_title", this.getBooleanAttr(node, "has_title", true));
            ((HashMap)object).put("rounded_top_left", this.getBooleanAttr(node, "rounded_top_left", false));
            ((HashMap)object).put("rounded_top_right", this.getBooleanAttr(node, "rounded_top_right", false));
            ((HashMap)object).put("rounded_bottom_left", this.getBooleanAttr(node, "rounded_bottom_left", false));
            ((HashMap)object).put("rounded_bottom_right", this.getBooleanAttr(node, "rounded_bottom_right", false));
            NodeList nodeList = node.getChildNodes();
            int n4 = nodeList.getLength();
            for (int i2 = 0; i2 < n4; ++i2) {
                Node node2 = nodeList.item(i2);
                if (node2.getNodeType() != 1) continue;
                string2 = node2.getNodeName();
                Serializable serializable = null;
                if ("distance".equals(string2)) {
                    serializable = new Integer(this.getIntAttr(node2, "value", 0));
                } else if ("border".equals(string2)) {
                    serializable = new Insets(this.getIntAttr(node2, "top", 0), this.getIntAttr(node2, "left", 0), this.getIntAttr(node2, "bottom", 0), this.getIntAttr(node2, "right", 0));
                } else if ("aspect_ratio".equals(string2)) {
                    serializable = new Float(this.getFloatAttr(node2, "value", 1.0f));
                } else {
                    Metacity.logError(string, "Unknown Metacity frame geometry value type: " + string2);
                }
                String string4 = this.getStringAttr(node2, "name");
                if (string4 == null || serializable == null) continue;
                ((HashMap)object).put(string4, serializable);
            }
        }
        this.frameGeometry = this.frameGeometries.get("normal");
    }

    public static LayoutManager getTitlePaneLayout() {
        return Metacity.INSTANCE.titlePaneLayout;
    }

    private Shape getRoundedClipShape(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.roundedClipShape == null) {
            this.roundedClipShape = new RoundRectClipShape();
        }
        this.roundedClipShape.setRoundedRect(n2, n3, n4, n5, n6, n7, n8);
        return this.roundedClipShape;
    }

    void paintButtonBackground(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Node node;
        JInternalFrame jInternalFrame;
        this.context = synthContext;
        JButton jButton = (JButton)synthContext.getComponent();
        String string = jButton.getName();
        int n6 = synthContext.getComponentState();
        JComponent jComponent = (JComponent)jButton.getParent();
        Container container = jComponent.getParent();
        if (container instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)container;
        } else if (container instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)container).getInternalFrame();
        } else {
            return;
        }
        boolean bl2 = jInternalFrame.isSelected();
        jButton.setOpaque(false);
        String string2 = "normal";
        if ((n6 & 4) != 0) {
            string2 = "pressed";
        } else if ((n6 & 2) != 0) {
            string2 = "prelight";
        }
        String string3 = null;
        String string4 = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string == "InternalFrameTitlePane.menuButton") {
            string3 = "menu";
            string4 = "left_left";
            bl3 = true;
        } else if (string == "InternalFrameTitlePane.iconifyButton") {
            string3 = "minimize";
            int n7 = (jInternalFrame.isIconifiable() ? 1 : 0) + (jInternalFrame.isMaximizable() ? 1 : 0) + (jInternalFrame.isClosable() ? 1 : 0);
            bl4 = n7 == 1;
            switch (n7) {
                case 1: {
                    string4 = "right_right";
                    break;
                }
                case 2: {
                    string4 = "right_middle";
                    break;
                }
                case 3: {
                    string4 = "right_left";
                }
            }
        } else if (string == "InternalFrameTitlePane.maximizeButton") {
            string3 = "maximize";
            bl4 = !jInternalFrame.isClosable();
            string4 = jInternalFrame.isClosable() ? "right_middle" : "right_right";
        } else if (string == "InternalFrameTitlePane.closeButton") {
            string3 = "close";
            bl4 = true;
            string4 = "right_right";
        }
        Node node2 = this.getNode(this.frame_style_set, "frame", new String[]{"focus", bl2 ? "yes" : "no", "state", jInternalFrame.isMaximum() ? "maximized" : "normal"});
        if (string3 != null && node2 != null && (node = this.getNode("frame_style", new String[]{"name", this.getStringAttr(node2, "style")})) != null) {
            this.setFrameGeometry(jComponent, this.frameGeometries.get(this.getStringAttr(node, "geometry")));
            Shape shape = graphics.getClip();
            if (bl4 && this.getBoolean("rounded_top_right", false) || bl3 && this.getBoolean("rounded_top_left", false)) {
                Point point = jButton.getLocation();
                if (bl4) {
                    graphics.setClip(this.getRoundedClipShape(0, 0, n4, n5, 12, 12, 2));
                } else {
                    graphics.setClip(this.getRoundedClipShape(0, 0, n4, n5, 11, 11, 1));
                }
            }
            this.drawButton(node, string4 + "_background", string2, graphics, n4, n5, jInternalFrame);
            this.drawButton(node, string3, string2, graphics, n4, n5, jInternalFrame);
            graphics.setClip(shape);
        }
    }

    protected void drawButton(Node node, String string, String string2, Graphics graphics, int n2, int n3, JInternalFrame jInternalFrame) {
        Node node2 = this.getNode(node, "button", new String[]{"function", string, "state", string2});
        if (node2 == null && !string2.equals("normal")) {
            node2 = this.getNode(node, "button", new String[]{"function", string, "state", "normal"});
        }
        if (node2 != null) {
            String string3 = this.getStringAttr(node2, "draw_ops");
            Node node3 = string3 != null ? this.getNode("draw_ops", new String[]{"name", string3}) : this.getNode(node2, "draw_ops", null);
            this.variables.put("width", n2);
            this.variables.put("height", n3);
            this.draw(node3, graphics, jInternalFrame);
        }
    }

    void paintFrameBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        Node node;
        Node node2;
        this.context = synthContext;
        JComponent jComponent = synthContext.getComponent();
        JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrame.northPane");
        if (jComponent2 == null) {
            return;
        }
        JInternalFrame jInternalFrame = null;
        if (jComponent instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)jComponent;
        } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame();
        } else {
            return;
        }
        boolean bl2 = jInternalFrame.isSelected();
        Font font = graphics.getFont();
        graphics.setFont(jComponent2.getFont());
        graphics.translate(n2, n3);
        Rectangle rectangle = this.calculateTitleArea(jInternalFrame);
        JComponent jComponent3 = Metacity.findChild(jComponent2, "InternalFrameTitlePane.menuButton");
        Icon icon = jInternalFrame.getFrameIcon();
        this.variables.put("mini_icon_width", icon != null ? icon.getIconWidth() : 0);
        this.variables.put("mini_icon_height", icon != null ? icon.getIconHeight() : 0);
        this.variables.put("title_width", this.calculateTitleTextWidth(graphics, jInternalFrame));
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jInternalFrame, graphics);
        this.variables.put("title_height", fontMetrics.getAscent() + fontMetrics.getDescent());
        this.variables.put("icon_width", 32);
        this.variables.put("icon_height", 32);
        if (this.frame_style_set == null) {
            this.frame_style_set = this.getNode("frame_style_set", new String[]{"name", "normal"});
        }
        if (this.frame_style_set != null && (node2 = this.getNode(this.frame_style_set, "frame", new String[]{"focus", bl2 ? "yes" : "no", "state", jInternalFrame.isMaximum() ? "maximized" : "normal"})) != null && (node = this.getNode("frame_style", new String[]{"name", this.getStringAttr(node2, "style")})) != null) {
            Map<String, Object> map = this.frameGeometries.get(this.getStringAttr(node, "geometry"));
            this.setFrameGeometry(jComponent2, map);
            Shape shape = graphics.getClip();
            boolean bl3 = this.getBoolean("rounded_top_left", false);
            boolean bl4 = this.getBoolean("rounded_top_right", false);
            boolean bl5 = this.getBoolean("rounded_bottom_left", false);
            boolean bl6 = this.getBoolean("rounded_bottom_right", false);
            if (bl3 || bl4 || bl5 || bl6) {
                jInternalFrame.setOpaque(false);
                graphics.setClip(this.getRoundedClipShape(0, 0, n4, n5, 12, 12, (bl3 ? 1 : 0) | (bl4 ? 2 : 0) | (bl5 ? 4 : 0) | (bl6 ? 8 : 0)));
            }
            int n6 = jComponent2.getHeight();
            boolean bl7 = jInternalFrame.isIcon();
            Insets insets = this.getBorderInsets(synthContext, null);
            int n7 = this.getInt("left_titlebar_edge");
            int n8 = this.getInt("right_titlebar_edge");
            int n9 = this.getInt("top_titlebar_edge");
            int n10 = this.getInt("bottom_titlebar_edge");
            if (!bl7) {
                this.drawPiece(node, graphics, "entire_background", 0, 0, n4, n5, jInternalFrame);
            }
            this.drawPiece(node, graphics, "titlebar", 0, 0, n4, n6, jInternalFrame);
            this.drawPiece(node, graphics, "titlebar_middle", n7, n9, n4 - n7 - n8, n6 - n9 - n10, jInternalFrame);
            this.drawPiece(node, graphics, "left_titlebar_edge", 0, 0, n7, n6, jInternalFrame);
            this.drawPiece(node, graphics, "right_titlebar_edge", n4 - n8, 0, n8, n6, jInternalFrame);
            this.drawPiece(node, graphics, "top_titlebar_edge", 0, 0, n4, n9, jInternalFrame);
            this.drawPiece(node, graphics, "bottom_titlebar_edge", 0, n6 - n10, n4, n10, jInternalFrame);
            this.drawPiece(node, graphics, "title", rectangle.x, rectangle.y, rectangle.width, rectangle.height, jInternalFrame);
            if (!bl7) {
                this.drawPiece(node, graphics, "left_edge", 0, n6, insets.left, n5 - n6, jInternalFrame);
                this.drawPiece(node, graphics, "right_edge", n4 - insets.right, n6, insets.right, n5 - n6, jInternalFrame);
                this.drawPiece(node, graphics, "bottom_edge", 0, n5 - insets.bottom, n4, insets.bottom, jInternalFrame);
                this.drawPiece(node, graphics, "overlay", 0, 0, n4, n5, jInternalFrame);
            }
            graphics.setClip(shape);
        }
        graphics.translate(-n2, -n3);
        graphics.setFont(font);
    }

    private static URL getThemeDir(String string) {
        return (URL)new Privileged().doPrivileged(Privileged.GET_THEME_DIR, string);
    }

    private static String getUserTheme() {
        return (String)new Privileged().doPrivileged(Privileged.GET_USER_THEME, null);
    }

    protected void tileImage(Graphics graphics, Image image, int n2, int n3, int n4, int n5, float[] fArray) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        for (int i2 = n3; i2 < n3 + n5; i2 += n7) {
            int n8;
            n7 = Math.min(n7, n3 + n5 - i2);
            for (int i3 = n2; i3 < n2 + n4; i3 += n8) {
                float f2 = ((float)fArray.length - 1.0f) * (float)i3 / (float)(n2 + n4);
                int n9 = (int)f2;
                f2 -= (float)((int)f2);
                float f3 = (1.0f - f2) * fArray[n9];
                if (n9 + 1 < fArray.length) {
                    f3 += f2 * fArray[n9 + 1];
                }
                graphics2D.setComposite(AlphaComposite.getInstance(3, f3));
                n8 = Math.min(n6, n2 + n4 - i3);
                graphics.drawImage(image, i3, i2, i3 + n8, i2 + n7, 0, 0, n8, n7, null);
            }
        }
        graphics2D.setComposite(composite);
    }

    protected Image getImage(String string, Color color) {
        Image image = this.images.get(string + "-" + color.getRGB());
        if (image == null && (image = this.imageFilter.colorize(this.getImage(string), color)) != null) {
            this.images.put(string + "-" + color.getRGB(), image);
        }
        return image;
    }

    protected Image getImage(String string) {
        Image image = this.images.get(string);
        if (image == null) {
            if (this.themeDir != null) {
                try {
                    URL uRL = new URL(this.themeDir, string);
                    image = (Image)new Privileged().doPrivileged(Privileged.GET_IMAGE, uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (image != null) {
                this.images.put(string, image);
            }
        }
        return image;
    }

    protected static JComponent findChild(JComponent jComponent, String string) {
        int n2 = jComponent.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i2);
            if (!string.equals(jComponent2.getName())) continue;
            return jComponent2;
        }
        return null;
    }

    protected Map getFrameGeometry() {
        return this.frameGeometry;
    }

    protected void setFrameGeometry(JComponent jComponent, Map map) {
        this.frameGeometry = map;
        if (this.getInt("top_height") == 0) {
            map.put("top_height", new Integer(jComponent.getHeight()));
        }
    }

    protected int getInt(String string) {
        Integer n2 = (Integer)this.frameGeometry.get(string);
        if (n2 == null) {
            n2 = this.variables.get(string);
        }
        return n2 != null ? n2 : 0;
    }

    protected boolean getBoolean(String string, boolean bl2) {
        Boolean bl3 = (Boolean)this.frameGeometry.get(string);
        return bl3 != null ? bl3 : bl2;
    }

    protected void drawArc(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "start_angle"));
        int n7 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "extent_angle"));
        boolean bl2 = this.getBooleanAttr(node, "filled", false);
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        graphics.setColor(color);
        if (bl2) {
            graphics.fillArc(n2, n3, n4, n5, n6, n7);
        } else {
            graphics.drawArc(n2, n3, n4, n5, n6, n7);
        }
    }

    protected void drawLine(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x1"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y1"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x2"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y2"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"), 1);
        graphics.setColor(color);
        if (n6 != 1) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(n6));
            graphics2D.drawLine(n2, n3, n4, n5);
            graphics2D.setStroke(stroke);
        } else {
            graphics.drawLine(n2, n3, n4, n5);
        }
    }

    protected void drawRectangle(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        boolean bl2 = this.getBooleanAttr(node, "filled", false);
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        graphics.setColor(color);
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        if (bl2) {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            graphics.drawRect(n2, n3, n4, n5);
        }
    }

    protected void drawTile(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "tile_width"));
        int n7 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "tile_height"));
        int n8 = this.getInt("width");
        int n9 = this.getInt("height");
        if (n8 == -1) {
            n2 -= n4;
        }
        if (n9 == -1) {
            n3 -= n5;
        }
        Shape shape = graphics.getClip();
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).clip(new Rectangle(n2, n3, n4, n5));
        }
        this.variables.put("width", n6);
        this.variables.put("height", n7);
        Node node2 = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        for (int i2 = n3; i2 < n3 + n5; i2 += n7) {
            for (int i3 = n2; i3 < n2 + n4; i3 += n6) {
                graphics.translate(i3, i2);
                this.draw(node2, graphics, jInternalFrame);
                graphics.translate(-i3, -i2);
            }
        }
        this.variables.put("width", n8);
        this.variables.put("height", n9);
        graphics.setClip(shape);
    }

    protected void drawTint(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Color color = this.parseColor(this.getStringAttr(namedNodeMap, "color"));
        float f2 = Float.parseFloat(this.getStringAttr(namedNodeMap, "alpha"));
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f2);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setColor(color);
            graphics2D.fillRect(n2, n3, n4, n5);
            graphics2D.setComposite(composite);
        }
    }

    protected void drawTitle(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "color");
        int n2 = string.indexOf("gtk:fg[");
        if (n2 > 0) {
            string = string.substring(0, n2) + "gtk:text[" + string.substring(n2 + 7);
        }
        Color color = this.parseColor(string);
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        String string2 = jInternalFrame.getTitle();
        if (string2 != null) {
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jInternalFrame, graphics);
            if (jInternalFrame.getComponentOrientation().isLeftToRight()) {
                string2 = SwingUtilities2.clipStringIfNecessary(jInternalFrame, fontMetrics, string2, this.calculateTitleTextWidth(graphics, jInternalFrame));
            }
            graphics.setColor(color);
            SwingUtilities2.drawString((JComponent)jInternalFrame, graphics, string2, n3, n4 + fontMetrics.getAscent());
        }
    }

    protected Dimension calculateButtonSize(JComponent jComponent) {
        int n2;
        int n3 = this.getInt("button_height");
        if (n3 == 0) {
            n3 = jComponent.getHeight();
            if (n3 == 0) {
                n3 = 13;
            } else {
                Insets insets = (Insets)this.frameGeometry.get("button_border");
                if (insets != null) {
                    n3 -= insets.top + insets.bottom;
                }
            }
        }
        if ((n2 = this.getInt("button_width")) == 0) {
            n2 = n3;
            Float f2 = (Float)this.frameGeometry.get("aspect_ratio");
            if (f2 != null) {
                n2 = (int)((float)n3 / f2.floatValue());
            }
        }
        return new Dimension(n2, n3);
    }

    protected Rectangle calculateTitleArea(JInternalFrame jInternalFrame) {
        JComponent jComponent = Metacity.findChild(jInternalFrame, "InternalFrame.northPane");
        Dimension dimension = this.calculateButtonSize(jComponent);
        Insets insets = (Insets)this.frameGeometry.get("title_border");
        Rectangle rectangle = new Rectangle();
        rectangle.x = this.getInt("left_titlebar_edge") + dimension.width;
        rectangle.y = 0;
        rectangle.height = jComponent.getHeight();
        if (insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
        }
        rectangle.width = jComponent.getWidth() - rectangle.x - this.getInt("right_titlebar_edge");
        if (jInternalFrame.isClosable()) {
            rectangle.width -= dimension.width;
        }
        if (jInternalFrame.isMaximizable()) {
            rectangle.width -= dimension.width;
        }
        if (jInternalFrame.isIconifiable()) {
            rectangle.width -= dimension.width;
        }
        if (insets != null) {
            rectangle.width -= insets.right;
        }
        return rectangle;
    }

    protected int calculateTitleTextWidth(Graphics graphics, JInternalFrame jInternalFrame) {
        String string = jInternalFrame.getTitle();
        if (string != null) {
            Rectangle rectangle = this.calculateTitleArea(jInternalFrame);
            return Math.min(SwingUtilities2.stringWidth(jInternalFrame, SwingUtilities2.getFontMetrics(jInternalFrame, graphics), string), rectangle.width);
        }
        return 0;
    }

    protected void setClip(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).clip(new Rectangle(n2, n3, n4, n5));
        }
    }

    protected void drawGTKArrow(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "arrow");
        String string2 = this.getStringAttr(namedNodeMap, "shadow");
        String string3 = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n6 = -1;
        if ("NORMAL".equals(string3)) {
            n6 = 1;
        } else if ("SELECTED".equals(string3)) {
            n6 = 512;
        } else if ("INSENSITIVE".equals(string3)) {
            n6 = 8;
        } else if ("PRELIGHT".equals(string3)) {
            n6 = 2;
        }
        int n7 = -1;
        if ("in".equals(string2)) {
            n7 = 0;
        } else if ("out".equals(string2)) {
            n7 = 1;
        } else if ("etched_in".equals(string2)) {
            n7 = 2;
        } else if ("etched_out".equals(string2)) {
            n7 = 3;
        } else if ("none".equals(string2)) {
            n7 = 4;
        }
        int n8 = -1;
        if ("up".equals(string)) {
            n8 = 100;
        } else if ("down".equals(string)) {
            n8 = 101;
        } else if ("left".equals(string)) {
            n8 = 102;
        } else if ("right".equals(string)) {
            n8 = 103;
        }
        GTKEngine gTKEngine = ((GTKStyle)this.context.getStyle()).getEngine(this.context);
        gTKEngine.paintArrow(this.context, graphics, n6, n7, n8, null, n2, n3, n4, n5);
    }

    protected void drawGTKBox(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "shadow");
        String string2 = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        int n6 = -1;
        if ("NORMAL".equals(string2)) {
            n6 = 1;
        } else if ("SELECTED".equals(string2)) {
            n6 = 512;
        } else if ("INSENSITIVE".equals(string2)) {
            n6 = 8;
        } else if ("PRELIGHT".equals(string2)) {
            n6 = 2;
        }
        int n7 = -1;
        if ("in".equals(string)) {
            n7 = 0;
        } else if ("out".equals(string)) {
            n7 = 1;
        } else if ("etched_in".equals(string)) {
            n7 = 2;
        } else if ("etched_out".equals(string)) {
            n7 = 3;
        } else if ("none".equals(string)) {
            n7 = 4;
        }
        GTKEngine.INSTANCE.paintBox(this.context, graphics, n6, n7, null, n2, n3, n4, n5);
    }

    protected void drawGTKVLine(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "state").toUpperCase();
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y1"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y2"));
        int n5 = -1;
        if ("NORMAL".equals(string)) {
            n5 = 1;
        } else if ("SELECTED".equals(string)) {
            n5 = 512;
        } else if ("INSENSITIVE".equals(string)) {
            n5 = 8;
        } else if ("PRELIGHT".equals(string)) {
            n5 = 2;
        }
        GTKEngine.INSTANCE.paintVline(this.context, graphics, n5, null, n2, n3, 1, n4 - n3);
    }

    protected void drawGradient(Node node, Graphics graphics) {
        boolean bl2;
        int n2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "type");
        float f2 = this.getFloatAttr(node, "alpha", -1.0f);
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n3 -= n5;
        }
        if (this.getInt("height") == -1) {
            n4 -= n6;
        }
        Node[] nodeArray = this.getNodesByName(node, "color");
        Color[] colorArray = new Color[nodeArray.length];
        for (n2 = 0; n2 < nodeArray.length; ++n2) {
            colorArray[n2] = this.parseColor(this.getStringAttr(nodeArray[n2], "value"));
        }
        n2 = "diagonal".equals(string) || "horizontal".equals(string) ? 1 : 0;
        boolean bl3 = bl2 = "diagonal".equals(string) || "vertical".equals(string);
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            if (f2 >= 0.0f) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
            }
            int n7 = colorArray.length - 1;
            for (int i2 = 0; i2 < n7; ++i2) {
                graphics2D.setPaint(new GradientPaint(n3 + (n2 != 0 ? i2 * n5 / n7 : 0), n4 + (bl2 ? i2 * n6 / n7 : 0), colorArray[i2], n3 + (n2 != 0 ? (i2 + 1) * n5 / n7 : 0), n4 + (bl2 ? (i2 + 1) * n6 / n7 : 0), colorArray[i2 + 1]));
                graphics2D.fillRect(n3 + (n2 != 0 ? i2 * n5 / n7 : 0), n4 + (bl2 ? i2 * n6 / n7 : 0), n2 != 0 ? n5 / n7 : n5, bl2 ? n6 / n7 : n6);
            }
            graphics2D.setComposite(composite);
        }
    }

    protected void drawImage(Node node, Graphics graphics) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "filename");
        String string2 = this.getStringAttr(namedNodeMap, "colorize");
        Color color = string2 != null ? this.parseColor(string2) : null;
        String string3 = this.getStringAttr(namedNodeMap, "alpha");
        Image image = color != null ? this.getImage(string, color) : this.getImage(string);
        this.variables.put("object_width", image.getWidth(null));
        this.variables.put("object_height", image.getHeight(null));
        String string4 = this.getStringAttr(namedNodeMap, "fill_type");
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        if (string3 != null) {
            if ("tile".equals(string4)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                float[] fArray = new float[stringTokenizer.countTokens()];
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    fArray[i2] = Float.parseFloat(stringTokenizer.nextToken());
                }
                this.tileImage(graphics, image, n2, n3, n4, n5, fArray);
            } else {
                float f2 = Float.parseFloat(string3);
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                    graphics2D.drawImage(image, n2, n3, n4, n5, null);
                    graphics2D.setComposite(composite);
                }
            }
        } else {
            graphics.drawImage(image, n2, n3, n4, n5, null);
        }
    }

    protected void drawIcon(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = this.getStringAttr(namedNodeMap, "alpha");
        int n2 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"));
        int n3 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"));
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"));
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"));
        if (this.getInt("width") == -1) {
            n2 -= n4;
        }
        if (this.getInt("height") == -1) {
            n3 -= n5;
        }
        if (string != null) {
            float f2 = Float.parseFloat(string);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                icon.paintIcon(jInternalFrame, graphics, n2, n3);
                graphics2D.setComposite(composite);
            }
        } else {
            icon.paintIcon(jInternalFrame, graphics, n2, n3);
        }
    }

    protected void drawInclude(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        int n2 = this.getInt("width");
        int n3 = this.getInt("height");
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n4 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "x"), 0);
        int n5 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "y"), 0);
        int n6 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "width"), -1);
        int n7 = this.aee.evaluate(this.getStringAttr(namedNodeMap, "height"), -1);
        if (n6 != -1) {
            this.variables.put("width", n6);
        }
        if (n7 != -1) {
            this.variables.put("height", n7);
        }
        Node node2 = this.getNode("draw_ops", new String[]{"name", this.getStringAttr(node, "name")});
        graphics.translate(n4, n5);
        this.draw(node2, graphics, jInternalFrame);
        graphics.translate(-n4, -n5);
        if (n6 != -1) {
            this.variables.put("width", n2);
        }
        if (n7 != -1) {
            this.variables.put("height", n3);
        }
    }

    protected void draw(Node node, Graphics graphics, JInternalFrame jInternalFrame) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            Shape shape = graphics.getClip();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                if (node2.getNodeType() != 1) continue;
                try {
                    String string = node2.getNodeName();
                    if ("include".equals(string)) {
                        this.drawInclude(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("arc".equals(string)) {
                        this.drawArc(node2, graphics);
                        continue;
                    }
                    if ("clip".equals(string)) {
                        this.setClip(node2, graphics);
                        continue;
                    }
                    if ("gradient".equals(string)) {
                        this.drawGradient(node2, graphics);
                        continue;
                    }
                    if ("gtk_arrow".equals(string)) {
                        this.drawGTKArrow(node2, graphics);
                        continue;
                    }
                    if ("gtk_box".equals(string)) {
                        this.drawGTKBox(node2, graphics);
                        continue;
                    }
                    if ("gtk_vline".equals(string)) {
                        this.drawGTKVLine(node2, graphics);
                        continue;
                    }
                    if ("image".equals(string)) {
                        this.drawImage(node2, graphics);
                        continue;
                    }
                    if ("icon".equals(string)) {
                        this.drawIcon(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("line".equals(string)) {
                        this.drawLine(node2, graphics);
                        continue;
                    }
                    if ("rectangle".equals(string)) {
                        this.drawRectangle(node2, graphics);
                        continue;
                    }
                    if ("tint".equals(string)) {
                        this.drawTint(node2, graphics);
                        continue;
                    }
                    if ("tile".equals(string)) {
                        this.drawTile(node2, graphics, jInternalFrame);
                        continue;
                    }
                    if ("title".equals(string)) {
                        this.drawTitle(node2, graphics, jInternalFrame);
                        continue;
                    }
                    System.err.println("Unknown Metacity drawing op: " + node2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    Metacity.logError(this.themeName, numberFormatException);
                }
            }
            graphics.setClip(shape);
        }
    }

    protected void drawPiece(Node node, Graphics graphics, String string, int n2, int n3, int n4, int n5, JInternalFrame jInternalFrame) {
        Node node2 = this.getNode(node, "piece", new String[]{"position", string});
        if (node2 != null) {
            String string2 = this.getStringAttr(node2, "draw_ops");
            Node node3 = string2 != null ? this.getNode("draw_ops", new String[]{"name", string2}) : this.getNode(node2, "draw_ops", null);
            this.variables.put("width", n4);
            this.variables.put("height", n5);
            graphics.translate(n2, n3);
            this.draw(node3, graphics, jInternalFrame);
            graphics.translate(-n2, -n3);
        }
    }

    Insets getBorderInsets(SynthContext synthContext, Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = ((Insets)this.frameGeometry.get((Object)"title_border")).top;
        insets.bottom = this.getInt("bottom_height");
        insets.left = this.getInt("left_width");
        insets.right = this.getInt("right_width");
        return insets;
    }

    protected static void logError(String string, Exception exception) {
        Metacity.logError(string, exception.toString());
    }

    protected static void logError(String string, String string2) {
        if (!errorLogged) {
            System.err.println("Exception in Metacity for theme \"" + string + "\": " + string2);
            errorLogged = true;
        }
    }

    protected static Document getXMLDoc(URL uRL) throws IOException, ParserConfigurationException, SAXException {
        if (documentBuilder == null) {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        return documentBuilder.parse(bufferedInputStream);
    }

    protected Node[] getNodesByName(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = nodeList.item(i2);
            if (!string.equals(node2.getNodeName())) continue;
            arrayList.add(node2);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    protected Node getNode(String string, String[] stringArray) {
        NodeList nodeList = xmlDoc.getElementsByTagName(string);
        return nodeList != null ? this.getNode(nodeList, string, stringArray) : null;
    }

    protected Node getNode(Node node, String string, String[] stringArray) {
        Node node2;
        String string2;
        Node node3 = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            node3 = this.getNode(nodeList, string, stringArray);
        }
        if (node3 == null && (string2 = this.getStringAttr(node, "parent")) != null && (node2 = this.getNode(node.getParentNode(), node.getNodeName(), new String[]{"name", string2})) != null) {
            node3 = this.getNode(node2, string, stringArray);
        }
        return node3;
    }

    protected Node getNode(NodeList nodeList, String string, String[] stringArray) {
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (!string.equals(node.getNodeName())) continue;
            if (stringArray != null) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap == null) continue;
                boolean bl2 = true;
                int n3 = stringArray.length / 2;
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string2 = stringArray[i3 * 2];
                    String string3 = stringArray[i3 * 2 + 1];
                    Node node2 = namedNodeMap.getNamedItem(string2);
                    if (node2 != null && string3.equals(node2.getNodeValue())) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                return node;
            }
            return node;
        }
        return null;
    }

    protected String getStringAttr(Node node, String string) {
        Node node2;
        String string2;
        String string3 = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (string3 = this.getStringAttr(namedNodeMap, string)) == null && (string2 = this.getStringAttr(namedNodeMap, "parent")) != null && (node2 = this.getNode(node.getParentNode(), node.getNodeName(), new String[]{"name", string2})) != null) {
            string3 = this.getStringAttr(node2, string);
        }
        return string3;
    }

    protected String getStringAttr(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        return node != null ? node.getNodeValue() : null;
    }

    protected boolean getBooleanAttr(Node node, String string, boolean bl2) {
        String string2 = this.getStringAttr(node, string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return bl2;
    }

    protected int getIntAttr(Node node, String string, int n2) {
        String string2 = this.getStringAttr(node, string);
        int n3 = n2;
        if (string2 != null) {
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(this.themeName, numberFormatException);
            }
        }
        return n3;
    }

    protected float getFloatAttr(Node node, String string, float f2) {
        String string2 = this.getStringAttr(node, string);
        float f3 = f2;
        if (string2 != null) {
            try {
                f3 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Metacity.logError(this.themeName, numberFormatException);
            }
        }
        return f3;
    }

    protected Color parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = stringTokenizer.countTokens();
        if (n2 > 1) {
            String string2 = stringTokenizer.nextToken();
            if ("shade".equals(string2)) {
                assert (n2 == 3);
                Color color = this.parseColor2(stringTokenizer.nextToken());
                float f2 = Float.parseFloat(stringTokenizer.nextToken());
                return GTKColorType.adjustColor(color, 1.0f, f2, f2);
            }
            if ("blend".equals(string2)) {
                assert (n2 == 4);
                Color color = this.parseColor2(stringTokenizer.nextToken());
                Color color2 = this.parseColor2(stringTokenizer.nextToken());
                float f3 = Float.parseFloat(stringTokenizer.nextToken());
                return new Color((int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f3), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f3), (int)((float)color.getRed() + (float)(color2.getRed() - color.getRed()) * f3));
            }
            System.err.println("Unknown Metacity color function=" + string);
            return null;
        }
        return this.parseColor2(string);
    }

    protected Color parseColor2(String string) {
        int n2;
        Color color = null;
        if (string.startsWith("gtk:") && (n2 = string.indexOf(91)) > 3) {
            String string2 = string.substring(4, n2).toLowerCase();
            int n3 = string.indexOf(93);
            if (n3 > n2 + 1) {
                String string3 = string.substring(n2 + 1, n3).toUpperCase();
                int n4 = -1;
                if ("ACTIVE".equals(string3)) {
                    n4 = 4;
                } else if ("INSENSITIVE".equals(string3)) {
                    n4 = 8;
                } else if ("NORMAL".equals(string3)) {
                    n4 = 1;
                } else if ("PRELIGHT".equals(string3)) {
                    n4 = 2;
                } else if ("SELECTED".equals(string3)) {
                    n4 = 512;
                }
                ColorType colorType = null;
                if ("fg".equals(string2)) {
                    colorType = GTKColorType.FOREGROUND;
                } else if ("bg".equals(string2)) {
                    colorType = GTKColorType.BACKGROUND;
                } else if ("base".equals(string2)) {
                    colorType = GTKColorType.TEXT_BACKGROUND;
                } else if ("text".equals(string2)) {
                    colorType = GTKColorType.TEXT_FOREGROUND;
                } else if ("dark".equals(string2)) {
                    colorType = GTKColorType.DARK;
                } else if ("light".equals(string2)) {
                    colorType = GTKColorType.LIGHT;
                }
                if (n4 >= 0 && colorType != null) {
                    color = ((GTKStyle)this.context.getStyle()).getGTKColor(this.context.getComponent(), this.context.getRegion(), n4, colorType);
                }
            }
        }
        if (color == null) {
            color = GTKParser.parseColorString(string);
        }
        return color;
    }

    static {
        for (String string : themeNames = new String[]{Metacity.getUserTheme(), "Bluecurve", "Crux", "SwingFallbackTheme"}) {
            if (string != null) {
                try {
                    INSTANCE = new Metacity(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    Metacity.logError(string, iOException);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    Metacity.logError(string, parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    Metacity.logError(string, sAXException);
                }
            }
            if (INSTANCE != null) break;
        }
        if (INSTANCE == null) {
            throw new Error("Could not find any installed metacity theme, and fallback failed");
        }
        errorLogged = false;
    }

    class ArithmeticExpressionEvaluator {
        private PeekableStringTokenizer tokenizer;

        ArithmeticExpressionEvaluator() {
        }

        int evaluate(String string) {
            this.tokenizer = new PeekableStringTokenizer(string, " \t+-*/%()", true);
            return Math.round(this.expression());
        }

        int evaluate(String string, int n2) {
            return string != null ? this.evaluate(string) : n2;
        }

        public float expression() {
            float f2 = this.getTermValue();
            boolean bl2 = false;
            while (!bl2 && this.tokenizer.hasMoreTokens()) {
                String string = this.tokenizer.peek();
                if ("+".equals(string) || "-".equals(string) || "`max`".equals(string) || "`min`".equals(string)) {
                    this.tokenizer.nextToken();
                    float f3 = this.getTermValue();
                    if ("+".equals(string)) {
                        f2 += f3;
                        continue;
                    }
                    if ("-".equals(string)) {
                        f2 -= f3;
                        continue;
                    }
                    if ("`max`".equals(string)) {
                        f2 = Math.max(f2, f3);
                        continue;
                    }
                    if (!"`min`".equals(string)) continue;
                    f2 = Math.min(f2, f3);
                    continue;
                }
                bl2 = true;
            }
            return f2;
        }

        public float getTermValue() {
            float f2 = this.getFactorValue();
            boolean bl2 = false;
            while (!bl2 && this.tokenizer.hasMoreTokens()) {
                String string = this.tokenizer.peek();
                if ("*".equals(string) || "/".equals(string) || "%".equals(string)) {
                    this.tokenizer.nextToken();
                    float f3 = this.getFactorValue();
                    if ("*".equals(string)) {
                        f2 *= f3;
                        continue;
                    }
                    if ("/".equals(string)) {
                        f2 /= f3;
                        continue;
                    }
                    f2 %= f3;
                    continue;
                }
                bl2 = true;
            }
            return f2;
        }

        public float getFactorValue() {
            float f2;
            if ("(".equals(this.tokenizer.peek())) {
                this.tokenizer.nextToken();
                f2 = this.expression();
                this.tokenizer.nextToken();
            } else {
                String string = this.tokenizer.nextToken();
                if (Character.isDigit(string.charAt(0))) {
                    f2 = Float.parseFloat(string);
                } else {
                    Integer n2 = (Integer)Metacity.this.variables.get(string);
                    if (n2 == null) {
                        n2 = (Integer)Metacity.this.getFrameGeometry().get(string);
                    }
                    if (n2 == null) {
                        Metacity.logError(Metacity.this.themeName, "Variable \"" + string + "\" not defined");
                        return 0.0f;
                    }
                    f2 = n2 != null ? (float)n2.intValue() : 0.0f;
                }
            }
            return f2;
        }
    }

    private class ColorizeImageFilter
    extends RGBImageFilter {
        double cr;
        double cg;
        double cb;

        public ColorizeImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this.cr = (double)color.getRed() / 255.0;
            this.cg = (double)color.getGreen() / 255.0;
            this.cb = (double)color.getBlue() / 255.0;
        }

        public Image colorize(Image image, Color color) {
            this.setColor(color);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this);
            return new ImageIcon(Metacity.this.context.getComponent().createImage(filteredImageSource)).getImage();
        }

        public int filterRGB(int n2, int n3, int n4) {
            double d2;
            double d3;
            double d4;
            double d5 = (double)(2 * (n4 & 0xFF)) / 255.0;
            if (d5 <= 1.0) {
                d4 = this.cr * d5;
                d3 = this.cg * d5;
                d2 = this.cb * d5;
            } else {
                d4 = this.cr + (1.0 - this.cr) * (d5 -= 1.0);
                d3 = this.cg + (1.0 - this.cg) * d5;
                d2 = this.cb + (1.0 - this.cb) * d5;
            }
            return (n4 & 0xFF000000) + ((int)(d4 * 255.0) << 16) + ((int)(d3 * 255.0) << 8) + (int)(d2 * 255.0);
        }
    }

    static class PeekableStringTokenizer
    extends StringTokenizer {
        String token = null;

        public PeekableStringTokenizer(String string, String string2, boolean bl2) {
            super(string, string2, bl2);
            this.peek();
        }

        public String peek() {
            if (this.token == null) {
                this.token = this.nextToken();
            }
            return this.token;
        }

        public boolean hasMoreTokens() {
            return this.token != null || super.hasMoreTokens();
        }

        public String nextToken() {
            if (this.token != null) {
                String string = this.token;
                this.token = null;
                if (this.hasMoreTokens()) {
                    this.peek();
                }
                return string;
            }
            String string = super.nextToken();
            while ((string.equals(" ") || string.equals("\t")) && this.hasMoreTokens()) {
                string = super.nextToken();
            }
            return string;
        }
    }

    private static class Privileged
    implements PrivilegedAction {
        private static int GET_THEME_DIR = 0;
        private static int GET_USER_THEME = 1;
        private static int GET_IMAGE = 2;
        private int type;
        private Object arg;

        private Privileged() {
        }

        public Object doPrivileged(int n2, Object object) {
            this.type = n2;
            this.arg = object;
            return AccessController.doPrivileged(this);
        }

        public Object run() {
            if (this.type == GET_THEME_DIR) {
                Serializable serializable;
                String string = File.separator;
                String[] stringArray = new String[]{userHome + string + ".themes", System.getProperty("swing.metacitythemedir"), "/usr/share/themes", "/usr/gnome/share/themes", "/opt/gnome2/share/themes"};
                URL uRL = null;
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2] == null || !new File((File)(serializable = new File(stringArray[i2] + string + this.arg + string + "metacity-1")), "metacity-theme-1.xml").canRead()) continue;
                    try {
                        uRL = ((File)serializable).toURL();
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                    break;
                }
                if (uRL == null) {
                    String string2 = "resources/metacity/" + this.arg + "/metacity-1/metacity-theme-1.xml";
                    serializable = this.getClass().getResource(string2);
                    if (serializable != null) {
                        String string3 = ((URL)serializable).toString();
                        try {
                            uRL = new URL(string3.substring(0, string3.lastIndexOf(47)) + "/");
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                    }
                }
                return uRL;
            }
            if (this.type == GET_USER_THEME) {
                try {
                    String string;
                    int n2;
                    int n3;
                    userHome = System.getProperty("user.home");
                    String string4 = System.getProperty("swing.metacitythemename");
                    if (string4 != null) {
                        return string4;
                    }
                    URL uRL = new URL(new File(userHome).toURL(), ".gconf/apps/metacity/general/%25gconf.xml");
                    InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), "ISO-8859-1");
                    char[] cArray = new char[1024];
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n3 = inputStreamReader.read(cArray)) >= 0) {
                        stringBuffer.append(cArray, 0, n3);
                    }
                    ((Reader)inputStreamReader).close();
                    String string5 = stringBuffer.toString();
                    if (string5 != null && (n2 = (string = string5.toLowerCase()).indexOf("<entry name=\"theme\"")) >= 0 && (n2 = string.indexOf("<stringvalue>", n2)) > 0) {
                        int n4 = string5.indexOf("<", n2 += "<stringvalue>".length());
                        return string5.substring(n2, n4);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            if (this.type == GET_IMAGE) {
                return new ImageIcon((URL)this.arg).getImage();
            }
            return null;
        }
    }

    static class RoundRectClipShape
    extends RectangularShape {
        static final int TOP_LEFT = 1;
        static final int TOP_RIGHT = 2;
        static final int BOTTOM_LEFT = 4;
        static final int BOTTOM_RIGHT = 8;
        int x;
        int y;
        int width;
        int height;
        int arcwidth;
        int archeight;
        int corners;

        public RoundRectClipShape() {
        }

        public RoundRectClipShape(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.setRoundedRect(n2, n3, n4, n5, n6, n7, n8);
        }

        public void setRoundedRect(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            this.corners = n8;
            this.x = n2;
            this.y = n3;
            this.width = n4;
            this.height = n5;
            this.arcwidth = n6;
            this.archeight = n7;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public boolean isEmpty() {
            return false;
        }

        public Rectangle2D getBounds2D() {
            return null;
        }

        public int getCornerFlags() {
            return this.corners;
        }

        public void setFrame(double d2, double d3, double d4, double d5) {
        }

        public boolean contains(double d2, double d3) {
            return false;
        }

        private int classify(double d2, double d3, double d4, double d5) {
            return 0;
        }

        public boolean intersects(double d2, double d3, double d4, double d5) {
            return false;
        }

        public boolean contains(double d2, double d3, double d4, double d5) {
            return false;
        }

        public PathIterator getPathIterator(AffineTransform affineTransform) {
            return new RoundishRectIterator(this, affineTransform);
        }

        static class RoundishRectIterator
        implements PathIterator {
            double x;
            double y;
            double w;
            double h;
            double aw;
            double ah;
            AffineTransform affine;
            int index;
            double[][] ctrlpts;
            int[] types;
            private static final double angle = 0.7853981633974483;
            private static final double a = 1.0 - Math.cos(0.7853981633974483);
            private static final double b = Math.tan(0.7853981633974483);
            private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
            private static final double cv = 1.3333333333333333 * a * b / c;
            private static final double acv = (1.0 - cv) / 2.0;
            private static final double[][] CtrlPtTemplate = new double[][]{{0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, -0.5}, {0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, -0.5, 1.0, 0.0}, {1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.5}, {1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.0}, {0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5}, new double[0]};
            private static final int[] CornerFlags = new int[]{4, 8, 2, 1};

            RoundishRectIterator(RoundRectClipShape roundRectClipShape, AffineTransform affineTransform) {
                this.x = roundRectClipShape.getX();
                this.y = roundRectClipShape.getY();
                this.w = roundRectClipShape.getWidth();
                this.h = roundRectClipShape.getHeight();
                this.aw = Math.min(this.w, Math.abs(roundRectClipShape.getArcWidth()));
                this.ah = Math.min(this.h, Math.abs(roundRectClipShape.getArcHeight()));
                this.affine = affineTransform;
                if (this.w < 0.0 || this.h < 0.0) {
                    this.ctrlpts = new double[0][];
                    this.types = new int[0];
                } else {
                    int n2;
                    int n3 = roundRectClipShape.getCornerFlags();
                    int n4 = 5;
                    for (n2 = 1; n2 < 16; n2 <<= 1) {
                        if ((n3 & n2) == 0) continue;
                        ++n4;
                    }
                    this.ctrlpts = new double[n4][];
                    this.types = new int[n4];
                    n2 = 0;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        this.types[n2] = 1;
                        if ((n3 & CornerFlags[i2]) == 0) {
                            this.ctrlpts[n2++] = CtrlPtTemplate[i2 * 3 + 0];
                            continue;
                        }
                        this.ctrlpts[n2++] = CtrlPtTemplate[i2 * 3 + 1];
                        this.types[n2] = 3;
                        this.ctrlpts[n2++] = CtrlPtTemplate[i2 * 3 + 2];
                    }
                    this.types[n2] = 4;
                    this.ctrlpts[n2++] = CtrlPtTemplate[12];
                    this.types[0] = 0;
                }
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.index >= this.ctrlpts.length;
            }

            public void next() {
                ++this.index;
            }

            public int currentSegment(float[] fArray) {
                if (this.isDone()) {
                    throw new NoSuchElementException("roundrect iterator out of bounds");
                }
                double[] dArray = this.ctrlpts[this.index];
                int n2 = 0;
                for (int i2 = 0; i2 < dArray.length; i2 += 4) {
                    fArray[n2++] = (float)(this.x + dArray[i2 + 0] * this.w + dArray[i2 + 1] * this.aw);
                    fArray[n2++] = (float)(this.y + dArray[i2 + 2] * this.h + dArray[i2 + 3] * this.ah);
                }
                if (this.affine != null) {
                    this.affine.transform(fArray, 0, fArray, 0, n2 / 2);
                }
                return this.types[this.index];
            }

            public int currentSegment(double[] dArray) {
                return 0;
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return null;
            }
            Dimension dimension = Metacity.this.calculateButtonSize(jComponent);
            Insets insets = (Insets)Metacity.this.getFrameGeometry().get("title_border");
            Insets insets2 = (Insets)Metacity.this.getFrameGeometry().get("button_border");
            int n4 = Metacity.this.getInt("left_titlebar_edge") + dimension.width + Metacity.this.getInt("right_titlebar_edge");
            if (insets != null) {
                n4 += insets.left + insets.right;
            }
            if (jInternalFrame.isClosable()) {
                n4 += dimension.width;
            }
            if (jInternalFrame.isMaximizable()) {
                n4 += dimension.width;
            }
            if (jInternalFrame.isIconifiable()) {
                n4 += dimension.width;
            }
            FontMetrics fontMetrics = jInternalFrame.getFontMetrics(jComponent.getFont());
            String string = jInternalFrame.getTitle();
            int n5 = string != null ? SwingUtilities2.stringWidth(jInternalFrame, fontMetrics, string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = SwingUtilities2.stringWidth(jInternalFrame, fontMetrics, string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            n2 = fontMetrics.getHeight() + Metacity.this.getInt("title_vertical_pad");
            if (insets != null) {
                n2 += insets.top + insets.bottom;
            }
            int n7 = dimension.height;
            if (insets2 != null) {
                n7 += insets2.top + insets2.bottom;
            }
            int n8 = Math.max(n7, n2);
            return new Dimension(n4, n8);
        }

        public void layoutContainer(Container container) {
            JInternalFrame jInternalFrame;
            JComponent jComponent = (JComponent)container;
            Container container2 = jComponent.getParent();
            if (container2 instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)container2;
            } else if (container2 instanceof JInternalFrame.JDesktopIcon) {
                jInternalFrame = ((JInternalFrame.JDesktopIcon)container2).getInternalFrame();
            } else {
                return;
            }
            Map map = Metacity.this.getFrameGeometry();
            int n2 = jComponent.getWidth();
            int n3 = jComponent.getHeight();
            JComponent jComponent2 = Metacity.findChild(jComponent, "InternalFrameTitlePane.menuButton");
            JComponent jComponent3 = Metacity.findChild(jComponent, "InternalFrameTitlePane.iconifyButton");
            JComponent jComponent4 = Metacity.findChild(jComponent, "InternalFrameTitlePane.maximizeButton");
            JComponent jComponent5 = Metacity.findChild(jComponent, "InternalFrameTitlePane.closeButton");
            int n4 = 0;
            Insets insets = (Insets)map.get("button_border");
            Dimension dimension = Metacity.this.calculateButtonSize(jComponent);
            int n5 = Metacity.this.getInt("left_titlebar_edge");
            int n6 = insets != null ? insets.top : 0;
            jComponent2.setBounds(n5, n6, dimension.width, dimension.height);
            n5 = n2 - dimension.width - Metacity.this.getInt("right_titlebar_edge");
            if (insets != null) {
                n5 -= insets.right;
            }
            if (jInternalFrame.isClosable()) {
                jComponent5.setBounds(n5, n6, dimension.width, dimension.height);
                n5 -= dimension.width + n4;
            }
            if (jInternalFrame.isMaximizable()) {
                jComponent4.setBounds(n5, n6, dimension.width, dimension.height);
                n5 -= dimension.width + n4;
            }
            if (jInternalFrame.isIconifiable()) {
                jComponent3.setBounds(n5, n6, dimension.width, dimension.height);
            }
        }
    }
}

