/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Code;
import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class Package
implements Constants {
    int verbose;
    int magic;
    int package_minver;
    int package_majver;
    int default_modtime;
    int default_options;
    short default_class_majver;
    short default_class_minver;
    short min_class_majver;
    short min_class_minver;
    short max_class_majver;
    short max_class_minver;
    ConstantPool.IndexGroup cp;
    public static final Attribute.Layout attrCodeEmpty;
    public static final Attribute.Layout attrInnerClassesEmpty;
    public static final Attribute.Layout attrSourceFileSpecial;
    public static final Map attrDefs;
    ArrayList classes;
    ArrayList files;
    ArrayList allInnerClasses;
    HashMap allInnerClassesByThis;
    private static final int SLASH_MIN = 46;
    private static final int SLASH_MAX = 47;
    private static final int DOLLAR_MIN = 0;
    private static final int DOLLAR_MAX = 45;
    static final List noObjects;
    static final List noFields;
    static final List noMethods;
    static final List noInnerClasses;

    Package() {
        PropMap propMap = Utils.currentPropMap();
        if (propMap != null) {
            this.verbose = propMap.getInteger("com.sun.java.util.jar.pack.verbose");
        }
        this.default_modtime = 0;
        this.default_options = 0;
        this.default_class_majver = (short)-1;
        this.default_class_minver = 0;
        this.min_class_majver = (short)45;
        this.min_class_minver = (short)3;
        this.max_class_majver = (short)49;
        this.max_class_minver = 0;
        this.cp = new ConstantPool.IndexGroup();
        this.classes = new ArrayList();
        this.files = new ArrayList();
        this.allInnerClasses = new ArrayList();
        this.magic = -889270259;
        this.package_minver = 5;
        this.package_majver = 150;
    }

    public void reset() {
        this.cp = new ConstantPool.IndexGroup();
        this.classes.clear();
        this.files.clear();
    }

    int getDefaultClassVersion() {
        return (this.default_class_minver << 16) + (char)this.default_class_minver;
    }

    void checkVersion() {
        if (this.magic != -889270259) {
            String string = Integer.toHexString(this.magic);
            String string2 = Integer.toHexString(-889270259);
            throw new RuntimeException("Unexpected package magic number: got " + string + "; expected " + string2);
        }
        if (this.package_majver != 150 || this.package_minver != 5) {
            String string = this.package_majver + "." + this.package_minver;
            String string3 = "150.5";
            throw new RuntimeException("Unexpected package minor version: got " + string + "; expected " + string3);
        }
    }

    public List getClasses() {
        return this.classes;
    }

    void addClass(Class clazz) {
        assert (clazz.getPackage() == this);
        boolean bl2 = this.classes.add(clazz);
        assert (bl2);
        if (clazz.file == null) {
            clazz.initFile(null);
        }
        this.addFile(clazz.file);
    }

    public List getFiles() {
        return this.files;
    }

    public List getClassStubs() {
        ArrayList<File> arrayList = new ArrayList<File>(this.classes.size());
        for (Class clazz : this.classes) {
            assert (clazz.file.isClassStub());
            arrayList.add(clazz.file);
        }
        return arrayList;
    }

    File newStub(String string) {
        File file = new File(string);
        file.options |= 2;
        file.prepend = null;
        file.append = null;
        return file;
    }

    private static String fixupFileName(String string) {
        String string2 = string.replace(java.io.File.separatorChar, '/');
        if (string2.startsWith("/")) {
            throw new IllegalArgumentException("absolute file name " + string2);
        }
        return string2;
    }

    void addFile(File file) {
        boolean bl2 = this.files.add(file);
        assert (bl2);
    }

    public List getAllInnerClasses() {
        return this.allInnerClasses;
    }

    public void setAllInnerClasses(Collection collection) {
        assert (collection != this.allInnerClasses);
        this.allInnerClasses.clear();
        this.allInnerClasses.addAll(collection);
        this.allInnerClassesByThis = new HashMap(this.allInnerClasses.size());
        for (InnerClass innerClass : this.allInnerClasses) {
            InnerClass innerClass2 = this.allInnerClassesByThis.put(innerClass.thisClass, innerClass);
            assert (innerClass2 == null);
        }
    }

    public InnerClass getGlobalInnerClass(ConstantPool.Entry entry) {
        assert (entry instanceof ConstantPool.ClassEntry);
        return (InnerClass)this.allInnerClassesByThis.get(entry);
    }

    private static void visitInnerClassRefs(Collection collection, int n2, Collection collection2) {
        if (collection == null) {
            return;
        }
        if (n2 == 0) {
            collection2.add(Package.getRefString("InnerClasses"));
        }
        if (collection.size() > 0) {
            for (InnerClass innerClass : collection) {
                innerClass.visitRefs(n2, collection2);
            }
        }
    }

    static String[] parseInnerClassName(String string) {
        int n2;
        String string2;
        String string3;
        int n3 = string.length();
        int n4 = Package.lastIndexOf(46, 47, string, string.length()) + 1;
        int n5 = Package.lastIndexOf(0, 45, string, string.length());
        if (n5 < n4) {
            return null;
        }
        if (Package.isDigitString(string, n5 + 1, n3)) {
            string3 = string.substring(n5 + 1, n3);
            string2 = null;
            n2 = n5;
        } else {
            n2 = Package.lastIndexOf(0, 45, string, n5 - 1);
            if (n2 > n4 && Package.isDigitString(string, n2 + 1, n5)) {
                string3 = string.substring(n2 + 1, n5);
                string2 = string.substring(n5 + 1, n3).intern();
            } else {
                n2 = n5;
                string3 = null;
                string2 = string.substring(n5 + 1, n3).intern();
            }
        }
        String string4 = string3 == null ? string.substring(0, n2).intern() : null;
        return new String[]{string4, string3, string2};
    }

    private static int lastIndexOf(int n2, int n3, String string, int n4) {
        int n5 = n4;
        while (--n5 >= 0) {
            char c2 = string.charAt(n5);
            if (c2 < n2 || c2 > n3) continue;
            return n5;
        }
        return -1;
    }

    private static boolean isDigitString(String string, int n2, int n3) {
        if (n2 == n3) {
            return false;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    static String getObviousSourceFile(String string) {
        int n2;
        String string2 = string;
        int n3 = Package.lastIndexOf(46, 47, string2, string2.length()) + 1;
        string2 = string2.substring(n3);
        int n4 = string2.length();
        while ((n2 = Package.lastIndexOf(0, 45, string2, n4 - 1)) >= 0 && (n4 = n2) != 0) {
        }
        String string3 = string2.substring(0, n4) + ".java";
        return string3;
    }

    static ConstantPool.Utf8Entry getRefString(String string) {
        return ConstantPool.getUtf8Entry(string);
    }

    static ConstantPool.LiteralEntry getRefLiteral(Comparable comparable) {
        return ConstantPool.getLiteralEntry(comparable);
    }

    void stripAttributeKind(String string) {
        if (this.verbose > 0) {
            Utils.log.info("Stripping " + string.toLowerCase() + " data and attributes...");
        }
        if (string == "Debug") {
            this.strip("SourceFile");
            this.strip("LineNumberTable");
            this.strip("LocalVariableTable");
        }
        if (string == "Compile") {
            this.strip("Deprecated");
            this.strip("Synthetic");
        }
        if (string == "Exceptions") {
            this.strip("Exceptions");
        }
        if (string == "Constant") {
            this.stripConstantFields();
        }
    }

    public void trimToSize() {
        this.classes.trimToSize();
        for (Class clazz : this.classes) {
            clazz.trimToSize();
        }
        this.files.trimToSize();
    }

    public void strip(String string) {
        for (Class clazz : this.classes) {
            clazz.strip(string);
        }
    }

    public static String versionStringOf(int n2, int n3) {
        return n2 + "." + n3;
    }

    public void stripConstantFields() {
        for (Class clazz : this.classes) {
            Iterator iterator = clazz.fields.iterator();
            while (iterator.hasNext()) {
                Class.Field field = (Class.Field)iterator.next();
                if (!Modifier.isFinal(field.flags) || !Modifier.isStatic(field.flags) || field.getAttribute("ConstantValue") == null || field.getName().startsWith("serial") || this.verbose <= 2) continue;
                Utils.log.fine(">> Strip " + this + " ConstantValue");
                iterator.remove();
            }
        }
    }

    protected void visitRefs(int n2, Collection collection) {
        for (Comparable comparable : this.classes) {
            ((Class)comparable).visitRefs(n2, collection);
        }
        if (n2 != 0) {
            for (Comparable comparable : this.files) {
                ((File)comparable).visitRefs(n2, collection);
            }
            Package.visitInnerClassRefs(this.allInnerClasses, n2, collection);
        }
    }

    void reorderFiles(boolean bl2, boolean bl3) {
        if (!bl2) {
            Collections.sort(this.classes);
        }
        List list = this.getClassStubs();
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.isClassStub() && (!bl3 || !file.isDirectory())) continue;
            iterator.remove();
        }
        Collections.sort(this.files, new Comparator(){

            public int compare(Object object, Object object2) {
                String string;
                File file = (File)object;
                File file2 = (File)object2;
                String string2 = file.nameString;
                String string3 = file2.nameString;
                if (string2.equals(string3)) {
                    return 0;
                }
                if ("META-INF/MANIFEST.MF".equals(string2)) {
                    return -1;
                }
                if ("META-INF/MANIFEST.MF".equals(string3)) {
                    return 1;
                }
                String string4 = string2.substring(1 + string2.lastIndexOf(47));
                String string5 = string3.substring(1 + string3.lastIndexOf(47));
                String string6 = string4.substring(1 + string4.lastIndexOf(46));
                int n2 = string6.compareTo(string = string5.substring(1 + string5.lastIndexOf(46)));
                if (n2 != 0) {
                    return n2;
                }
                n2 = string2.compareTo(string3);
                return n2;
            }
        });
        this.files.addAll(list);
    }

    void trimStubs() {
        ListIterator listIterator = this.files.listIterator(this.files.size());
        while (listIterator.hasPrevious()) {
            File file = (File)listIterator.previous();
            if (!file.isTrivialClassStub()) {
                if (this.verbose <= 1) break;
                Utils.log.fine("Keeping last non-trivial " + file);
                break;
            }
            if (this.verbose > 2) {
                Utils.log.fine("Removing trivial " + file);
            }
            listIterator.remove();
        }
        if (this.verbose > 0) {
            Utils.log.info("Transmitting " + this.files.size() + " files, including per-file data for " + this.getClassStubs().size() + " classes out of " + this.classes.size());
        }
    }

    void buildGlobalConstantPool(Set set) {
        ConstantPool.Index index;
        byte by;
        int n2;
        if (this.verbose > 1) {
            Utils.log.fine("Checking for unused CP entries");
        }
        set.add(Package.getRefString(""));
        this.visitRefs(1, set);
        ConstantPool.completeReferencesIn(set, false);
        if (this.verbose > 1) {
            Utils.log.fine("Sorting CP entries");
        }
        ConstantPool.Index index2 = ConstantPool.makeIndex("unsorted", set);
        ConstantPool.Index[] indexArray = ConstantPool.partitionByTag(index2);
        for (n2 = 0; n2 < ConstantPool.TAGS_IN_ORDER.length; ++n2) {
            by = ConstantPool.TAGS_IN_ORDER[n2];
            index = indexArray[by];
            if (index == null) continue;
            ConstantPool.sort(index);
            this.cp.initIndexByTag(by, index);
            indexArray[by] = null;
        }
        for (n2 = 0; n2 < indexArray.length; ++n2) {
            assert (indexArray[n2] == null);
        }
        for (n2 = 0; n2 < ConstantPool.TAGS_IN_ORDER.length; ++n2) {
            by = ConstantPool.TAGS_IN_ORDER[n2];
            index = this.cp.getIndexByTag(by);
            assert (index.assertIsSorted());
            if (this.verbose <= 2) continue;
            Utils.log.fine(index.dumpString());
        }
    }

    void ensureAllClassFiles() {
        HashSet hashSet = new HashSet(this.files);
        for (Class clazz : this.classes) {
            if (hashSet.contains(clazz.file)) continue;
            this.files.add(clazz.file);
        }
    }

    static {
        HashMap hashMap = new HashMap(2);
        attrCodeEmpty = Attribute.define(hashMap, 2, "Code", "").layout();
        attrInnerClassesEmpty = Attribute.define(hashMap, 0, "InnerClasses", "").layout();
        attrSourceFileSpecial = Attribute.define(hashMap, 0, "SourceFile", "RUNH").layout();
        attrDefs = Collections.unmodifiableMap(hashMap);
        assert (Package.lastIndexOf(0, 45, "x$$y$", 4) == 2);
        assert (Package.lastIndexOf(46, 47, "x//y/", 4) == 2);
        noObjects = Arrays.asList(new Object[0]);
        noFields = Arrays.asList(new Class.Field[0]);
        noMethods = Arrays.asList(new Class.Method[0]);
        noInnerClasses = Arrays.asList(new InnerClass[0]);
    }

    public class Class
    extends Attribute.Holder
    implements Comparable {
        File file;
        int magic;
        short minver;
        short majver;
        ConstantPool.Entry[] cpMap;
        ConstantPool.ClassEntry thisClass;
        ConstantPool.ClassEntry superClass;
        ConstantPool.ClassEntry[] interfaces;
        ArrayList fields;
        ArrayList methods;
        ArrayList innerClasses;

        public Package getPackage() {
            return Package.this;
        }

        Class(int n2, ConstantPool.ClassEntry classEntry, ConstantPool.ClassEntry classEntry2, ConstantPool.ClassEntry[] classEntryArray) {
            this.magic = -889275714;
            this.minver = Package.this.default_class_minver;
            this.majver = Package.this.default_class_majver;
            this.flags = n2;
            this.thisClass = classEntry;
            this.superClass = classEntry2;
            this.interfaces = classEntryArray;
            boolean bl2 = Package.this.classes.add(this);
            assert (bl2);
        }

        Class(String string) {
            this.initFile(Package.this.newStub(string));
        }

        List getFields() {
            return this.fields == null ? noFields : this.fields;
        }

        List getMethods() {
            return this.methods == null ? noMethods : this.methods;
        }

        public String getName() {
            return this.thisClass.stringValue();
        }

        int getVersion() {
            return (this.majver << 16) + (char)this.minver;
        }

        String getVersionString() {
            return Package.versionStringOf(this.majver, this.minver);
        }

        public int compareTo(Object object) {
            Class clazz = (Class)object;
            String string = this.getName();
            String string2 = clazz.getName();
            return string.compareTo(string2);
        }

        String getObviousSourceFile() {
            return Package.getObviousSourceFile(this.getName());
        }

        private void transformSourceFile(boolean bl2) {
            Object object;
            Attribute attribute = this.getAttribute(attrSourceFileSpecial);
            if (attribute == null) {
                return;
            }
            String string = this.getObviousSourceFile();
            ArrayList arrayList = new ArrayList(1);
            attribute.visitRefs(this, 1, arrayList);
            ConstantPool.Utf8Entry utf8Entry = (ConstantPool.Utf8Entry)arrayList.get(0);
            Attribute attribute2 = attribute;
            if (utf8Entry == null) {
                if (bl2) {
                    attribute2 = Attribute.find(0, "SourceFile", "H");
                    attribute2 = attribute2.addContent(new byte[2]);
                } else {
                    object = new byte[2];
                    utf8Entry = Package.getRefString(string);
                    Object object2 = null;
                    object2 = Fixups.add(object2, (byte[])object, 0, 0, utf8Entry);
                    attribute2 = attrSourceFileSpecial.addContent((byte[])object, object2);
                }
            } else if (string.equals(utf8Entry.stringValue())) {
                if (bl2) {
                    attribute2 = attrSourceFileSpecial.addContent(new byte[2]);
                } else assert (false);
            }
            if (attribute2 != attribute) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("recoding obvious SourceFile=" + string);
                }
                object = new ArrayList(this.getAttributes());
                int n2 = object.indexOf(attribute);
                object.set(n2, attribute2);
                this.setAttributes((List)object);
            }
        }

        void minimizeSourceFile() {
            this.transformSourceFile(true);
        }

        void expandSourceFile() {
            this.transformSourceFile(false);
        }

        protected ConstantPool.Entry[] getCPMap() {
            return this.cpMap;
        }

        protected void setCPMap(ConstantPool.Entry[] entryArray) {
            this.cpMap = entryArray;
        }

        boolean hasInnerClasses() {
            return this.innerClasses != null;
        }

        List getInnerClasses() {
            return this.innerClasses;
        }

        public void setInnerClasses(Collection collection) {
            this.innerClasses = collection == null ? null : new ArrayList(collection);
            Attribute attribute = this.getAttribute(attrInnerClassesEmpty);
            if (this.innerClasses != null && attribute == null) {
                this.addAttribute(attrInnerClassesEmpty.canonicalInstance());
            } else if (this.innerClasses == null && attribute != null) {
                this.removeAttribute(attribute);
            }
        }

        public List computeGloballyImpliedICs() {
            HashSet hashSet = new HashSet();
            AbstractCollection abstractCollection = this.innerClasses;
            this.innerClasses = null;
            this.visitRefs(0, hashSet);
            this.innerClasses = abstractCollection;
            ConstantPool.completeReferencesIn(hashSet, true);
            abstractCollection = new HashSet();
            for (Object object : hashSet) {
                InnerClass innerClass;
                if (!(object instanceof ConstantPool.ClassEntry)) continue;
                while (object != null && (innerClass = Package.this.getGlobalInnerClass((ConstantPool.Entry)object)) != null && ((HashSet)abstractCollection).add(object)) {
                    object = innerClass.outerClass;
                }
            }
            ArrayList arrayList = new ArrayList();
            for (InnerClass innerClass : Package.this.allInnerClasses) {
                if (!((HashSet)abstractCollection).contains(innerClass.thisClass) && innerClass.outerClass != this.thisClass) continue;
                if (Package.this.verbose > 1) {
                    Utils.log.fine("Relevant IC: " + innerClass);
                }
                arrayList.add(innerClass);
            }
            return arrayList;
        }

        private List computeICdiff() {
            List list = this.computeGloballyImpliedICs();
            List list2 = this.getInnerClasses();
            if (list2 == null) {
                list2 = Collections.EMPTY_LIST;
            }
            if (list2.isEmpty()) {
                return list;
            }
            if (list.isEmpty()) {
                return list2;
            }
            HashSet hashSet = new HashSet(list2);
            hashSet.retainAll(new HashSet(list));
            list.addAll(list2);
            list.removeAll(hashSet);
            return list;
        }

        void minimizeLocalICs() {
            List list;
            List list2 = this.computeICdiff();
            ArrayList arrayList = this.innerClasses;
            if (list2.isEmpty()) {
                list = null;
                if (arrayList != null && arrayList.isEmpty() && Package.this.verbose > 0) {
                    Utils.log.info("Warning: Dropping empty InnerClasses attribute from " + this);
                }
            } else {
                list = arrayList == null ? Collections.EMPTY_LIST : list2;
            }
            this.setInnerClasses(list);
            if (Package.this.verbose > 1 && list != null) {
                Utils.log.fine("keeping local ICs in " + this + ": " + list);
            }
        }

        int expandLocalICs() {
            int n2;
            List list;
            ArrayList arrayList = this.innerClasses;
            if (arrayList == null) {
                List list2 = this.computeGloballyImpliedICs();
                if (list2.isEmpty()) {
                    list = null;
                    n2 = 0;
                } else {
                    list = list2;
                    n2 = 1;
                }
            } else if (arrayList.isEmpty()) {
                list = null;
                n2 = 0;
            } else {
                list = this.computeICdiff();
                n2 = list.containsAll(arrayList) ? 1 : -1;
            }
            this.setInnerClasses(list);
            return n2;
        }

        public void trimToSize() {
            super.trimToSize();
            for (int i2 = 0; i2 <= 1; ++i2) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = i2 == 0 ? this.fields : this.methods;
                if (arrayList == null) continue;
                arrayList.trimToSize();
                for (Member member : arrayList) {
                    member.trimToSize();
                }
            }
            if (this.innerClasses != null) {
                this.innerClasses.trimToSize();
            }
        }

        public void strip(String string) {
            if (string == "InnerClass") {
                this.innerClasses = null;
            }
            for (int i2 = 0; i2 <= 1; ++i2) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = i2 == 0 ? this.fields : this.methods;
                if (arrayList == null) continue;
                for (Member member : arrayList) {
                    member.strip(string);
                }
            }
            super.strip(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visitRefs(int n2, Collection collection) {
            int n3;
            if (Package.this.verbose > 2) {
                Utils.log.fine("visitRefs " + this);
            }
            collection.add(this.thisClass);
            collection.add(this.superClass);
            for (n3 = 0; n3 < this.interfaces.length; ++n3) {
                collection.add(this.interfaces[n3]);
            }
            for (n3 = 0; n3 <= 1; ++n3) {
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList = n3 == 0 ? this.fields : this.methods;
                if (arrayList == null) continue;
                for (Member member : arrayList) {
                    boolean bl2 = false;
                    try {
                        member.visitRefs(n2, collection);
                        bl2 = true;
                    }
                    finally {
                        if (bl2) continue;
                        Utils.log.warning("Error scanning " + member);
                    }
                }
            }
            this.visitInnerClassRefs(n2, collection);
            super.visitRefs(n2, collection);
        }

        protected void visitInnerClassRefs(int n2, Collection collection) {
            Package.visitInnerClassRefs(this.innerClasses, n2, collection);
        }

        void finishReading() {
            this.trimToSize();
            this.maybeChooseFileName();
        }

        public void initFile(File file) {
            assert (this.file == null);
            if (file == null) {
                file = Package.this.newStub(this.canonicalFileName());
            }
            this.file = file;
            assert (file.isClassStub());
            file.stubClass = this;
            this.maybeChooseFileName();
        }

        public void maybeChooseFileName() {
            if (this.thisClass == null) {
                return;
            }
            String string = this.canonicalFileName();
            if (this.file.nameString.equals("")) {
                this.file.nameString = string;
            }
            if (this.file.nameString.equals(string)) {
                this.file.name = Package.getRefString("");
                return;
            }
            if (this.file.name == null) {
                this.file.name = Package.getRefString(this.file.nameString);
            }
        }

        public String canonicalFileName() {
            if (this.thisClass == null) {
                return null;
            }
            return this.thisClass.stringValue() + ".class";
        }

        public java.io.File getFileName(java.io.File file) {
            String string = this.file.name.stringValue();
            if (string.equals("")) {
                string = this.canonicalFileName();
            }
            String string2 = string.replace('/', java.io.File.separatorChar);
            return new java.io.File(file, string2);
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public String toString() {
            return this.thisClass.stringValue();
        }

        public class Field
        extends Member {
            int order;

            public Field(int n2, ConstantPool.DescriptorEntry descriptorEntry) {
                super(n2, descriptorEntry);
                assert (!descriptorEntry.isMethod());
                if (Class.this.fields == null) {
                    Class.this.fields = new ArrayList();
                }
                boolean bl2 = Class.this.fields.add(this);
                assert (bl2);
                this.order = Class.this.fields.size();
            }

            public byte getLiteralTag() {
                return this.descriptor.getLiteralTag();
            }

            public int compareTo(Object object) {
                Field field = (Field)object;
                return this.order - field.order;
            }
        }

        public abstract class Member
        extends Attribute.Holder
        implements Comparable {
            ConstantPool.DescriptorEntry descriptor;

            protected Member(int n2, ConstantPool.DescriptorEntry descriptorEntry) {
                this.flags = n2;
                this.descriptor = descriptorEntry;
            }

            public Class thisClass() {
                return Class.this;
            }

            public ConstantPool.DescriptorEntry getDescriptor() {
                return this.descriptor;
            }

            public String getName() {
                return this.descriptor.nameRef.stringValue();
            }

            public String getType() {
                return this.descriptor.typeRef.stringValue();
            }

            protected ConstantPool.Entry[] getCPMap() {
                return Class.this.cpMap;
            }

            protected void visitRefs(int n2, Collection collection) {
                if (Package.this.verbose > 2) {
                    Utils.log.fine("visitRefs " + this);
                }
                if (n2 == 0) {
                    collection.add(this.descriptor.nameRef);
                    collection.add(this.descriptor.typeRef);
                } else {
                    collection.add(this.descriptor);
                }
                super.visitRefs(n2, collection);
            }

            public String toString() {
                return Class.this + "." + this.descriptor.prettyString();
            }
        }

        public class Method
        extends Member {
            Code code;

            public Method(int n2, ConstantPool.DescriptorEntry descriptorEntry) {
                super(n2, descriptorEntry);
                assert (descriptorEntry.isMethod());
                if (Class.this.methods == null) {
                    Class.this.methods = new ArrayList();
                }
                boolean bl2 = Class.this.methods.add(this);
                assert (bl2);
            }

            public void trimToSize() {
                super.trimToSize();
                if (this.code != null) {
                    this.code.trimToSize();
                }
            }

            public int getArgumentSize() {
                int n2 = this.descriptor.typeRef.computeSize(true);
                int n3 = Modifier.isStatic(this.flags) ? 0 : 1;
                return n3 + n2;
            }

            public int compareTo(Object object) {
                Method method = (Method)object;
                return this.getDescriptor().compareTo(method.getDescriptor());
            }

            public void strip(String string) {
                if (string == "Code") {
                    this.code = null;
                }
                if (this.code != null) {
                    this.code.strip(string);
                }
                super.strip(string);
            }

            protected void visitRefs(int n2, Collection collection) {
                super.visitRefs(n2, collection);
                if (this.code != null) {
                    if (n2 == 0) {
                        collection.add(Package.getRefString("Code"));
                    }
                    this.code.visitRefs(n2, collection);
                }
            }
        }
    }

    public class File
    implements Comparable {
        String nameString;
        ConstantPool.Utf8Entry name;
        int modtime = 0;
        int options = 0;
        Class stubClass;
        ArrayList prepend = new ArrayList();
        ByteArrayOutputStream append = new ByteArrayOutputStream();

        File(ConstantPool.Utf8Entry utf8Entry) {
            this.name = utf8Entry;
            this.nameString = utf8Entry.stringValue();
        }

        File(String string) {
            this.nameString = string = Package.fixupFileName(string);
            this.name = Package.getRefString(string);
        }

        public boolean isDirectory() {
            return this.nameString.endsWith("/");
        }

        public boolean isClassStub() {
            return (this.options & 2) != 0;
        }

        public Class getStubClass() {
            assert (this.isClassStub());
            assert (this.stubClass != null);
            return this.stubClass;
        }

        public boolean isTrivialClassStub() {
            return this.isClassStub() && this.name.stringValue().equals("") && (this.modtime == 0 || this.modtime == Package.this.default_modtime) && (this.options & 0xFFFFFFFD) == 0;
        }

        public boolean equals(Object object) {
            File file = (File)object;
            return file.nameString == this.nameString;
        }

        public int hashCode() {
            return this.nameString.hashCode();
        }

        public int compareTo(Object object) {
            File file = (File)object;
            return this.nameString.compareTo(file.nameString);
        }

        public String toString() {
            return this.nameString + "{" + (this.isClassStub() ? "*" : "") + (BandStructure.testBit(this.options, 1) ? "@" : "") + (this.modtime == 0 ? "" : "M" + this.modtime) + (this.getFileLength() == 0L ? "" : "[" + this.getFileLength() + "]") + "}";
        }

        public java.io.File getFileName() {
            return this.getFileName(null);
        }

        public java.io.File getFileName(java.io.File file) {
            String string = this.nameString;
            String string2 = string.replace('/', java.io.File.separatorChar);
            return new java.io.File(file, string2);
        }

        public void addBytes(byte[] byArray) {
            this.addBytes(byArray, 0, byArray.length);
        }

        public void addBytes(byte[] byArray, int n2, int n3) {
            if ((this.append.size() | n3) << 2 < 0) {
                this.prepend.add(this.append.toByteArray());
                this.append.reset();
            }
            this.append.write(byArray, n2, n3);
        }

        public long getFileLength() {
            long l2 = 0L;
            if (this.prepend == null && this.append == null) {
                return 0L;
            }
            for (byte[] byArray : this.prepend) {
                l2 += (long)byArray.length;
            }
            return l2 += (long)this.append.size();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            if (this.prepend == null && this.append == null) {
                return;
            }
            for (byte[] byArray : this.prepend) {
                outputStream.write(byArray);
            }
            this.append.writeTo(outputStream);
        }

        public void readFrom(InputStream inputStream) throws IOException {
            int n2;
            byte[] byArray = new byte[65536];
            while ((n2 = inputStream.read(byArray)) > 0) {
                this.addBytes(byArray, 0, n2);
            }
        }

        public InputStream getInputStream() {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.append.toByteArray());
            if (this.prepend.size() == 0) {
                return byteArrayInputStream;
            }
            ArrayList<ByteArrayInputStream> arrayList = new ArrayList<ByteArrayInputStream>(this.prepend.size() + 1);
            for (byte[] byArray : this.prepend) {
                arrayList.add(new ByteArrayInputStream(byArray));
            }
            arrayList.add(byteArrayInputStream);
            return new SequenceInputStream(Collections.enumeration(arrayList));
        }

        protected void visitRefs(int n2, Collection collection) {
            assert (this.name != null);
            collection.add(this.name);
        }
    }

    static class InnerClass
    implements Comparable {
        final ConstantPool.ClassEntry thisClass;
        final ConstantPool.ClassEntry outerClass;
        final ConstantPool.Utf8Entry name;
        final int flags;
        final boolean predictable;

        InnerClass(ConstantPool.ClassEntry classEntry, ConstantPool.ClassEntry classEntry2, ConstantPool.Utf8Entry utf8Entry, int n2) {
            this.thisClass = classEntry;
            this.outerClass = classEntry2;
            this.name = utf8Entry;
            this.flags = n2;
            this.predictable = this.computePredictable();
        }

        private boolean computePredictable() {
            String[] stringArray = Package.parseInnerClassName(this.thisClass.stringValue());
            if (stringArray == null) {
                return false;
            }
            String string = stringArray[0];
            String string2 = stringArray[2];
            String string3 = this.name == null ? null : this.name.stringValue();
            String string4 = this.outerClass == null ? null : this.outerClass.stringValue();
            boolean bl2 = string2 == string3 && string == string4;
            return bl2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            InnerClass innerClass = (InnerClass)object;
            return InnerClass.eq(this.thisClass, innerClass.thisClass) && InnerClass.eq(this.outerClass, innerClass.outerClass) && InnerClass.eq(this.name, innerClass.name) && this.flags == innerClass.flags;
        }

        private static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }

        public int hashCode() {
            return this.thisClass.hashCode();
        }

        public int compareTo(Object object) {
            InnerClass innerClass = (InnerClass)object;
            return this.thisClass.compareTo(innerClass.thisClass);
        }

        protected void visitRefs(int n2, Collection collection) {
            collection.add(this.thisClass);
            if (n2 == 0 || !this.predictable) {
                collection.add(this.outerClass);
                collection.add(this.name);
            }
        }

        public String toString() {
            return this.thisClass.stringValue();
        }
    }
}

