/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.AdaptiveCoding;
import com.sun.java.util.jar.pack.BandStructure;
import com.sun.java.util.jar.pack.Coding;
import com.sun.java.util.jar.pack.CodingMethod;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Histogram;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;

class PopulationCoding
implements Constants,
CodingMethod {
    Histogram vHist;
    int[] fValues;
    int fVlen;
    long[] symtab;
    CodingMethod favoredCoding;
    CodingMethod tokenCoding;
    CodingMethod unfavoredCoding;
    int L = -1;
    static final int[] LValuesCoded = new int[]{-1, 4, 8, 16, 32, 64, 128, 192, 224, 240, 248, 252};

    PopulationCoding() {
    }

    public void setFavoredValues(int[] nArray, int n2) {
        assert (nArray[0] == 0);
        assert (this.fValues == null);
        this.fValues = nArray;
        this.fVlen = n2;
        if (this.L >= 0) {
            this.setL(this.L);
        }
    }

    public void setFavoredValues(int[] nArray) {
        int n2 = nArray.length - 1;
        this.setFavoredValues(nArray, n2);
    }

    public void setHistogram(Histogram histogram) {
        this.vHist = histogram;
    }

    public void setL(int n2) {
        this.L = n2;
        if (n2 >= 0 && this.fValues != null && this.tokenCoding == null) {
            this.tokenCoding = PopulationCoding.fitTokenCoding(this.fVlen, n2);
            assert (this.tokenCoding != null);
        }
    }

    public static Coding fitTokenCoding(int n2, int n3) {
        if (n2 < 256) {
            return BandStructure.BYTE1;
        }
        Coding coding = BandStructure.UNSIGNED5.setL(n3);
        if (!coding.canRepresent(n2)) {
            return null;
        }
        Coding coding2 = coding;
        Coding coding3 = coding;
        while ((coding3 = coding3.setB(coding3.B() - 1)).umax() >= n2) {
            coding2 = coding3;
        }
        return coding2;
    }

    public void setFavoredCoding(CodingMethod codingMethod) {
        this.favoredCoding = codingMethod;
    }

    public void setTokenCoding(CodingMethod codingMethod) {
        Coding coding;
        this.tokenCoding = codingMethod;
        this.L = -1;
        if (codingMethod instanceof Coding && this.fValues != null && (coding = (Coding)codingMethod) == PopulationCoding.fitTokenCoding(this.fVlen, coding.L())) {
            this.L = coding.L();
        }
    }

    public void setUnfavoredCoding(CodingMethod codingMethod) {
        this.unfavoredCoding = codingMethod;
    }

    public int favoredValueMaxLength() {
        if (this.L == 0) {
            return Integer.MAX_VALUE;
        }
        return BandStructure.UNSIGNED5.setL(this.L).umax();
    }

    public void resortFavoredValues() {
        Coding coding = (Coding)this.tokenCoding;
        this.fValues = BandStructure.realloc(this.fValues, 1 + this.fVlen);
        int n2 = 1;
        for (int i2 = 1; i2 <= coding.B(); ++i2) {
            int n3 = coding.byteMax(i2);
            if (n3 > this.fVlen) {
                n3 = this.fVlen;
            }
            if (n3 < coding.byteMin(i2)) break;
            int n4 = n3 + 1;
            int n5 = n2;
            if (n4 == n5) continue;
            assert (n4 > n5) : n4 + "!>" + n5;
            assert (coding.getLength(n5) == i2) : i2 + " != len(" + n5 + ") == " + coding.getLength(n5);
            assert (coding.getLength(n4 - 1) == i2) : i2 + " != len(" + (n4 - 1) + ") == " + coding.getLength(n4 - 1);
            int n6 = n5 + (n4 - n5) / 2;
            int n7 = n5;
            int n8 = -1;
            int n9 = n5;
            for (int i3 = n5; i3 < n4; ++i3) {
                int n10 = this.fValues[i3];
                int n11 = this.vHist.getFrequency(n10);
                if (n8 == n11) continue;
                if (i2 == 1) {
                    Arrays.sort(this.fValues, n9, i3);
                } else if (Math.abs(n7 - n6) > Math.abs(i3 - n6)) {
                    n7 = i3;
                }
                n8 = n11;
                n9 = i3;
            }
            if (i2 == 1) {
                Arrays.sort(this.fValues, n9, n4);
            } else {
                Arrays.sort(this.fValues, n5, n7);
                Arrays.sort(this.fValues, n7, n4);
            }
            assert (coding.getLength(n5) == coding.getLength(n7));
            assert (coding.getLength(n5) == coding.getLength(n4 - 1));
            n2 = n3 + 1;
        }
        assert (n2 == this.fValues.length);
        this.symtab = null;
    }

    public int getToken(int n2) {
        int n3;
        if (this.symtab == null) {
            this.symtab = this.makeSymtab();
        }
        if ((n3 = Arrays.binarySearch(this.symtab, (long)n2 << 32)) < 0) {
            n3 = -n3 - 1;
        }
        if (n3 < this.symtab.length && n2 == (int)(this.symtab[n3] >>> 32)) {
            return (int)this.symtab[n3];
        }
        return 0;
    }

    public int[][] encodeValues(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray2 = new int[n3 - n2];
        int n6 = 0;
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            n5 = nArray[n2 + i2];
            n4 = this.getToken(n5);
            if (n4 != 0) {
                nArray2[i2] = n4;
                continue;
            }
            ++n6;
        }
        int[] nArray3 = new int[n6];
        n6 = 0;
        for (n5 = 0; n5 < nArray2.length; ++n5) {
            if (nArray2[n5] != 0) continue;
            n4 = nArray[n2 + n5];
            nArray3[n6++] = n4;
        }
        assert (n6 == nArray3.length);
        return new int[][]{nArray2, nArray3};
    }

    private long[] makeSymtab() {
        long[] lArray = new long[this.fVlen];
        for (int i2 = 1; i2 <= this.fVlen; ++i2) {
            lArray[i2 - 1] = (long)this.fValues[i2] << 32 | (long)i2;
        }
        Arrays.sort(lArray);
        return lArray;
    }

    private Coding getTailCoding(CodingMethod codingMethod) {
        while (codingMethod instanceof AdaptiveCoding) {
            codingMethod = ((AdaptiveCoding)codingMethod).tailCoding;
        }
        return (Coding)codingMethod;
    }

    public void writeArrayTo(OutputStream outputStream, int[] nArray, int n2, int n3) throws IOException {
        int[][] nArray2 = this.encodeValues(nArray, n2, n3);
        this.writeSequencesTo(outputStream, nArray2[0], nArray2[1]);
    }

    void writeSequencesTo(OutputStream outputStream, int[] nArray, int[] nArray2) throws IOException {
        this.favoredCoding.writeArrayTo(outputStream, this.fValues, 1, 1 + this.fVlen);
        this.getTailCoding(this.favoredCoding).writeTo(outputStream, this.computeSentinelValue());
        this.tokenCoding.writeArrayTo(outputStream, nArray, 0, nArray.length);
        if (nArray2.length > 0) {
            this.unfavoredCoding.writeArrayTo(outputStream, nArray2, 0, nArray2.length);
        }
    }

    int computeSentinelValue() {
        int n2;
        Coding coding = this.getTailCoding(this.favoredCoding);
        if (coding.isDelta()) {
            return 0;
        }
        int n3 = n2 = this.fValues[1];
        for (int i2 = 2; i2 <= this.fVlen; ++i2) {
            n3 = this.fValues[i2];
            n2 = PopulationCoding.moreCentral(n2, n3);
        }
        if (coding.getLength(n2) <= coding.getLength(n3)) {
            return n2;
        }
        return n3;
    }

    public void readArrayFrom(InputStream inputStream, int[] nArray, int n2, int n3) throws IOException {
        int n4;
        this.setFavoredValues(this.readFavoredValuesFrom(inputStream, n3 - n2));
        this.tokenCoding.readArrayFrom(inputStream, nArray, n2, n3);
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            n4 = nArray[i2];
            if (n4 == 0) {
                if (n6 < 0) {
                    n5 = i2;
                } else {
                    nArray[n6] = i2;
                }
                n6 = i2;
                ++n7;
                continue;
            }
            nArray[i2] = this.fValues[n4];
        }
        int[] nArray2 = new int[n7];
        if (n7 > 0) {
            this.unfavoredCoding.readArrayFrom(inputStream, nArray2, 0, n7);
        }
        for (n4 = 0; n4 < n7; ++n4) {
            int n8 = nArray[n5];
            nArray[n5] = nArray2[n4];
            n5 = n8;
        }
    }

    int[] readFavoredValuesFrom(InputStream inputStream, int n2) throws IOException {
        int n3;
        int n4;
        CodingMethod codingMethod;
        int[] nArray = new int[1000];
        HashSet<Integer> hashSet = null;
        assert ((hashSet = new HashSet<Integer>()) != null);
        int n5 = 1;
        int n6 = Integer.MIN_VALUE;
        int n7 = 0;
        CodingMethod codingMethod2 = this.favoredCoding;
        while (codingMethod2 instanceof AdaptiveCoding) {
            codingMethod = (AdaptiveCoding)codingMethod2;
            n4 = ((AdaptiveCoding)codingMethod).headLength;
            while (n5 + n4 > nArray.length) {
                nArray = BandStructure.realloc(nArray);
            }
            n3 = n5 + n4;
            ((AdaptiveCoding)codingMethod).headCoding.readArrayFrom(inputStream, nArray, n5, n3);
            while (n5 < n3) {
                int n8 = nArray[n5++];
                assert (hashSet.add(new Integer(n8)));
                assert (n5 <= n2);
                n7 = n8;
                n6 = PopulationCoding.moreCentral(n6, n8);
            }
            codingMethod2 = ((AdaptiveCoding)codingMethod).tailCoding;
        }
        codingMethod = (Coding)codingMethod2;
        if (((Coding)codingMethod).isDelta()) {
            n4 = 0;
            while (true) {
                n4 += ((Coding)codingMethod).readFrom(inputStream);
                n3 = n4 = ((Coding)codingMethod).reduceToUnsignedRange(n4);
                if (n5 <= 1 || n3 != n7 && n3 != n6) {
                    if (n5 == nArray.length) {
                        nArray = BandStructure.realloc(nArray);
                    }
                    nArray[n5++] = n3;
                    assert (hashSet.add(new Integer(n3)));
                    assert (n5 <= n2);
                    n7 = n3;
                    n6 = PopulationCoding.moreCentral(n6, n3);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                n4 = ((Coding)codingMethod).readFrom(inputStream);
                if (n5 > 1 && (n4 == n7 || n4 == n6)) break;
                if (n5 == nArray.length) {
                    nArray = BandStructure.realloc(nArray);
                }
                nArray[n5++] = n4;
                assert (hashSet.add(new Integer(n4)));
                assert (n5 <= n2);
                n7 = n4;
                n6 = PopulationCoding.moreCentral(n6, n4);
            }
        }
        return BandStructure.realloc(nArray, n5);
    }

    private static int moreCentral(int n2, int n3) {
        int n4;
        int n5 = n2 >> 31 ^ n2 << 1;
        int n6 = n3 >> 31 ^ n3 << 1;
        int n7 = n4 = (n5 -= Integer.MIN_VALUE) < (n6 -= Integer.MIN_VALUE) ? n2 : n3;
        assert (n4 == PopulationCoding.moreCentralSlow(n2, n3));
        return n4;
    }

    private static int moreCentralSlow(int n2, int n3) {
        int n4 = n2;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n4 < 0) {
            return n3;
        }
        int n5 = n3;
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 < 0) {
            return n2;
        }
        if (n4 < n5) {
            return n2;
        }
        if (n4 > n5) {
            return n3;
        }
        return n2 > n3 ? n2 : n3;
    }

    public byte[] getMetaCoding(Coding coding) {
        int n2;
        int n3;
        CodingMethod codingMethod;
        int n4 = this.fVlen;
        int n5 = 0;
        if (this.tokenCoding instanceof Coding) {
            codingMethod = (Coding)this.tokenCoding;
            if (((Coding)codingMethod).B() == 1) {
                n5 = 1;
            } else if (this.L >= 0) {
                assert (this.L == ((Coding)codingMethod).L());
                for (n3 = 1; n3 < LValuesCoded.length; ++n3) {
                    if (LValuesCoded[n3] != this.L) continue;
                    n5 = n3;
                    break;
                }
            }
        }
        codingMethod = null;
        if (n5 != 0 && this.tokenCoding == PopulationCoding.fitTokenCoding(this.fVlen, this.L)) {
            codingMethod = this.tokenCoding;
        }
        n3 = this.favoredCoding == coding ? 1 : 0;
        int n6 = this.unfavoredCoding == coding || this.unfavoredCoding == null ? 1 : 0;
        boolean bl2 = this.tokenCoding == codingMethod;
        int n7 = n2 = bl2 ? n5 : 0;
        assert (bl2 == n2 > 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(141 + n3 + 2 * n6 + 4 * n2);
        try {
            if (n3 == 0) {
                byteArrayOutputStream.write(this.favoredCoding.getMetaCoding(coding));
            }
            if (!bl2) {
                byteArrayOutputStream.write(this.tokenCoding.getMetaCoding(coding));
            }
            if (n6 == 0) {
                byteArrayOutputStream.write(this.unfavoredCoding.getMetaCoding(coding));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int parseMetaCoding(byte[] byArray, int n2, Coding coding, CodingMethod[] codingMethodArray) {
        int n3;
        if ((n3 = byArray[n2++] & 0xFF) < 141) {
            return n2 - 1;
        }
        int n4 = (n3 -= 141) % 2;
        int n5 = n3 / 2 % 2;
        int n6 = n3 / 4;
        if (n6 >= LValuesCoded.length) {
            return n2 - 1;
        }
        boolean bl2 = n6 > 0;
        int n7 = LValuesCoded[n6];
        CodingMethod[] codingMethodArray2 = new CodingMethod[]{coding};
        CodingMethod[] codingMethodArray3 = new CodingMethod[]{null};
        CodingMethod[] codingMethodArray4 = new CodingMethod[]{coding};
        if (n4 == 0) {
            n2 = BandStructure.parseMetaCoding(byArray, n2, coding, codingMethodArray2);
        }
        if (!bl2) {
            n2 = BandStructure.parseMetaCoding(byArray, n2, coding, codingMethodArray3);
        }
        if (n5 == 0) {
            n2 = BandStructure.parseMetaCoding(byArray, n2, coding, codingMethodArray4);
        }
        PopulationCoding populationCoding = new PopulationCoding();
        populationCoding.L = n7;
        populationCoding.favoredCoding = codingMethodArray2[0];
        populationCoding.tokenCoding = codingMethodArray3[0];
        populationCoding.unfavoredCoding = codingMethodArray4[0];
        codingMethodArray[0] = populationCoding;
        return n2;
    }

    private String keyString(CodingMethod codingMethod) {
        if (codingMethod instanceof Coding) {
            return ((Coding)codingMethod).keyString();
        }
        if (codingMethod == null) {
            return "none";
        }
        return codingMethod.toString();
    }

    public String toString() {
        return "pop(fVlen=" + this.fVlen + " fc=" + this.keyString(this.favoredCoding) + " tc=" + this.keyString(this.tokenCoding) + " uc=" + this.keyString(this.unfavoredCoding) + ")";
    }
}

